<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
require_once('config.php');

// Fetch system settings
$query = "SELECT * FROM his_system_settings LIMIT 1";
$result = $mysqli->query($query);
$settings = $result->fetch_assoc();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" integrity="sha384-KK94CHFLLe+nY2dmCWGMq91rCGa5gtU4mk92HdvYe+M/SXH301p5ILy+dN9+nJOZ" crossorigin="anonymous" />
    <link rel="stylesheet" href="style.css" />
    <title><?php echo htmlspecialchars($settings['system_name'] ?? 'AFLUX Hospital'); ?></title>
</head>
<body>
    <header class="min-vh-100">
        <nav class="navbar navbar-expand-lg fixed-top bg-white bg-opacity-75">
            <div class="container">
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarTogglerDemo01" aria-controls="navbarTogglerDemo01" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarTogglerDemo01">
                    <a class="navbar-brand" href="#">
                        <?php if(!empty($settings['system_logo'])): ?>
                            <img src="system/admin_endpoint/<?php echo htmlspecialchars($settings['system_logo']); ?>" alt="<?php echo htmlspecialchars($settings['system_name']); ?> logo" height="50" />
                        <?php else: ?>
                            <img src="img/Medical.png" alt="Medical logo" height="50" />
                        <?php endif; ?>
                    </a>
                    <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                        <li class="nav-item">
                            <a class="nav-link active" aria-current="page" href="#">Home</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#">About us</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#">Services</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#">Porfolio</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#">Blog</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#">Contact</a>
                        </li>
                    </ul>
                    <div class="dropdown">
                        <button class="btn btn-info bg-mavi text-white rounded-0 text-uppercase dropdown-toggle" 
                                type="button" 
                                id="getStartedDropdown" 
                                data-bs-toggle="dropdown" 
                                aria-expanded="false">
                           Login
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="getStartedDropdown">
                            <li><a class="dropdown-item" href="system/admin_endpoint/">Admin Login</a></li>
                            <li><a class="dropdown-item" href="system/doctors_endpoint">Doctor Login</a></li>
                            <li><a class="dropdown-item" href="system/lab_endpoint">Laboratory Login</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </nav>

        <div class="container vh-100 d-flex align-items-center justify-content-center">
            <div class="row w-100">
                <div class="card col-lg-6 bg-transparent border-0 text-white">
                    <div class="card-body">
                        <h1 class="card-title display-3">The best doctors in <b><?php echo htmlspecialchars($settings['system_name'] ?? 'Medicine!'); ?></b></h1>
                        <h5 class="card-subtitle mb-2">in the world of modern medicine!</h5>
                        <p class="card-text my-5"><?php echo htmlspecialchars($settings['system_mission'] ?? 'Our hospital provides top-quality healthcare services with cutting-edge technology and compassionate care.'); ?></p>
                        <button class="btn btn-info bg-light text-dark border-0 rounded-0 text-uppercase" type="submit">Get started</button>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <main>
        <div class="py-5">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <div class="card bg-transparent border-0">
                            <div class="card-body">
                                <h6 class="card-title text-mavi text-uppercase">Welcome to <?php echo htmlspecialchars($settings['system_name'] ?? 'our clinic'); ?></h6>
                                <h2 class="card-subtitle mb-2">Why you should choose us?</h2>
                                <p class="card-text my-4"><?php echo htmlspecialchars($settings['system_mission'] ?? 'We combine expertise with state-of-the-art facilities to deliver exceptional patient care. Our team of specialists is dedicated to your health and well-being.'); ?></p>
                                <button class="btn btn-info bg-mavi text-white border-0 rounded-0 text-uppercase" type="submit">Get started now</button>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 text-end">
                        <img src="img/hekimbaba.jpg" class="mw-100" alt="Our medical team" />
                    </div>
                </div>
            </div>
        </div>

        <!-- Rest of your content remains the same until footer -->

        <footer class="bg-goy">
            <div class="container">
                <div class="row py-4 jus d-flex justify-content-center">
                    <div class="col-md-5 text-white">
                        <h5><?php echo htmlspecialchars($settings['system_name'] ?? 'Medical'); ?></h5>
                        <p><?php echo htmlspecialchars($settings['system_mission'] ?? 'Committed to excellence in healthcare delivery.'); ?></p>
                        <p><?php echo htmlspecialchars($settings['system_address'] ?? '123 Main Street, City, Country'); ?></p>
                    </div>
                    <div class="col-md-4 text-white">
                        <h5>Contact Us</h5>
                        <p>
                            <?php echo htmlspecialchars($settings['system_address'] ?? '123-india.'); ?><br>
                            <?php echo htmlspecialchars($settings['system_phone'] ?? '0757563475'); ?><br>
                            <?php echo htmlspecialchars($settings['system_email'] ?? 'info@hospital.com'); ?>
                        </p>
                    </div>
                    <div class="col-md-3 text-white">
                        <h5>Quick Links</h5>
                        <p><a href="#" class="text-white">Appointments</a></p>
                        <p><a href="#" class="text-white">Emergency Services</a></p>
                        <p><a href="#" class="text-white">Patient Portal</a></p>
                    </div>
                </div>
            </div>
        </footer>

        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ENjdO4Dr2bkBIFxQpeoTz1HIcje39Wm4jDKdf19U8gI4ddQ3GYNS7NTKfAdVQSZe" crossorigin="anonymous"></script>
    </body>
</html>
<?php 
// Close connection
if(isset($mysqli)) {
    $mysqli->close();
}
?>