<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();

if(isset($_POST['add_department'])) {
    $department_name = $_POST['department_name'];
    $department_type = $_POST['department_type'];
    $opd_fee = $_POST['opd_fee'];
    $ipd_fee = $_POST['ipd_fee'];
    $ailment_name = $_POST['ailment_name'];
    $department_description = $_POST['department_description'];
    
    // Insert query
    $query = "INSERT INTO his_departments (
        department_name, 
        department_type, 
        opd_fee, 
        ipd_fee, 
        ailment_name, 
        department_description
    ) VALUES (?, ?, ?, ?, ?, ?)";
    
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('ssddss', 
        $department_name, 
        $department_type, 
        $opd_fee, 
        $ipd_fee, 
        $ailment_name, 
        $department_description
    );
    $stmt->execute();
    
    if($stmt) {
        $success = "Department Added";
    } else {
        $err = "Please Try Again Or Try Later";
    }
}

header("location:settings.php");
exit;
?>