<?php
session_start();
include('assets/inc/config.php');

if(isset($_POST['add_doc'])) {
    $doc_title = $_POST['doc_title'];
    $doc_fname = $_POST['doc_fname'];
    $doc_lname = $_POST['doc_lname'];
    $doc_designation = $_POST['doc_designation'];
    $doc_aadhar = $_POST['doc_aadhar'];
    $doc_number = $_POST['doc_number'];
    $doc_email = $_POST['doc_email'];
    $doc_mobile1 = $_POST['doc_mobile1'];
    $doc_mobile2 = $_POST['doc_mobile2'];
    $doc_temp_address = $_POST['doc_temp_address'];
    $doc_pwd = sha1(md5($_POST['doc_pwd']));
    
    //sql to insert captured values
    $query = "INSERT INTO his_docs (doc_title, doc_fname, doc_lname, doc_designation, doc_aadhar, doc_number, doc_email, doc_mobile1, doc_mobile2, doc_temp_address, doc_pwd) values(?,?,?,?,?,?,?,?,?,?,?)";
    $stmt = $mysqli->prepare($query);
    $rc = $stmt->bind_param('sssssssssss', $doc_title, $doc_fname, $doc_lname, $doc_designation, $doc_aadhar, $doc_number, $doc_email, $doc_mobile1, $doc_mobile2, $doc_temp_address, $doc_pwd);
    $stmt->execute();
    
    if($stmt) {
        $success = "Employee Details Added";
    } else {
        $err = "Please Try Again Or Try Later";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        :root {
            --primary-color: #4a8bfc;
            --secondary-color: #6c757d;
            --success-color: #28a745;
            --danger-color: #dc3545;
            --light-color: #f8f9fa;
            --dark-color: #343a40;
        }
        
        body {
            background-color: #f5f7fb;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .card {
            border-radius: 10px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            border: none;
            overflow: hidden;
        }
        
        .card-header {
            background-color: white;
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
            padding: 20px;
        }
        
        .card-body {
            padding: 30px;
        }
        
        .page-title-box {
            padding: 20px 0;
        }
        
        .form-control {
            border-radius: 5px;
            padding: 10px 15px;
            border: 1px solid #e0e0e0;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(74, 139, 252, 0.25);
        }
        
        .btn-success {
            background-color: var(--success-color);
            border-color: var(--success-color);
            padding: 10px 25px;
            border-radius: 5px;
            font-weight: 500;
            transition: all 0.3s;
        }
        
        .btn-success:hover {
            background-color: #218838;
            border-color: #1e7e34;
            transform: translateY(-2px);
        }
        
        .form-group label {
            font-weight: 500;
            color: #495057;
            margin-bottom: 8px;
        }
        
        .header-title {
            color: var(--dark-color);
            margin-bottom: 20px;
            font-weight: 600;
        }
        
        .breadcrumb {
            background-color: transparent;
            padding: 0;
        }
        
        .alert {
            border-radius: 5px;
        }
        
        @media (max-width: 768px) {
            .card-body {
                padding: 20px;
            }
        }
    </style>
</head>

<body>
    <div id="wrapper">
        <?php include("assets/inc/nav.php");?>
        <?php include("assets/inc/sidebar.php");?>

        <div class="content-page">
            <div class="content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript:void(0);">Employee</a></li>
                                        <li class="breadcrumb-item active">Add Employee</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Add Employee Details</h4>
                            </div>
                        </div>
                    </div>
                    
                    <?php if(isset($success)): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                        <?php echo $success; ?>
                    </div>
                    <?php endif; ?>
                    
                    <?php if(isset($err)): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                        <?php echo $err; ?>
                    </div>
                    <?php endif; ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">Fill all fields</h4>
                                    <form method="post">
                                        <div class="form-row">
                                            <div class="form-group col-md-2">
                                                <label for="doc_title" class="col-form-label">Title</label>
                                                <select class="form-control" name="doc_title" id="doc_title" required>
                                                    <option value="">Select</option>
                                                    <option value="Mr.">Mr.</option>
                                                    <option value="Mrs.">Mrs.</option>
                                                    <option value="Miss">Miss</option>
                                                    <option value="Dr.">Dr.</option>
                                                    <option value="Prof.">Prof.</option>
                                                </select>
                                            </div>
                                            <div class="form-group col-md-5">
                                                <label for="doc_fname" class="col-form-label">First Name</label>
                                                <input type="text" required name="doc_fname" class="form-control" id="doc_fname" placeholder="Enter first name">
                                            </div>
                                            <div class="form-group col-md-5">
                                                <label for="doc_lname" class="col-form-label">Last Name</label>
                                                <input required type="text" name="doc_lname" class="form-control" id="doc_lname" placeholder="Enter last name">
                                            </div>
                                        </div>

                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label for="doc_designation" class="col-form-label">Designation</label>
                                                <input type="text" required name="doc_designation" class="form-control" id="doc_designation" placeholder="Enter designation">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label for="doc_aadhar" class="col-form-label">Aadhar Number</label>
                                                <input type="text" required name="doc_aadhar" class="form-control" id="doc_aadhar" placeholder="Enter Aadhar number" >
                                            </div>
                                        </div>

                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label for="doc_email" class="col-form-label">Email</label>
                                                <input required type="email" class="form-control" name="doc_email" id="doc_email" placeholder="Enter email address">
                                            </div>
                                            <div class="form-group col-md-3">
                                                <label for="doc_mobile1" class="col-form-label">Mobile Number 1</label>
                                                <input required type="tel" class="form-control" name="doc_mobile1" id="doc_mobile1" placeholder="Enter mobile number" pattern="[0-9]{10}" title="10 digit mobile number">
                                            </div>
                                            <div class="form-group col-md-3">
                                                <label for="doc_mobile2" class="col-form-label">Mobile Number 2</label>
                                                <input type="tel" class="form-control" name="doc_mobile2" id="doc_mobile2" placeholder="Optional mobile number" pattern="[0-9]{10}" title="10 digit mobile number">
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="doc_temp_address" class="col-form-label">Temporary Address</label>
                                            <textarea class="form-control" name="doc_temp_address" id="doc_temp_address" rows="3" placeholder="Enter temporary address" required></textarea>
                                        </div>

                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label for="doc_pwd" class="col-form-label">Password</label>
                                                <input required type="password" name="doc_pwd" class="form-control" id="doc_pwd" placeholder="Create password" minlength="8">
                                                <small class="form-text text-muted">Minimum 8 characters</small>
                                            </div>
                                        </div>

                                        <div class="form-group" style="display:none">
                                            <?php 
                                                $length = 5;    
                                                $patient_number = substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'),1,$length);
                                            ?>
                                            <input type="text" name="doc_number" value="<?php echo $patient_number;?>" class="form-control">
                                        </div>

                                        <button type="submit" name="add_doc" class="ladda-button btn btn-success" data-style="expand-right">
                                            <span class="ladda-label">Add Employee</span>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php include('assets/inc/footer.php');?>
        </div>
    </div>

    <div class="rightbar-overlay"></div>

    <script src="assets/js/vendor.min.js"></script>
    <script src="assets/js/app.min.js"></script>
    <script src="assets/libs/ladda/spin.js"></script>
    <script src="assets/libs/ladda/ladda.js"></script>
    <script src="assets/js/pages/loading-btn.init.js"></script>
</body>
</html>