<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];
?>

<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
    <style>
        :root {
            --primary: #4a8bfc;
            --secondary: #6c757d;
            --success: #28a745;
            --info: #17a2b8;
            --warning: #ffc107;
            --danger: #dc3545;
            --light: #f8f9fa;
            --dark: #343a40;
            --white: #ffffff;
            --gray-light: #f5f7fb;
        }
        
        body {
            background-color: var(--gray-light);
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            overflow-x: hidden;
        }
        
        .card-box {
            border-radius: 12px;
            box-shadow: 0 4px 24px rgba(0, 0, 0, 0.05);
            border: none;
            overflow: hidden;
            background: var(--white);
            transform: translateY(20px);
            opacity: 0;
            animation: fadeInUp 0.6s forwards;
        }
        
        @keyframes fadeInUp {
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }
        
        .page-title-box {
            padding: 20px 0;
            animation: fadeIn 0.5s ease-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        
        .page-title {
            font-weight: 600;
            color: var(--dark);
            position: relative;
            display: inline-block;
        }
        
        .page-title:after {
            content: '';
            position: absolute;
            width: 50%;
            height: 3px;
            bottom: -8px;
            left: 0;
            background: var(--primary);
            transform: scaleX(0);
            transform-origin: left;
            transition: transform 0.3s ease;
        }
        
        .page-title:hover:after {
            transform: scaleX(1);
        }
        
        .breadcrumb {
            background-color: transparent;
            padding: 0.75rem 0;
        }
        
        .breadcrumb-item a {
            color: var(--secondary);
            text-decoration: none;
            transition: color 0.2s;
        }
        
        .breadcrumb-item a:hover {
            color: var(--primary);
        }
        
        .table {
            border-collapse: separate;
            border-spacing: 0;
        }
        
        .table thead th {
            border-top: none;
            background-color: var(--light);
            color: var(--dark);
            font-weight: 600;
            border-bottom: 1px solid #e0e0e0;
            position: sticky;
            top: 0;
            z-index: 10;
        }
        
        .table td, .table th {
            padding: 15px;
            vertical-align: middle;
            border-top: 1px solid #f1f1f1;
            transition: all 0.2s ease;
        }
        
        .table tbody tr {
            transform: translateX(0);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        
        .table tbody tr:hover {
            background-color: rgba(74, 139, 252, 0.03);
            transform: translateX(5px);
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        
        .badge {
            padding: 6px 10px;
            font-weight: 500;
            font-size: 12px;
            border-radius: 4px;
            letter-spacing: 0.3px;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
        }
        
        .badge i {
            margin-right: 4px;
            transition: transform 0.2s;
        }
        
        .badge-primary {
            background-color: rgba(74, 139, 252, 0.1);
            color: var(--primary);
        }
        
        .badge-primary:hover {
            background-color: rgba(74, 139, 252, 0.2);
            transform: translateY(-2px);
        }
        
        .badge-primary:hover i {
            transform: scale(1.1);
        }
        
        .badge-success {
            background-color: rgba(40, 167, 69, 0.1);
            color: var(--success);
        }
        
        .badge-success:hover {
            background-color: rgba(40, 167, 69, 0.2);
            transform: translateY(-2px);
        }
        
        .badge-success:hover i {
            transform: scale(1.1);
        }
        
        .form-control {
            border-radius: 6px;
            padding: 8px 15px;
            border: 1px solid #e0e0e0;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 0.2rem rgba(74, 139, 252, 0.15);
        }
        
        .pagination .page-item .page-link {
            border-radius: 6px !important;
            margin: 0 3px;
            border: none;
            color: var(--secondary);
            transition: all 0.2s;
        }
        
        .pagination .page-item.active .page-link {
            background-color: var(--primary);
        }
        
        .pagination .page-item:not(.active) .page-link:hover {
            background-color: rgba(74, 139, 252, 0.1);
        }
        
        .header-title {
            color: var(--dark);
            font-weight: 600;
            margin-bottom: 1.5rem;
            position: relative;
        }
        
        .header-title:after {
            content: '';
            position: absolute;
            width: 40px;
            height: 3px;
            bottom: -8px;
            left: 0;
            background: var(--primary);
        }
        
        .search-box {
            position: relative;
        }
        
        .search-box .form-control {
            padding-left: 40px;
            width: 300px;
            transition: width 0.3s ease;
        }
        
        .search-box .form-control:focus {
            width: 350px;
        }
        
        .search-box:before {
            content: "\f349";
            font-family: "Material Design Icons";
            position: absolute;
            left: 15px;
            top: 10px;
            color: var(--secondary);
            font-size: 18px;
            transition: all 0.2s;
        }
        
        .search-box:focus-within:before {
            color: var(--primary);
            transform: scale(1.1);
        }
        
        /* Row animation */
        .table tbody tr {
            animation: fadeIn 0.5s ease forwards;
            animation-delay: calc(var(--i) * 0.1s);
            opacity: 0;
        }
        
        @keyframes fadeIn {
            to {
                opacity: 1;
            }
        }
        
        @media (max-width: 768px) {
            .search-box .form-control {
                width: 100%;
            }
            
            .search-box .form-control:focus {
                width: 100%;
            }
            
            .table-responsive {
                border: none;
            }
            
            .d-flex {
                flex-direction: column;
                gap: 8px;
            }
            
            .badge {
                width: 100%;
                justify-content: center;
            }
        }
    </style>
</head>

<body>
    <div id="wrapper">
        <?php include('assets/inc/nav.php');?>
        <?php include("assets/inc/sidebar.php");?>

        <div class="content-page">
            <div class="content">
                <div class="container-fluid">
                    <div class="row animate__animated animate__fadeIn">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Payroll</a></li>
                                        <li class="breadcrumb-item active">Add Payroll</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Employee Details</h4>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-12">
                            <div class="card-box">
                                <div class="d-flex justify-content-between align-items-center mb-3 animate__animated animate__fadeInDown">
                                    <h4 class="header-title">Employee Records</h4>
                                    <div class="search-box">
                                        <input id="demo-foo-search" type="text" placeholder="Search employees..." class="form-control form-control-sm" autocomplete="on">
                                    </div>
                                </div>
                                
                                <div class="table-responsive">
                                    <table id="demo-foo-filtering" class="table table-hover mb-0">
                                        <thead class="thead-light animate__animated animate__fadeIn">
                                            <tr>
                                                <th>#</th>
                                                <th data-toggle="true">Employee Name</th>
                                                <th data-hide="phone">Employee ID</th>
                                                <th data-hide="phone">Email</th>
                                                <th data-hide="phone">Department</th>
                                                <th data-hide="phone">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $ret = "SELECT * FROM his_docs ORDER BY RAND()";
                                            $stmt = $mysqli->prepare($ret);
                                            $stmt->execute();
                                            $res = $stmt->get_result();
                                            $cnt = 1;
                                            while($row = $res->fetch_object()):
                                            ?>
                                            <tr style="--i: <?php echo $cnt; ?>">
                                                <td><?php echo $cnt; ?></td>
                                                <td>
                                                    <div class="font-weight-semibold"><?php echo $row->doc_fname; ?> <?php echo $row->doc_lname; ?></div>
                                                </td>
                                                <td><?php echo $row->doc_number; ?></td>
                                                <td><?php echo $row->doc_email; ?></td>
                                                <td><?php echo $row->doc_dept; ?></td>
                                                <td>
                                                    <div class="d-flex">
                                                        <a href="view_single_employee.php?doc_id=<?php echo $row->doc_id; ?>&&doc_number=<?php echo $row->doc_number; ?>" class="badge badge-primary mr-2">
                                                            <i class="mdi mdi-eye-outline mr-1"></i> View
                                                        </a>
                                                        <a href="add_single_employee_payroll.php?doc_number=<?php echo $row->doc_number; ?>" class="badge badge-success">
                                                            <i class="mdi mdi-cash-plus mr-1"></i> Add Payroll
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <?php $cnt++; endwhile; ?>
                                        </tbody>
                                        <tfoot>
                                            <tr class="animate__animated animate__fadeIn">
                                                <td colspan="6">
                                                    <div class="text-right">
                                                        <ul class="pagination pagination-rounded justify-content-end footable-pagination"></ul>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php include('assets/inc/footer.php');?>
        </div>
    </div>

    <div class="rightbar-overlay"></div>

    <script src="assets/js/vendor.min.js"></script>
    <script src="assets/libs/footable/footable.all.min.js"></script>
    <script src="assets/js/pages/foo-tables.init.js"></script>
    <script src="assets/js/app.min.js"></script>
    
    <script>
        // Additional animation triggers
        document.addEventListener('DOMContentLoaded', function() {
            // Animate search box on focus
            const searchBox = document.getElementById('demo-foo-search');
            if(searchBox) {
                searchBox.addEventListener('focus', function() {
                    this.parentElement.classList.add('animate__pulse');
                });
                
                searchBox.addEventListener('blur', function() {
                    this.parentElement.classList.remove('animate__pulse');
                });
            }
            
            // Add hover effect to table rows
            const tableRows = document.querySelectorAll('.table tbody tr');
            tableRows.forEach(row => {
                row.addEventListener('mouseenter', () => {
                    row.classList.add('animate__animated', 'animate__pulse');
                });
                
                row.addEventListener('mouseleave', () => {
                    setTimeout(() => {
                        row.classList.remove('animate__animated', 'animate__pulse');
                    }, 500);
                });
            });
            
            // Button hover effects
            const buttons = document.querySelectorAll('.badge');
            buttons.forEach(button => {
                button.addEventListener('mouseenter', () => {
                    button.classList.add('animate__animated', 'animate__headShake');
                });
                
                button.addEventListener('mouseleave', () => {
                    setTimeout(() => {
                        button.classList.remove('animate__animated', 'animate__headShake');
                    }, 500);
                });
            });
        });
    </script>
</body>
</html>