<?php
session_start();
include('assets/inc/config.php');
if(isset($_POST['add_patient_vitals'])) {
    $vit_number = $_POST['vit_number'];
    $vit_pat_number = $_POST['vit_pat_number'];
    $vit_bodytemp  = $_POST['vit_bodytemp'];
    $vit_heartpulse = $_POST['vit_heartpulse'];
    $vit_resprate  = $_POST['vit_resprate'];
    $vit_bloodpress = $_POST['vit_bloodpress'];
    
    $query = "INSERT INTO his_vitals (vit_number, vit_pat_number, vit_bodytemp, vit_heartpulse, vit_resprate, vit_bloodpress) VALUES(?,?,?,?,?,?)";
    $stmt = $mysqli->prepare($query);
    $rc = $stmt->bind_param('ssssss', $vit_number, $vit_pat_number, $vit_bodytemp, $vit_heartpulse, $vit_resprate, $vit_bloodpress);
    $stmt->execute();
    
    if($stmt) {
        $success = "Patient Vitals Added Successfully";
    } else {
        $err = "Please Try Again Or Try Later";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        /* Custom CSS */
        .card {
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }
        .card-body {
            padding: 2rem;
        }
        .form-control {
            border-radius: 5px;
            padding: 10px 15px;
            border: 1px solid #ced4da;
        }
        .form-control:focus {
            border-color: #80bdff;
            box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
        }
        .form-control[readonly] {
            background-color: #f8f9fa;
        }
        .btn-success {
            background-color: #28a745;
            border-color: #28a745;
            padding: 10px 25px;
            font-weight: 600;
            border-radius: 5px;
            transition: all 0.3s;
        }
        .btn-success:hover {
            background-color: #218838;
            border-color: #1e7e34;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        .header-title {
            color: #2c3e50;
            margin-bottom: 1.5rem;
            font-weight: 700;
        }
        hr {
            margin: 2rem 0;
            border-top: 1px solid #eee;
        }
        .form-group label {
            font-weight: 600;
            margin-bottom: 8px;
            color: #495057;
        }
        .vital-input-group {
            position: relative;
        }
        .vital-input-group .input-group-text {
            position: absolute;
            right: 0;
            top: 0;
            height: 100%;
            background: transparent;
            border: none;
            color: #6c757d;
            font-weight: 500;
        }
        /* Responsive adjustments */
        @media (max-width: 768px) {
            .form-row > div {
                margin-bottom: 15px;
            }
        }
    </style>
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include("assets/inc/nav.php");?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->
        <?php
            $pat_number = $_GET['pat_number'];
            $ret = "SELECT * FROM his_patients WHERE pat_number=?";
            $stmt = $mysqli->prepare($ret);
            $stmt->bind_param('s', $pat_number);
            $stmt->execute();
            $res = $stmt->get_result();
            while($row = $res->fetch_object()):
        ?>
            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Laboratory</a></li>
                                            <li class="breadcrumb-item active">Capture Vitals</li>
                                        </ol>
                                    </div>
                                    <h4 class="page-title">Capture <?php echo htmlspecialchars($row->pat_fname); ?> <?php echo htmlspecialchars($row->pat_lname); ?> Vitals</h4>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 
                        
                        <!-- Success/Error Messages -->
                        <?php if(isset($success)): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <?php echo $success; ?>
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        <?php endif; ?>
                        <?php if(isset($err)): ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <?php echo $err; ?>
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        <?php endif; ?>
                        
                        <!-- Form row -->
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="header-title">Patient Vitals Information</h4>
                                        
                                        <!--Add Patient Form-->
                                        <form method="post">
                                            <div class="form-row">
                                                <div class="form-group col-md-6">
                                                    <label>Patient Name</label>
                                                    <input type="text" readonly class="form-control" 
                                                           value="<?php echo htmlspecialchars($row->pat_fname) . ' ' . htmlspecialchars($row->pat_lname); ?>">
                                                </div>

                                                <div class="form-group col-md-6">
                                                    <label>Patient Ailment</label>
                                                    <input type="text" readonly class="form-control" 
                                                           value="<?php echo htmlspecialchars($row->pat_ailment); ?>">
                                                </div>
                                            </div>

                                            <div class="form-row">
                                                <div class="form-group col-md-12">
                                                    <label for="vit_pat_number">Patient Number</label>
                                                    <input type="text" required readonly name="vit_pat_number" 
                                                           value="<?php echo htmlspecialchars($row->pat_number); ?>" 
                                                           class="form-control" id="vit_pat_number">
                                                </div>
                                            </div>

                                            <hr>
                                            
                                            <!-- Hidden vital number field -->
                                            <div class="form-group" style="display:none">
                                                <?php 
                                                    $length = 5;    
                                                    $vit_no = substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'),1,$length);
                                                ?>
                                                <input type="text" name="vit_number" value="<?php echo $vit_no; ?>" class="form-control">
                                            </div>

                                            <div class="form-row">
                                                <div class="form-group col-md-3 vital-input-group">
                                                    <label for="vit_bodytemp">Body Temperature</label>
                                                    <input type="text" required name="vit_bodytemp" class="form-control" 
                                                           id="vit_bodytemp" placeholder="36.5">
                                                    <div class="input-group-text">°C</div>
                                                </div>

                                                <div class="form-group col-md-3 vital-input-group">
                                                    <label for="vit_heartpulse">Heart Pulse/Beat</label>
                                                    <input type="text" required name="vit_heartpulse" class="form-control" 
                                                           id="vit_heartpulse" placeholder="72">
                                                    <div class="input-group-text">BPM</div>
                                                </div>

                                                <div class="form-group col-md-3 vital-input-group">
                                                    <label for="vit_resprate">Respiratory Rate</label>
                                                    <input type="text" required name="vit_resprate" class="form-control" 
                                                           id="vit_resprate" placeholder="16">
                                                    <div class="input-group-text">bpm</div>
                                                </div>

                                                <div class="form-group col-md-3 vital-input-group">
                                                    <label for="vit_bloodpress">Blood Pressure</label>
                                                    <input type="text" required name="vit_bloodpress" class="form-control" 
                                                           id="vit_bloodpress" placeholder="120/80">
                                                    <div class="input-group-text">mmHg</div>
                                                </div>
                                            </div>

                                            <button type="submit" name="add_patient_vitals" class="ladda-button btn btn-success" data-style="expand-right">
                                                <span class="ladda-label">Save Vitals</span>
                                            </button>
                                        </form>
                                        <!--End Patient Form-->
                                    </div> <!-- end card-body -->
                                </div> <!-- end card-->
                            </div> <!-- end col -->
                        </div>
                        <!-- end row -->
                    </div> <!-- container -->
                </div> <!-- content -->

                <!-- Footer Start -->
                <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->
            </div>
        <?php endwhile; ?>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->
    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App js-->
    <script src="assets/js/app.min.js"></script>

    <!-- Loading buttons js -->
    <script src="assets/libs/ladda/spin.js"></script>
    <script src="assets/libs/ladda/ladda.js"></script>

    <!-- Buttons init js-->
    <script src="assets/js/pages/loading-btn.init.js"></script>
    
    <!-- Input validation -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Add input validation for numeric fields
            document.getElementById('vit_bodytemp').addEventListener('input', function(e) {
                this.value = this.value.replace(/[^0-9.]/g, '');
            });
            
            document.getElementById('vit_heartpulse').addEventListener('input', function(e) {
                this.value = this.value.replace(/[^0-9]/g, '');
            });
            
            document.getElementById('vit_resprate').addEventListener('input', function(e) {
                this.value = this.value.replace(/[^0-9]/g, '');
            });
            
            document.getElementById('vit_bloodpress').addEventListener('input', function(e) {
                // Allow numbers and forward slash for blood pressure
                this.value = this.value.replace(/[^0-9\/]/g, '');
            });
        });
    </script>
</body>
</html>