<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];

// Get all required metrics from database
// Total Beds
$bed_result = "SELECT COUNT(*) FROM his_beds";
$bed_stmt = $mysqli->prepare($bed_result);
$bed_stmt->execute();
$bed_stmt->bind_result($total_beds);
$bed_stmt->fetch();
$bed_stmt->close();

// OPD Amounts
$opd_result = "SELECT 
    COALESCE(SUM(CASE WHEN p.pat_type = 'OutPatient' THEN CAST(p.fee AS DECIMAL(10,2)) ELSE 0 END), 0) as total_opd,
    COALESCE(SUM(CASE WHEN p.pat_type = 'OutPatient' AND p.psataus = 'paid' THEN CAST(p.fee AS DECIMAL(10,2)) ELSE 0 END), 0) as paid_opd,
    COALESCE(SUM(CASE WHEN p.pat_type = 'OutPatient' AND p.psataus = 'pending' THEN CAST(p.fee AS DECIMAL(10,2)) ELSE 0 END), 0) as due_opd
FROM his_patients p";
$opd_stmt = $mysqli->prepare($opd_result);
$opd_stmt->execute();
$opd_stmt->bind_result($all_opd_amount, $paid_opd_amount, $due_opd_amount);
$opd_stmt->fetch();
$opd_stmt->close();



$total_patients_result = "SELECT COUNT(*) FROM his_patients";
$total_patients_stmt = $mysqli->prepare($total_patients_result);
$total_patients_stmt->execute();
$total_patients_stmt->bind_result($total_patients);
$total_patients_stmt->fetch();
$total_patients_stmt->close();

// Total IPD Patients
$ipd_patients_result = "SELECT COUNT(*) FROM his_patients WHERE pat_type = 'InPatient'";
$ipd_patients_stmt = $mysqli->prepare($ipd_patients_result);
$ipd_patients_stmt->execute();
$ipd_patients_stmt->bind_result($total_ipd_patients);
$ipd_patients_stmt->fetch();
$ipd_patients_stmt->close();

// Total OPD Patients
$opd_patients_result = "SELECT COUNT(*) FROM his_patients WHERE pat_type = 'OutPatient'";
$opd_patients_stmt = $mysqli->prepare($opd_patients_result);
$opd_patients_stmt->execute();
$opd_patients_stmt->bind_result($total_opd_patients);
$opd_patients_stmt->fetch();
$opd_patients_stmt->close();
// IPD Amounts
$ipd_result = "SELECT 
    COALESCE(SUM(CASE WHEN p.pat_type = 'InPatient' THEN CAST(p.fee AS DECIMAL(10,2)) ELSE 0 END), 0) as total_ipd,
    COALESCE(SUM(CASE WHEN p.pat_type = 'InPatient' AND p.psataus = 'paid' THEN CAST(p.fee AS DECIMAL(10,2)) ELSE 0 END), 0) as paid_ipd,
    COALESCE(SUM(CASE WHEN p.pat_type = 'InPatient' AND p.psataus = 'pending' THEN CAST(p.fee AS DECIMAL(10,2)) ELSE 0 END), 0) as due_ipd,
    COALESCE(SUM(CASE WHEN p.pat_type = 'InPatient' THEN CAST(p.fee AS DECIMAL(10,2)) * 0.1 ELSE 0 END), 0) as discount_ipd
FROM his_patients p";
$ipd_stmt = $mysqli->prepare($ipd_result);
$ipd_stmt->execute();
$ipd_stmt->bind_result($all_ipd_amount, $paid_ipd_amount, $due_ipd_amount, $discount_ipd_amount);
$ipd_stmt->fetch();
$ipd_stmt->close();

// Total Employees
$emp_result = "SELECT COUNT(*) FROM his_docs";
$emp_stmt = $mysqli->prepare($emp_result);
$emp_stmt->execute();
$emp_stmt->bind_result($total_employees);
$emp_stmt->fetch();
$emp_stmt->close();

// Total MRD Patients
$mrd_result = "SELECT COUNT(*) FROM his_patients WHERE pat_type = 'OutPatient'";
$mrd_stmt = $mysqli->prepare($mrd_result);
$mrd_stmt->execute();
$mrd_stmt->bind_result($total_mrd_patients);
$mrd_stmt->fetch();
$mrd_stmt->close();

// Total Expenses
$expense_result = "SELECT COALESCE(SUM(amount), 0) FROM his_expenses WHERE status = 'Approved'";
$expense_stmt = $mysqli->prepare($expense_result);
$expense_stmt->execute();
$expense_stmt->bind_result($total_expenses);
$expense_stmt->fetch();
$expense_stmt->close();

// Total Inventory (Pharmaceuticals + Equipment)
$inventory_result = "SELECT 
    (SELECT COALESCE(SUM(CAST(phar_qty AS INTEGER)), 0) FROM his_pharmaceuticals) + 
    (SELECT COALESCE(SUM(CAST(eqp_qty AS INTEGER)), 0) FROM his_equipments) as total_inventory";
$inventory_stmt = $mysqli->prepare($inventory_result);
$inventory_stmt->execute();
$inventory_stmt->bind_result($total_inventory);
$inventory_stmt->fetch();
$inventory_stmt->close();
?>
<!DOCTYPE html>
<html lang="en">
    
    <!--Head Code-->
    <?php include("assets/inc/head.php");?>

    <body class="dashboard-background" style="background-color: #f5f7fa;">

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
            <?php include('assets/inc/nav.php');?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
            <?php include('assets/inc/sidebar.php');?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                      <div class="row">
    <div class="col-12">
        <div class="page-title-box" style="
            border-radius: 10px; 
            padding: 15px 20px; 
            background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
            box-shadow: 0 3px 15px rgba(0,0,0,0.04);
            border: 1px solid rgba(255,255,255,0.2);
            backdrop-filter: blur(5px);
            height: 70px;
            overflow: hidden;
            position: relative;
            animation: slideInDown 0.6s ease-out;
        ">
            <!-- Animated background elements -->
            <div style="
                position: absolute;
                top: -20px;
                right: -20px;
                width: 80px;
                height: 80px;
                background: linear-gradient(135deg, rgba(108, 92, 231, 0.1) 0%, rgba(162, 155, 254, 0.1) 100%);
                border-radius: 50%;
                z-index: 0;
                animation: pulse 4s infinite ease-in-out;
            "></div>
            
            <div style="
                position: absolute;
                bottom: -15px;
                left: -15px;
                width: 60px;
                height: 60px;
                background: linear-gradient(135deg, rgba(108, 92, 231, 0.05) 0%, rgba(162, 155, 254, 0.05) 100%);
                border-radius: 50%;
                z-index: 0;
                animation: pulse 4s infinite ease-in-out 1s;
            "></div>
            
            <div class="d-flex align-items-center justify-content-between" style="position: relative; z-index: 1; height: 100%;">
                <div class="d-flex align-items-center">
                    <div style="
                        background: linear-gradient(135deg, #6c5ce7 0%, #a29bfe 100%);
                        width: 40px;
                        height: 40px;
                        border-radius: 10px;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        margin-right: 12px;
                        box-shadow: 0 4px 10px rgba(108, 92, 231, 0.3);
                        animation: bounceIn 0.8s ease-out;
                    ">
                        <i class="fas fa-clinic-medical" style="color: white; font-size: 1.2rem;"></i>
                    </div>
                    <h4 class="page-title font-weight-bold mb-0" style="color: #2c3e50; font-size: 1.3rem; animation: fadeInLeft 0.8s ease-out;">
                        Hospital Dashboard
                    </h4>
                </div>
                
                <div class="page-title-right" style="animation: fadeInRight 0.8s ease-out;">
                    <ol class="breadcrumb m-0" style="display: flex; align-items: center;">
                        <li class="breadcrumb-item" style="margin-right: 5px;">
                            <a href="javascript: void(0);" style="color: #6c5ce7; text-decoration: none; font-size: 0.9rem;">
                                <i class="fas fa-hospital mr-1" style="font-size: 0.8rem;"></i> Hospital
                            </a>
                        </li>
                        <li class="breadcrumb-item active" style="color: #636e72; font-size: 0.9rem; display: flex; align-items: center;">
                            <i class="fas fa-chevron-right mx-2" style="font-size: 0.7rem; color: #adb5bd;"></i>
                            <i class="fas fa-tachometer-alt mr-1" style="font-size: 0.8rem;"></i> Dashboard
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    /* Animations */
    @keyframes slideInDown {
        from {
            transform: translateY(-20px);
            opacity: 0;
        }
        to {
            transform: translateY(0);
            opacity: 1;
        }
    }
    
    @keyframes fadeInLeft {
        from {
            transform: translateX(-20px);
            opacity: 0;
        }
        to {
            transform: translateX(0);
            opacity: 1;
        }
    }
    
    @keyframes fadeInRight {
        from {
            transform: translateX(20px);
            opacity: 0;
        }
        to {
            transform: translateX(0);
            opacity: 1;
        }
    }
    
    @keyframes bounceIn {
        0% {
            transform: scale(0.8);
            opacity: 0;
        }
        50% {
            transform: scale(1.1);
        }
        100% {
            transform: scale(1);
            opacity: 1;
        }
    }
    
    @keyframes pulse {
        0% {
            transform: scale(1);
            opacity: 0.5;
        }
        50% {
            transform: scale(1.1);
            opacity: 0.7;
        }
        100% {
            transform: scale(1);
            opacity: 0.5;
        }
    }
    
    /* Hover effects */
    .page-title-box:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(0,0,0,0.07);
        transition: all 0.3s ease;
    }
    
    .page-title-box:hover .breadcrumb-item a {
        color: #a29bfe !important;
        transition: color 0.3s ease;
    }
    
    /* Responsive adjustments */
    @media (max-width: 768px) {
        .page-title-box {
            height: auto !important;
            padding: 12px 15px !important;
        }
        
        .page-title-box h4 {
            font-size: 1.1rem !important;
        }
        
        .breadcrumb {
            font-size: 0.8rem !important;
        }
        
        .breadcrumb-item {
            display: none;
        }
        
        .breadcrumb-item.active {
            display: flex !important;
        }
    }
</style>
                        <!-- end page title --> 
                        

                        <div class="row mt-4">

                           


<div class="col-md-4 col-xl-4">
    <div class="widget-rounded-circle card-box shadow-sm" style="
        border-radius: 16px; 
        overflow: hidden; 
        transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
        background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
        border: none;
        animation: fadeIn 0.6s ease-out;
        height: 120px;
        position: relative;
    ">
        <!-- Optional subtle pattern overlay -->
        <div style="
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
           
        "></div>
        
        <div class="row align-items-center p-3" style="height: 90px; position: relative; z-index: 2;">
            <div class="col-5">
                <div class="avatar-lg rounded-circle d-flex align-items-center justify-content-center" style="
                    background: rgba(255, 255, 255, 0.2);
                    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
                    transition: transform 0.3s ease;
                    width: 60px;
                    height: 60px;
                    backdrop-filter: blur(5px);
                ">
                    <i class="fas fa-user-injured font-22" style="color: white;"></i>
                </div>
            </div>
            <div class="col-7">
                <div class="text-right">
                    <h3 class="mt-1 mb-0" style="color: white; font-size: 1.4rem; text-shadow: 0 2px 4px rgba(0,0,0,0.2);">
                        <span data-plugin="counterup"><?php echo $total_patients;?></span>
                    </h3>
                    <p class="mb-1 text-truncate" style="color: rgba(255, 255, 255, 0.9); font-weight: 500; font-size: 0.9rem;">
                        <i class="fas fa-circle mr-1" style="font-size: 8px; color: white; vertical-align: middle;"></i> Total Patients
                    </p>
                </div>
            </div>
        </div>
        
        <!-- Subtle shine effect -->
        <div style="
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 200%;
            background: linear-gradient(to right, rgba(255,255,255,0) 0%, rgba(255,255,255,0.1) 50%, rgba(255,255,255,0) 100%);
            transform: rotate(30deg);
            z-index: 1;
            pointer-events: none;
        "></div>
    </div>
</div>

                            <!-- Total IPD Patients -->
                           <!-- Total Patients -->


<!-- IPD Patients -->
<div class="col-md-4 col-xl-4">
    <div class="widget-rounded-circle card-box shadow-sm" style="
        border-radius: 16px; 
        overflow: hidden; 
        transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
        background: linear-gradient(135deg, #0ba360 0%, #3cba92 100%);
        border: none;
        animation: fadeIn 0.6s ease-out 0.1s;
        height: 120px;
        position: relative;
    ">
        <div style="
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
          
        "></div>
        
        <div class="row align-items-center p-3" style="height: 90px; position: relative; z-index: 2;">
            <div class="col-5">
                <div class="avatar-lg rounded-circle d-flex align-items-center justify-content-center" style="
                    background: rgba(255, 255, 255, 0.2);
                    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
                    transition: transform 0.3s ease;
                    width: 60px;
                    height: 60px;
                    backdrop-filter: blur(5px);
                ">
                    <i class="fas fa-procedures font-22" style="color: white;"></i>
                </div>
            </div>
            <div class="col-7">
                <div class="text-right">
                    <h3 class="mt-1 mb-0" style="color: white; font-size: 1.4rem; text-shadow: 0 2px 4px rgba(0,0,0,0.2);">
                        <span data-plugin="counterup"><?php echo $total_ipd_patients;?></span>
                    </h3>
                    <p class="mb-1 text-truncate" style="color: rgba(255, 255, 255, 0.9); font-weight: 500; font-size: 0.9rem;">
                        <i class="fas fa-circle mr-1" style="font-size: 8px; color: white; vertical-align: middle;"></i> IPD Patients
                    </p>
                </div>
            </div>
        </div>
        
        <div style="
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 200%;
            background: linear-gradient(to right, rgba(255,255,255,0) 0%, rgba(255,255,255,0.1) 50%, rgba(255,255,255,0) 100%);
            transform: rotate(30deg);
            z-index: 1;
            pointer-events: none;
        "></div>
    </div>
</div>

<!-- OPD Patients -->
<div class="col-md-4 col-xl-4">
    <div class="widget-rounded-circle card-box shadow-sm" style="
        border-radius: 16px; 
        overflow: hidden; 
        transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
        background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);
        border: none;
        animation: fadeIn 0.6s ease-out 0.2s;
        height: 120px;
        position: relative;
    ">
        <div style="
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
           
        "></div>
        
        <div class="row align-items-center p-3" style="height: 90px; position: relative; z-index: 2;">
            <div class="col-5">
                <div class="avatar-lg rounded-circle d-flex align-items-center justify-content-center" style="
                    background: rgba(255, 255, 255, 0.2);
                    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
                    transition: transform 0.3s ease;
                    width: 60px;
                    height: 60px;
                    backdrop-filter: blur(5px);
                ">
                    <i class="fas fa-stethoscope font-22" style="color: white;"></i>
                </div>
            </div>
            <div class="col-7">
                <div class="text-right">
                    <h3 class="mt-1 mb-0" style="color: white; font-size: 1.4rem; text-shadow: 0 2px 4px rgba(0,0,0,0.2);">
                        <span data-plugin="counterup"><?php echo $total_opd_patients;?></span>
                    </h3>
                    <p class="mb-1 text-truncate" style="color: rgba(255, 255, 255, 0.9); font-weight: 500; font-size: 0.9rem;">
                        <i class="fas fa-circle mr-1" style="font-size: 8px; color: white; vertical-align: middle;"></i> OPD Patients
                    </p>
                </div>
            </div>
        </div>
        
        <div style="
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 200%;
            background: linear-gradient(to right, rgba(255,255,255,0) 0%, rgba(255,255,255,0.1) 50%, rgba(255,255,255,0) 100%);
            transform: rotate(30deg);
            z-index: 1;
            pointer-events: none;
        "></div>
    </div>
</div>

<!-- Total Beds -->
<div class="col-md-4 col-xl-4">
    <div class="widget-rounded-circle card-box shadow-sm" style="
        border-radius: 16px; 
        overflow: hidden; 
        transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
        background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
        border: none;
        animation: fadeIn 0.6s ease-out;
        height: 120px;
        position: relative;
    ">
        <div style="
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
         
        "></div>
        
        <div class="row align-items-center p-3" style="height: 90px; position: relative; z-index: 2;">
            <div class="col-5">
                <div class="avatar-lg rounded-circle d-flex align-items-center justify-content-center" style="
                    background: rgba(255, 255, 255, 0.2);
                    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
                    transition: transform 0.3s ease;
                    width: 60px;
                    height: 60px;
                    backdrop-filter: blur(5px);
                ">
                    <i class="fas fa-bed font-22" style="color: white;"></i>
                </div>
            </div>
            <div class="col-7">
                <div class="text-right">
                    <h3 class="mt-1 mb-0" style="color: white; font-size: 1.4rem; text-shadow: 0 2px 4px rgba(0,0,0,0.2);">
                        <span data-plugin="counterup"><?php echo $total_beds;?></span>
                    </h3>
                    <p class="mb-1 text-truncate" style="color: rgba(255, 255, 255, 0.9); font-weight: 500; font-size: 0.9rem;">
                        <i class="fas fa-circle mr-1" style="font-size: 8px; color: white; vertical-align: middle;"></i> Total Beds
                    </p>
                </div>
            </div>
        </div>
        
        <div style="
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 200%;
            background: linear-gradient(to right, rgba(255,255,255,0) 0%, rgba(255,255,255,0.1) 50%, rgba(255,255,255,0) 100%);
            transform: rotate(30deg);
            z-index: 1;
            pointer-events: none;
        "></div>
    </div>
</div>

<!-- All OPD Amount -->
<div class="col-md-4 col-xl-4">
    <div class="widget-rounded-circle card-box shadow-sm" style="
        border-radius: 16px; 
        overflow: hidden; 
        transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
        background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
        border: none;
        animation: fadeIn 0.6s ease-out 0.1s;
        height: 120px;
        position: relative;
    ">
        <div style="
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            
        "></div>
        
        <div class="row align-items-center p-3" style="height: 90px; position: relative; z-index: 2;">
            <div class="col-5">
                <div class="avatar-lg rounded-circle d-flex align-items-center justify-content-center" style="
                    background: rgba(255, 255, 255, 0.2);
                    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
                    transition: transform 0.3s ease;
                    width: 60px;
                    height: 60px;
                    backdrop-filter: blur(5px);
                ">
                    <i class="fas fa-money-bill-wave font-22" style="color: white;"></i>
                </div>
            </div>
            <div class="col-7">
                <div class="text-right">
                    <h3 class="mt-1 mb-0" style="color: white; font-size: 1.4rem; text-shadow: 0 2px 4px rgba(0,0,0,0.2);">
                        <span data-plugin="counterup"><?php echo number_format($all_opd_amount, 2);?></span>
                    </h3>
                    <p class="mb-1 text-truncate" style="color: rgba(255, 255, 255, 0.9); font-weight: 500; font-size: 0.9rem;">
                        <i class="fas fa-circle mr-1" style="font-size: 8px; color: white; vertical-align: middle;"></i> All OPD Amount
                    </p>
                </div>
            </div>
        </div>
        
        <div style="
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 200%;
            background: linear-gradient(to right, rgba(255,255,255,0) 0%, rgba(255,255,255,0.1) 50%, rgba(255,255,255,0) 100%);
            transform: rotate(30deg);
            z-index: 1;
            pointer-events: none;
        "></div>
    </div>
</div>

<!-- Paid OPD Amount -->
<div class="col-md-4 col-xl-4">
    <div class="widget-rounded-circle card-box shadow-sm" style="
        border-radius: 16px; 
        overflow: hidden; 
        transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
        background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);
        border: none;
        animation: fadeIn 0.6s ease-out 0.2s;
        height: 120px;
        position: relative;
    ">
        <div style="
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
           
        "></div>
        
        <div class="row align-items-center p-3" style="height: 90px; position: relative; z-index: 2;">
            <div class="col-5">
                <div class="avatar-lg rounded-circle d-flex align-items-center justify-content-center" style="
                    background: rgba(255, 255, 255, 0.2);
                    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
                    transition: transform 0.3s ease;
                    width: 60px;
                    height: 60px;
                    backdrop-filter: blur(5px);
                ">
                    <i class="fas fa-check-circle font-22" style="color: white;"></i>
                </div>
            </div>
            <div class="col-7">
                <div class="text-right">
                    <h3 class="mt-1 mb-0" style="color: white; font-size: 1.4rem; text-shadow: 0 2px 4px rgba(0,0,0,0.2);">
                        <span data-plugin="counterup"><?php echo number_format($paid_opd_amount, 2);?></span>
                    </h3>
                    <p class="mb-1 text-truncate" style="color: rgba(255, 255, 255, 0.9); font-weight: 500; font-size: 0.9rem;">
                        <i class="fas fa-circle mr-1" style="font-size: 8px; color: white; vertical-align: middle;"></i> Paid OPD Amount
                    </p>
                </div>
            </div>
        </div>
        
        <div style="
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 200%;
            background: linear-gradient(to right, rgba(255,255,255,0) 0%, rgba(255,255,255,0.1) 50%, rgba(255,255,255,0) 100%);
            transform: rotate(30deg);
            z-index: 1;
            pointer-events: none;
        "></div>
    </div>
</div>

<!-- Due OPD Amount -->
<div class="col-md-4 col-xl-4">
    <div class="widget-rounded-circle card-box shadow-sm" style="
        border-radius: 16px; 
        overflow: hidden; 
        transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
        background: linear-gradient(135deg, #ff5858 0%, #f09819 100%);
        border: none;
        animation: fadeIn 0.6s ease-out 0.3s;
        height: 120px;
        position: relative;
    ">
        <div style="
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
          
        "></div>
        
        <div class="row align-items-center p-3" style="height: 90px; position: relative; z-index: 2;">
            <div class="col-5">
                <div class="avatar-lg rounded-circle d-flex align-items-center justify-content-center" style="
                    background: rgba(255, 255, 255, 0.2);
                    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
                    transition: transform 0.3s ease;
                    width: 60px;
                    height: 60px;
                    backdrop-filter: blur(5px);
                ">
                    <i class="fas fa-exclamation-triangle font-22" style="color: white;"></i>
                </div>
            </div>
            <div class="col-7">
                <div class="text-right">
                    <h3 class="mt-1 mb-0" style="color: white; font-size: 1.4rem; text-shadow: 0 2px 4px rgba(0,0,0,0.2);">
                        <span data-plugin="counterup"><?php echo number_format($due_opd_amount, 2);?></span>
                    </h3>
                    <p class="mb-1 text-truncate" style="color: rgba(255, 255, 255, 0.9); font-weight: 500; font-size: 0.9rem;">
                        <i class="fas fa-circle mr-1" style="font-size: 8px; color: white; vertical-align: middle;"></i> Due OPD Amount
                    </p>
                </div>
            </div>
        </div>
        
        <div style="
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 200%;
            background: linear-gradient(to right, rgba(255,255,255,0) 0%, rgba(255,255,255,0.1) 50%, rgba(255,255,255,0) 100%);
            transform: rotate(30deg);
            z-index: 1;
            pointer-events: none;
        "></div>
    </div>
</div>
                       
                            <!-- All IPD Amount -->
                           <!-- All IPD Amount -->
<div class="col-md-4 col-xl-4">
    <div class="widget-rounded-circle card-box shadow-sm" style="
        border-radius: 16px; 
        overflow: hidden; 
        transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
        background: linear-gradient(135deg, #8E2DE2 0%, #4A00E0 100%);
        border: none;
        animation: fadeIn 0.6s ease-out 0.4s;
        height: 120px;
        position: relative;
    ">
        <div style="
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            
        "></div>
        
        <div class="row align-items-center p-3" style="height: 90px; position: relative; z-index: 2;">
            <div class="col-5">
                <div class="avatar-lg rounded-circle d-flex align-items-center justify-content-center" style="
                    background: rgba(255, 255, 255, 0.2);
                    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
                    transition: transform 0.3s ease;
                    width: 60px;
                    height: 60px;
                    backdrop-filter: blur(5px);
                ">
                    <i class="fas fa-hospital-user font-22" style="color: white;"></i>
                </div>
            </div>
            <div class="col-7">
                <div class="text-right">
                    <h3 class="mt-1 mb-0" style="color: white; font-size: 1.4rem; text-shadow: 0 2px 4px rgba(0,0,0,0.2);">
                        <span data-plugin="counterup"><?php echo number_format($all_ipd_amount, 2);?></span>
                    </h3>
                    <p class="mb-1 text-truncate" style="color: rgba(255, 255, 255, 0.9); font-weight: 500; font-size: 0.9rem;">
                        <i class="fas fa-circle mr-1" style="font-size: 8px; color: white; vertical-align: middle;"></i> All IPD Amount
                    </p>
                </div>
            </div>
        </div>
        
        <div style="
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 200%;
            background: linear-gradient(to right, rgba(255,255,255,0) 0%, rgba(255,255,255,0.1) 50%, rgba(255,255,255,0) 100%);
            transform: rotate(30deg);
            z-index: 1;
            pointer-events: none;
        "></div>
    </div>
</div>

<!-- Paid IPD Amount -->
<div class="col-md-4 col-xl-4">
    <div class="widget-rounded-circle card-box shadow-sm" style="
        border-radius: 16px; 
        overflow: hidden; 
        transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
        background: linear-gradient(135deg, #00b09b 0%, #96c93d 100%);
        border: none;
        animation: fadeIn 0.6s ease-out 0.5s;
        height: 120px;
        position: relative;
    ">
        <div style="
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-image: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"20\" height=\"20\" viewBox=\"0 0 20 20\"><circle cx=\"2\" cy=\"2\" r=\"1\" fill=\"white\" opacity=\"0.1\"/></svg>');
            z-index: 1;
        "></div>
        
        <div class="row align-items-center p-3" style="height: 90px; position: relative; z-index: 2;">
            <div class="col-5">
                <div class="avatar-lg rounded-circle d-flex align-items-center justify-content-center" style="
                    background: rgba(255, 255, 255, 0.2);
                    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
                    transition: transform 0.3s ease;
                    width: 60px;
                    height: 60px;
                    backdrop-filter: blur(5px);
                ">
                    <i class="fas fa-receipt font-22" style="color: white;"></i>
                </div>
            </div>
            <div class="col-7">
                <div class="text-right">
                    <h3 class="mt-1 mb-0" style="color: white; font-size: 1.4rem; text-shadow: 0 2px 4px rgba(0,0,0,0.2);">
                        <span data-plugin="counterup"><?php echo number_format($paid_ipd_amount, 2);?></span>
                    </h3>
                    <p class="mb-1 text-truncate" style="color: rgba(255, 255, 255, 0.9); font-weight: 500; font-size: 0.9rem;">
                        <i class="fas fa-circle mr-1" style="font-size: 8px; color: white; vertical-align: middle;"></i> Paid IPD Amount
                    </p>
                </div>
            </div>
        </div>
        
        <div style="
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 200%;
            background: linear-gradient(to right, rgba(255,255,255,0) 0%, rgba(255,255,255,0.1) 50%, rgba(255,255,255,0) 100%);
            transform: rotate(30deg);
            z-index: 1;
            pointer-events: none;
        "></div>
    </div>
</div>

<!-- Due IPD Amount -->
<div class="col-md-4 col-xl-4">
    <div class="widget-rounded-circle card-box shadow-sm" style="
        border-radius: 16px; 
        overflow: hidden; 
        transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
        background: linear-gradient(135deg, #ff416c 0%, #ff4b2b 100%);
        border: none;
        animation: fadeIn 0.6s ease-out 0.6s;
        height: 120px;
        position: relative;
    ">
        <div style="
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
           
        "></div>
        
        <div class="row align-items-center p-3" style="height: 90px; position: relative; z-index: 2;">
            <div class="col-5">
                <div class="avatar-lg rounded-circle d-flex align-items-center justify-content-center" style="
                    background: rgba(255, 255, 255, 0.2);
                    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
                    transition: transform 0.3s ease;
                    width: 60px;
                    height: 60px;
                    backdrop-filter: blur(5px);
                ">
                    <i class="fas fa-clock font-22" style="color: white;"></i>
                </div>
            </div>
            <div class="col-7">
                <div class="text-right">
                    <h3 class="mt-1 mb-0" style="color: white; font-size: 1.4rem; text-shadow: 0 2px 4px rgba(0,0,0,0.2);">
                        <span data-plugin="counterup"><?php echo number_format($due_ipd_amount, 2);?></span>
                    </h3>
                    <p class="mb-1 text-truncate" style="color: rgba(255, 255, 255, 0.9); font-weight: 500; font-size: 0.9rem;">
                        <i class="fas fa-circle mr-1" style="font-size: 8px; color: white; vertical-align: middle;"></i> Due IPD Amount
                    </p>
                </div>
            </div>
        </div>
        
        <div style="
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 200%;
            background: linear-gradient(to right, rgba(255,255,255,0) 0%, rgba(255,255,255,0.1) 50%, rgba(255,255,255,0) 100%);
            transform: rotate(30deg);
            z-index: 1;
            pointer-events: none;
        "></div>
    </div>
</div>

<!-- IPD Discount Amount -->
<div class="col-md-4 col-xl-4">
    <div class="widget-rounded-circle card-box shadow-sm" style="
        border-radius: 16px; 
        overflow: hidden; 
        transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
        background: linear-gradient(135deg, #FFE53B 0%, #FF2525 100%);
        border: none;
        animation: fadeIn 0.6s ease-out 0.7s;
        height: 120px;
        position: relative;
    ">
        <div style="
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            
        "></div>
        
        <div class="row align-items-center p-3" style="height: 90px; position: relative; z-index: 2;">
            <div class="col-5">
                <div class="avatar-lg rounded-circle d-flex align-items-center justify-content-center" style="
                    background: rgba(255, 255, 255, 0.2);
                    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
                    transition: transform 0.3s ease;
                    width: 60px;
                    height: 60px;
                    backdrop-filter: blur(5px);
                ">
                    <i class="fas fa-percent font-22" style="color: white;"></i>
                </div>
            </div>
            <div class="col-7">
                <div class="text-right">
                    <h3 class="mt-1 mb-0" style="color: white; font-size: 1.4rem; text-shadow: 0 2px 4px rgba(0,0,0,0.2);">
                        <span data-plugin="counterup"><?php echo number_format($discount_ipd_amount, 2);?></span>
                    </h3>
                    <p class="mb-1 text-truncate" style="color: rgba(255, 255, 255, 0.9); font-weight: 500; font-size: 0.9rem;">
                        <i class="fas fa-circle mr-1" style="font-size: 8px; color: white; vertical-align: middle;"></i> IPD Discount
                    </p>
                </div>
            </div>
        </div>
        
        <div style="
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 200%;
            background: linear-gradient(to right, rgba(255,255,255,0) 0%, rgba(255,255,255,0.1) 50%, rgba(255,255,255,0) 100%);
            transform: rotate(30deg);
            z-index: 1;
            pointer-events: none;
        "></div>
    </div>
</div>

<!-- Total Employees -->
<div class="col-md-4 col-xl-4">
    <div class="widget-rounded-circle card-box shadow-sm" style="
        border-radius: 16px; 
        overflow: hidden; 
        transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
        background: linear-gradient(135deg, #FF6B6B 0%, #FFE66D 100%);
        border: none;
        animation: fadeIn 0.6s ease-out 0.8s;
        height: 120px;
        position: relative;
    ">
        <div style="
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            

        "></div>
        
        <div class="row align-items-center p-3" style="height: 90px; position: relative; z-index: 2;">
            <div class="col-5">
                <div class="avatar-lg rounded-circle d-flex align-items-center justify-content-center" style="
                    background: rgba(255, 255, 255, 0.2);
                    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
                    transition: transform 0.3s ease;
                    width: 60px;
                    height: 60px;
                    backdrop-filter: blur(5px);
                ">
                    <i class="fas fa-user-md font-22" style="color: white;"></i>
                </div>
            </div>
            <div class="col-7">
                <div class="text-right">
                    <h3 class="mt-1 mb-0" style="color: white; font-size: 1.4rem; text-shadow: 0 2px 4px rgba(0,0,0,0.2);">
                        <span data-plugin="counterup"><?php echo $total_employees;?></span>
                    </h3>
                    <p class="mb-1 text-truncate" style="color: rgba(255, 255, 255, 0.9); font-weight: 500; font-size: 0.9rem;">
                        <i class="fas fa-circle mr-1" style="font-size: 8px; color: white; vertical-align: middle;"></i> Total Employees
                    </p>
                </div>
            </div>
        </div>
        
        <div style="
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 200%;
            background: linear-gradient(to right, rgba(255,255,255,0) 0%, rgba(255,255,255,0.1) 50%, rgba(255,255,255,0) 100%);
            transform: rotate(30deg);
            z-index: 1;
            pointer-events: none;
        "></div>
    </div>
</div>

                            <!-- Total MRD Patients -->
                           <!-- MRD Patients -->
<div class="col-md-4 col-xl-4">
    <div class="widget-rounded-circle card-box shadow-sm" style="
        border-radius: 16px; 
        overflow: hidden; 
        transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
        background: linear-gradient(135deg, #0093E9 0%, #80D0C7 100%);
        border: none;
        animation: fadeIn 0.6s ease-out 0.9s;
        height: 120px;
        position: relative;
    ">
        <div style="
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
           
        "></div>
        
        <div class="row align-items-center p-3" style="height: 90px; position: relative; z-index: 2;">
            <div class="col-5">
                <div class="avatar-lg rounded-circle d-flex align-items-center justify-content-center" style="
                    background: rgba(255, 255, 255, 0.2);
                    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
                    transition: transform 0.3s ease;
                    width: 60px;
                    height: 60px;
                    backdrop-filter: blur(5px);
                ">
                    <i class="fas fa-users font-22" style="color: white;"></i>
                </div>
            </div>
            <div class="col-7">
                <div class="text-right">
                    <h3 class="mt-1 mb-0" style="color: white; font-size: 1.4rem; text-shadow: 0 2px 4px rgba(0,0,0,0.2);">
                        <span data-plugin="counterup"><?php echo $total_mrd_patients;?></span>
                    </h3>
                    <p class="mb-1 text-truncate" style="color: rgba(255, 255, 255, 0.9); font-weight: 500; font-size: 0.9rem;">
                        <i class="fas fa-circle mr-1" style="font-size: 8px; color: white; vertical-align: middle;"></i> MRD Patients
                    </p>
                </div>
            </div>
        </div>
        
        <div style="
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 200%;
            background: linear-gradient(to right, rgba(255,255,255,0) 0%, rgba(255,255,255,0.1) 50%, rgba(255,255,255,0) 100%);
            transform: rotate(30deg);
            z-index: 1;
            pointer-events: none;
        "></div>
    </div>
</div>

<!-- Total Expenses -->
<div class="col-md-4 col-xl-4">
    <div class="widget-rounded-circle card-box shadow-sm" style="
        border-radius: 16px; 
        overflow: hidden; 
        transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
        background: linear-gradient(135deg, #FF416C 0%, #FF4B2B 100%);
        border: none;
        animation: fadeIn 0.6s ease-out 1.0s;
        height: 120px;
        position: relative;
    ">
        <div style="
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
          
        "></div>
        
        <div class="row align-items-center p-3" style="height: 90px; position: relative; z-index: 2;">
            <div class="col-5">
                <div class="avatar-lg rounded-circle d-flex align-items-center justify-content-center" style="
                    background: rgba(255, 255, 255, 0.2);
                    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
                    transition: transform 0.3s ease;
                    width: 60px;
                    height: 60px;
                    backdrop-filter: blur(5px);
                ">
                    <i class="fas fa-money-bill-alt font-22" style="color: white;"></i>
                </div>
            </div>
            <div class="col-7">
                <div class="text-right">
                    <h3 class="mt-1 mb-0" style="color: white; font-size: 1.4rem; text-shadow: 0 2px 4px rgba(0,0,0,0.2);">
                        <span data-plugin="counterup"><?php echo number_format($total_expenses, 2);?></span>
                    </h3>
                    <p class="mb-1 text-truncate" style="color: rgba(255, 255, 255, 0.9); font-weight: 500; font-size: 0.9rem;">
                        <i class="fas fa-circle mr-1" style="font-size: 8px; color: white; vertical-align: middle;"></i> Total Expenses
                    </p>
                </div>
            </div>
        </div>
        
        <div style="
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 200%;
            background: linear-gradient(to right, rgba(255,255,255,0) 0%, rgba(255,255,255,0.1) 50%, rgba(255,255,255,0) 100%);
            transform: rotate(30deg);
            z-index: 1;
            pointer-events: none;
        "></div>
    </div>
</div>

<!-- Total Inventory -->
<div class="col-md-4 col-xl-4">
    <div class="widget-rounded-circle card-box shadow-sm" style="
        border-radius: 16px; 
        overflow: hidden; 
        transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
        background: linear-gradient(135deg, #0ba360 0%, #3cba92 100%);
        border: none;
        animation: fadeIn 0.6s ease-out 1.1s;
        height: 120px;
        position: relative;
    ">
        <div style="
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
        
        "></div>
        
        <div class="row align-items-center p-3" style="height: 90px; position: relative; z-index: 2;">
            <div class="col-5">
                <div class="avatar-lg rounded-circle d-flex align-items-center justify-content-center" style="
                    background: rgba(255, 255, 255, 0.2);
                    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
                    transition: transform 0.3s ease;
                    width: 60px;
                    height: 60px;
                    backdrop-filter: blur(5px);
                ">
                    <i class="fas fa-pills font-22" style="color: white;"></i>
                </div>
            </div>
            <div class="col-7">
                <div class="text-right">
                    <h3 class="mt-1 mb-0" style="color: white; font-size: 1.4rem; text-shadow: 0 2px 4px rgba(0,0,0,0.2);">
                        <span data-plugin="counterup"><?php echo $total_inventory;?></span>
                    </h3>
                    <p class="mb-1 text-truncate" style="color: rgba(255, 255, 255, 0.9); font-weight: 500; font-size: 0.9rem;">
                        <i class="fas fa-circle mr-1" style="font-size: 8px; color: white; vertical-align: middle;"></i> Total Inventory
                    </p>
                </div>
            </div>
        </div>
        
        <div style="
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 200%;
            background: linear-gradient(to right, rgba(255,255,255,0) 0%, rgba(255,255,255,0.1) 50%, rgba(255,255,255,0) 100%);
            transform: rotate(30deg);
            z-index: 1;
            pointer-events: none;
        "></div>
    </div>
</div>
                    

                        <!-- Financial Summary Chart -->
                        <div class="row mt-6">
                            <div class="col-xl-6">
                                <div class="card-box shadow-sm" style="
                                    border-radius: 16px; 
                                    border: none; 
                                    overflow: hidden;
                                    background: white;
                                    animation: slideUp 0.6s ease-out;
                                ">
                                    <div class="card-header p-3" style="
                                        background-color: #ffffff; 
                                        border-bottom: 1px solid #f0f4f8;
                                    ">
                                        <h4 class="header-title mb-0" style="
                                            color: #2d3436; 
                                            font-weight: 700; 
                                            font-size: 1.25rem;
                                        ">
                                            <i class="fas fa-chart-pie mr-2" style="color: #6c5ce7;"></i> 
                                            Revenue Summary
                                        </h4>
                                    </div>
                                    <div class="card-body">
                                        <canvas id="revenueChart" height="300"></canvas>
                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-6">
                                <div class="card-box shadow-sm" style="
                                    border-radius: 16px; 
                                    border: none; 
                                    overflow: hidden;
                                    background: white;
                                    animation: slideUp 0.6s ease-out 0.2s;
                                ">
                                    <div class="card-header p-3" style="
                                        background-color: #ffffff; 
                                        border-bottom: 1px solid #f0f4f8;
                                    ">
                                        <h4 class="header-title mb-0" style="
                                            color: #2d3436; 
                                            font-weight: 700; 
                                            font-size: 1.25rem;
                                        ">
                                            <i class="fas fa-chart-bar mr-2" style="color: #6c5ce7;"></i> 
                                            Payment Status
                                        </h4>
                                    </div>
                                    <div class="card-body">
                                        <canvas id="paymentChart" height="300"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!--Recently Employed Employees-->
                       <!-- Financial Summary Chart -->
<div class="row mt-6">
   <!--  <div class="col-xl-6">
        <div class="card-box shadow-sm" style="
            border-radius: 16px; 
            border: none; 
            overflow: hidden;
            background: white;
            animation: slideUp 0.6s ease-out;
        ">
            <div class="card-header p-3" style="
                background-color: #ffffff; 
                border-bottom: 1px solid #f0f4f8;
            ">
                <h4 class="header-title mb-0" style="
                    color: #2d3436; 
                    font-weight: 700; 
                    font-size: 1.25rem;
                ">
                    <i class="fas fa-chart-pie mr-2" style="color: #6c5ce7;"></i> 
                    Revenue Summary
                </h4>
            </div>
            <div class="card-body">
                <canvas id="revenueChart" height="300"></canvas>
            </div>
        </div>
    </div>
 -->
   <!--  <div class="col-xl-6">
        <div class="card-box shadow-sm" style="
            border-radius: 16px; 
            border: none; 
            overflow: hidden;
            background: white;
            animation: slideUp 0.6s ease-out 0.2s;
        ">
            <div class="card-header p-3" style="
                background-color: #ffffff; 
                border-bottom: 1px solid #f0f4f8;
            ">
                <h4 class="header-title mb-0" style="
                    color: #2d3436; 
                    font-weight: 700; 
                    font-size: 1.25rem;
                ">
                    <i class="fas fa-chart-bar mr-2" style="color: #6c5ce7;"></i> 
                    Payment Status
                </h4>
            </div>
            <div class="card-body">
                <canvas id="paymentChart" height="300"></canvas>
            </div>
        </div>
    </div> -->
</div>

<!-- Additional Charts Row -->
<div class="row mt-6">
    <!-- Line Chart - Revenue Trend -->
    <div class="col-xl-6">
        <div class="card-box shadow-sm" style="
            border-radius: 16px; 
            border: none; 
            overflow: hidden;
            background: white;
            animation: slideUp 0.6s ease-out 0.4s;
        ">
            <div class="card-header p-3" style="
                background-color: #ffffff; 
                border-bottom: 1px solid #f0f4f8;
            ">
                <h4 class="header-title mb-0" style="
                    color: #2d3436; 
                    font-weight: 700; 
                    font-size: 1.25rem;
                ">
                    <i class="fas fa-chart-line mr-2" style="color: #6c5ce7;"></i> 
                    Revenue Trend (Last 6 Months)
                </h4>
            </div>
            <div class="card-body">
                <canvas id="revenueTrendChart" height="300"></canvas>
            </div>
        </div>
    </div>

    <!-- Pie Chart - Patient Distribution -->
    <div class="col-xl-6">
        <div class="card-box shadow-sm" style="
            border-radius: 16px; 
            border: none; 
            overflow: hidden;
            background: white;
            animation: slideUp 0.6s ease-out 0.6s;
        ">
            <div class="card-header p-3" style="
                background-color: #ffffff; 
                border-bottom: 1px solid #f0f4f8;
            ">
                <h4 class="header-title mb-0" style="
                    color: #2d3436; 
                    font-weight: 700; 
                    font-size: 1.25rem;
                ">
                    <i class="fas fa-chart-pie mr-2" style="color: #6c5ce7;"></i> 
                    Patient Distribution
                </h4>
            </div>
            <div class="card-body">
                <canvas id="patientDistributionChart" height="300"></canvas>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript for Charts -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Revenue Summary Chart (Bar Chart)
        const revenueCtx = document.getElementById('revenueChart').getContext('2d');
        const revenueChart = new Chart(revenueCtx, {
            type: 'bar',
            data: {
                labels: ['OPD Revenue', 'IPD Revenue', 'Discounts'],
                datasets: [{
                    label: 'Amount (₹)',
                    data: [
                        <?php echo $all_opd_amount; ?>,
                        <?php echo $all_ipd_amount; ?>,
                        <?php echo $discount_ipd_amount; ?>
                    ],
                    backgroundColor: [
                        'rgba(54, 162, 235, 0.7)',
                        'rgba(75, 192, 192, 0.7)',
                        'rgba(255, 159, 64, 0.7)'
                    ],
                    borderColor: [
                        'rgba(54, 162, 235, 1)',
                        'rgba(75, 192, 192, 1)',
                        'rgba(255, 159, 64, 1)'
                    ],
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'top',
                    },
                    title: {
                        display: true,
                        text: 'Revenue Breakdown'
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        title: {
                            display: true,
                            text: 'Amount (₹)'
                        }
                    }
                }
            }
        });

        // Payment Status Chart (Doughnut Chart)
        const paymentCtx = document.getElementById('paymentChart').getContext('2d');
        const paymentChart = new Chart(paymentCtx, {
            type: 'doughnut',
            data: {
                labels: ['Paid OPD', 'Due OPD', 'Paid IPD', 'Due IPD'],
                datasets: [{
                    data: [
                        <?php echo $paid_opd_amount; ?>,
                        <?php echo $due_opd_amount; ?>,
                        <?php echo $paid_ipd_amount; ?>,
                        <?php echo $due_ipd_amount; ?>
                    ],
                    backgroundColor: [
                        'rgba(75, 192, 192, 0.7)',
                        'rgba(255, 99, 132, 0.7)',
                        'rgba(54, 162, 235, 0.7)',
                        'rgba(255, 159, 64, 0.7)'
                    ],
                    borderColor: [
                        'rgba(75, 192, 192, 1)',
                        'rgba(255, 99, 132, 1)',
                        'rgba(54, 162, 235, 1)',
                        'rgba(255, 159, 64, 1)'
                    ],
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'top',
                    },
                    title: {
                        display: true,
                        text: 'Payment Status Distribution'
                    }
                }
            }
        });

        // Revenue Trend Chart (Line Chart)
        const trendCtx = document.getElementById('revenueTrendChart').getContext('2d');
        const trendChart = new Chart(trendCtx, {
            type: 'line',
            data: {
                // These would typically come from database queries for historical data
                labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
                datasets: [
                    {
                        label: 'OPD Revenue',
                        data: [12000, 19000, 15000, 21000, 18000, 24000],
                        borderColor: 'rgba(54, 162, 235, 1)',
                        backgroundColor: 'rgba(54, 162, 235, 0.2)',
                        tension: 0.3,
                        fill: true
                    },
                    {
                        label: 'IPD Revenue',
                        data: [8000, 12000, 10000, 15000, 13000, 18000],
                        borderColor: 'rgba(75, 192, 192, 1)',
                        backgroundColor: 'rgba(75, 192, 192, 0.2)',
                        tension: 0.3,
                        fill: true
                    }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'top',
                    },
                    title: {
                        display: true,
                        text: 'Monthly Revenue Trend'
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        title: {
                            display: true,
                            text: 'Amount (₹)'
                        }
                    }
                }
            }
        });

        // Patient Distribution Chart (Pie Chart)
        const patientCtx = document.getElementById('patientDistributionChart').getContext('2d');
        const patientChart = new Chart(patientCtx, {
            type: 'pie',
            data: {
                labels: ['OPD Patients', 'IPD Patients'],
                datasets: [{
                    data: [
                        <?php echo $total_opd_patients; ?>,
                        <?php echo $total_ipd_patients; ?>
                    ],
                    backgroundColor: [
                        'rgba(54, 162, 235, 0.7)',
                        'rgba(75, 192, 192, 0.7)'
                    ],
                    borderColor: [
                        'rgba(54, 162, 235, 1)',
                        'rgba(75, 192, 192, 1)'
                    ],
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'top',
                    },
                    title: {
                        display: true,
                        text: 'Patient Type Distribution'
                    }
                }
            }
        });
    });
</script>

                                    <!-- Table Container -->
                               <div class="card-body p-0">
    <div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead style="background: linear-gradient(135deg, #6c5ce7 0%, #a29bfe 100%);">
                <tr>
                    <th style="
                        color: white; 
                        font-weight: 600; 
                        padding: 1rem; 
                        border-top: none; 
                        min-width: 200px;
                        position: relative;
                    ">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-user-circle mr-2" style="font-size: 1.1rem;"></i>
                            <span>Employee</span>
                        </div>
                        <span class="sort-indicator"><i class="fas fa-sort ml-1" style="font-size: 0.8rem;"></i></span>
                    </th>
                    <th style="
                        color: white; 
                        font-weight: 600; 
                        padding: 1rem; 
                        border-top: none;
                        position: relative;
                    ">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-envelope mr-2" style="font-size: 1.1rem;"></i>
                            <span>Email</span>
                        </div>
                        <span class="sort-indicator"><i class="fas fa-sort ml-1" style="font-size: 0.8rem;"></i></span>
                    </th>
                    <th style="
                        color: white; 
                        font-weight: 600; 
                        padding: 1rem; 
                        border-top: none;
                        position: relative;
                    ">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-building mr-2" style="font-size: 1.1rem;"></i>
                            <span>Department</span>
                        </div>
                        <span class="sort-indicator"><i class="fas fa-sort ml-1" style="font-size: 0.8rem;"></i></span>
                    </th>
                    <th style="
                        color: white; 
                        font-weight: 600; 
                        padding: 1rem; 
                        border-top: none;
                        position: relative;
                    ">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-check-circle mr-2" style="font-size: 1.1rem;"></i>
                            <span>Status</span>
                        </div>
                        <span class="sort-indicator"><i class="fas fa-sort ml-1" style="font-size: 0.8rem;"></i></span>
                    </th>
                    <th style="
                        color: white; 
                        font-weight: 600; 
                        padding: 1rem; 
                        border-top: none; 
                        text-align: center;
                    ">
                        <div class="d-flex align-items-center justify-content-center">
                            <i class="fas fa-cog mr-2" style="font-size: 1.1rem;"></i>
                            <span>Action</span>
                        </div>
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php
                    $ret="SELECT * FROM his_docs ORDER BY RAND() LIMIT 10"; 
                    $stmt= $mysqli->prepare($ret);
                    $stmt->execute();
                    $res=$stmt->get_result();
                    while($row=$res->fetch_object())
                    {
                ?>
                <tr style="
                    transition: all 0.3s ease;
                    animation: fadeInRow 0.5s ease-out;
                    border-left: 3px solid transparent;
                ">
                    <td style="padding: 1rem; border-top: 1px solid #f0f4f8;">
                        <div class="d-flex align-items-center">
                            <div class="avatar-container mr-3" style="
                                position: relative;
                                width: 40px;
                                height: 40px;
                            ">
                                <img src="assets/images/users/doc-icon.png" alt="img" 
                                    class="rounded-circle avatar-sm" 
                                    style="
                                        border: 2px solid #e2e8f0; 
                                        object-fit: cover; 
                                        width: 100%; 
                                        height: 100%;
                                        transition: all 0.3s ease;
                                    " />
                                <span class="online-status" style="
                                    position: absolute;
                                    bottom: 0;
                                    right: 0;
                                    width: 10px;
                                    height: 10px;
                                    background-color: #00b894;
                                    border-radius: 50%;
                                    border: 2px solid white;
                                "></span>
                            </div>
                            <div>
                                <h5 class="mb-0 font-14" style="
                                    color: #2d3436; 
                                    font-weight: 600;
                                    transition: all 0.3s ease;
                                ">
                                    <?php echo $row->doc_fname;?> <?php echo $row->doc_lname;?>
                                </h5>
                                <small class="text-muted" style="font-size: 0.75rem;">
                                    <i class="fas fa-id-card mr-1" style="font-size: 0.7rem;"></i> ID: <?php echo $row->doc_number;?>
                                </small>
                            </div>
                        </div>
                    </td>    
                    <td style="
                        padding: 1rem; 
                        border-top: 1px solid #f0f4f8; 
                        color: #636e72;
                    ">
                        <a href="mailto:<?php echo $row->doc_email;?>" class="text-primary d-flex align-items-center" style="
                            text-decoration: none;
                            transition: all 0.3s ease;
                        ">
                            <i class="fas fa-envelope mr-2" style="font-size: 0.9rem;"></i>
                            <?php echo $row->doc_email;?>
                        </a>
                    </td>
                    <td style="padding: 1rem; border-top: 1px solid #f0f4f8;">
                        <span class="badge p-2 department-badge d-flex align-items-center" style="
                            background-color: rgba(108, 92, 231, 0.1); 
                            color: #6c5ce7; 
                            border-radius: 8px; 
                            font-weight: 500;
                            display: inline-flex;
                            min-width: 80px;
                            text-align: center;
                            transition: all 0.3s ease;
                        ">
                            <i class="fas fa-building mr-1" style="font-size: 0.8rem;"></i>
                            <?php echo $row->doc_dept;?>
                        </span>
                    </td>
                    <td style="padding: 1rem; border-top: 1px solid #f0f4f8;">
                        <span class="badge p-2 status-badge d-flex align-items-center" style="
                            background-color: rgba(0, 184, 148, 0.1); 
                            color: #00b894; 
                            border-radius: 8px; 
                            font-weight: 500;
                            display: inline-flex;
                            min-width: 70px;
                            text-align: center;
                            transition: all 0.3s ease;
                        ">
                            <i class="fas fa-circle mr-1" style="
                                font-size: 0.5rem; 
                                vertical-align: middle;
                            "></i> Active
                        </span>
                    </td>
                    <td style="
                        padding: 1rem; 
                        border-top: 1px solid #f0f4f8; 
                        text-align: center;
                    ">
                        <a href="view_single_employee.php?doc_id=<?php echo $row->doc_id;?>&&doc_number=<?php echo $row->doc_number;?>" 
                            class="btn btn-sm btn-view" 
                            style="
                                background: linear-gradient(135deg, #6c5ce7 0%, #a29bfe 100%); 
                                color: white; 
                                border-radius: 8px; 
                                font-weight: 500;
                                padding: 0.35rem 0.75rem;
                                transition: all 0.3s ease;
                                box-shadow: 0 4px 12px rgba(108, 92, 231, 0.2);
                                border: none;
                                display: inline-flex;
                                align-items: center;
                                justify-content: center;
                            "
                        >
                            <i class="fas fa-eye mr-2"></i> View
                        </a>
                    </td>
                </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Card Footer -->
<div class="card-footer p-3" style="
    background-color: #f8f9fa; 
    border-top: 1px solid #f0f4f8;
    display: flex;
    justify-content: center;
">
    <a href="add_employee.php" class="text-primary font-weight-bold d-flex align-items-center" style="
        text-decoration: none;
        display: flex;
        align-items: center;
        transition: all 0.3s ease;
        padding: 0.5rem 1rem;
        border-radius: 8px;
        background: rgba(108, 92, 231, 0.1);
    ">
        <i class="fas fa-plus-circle mr-2" style="color: #6c5ce7; font-size: 1.2rem;"></i> 
        <span>Add New Employee</span>
    </a>
</div>

<style>
    /* Enhanced table styles */
    thead tr th {
        border-bottom: 2px solid rgba(255, 255, 255, 0.2) !important;
    }
    
    tbody tr {
        border-bottom: 1px solid #f0f4f8;
    }
    
    tbody tr:hover {
        background-color: #f8f9fa !important;
        transform: translateX(5px);
        box-shadow: 0 5px 15px rgba(0,0,0,0.03);
        border-left: 3px solid #6c5ce7 !important;
    }
    
    tbody tr:hover td h5 {
        color: #6c5ce7 !important;
    }
    
    tbody tr:hover td a {
        color: #6c5ce7 !important;
    }
    
    .department-badge:hover {
        background-color: rgba(108, 92, 231, 0.2) !important;
        transform: scale(1.05);
    }
    
    .status-badge:hover {
        background-color: rgba(0, 184, 148, 0.2) !important;
        transform: scale(1.05);
    }
    
    .avatar-container:hover img {
        transform: scale(1.1);
        border-color: #6c5ce7 !important;
    }
    
    .btn-view:hover {
        transform: translateY(-2px) !important;
        box-shadow: 0 8px 20px rgba(108, 92, 231, 0.3) !important;
    }
    
    .card-footer a:hover {
        background: rgba(108, 92, 231, 0.2) !important;
        transform: translateX(5px);
    }
    
    /* Animation for table rows */
    @keyframes fadeInRow {
        from { opacity: 0; transform: translateY(10px); }
        to { opacity: 1; transform: translateY(0); }
    }
    
    /* Staggered animation for rows */
    tbody tr:nth-child(1) { animation-delay: 0.1s; }
    tbody tr:nth-child(2) { animation-delay: 0.2s; }
    tbody tr:nth-child(3) { animation-delay: 0.3s; }
    tbody tr:nth-child(4) { animation-delay: 0.4s; }
    tbody tr:nth-child(5) { animation-delay: 0.5s; }
    tbody tr:nth-child(6) { animation-delay: 0.6s; }
    tbody tr:nth-child(7) { animation-delay: 0.7s; }
    tbody tr:nth-child(8) { animation-delay: 0.8s; }
    tbody tr:nth-child(9) { animation-delay: 0.9s; }
    tbody tr:nth-child(10) { animation-delay: 1.0s; }
</style>
                                </div>
                            </div>
                        </div>
                        
                        <!-- end row -->
                        
                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- Plugins js-->
        <script src="assets/libs/flatpickr/flatpickr.min.js"></script>
        <script src="assets/libs/jquery-knob/jquery.knob.min.js"></script>
        <script src="assets/libs/jquery-sparkline/jquery.sparkline.min.js"></script>
        <script src="assets/libs/flot-charts/jquery.flot.js"></script>
        <script src="assets/libs/flot-charts/jquery.flot.time.js"></script>
        <script src="assets/libs/flot-charts/jquery.flot.tooltip.min.js"></script>
        <script src="assets/libs/flot-charts/jquery.flot.selection.js"></script>
        <script src="assets/libs/flot-charts/jquery.flot.crosshair.js"></script>

        <!-- Dashboard init js-->
        <script src="assets/js/pages/dashboard-1.init.js"></script>

        <!-- App js-->
        <script src="assets/js/app.min.js"></script>
        
        <style>
            /* Animations */
            @keyframes fadeIn {
                from { opacity: 0; transform: translateY(10px); }
                to { opacity: 1; transform: translateY(0); }
            }
            
            @keyframes slideUp {
                from { opacity: 0; transform: translateY(20px); }
                to { opacity: 1; transform: translateY(0); }
            }
            
            @keyframes fadeInRow {
                from { opacity: 0; }
                to { opacity: 1; }
            }
            
            @keyframes progressAnimation {
                from { width: 0; }
                to { width: attr(data-width); }
            }
            
            /* Hover effects */
            .widget-rounded-circle:hover {
                transform: translateY(-5px) !important;
                box-shadow: 0 15px 30px rgba(0,0,0,0.1) !important;
            }
            
            .widget-rounded-circle:hover .avatar-lg {
                transform: scale(1.1);
            }
            
            tr:hover {
                background-color: #f8f9fa !important;
                transform: translateX(5px);
                box-shadow: 0 5px 15px rgba(0,0,0,0.03);
            }
            
            tr:hover td h5 {
                color: #6c5ce7 !important;
            }
            
            tr:hover td a {
                color: #6c5ce7 !important;
            }
            
            .btn-view-all:hover, .btn-view:hover {
                transform: translateY(-2px) !important;
                box-shadow: 0 8px 20px rgba(108, 92, 231, 0.3) !important;
            }
            
            .department-badge:hover {
                background-color: #e2e8f0 !important;
                color: #6c5ce7 !important;
            }
            
            .status-badge:hover {
                background-color: rgba(0, 184, 148, 0.2) !important;
                color: #00b894 !important;
            }
            
            .avatar-container:hover img {
                transform: scale(1.1);
                border-color: #6c5ce7 !important;
            }
            
            .card-header i:hover {
                background: rgba(108, 92, 231, 0.2) !important;
                transform: rotate(15deg);
            }
            
            .card-footer a:hover {
                color: #6c5ce7 !important;
                transform: translateX(5px);
            }
            
            /* Responsive adjustments */
            @media (max-width: 768px) {
                .avatar-container {
                    margin-right: 0.5rem !important;
                }
                
                td, th {
                    padding: 0.75rem !important;
                }
                
                .btn-view, .btn-view-all {
                    padding: 0.25rem 0.5rem !important;
                    font-size: 0.75rem !important;
                }
                
                .widget-rounded-circle {
                    margin-bottom: 1rem;
                }
            }
            
            /* Custom scrollbar */
            ::-webkit-scrollbar {
                width: 8px;
                height: 8px;
            }
            
            ::-webkit-scrollbar-track {
                background: #f1f1f1;
                border-radius: 10px;
            }
            
            ::-webkit-scrollbar-thumb {
                background: #a29bfe;
                border-radius: 10px;
            }
            
            ::-webkit-scrollbar-thumb:hover {
                background: #6c5ce7;
            }
        </style>
    </body>
</html>