<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid=$_SESSION['ad_id'];
?>

<!DOCTYPE html>
<html lang="en">
    
<?php include('assets/inc/head.php');?>

    <body style="background: linear-gradient(135deg, #f8f9fc 0%, #e6f2ff 100%); font-family: 'Poppins', sans-serif;">

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
                <?php include('assets/inc/nav.php');?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
                <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box" style="background: linear-gradient(45deg, #6a11cb 0%, #2575fc 100%); border-radius: 12px; padding: 20px; box-shadow: 0 8px 20px rgba(106, 17, 203, 0.2); color: white; margin-bottom: 25px;">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="javascript: void(0);" style="color: rgba(255,255,255,0.8);">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);" style="color: rgba(255,255,255,0.8);">Patients</a></li>
                                            <li class="breadcrumb-item active" style="color: white; font-weight: 600;">Discharge Patients</li>
                                        </ol>
                                    </div>
                                    <h4 class="page-title" style="color: white; font-weight: 700; letter-spacing: 0.5px;">
                                        <i class="fas fa-user-check mr-2"></i>Discharge Patients
                                    </h4>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 

                        <div class="row">
                            <div class="col-12">
                                <div class="card-box" style="border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); border: none; overflow: hidden;">
                                    <h4 class="header-title mb-4" style="color: #4e73df; font-weight: 600; border-left: 4px solid #4e73df; padding-left: 10px;">
                                        <i class="fas fa-procedures mr-2"></i>Current In-Patients (IPD)
                                    </h4>
                                    
                                    <div class="mb-3">
                                        <div class="row">
                                            <div class="col-12 text-sm-center form-inline">
                                                <div class="form-group position-relative">
                                                    <i class="fas fa-search position-absolute" style="left: 15px; top: 10px; color: #6c757d;"></i>
                                                    <input id="demo-foo-search" type="text" placeholder="Search patients..." class="form-control form-control-sm pl-4" autocomplete="on" style="border-radius: 8px; border: 1px solid #d1d3e2; width: 250px; padding-left: 35px;">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="table-responsive">
                                        <table id="demo-foo-filtering" class="table table-bordered toggle-circle mb-0" data-page-size="7" style="border-collapse: separate; border-spacing: 0; border-radius: 12px; overflow: hidden;">
                                            <thead style="background: linear-gradient(to right, #4e73df, #224abe); color: white;">
                                            <tr>
                                                <th style="border: none; padding: 15px 10px;">#</th>
                                                <th data-toggle="true" style="border: none; padding: 15px 10px;">Patient Details</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Admission Details</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Department</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Registration Date</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Admission Date</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Actions</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php
                                                // Fixed query to get patient details
                                                $ret = "SELECT 
                                                    p.pat_id, 
                                                    p.pat_fname, 
                                                    p.pat_lname, 
                                                    p.pat_number, 
                                                    p.pat_phone, 
                                                    p.pat_age, 
                                                    p.gender, 
                                                    p.title,
                                                    p.card_no,
                                                    p.pat_date_joined,
                                                    p.dept,
                                                    d.department_name,
                                                    p.pat_type,
                                                    p.pat_discharge_status,
                                                    p.pat_date_joined as admission_date
                                                FROM his_patients p
                                                LEFT JOIN his_departments d ON p.dept = d.department_id
                                                WHERE (p.pat_discharge_status IS NULL OR p.pat_discharge_status != 'Discharged') 
                                                AND p.pat_type = 'InPatient'"; 
                                                
                                                $stmt = $mysqli->prepare($ret);
                                                $stmt->execute();
                                                $res = $stmt->get_result();
                                                $cnt = 1;
                                                
                                                while($row = $res->fetch_object()) {
                                                    // Format the registration date
                                                    $regDate = date("d M Y", strtotime($row->pat_date_joined));
                                                    
                                                    // Use registration date as admission date since no separate field exists
                                                    $admissionDate = date("d M Y", strtotime($row->pat_date_joined));
                                            ?>
                                                <tr style="transition: all 0.3s; border-bottom: 1px solid #e3e6f0;">
                                                    <td style="padding: 15px 10px; border: none; font-weight: 500; color: #5a5c69;"><?php echo $cnt;?></td>
                                                    
                                                    <!-- Patient Details Column -->
                                                    <td style="padding: 15px 10px; border: none;">
                                                        <div style="font-weight: 600; color: #4e73df;">
                                                            <i class="fas fa-user-circle mr-2"></i>
                                                            <?php echo $row->title . ' ' . $row->pat_fname . ' ' . $row->pat_lname; ?>
                                                        </div>
                                                        <div style="font-size: 13px; color: #5a5c69; margin-top: 5px;">
                                                            <?php echo $row->gender . ' ' . $row->pat_age . ' yrs ' . $row->pat_phone; ?>
                                                        </div>
                                                        <div style="font-size: 12px; color: #6c757d; margin-top: 3px;">
                                                            <?php echo $row->card_no . ' | ' . $row->pat_number; ?>
                                                        </div>
                                                    </td>
                                                    
                                                    <!-- Admission Details Column -->
                                                    <td style="padding: 15px 10px; border: none; color: #5a5c69;">
                                                        <div style="font-size: 13px;">
                                                            <span class="badge badge-info" style="background: #36b9cc; padding: 4px 8px; font-size: 11px;">Room: N/A</span>
                                                            <span class="badge badge-warning" style="background: #f6c23e; padding: 4px 8px; font-size: 11px; margin-left: 5px;">Ward: N/A</span>
                                                            <span class="badge badge-success" style="background: #1cc88a; padding: 4px 8px; font-size: 11px; margin-left: 5px;">Bed: N/A</span>
                                                        </div>
                                                        <div style="font-size: 12px; margin-top: 5px; color: #6c757d;">
                                                            Floor: N/A
                                                        </div>
                                                    </td>
                                                    
                                                    <!-- Department Column -->
                                                    <td style="padding: 15px 10px; border: none; color: #5a5c69;">
                                                        <?php echo $row->department_name ? $row->department_name : 'Not assigned'; ?>
                                                    </td>
                                                    
                                                    <!-- Registration Date Column -->
                                                    <td style="padding: 15px 10px; border: none; color: #5a5c69;">
                                                        <?php echo $regDate; ?>
                                                    </td>
                                                    
                                                    <!-- Admission Date Column -->
                                                    <td style="padding: 15px 10px; border: none; color: #5a5c69;">
                                                        <?php echo $admissionDate; ?>
                                                    </td>
                                                    
                                                    <!-- Actions Column -->
                                                    <td style="padding: 15px 10px; border: none;">
                                                        <a href="discharge_single_patient.php?pat_id=<?php echo $row->pat_id;?>" class="btn btn-sm btn-primary" style="background: linear-gradient(to right, #4e73df, #224abe); border: none; padding: 6px 12px; font-weight: 500; border-radius: 6px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); transition: all 0.3s; margin-bottom: 5px;">
                                                            <i class="mdi mdi-check-box-outline mr-1"></i> Discharge
                                                        </a>
                                                        <a href="printrec.php?pat_id=<?php echo $row->pat_id;?>" class="btn btn-sm btn-info" style="background: linear-gradient(to right, #36b9cc, #2c9faf); border: none; padding: 6px 12px; font-weight: 500; border-radius: 6px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); transition: all 0.3s;">
                                                            <i class="mdi mdi-book-open mr-1"></i> Ledger
                                                        </a>
                                                    </td>
                                                </tr>
                                            <?php $cnt = $cnt + 1; } ?>
                                            </tbody>
                                            <tfoot>
                                            <tr class="active">
                                                <td colspan="7" style="border: none;">
                                                    <div class="text-right">
                                                        <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                    </div>
                                                </td>
                                            </tr>
                                            </tfoot>
                                        </table>
                                    </div> <!-- end .table-responsive-->
                                </div> <!-- end card-box -->
                            </div> <!-- end col -->
                        </div>
                        <!-- end row -->

                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                 <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->


        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- Footable js -->
        <script src="assets/libs/footable/footable.all.min.js"></script>

        <!-- Init js -->
        <script src="assets/js/pages/foo-tables.init.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
    </body>

</html>
