<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();

$id = intval($_GET['id']);

// Fetch insurance data
$query = "SELECT * FROM his_insurance WHERE insurance_id = ?";
$stmt = $mysqli->prepare($query);
$stmt->bind_param('i', $id);
$stmt->execute();
$res = $stmt->get_result();
$insurance = $res->fetch_object();

if (!$insurance) {
    $_SESSION['error'] = "Insurance provider not found";
    header("Location: settings.php#insurance");
    exit();
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $insurance_name = $_POST['insurance_name'];
    
    $query = "UPDATE his_insurance SET insurance_name = ? WHERE insurance_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('si', $insurance_name, $id);
    $stmt->execute();
    
    $_SESSION['success'] = "Insurance provider updated successfully";
    header("Location: settings.php#insurance");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">

    <?php include('assets/inc/head.php');?>


<body>
    <?php include('assets/inc/nav.php');?>
    <?php include("assets/inc/sidebar.php");?>

    <div class="content-page">
        <div class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box">
                            <h4 class="page-title">Edit Insurance Provider</h4>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-12">
                        <div class="card-box">
                            <form action="edit_insurance.php?id=<?php echo $id; ?>" method="post">
                                <div class="form-group">
                                    <label for="insurance_name">Insurance Provider Name</label>
                                    <input type="text" class="form-control" id="insurance_name" name="insurance_name" 
                                           value="<?php echo htmlspecialchars($insurance->insurance_name); ?>" required>
                                </div>
                                
                                <button type="submit" class="btn btn-primary">Update Insurance</button>
                                <a href="settings.php#insurance" class="btn btn-secondary">Cancel</a>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php include('assets/inc/footer.php');?>
    </div>
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- Footable js -->
    <script src="assets/libs/footable/footable.all.min.js"></script>

    <!-- FontAwesome for search icon -->
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>

    <!-- Init js -->
    <script src="assets/js/pages/foo-tables.init.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
   
</body>
</html>