<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];

// Handle form submissions
if (isset($_POST['add_floor'])) {
    $floor_number = $_POST['floor_number'];
    $floor_name = $_POST['floor_name'];
    $description = $_POST['description'];
    $status = $_POST['status'];

    $query = "INSERT INTO his_floors (floor_number, floor_name, description, status) VALUES (?, ?, ?, ?)";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('ssss', $floor_number, $floor_name, $description, $status);
    
    if ($stmt->execute()) {
        $success = "Floor added successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

if (isset($_POST['update_floor'])) {
    $floor_id = $_POST['floor_id'];
    $floor_number = $_POST['floor_number'];
    $floor_name = $_POST['floor_name'];
    $description = $_POST['description'];
    $status = $_POST['status'];

    $query = "UPDATE his_floors SET floor_number = ?, floor_name = ?, description = ?, status = ? WHERE floor_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('ssssi', $floor_number, $floor_name, $description, $status, $floor_id);
    
    if ($stmt->execute()) {
        $success = "Floor updated successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

if (isset($_GET['delete'])) {
    $floor_id = $_GET['delete'];
    $query = "DELETE FROM his_floors WHERE floor_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('i', $floor_id);
    
    if ($stmt->execute()) {
        $success = "Floor deleted successfully";
    } else {
        $err = "Please try again later: " . $stmt->error;
    }
}

// Get all floors
$floors = [];
$ret = "SELECT * FROM his_floors ORDER BY floor_number";
$stmt = $mysqli->prepare($ret);
$stmt->execute();
$res = $stmt->get_result();
while ($floor = $res->fetch_object()) {
    $floors[] = $floor;
}

// Get specific floor for editing
$edit_floor = null;
if (isset($_GET['edit'])) {
    $floor_id = $_GET['edit'];
    $ret = "SELECT * FROM his_floors WHERE floor_id = ?";
    $stmt = $mysqli->prepare($ret);
    $stmt->bind_param('i', $floor_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $edit_floor = $res->fetch_object();
}
?>

<!DOCTYPE html>
<html lang="en">
<?php include('assets/inc/head.php');?>

<body>
    <div id="wrapper">
        <?php include('assets/inc/nav.php');?>
        <?php include("assets/inc/sidebar.php");?>

        <div class="content-page">
            <div class="content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Ward Management</a></li>
                                        <li class="breadcrumb-item active">Floors</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Manage Floors</h4>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title"><?php echo isset($edit_floor) ? 'Edit Floor' : 'Add New Floor'; ?></h4>
                                    
                                    <?php if(isset($err)) { ?>
                                        <div class="alert alert-danger"><?php echo $err; ?></div>
                                    <?php } ?>
                                    <?php if(isset($success)) { ?>
                                        <div class="alert alert-success"><?php echo $success; ?></div>
                                    <?php } ?>

                                    <form method="post">
                                        <?php if(isset($edit_floor)) { ?>
                                            <input type="hidden" name="floor_id" value="<?php echo $edit_floor->floor_id; ?>">
                                        <?php } ?>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="floor_number">Floor Number *</label>
                                                    <input type="text" class="form-control" id="floor_number" name="floor_number" value="<?php echo isset($edit_floor) ? $edit_floor->floor_number : ''; ?>" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="floor_name">Floor Name *</label>
                                                    <input type="text" class="form-control" id="floor_name" name="floor_name" value="<?php echo isset($edit_floor) ? $edit_floor->floor_name : ''; ?>" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="description">Description</label>
                                            <textarea class="form-control" id="description" name="description" rows="3"><?php echo isset($edit_floor) ? $edit_floor->description : ''; ?></textarea>
                                        </div>
                                        <div class="form-group">
                                            <label for="status">Status</label>
                                            <select class="form-control" id="status" name="status" required>
                                                <option value="Active" <?php echo (isset($edit_floor) && $edit_floor->status == 'Active') ? 'selected' : ''; ?>>Active</option>
                                                <option value="Inactive" <?php echo (isset($edit_floor) && $edit_floor->status == 'Inactive') ? 'selected' : ''; ?>>Inactive</option>
                                            </select>
                                        </div>
                                        <?php if(isset($edit_floor)) { ?>
                                            <button type="submit" name="update_floor" class="btn btn-primary">Update Floor</button>
                                            <a href="floorno.php" class="btn btn-secondary">Cancel</a>
                                        <?php } else { ?>
                                            <button type="submit" name="add_floor" class="btn btn-success">Add Floor</button>
                                        <?php } ?>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">All Floors</h4>
                                    <table id="basic-datatable" class="table dt-responsive nowrap">
                                        <thead>
                                            <tr>
                                                <th>Floor Number</th>
                                                <th>Floor Name</th>
                                                <th>Description</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($floors as $floor) { ?>
                                                <tr>
                                                    <td><?php echo $floor->floor_number; ?></td>
                                                    <td><?php echo $floor->floor_name; ?></td>
                                                    <td><?php echo $floor->description; ?></td>
                                                    <td><span class="badge badge-<?php echo $floor->status == 'Active' ? 'success' : 'danger'; ?>"><?php echo $floor->status; ?></span></td>
                                                    <td>
                                                        <a href="floorno.php?edit=<?php echo $floor->floor_id; ?>" class="btn btn-sm btn-primary">Edit</a>
                                                        <a href="floorno.php?delete=<?php echo $floor->floor_id; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this floor?')">Delete</a>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include('assets/inc/footer.php');?>
        </div>
    </div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>
    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
</body>
</html>