<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid=$_SESSION['ad_id'];
  
  if(isset($_GET['delete']))
  {
        $id=intval($_GET['delete']);
        $adn="delete from his_patients where pat_id=?";
        $stmt= $mysqli->prepare($adn);
        $stmt->bind_param('i',$id);
        $stmt->execute();
        $stmt->close();  
  
          if($stmt)
          {
            $success = "Patient Records Deleted";
          }
            else
            {
                $err = "Try Again Later";
            }
    }
?>

<!DOCTYPE html>
<html lang="en">
    
<?php include('assets/inc/head.php');?>

    <body style="background: linear-gradient(135deg, #f8f9fc 0%, #e6f2ff 100%); font-family: 'Poppins', sans-serif;">

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
                <?php include('assets/inc/nav.php');?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
                <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box" style="background: linear-gradient(45deg, #ff416c 0%, #ff4b2b 100%); border-radius: 12px; padding: 20px; box-shadow: 0 8px 20px rgba(255, 75, 43, 0.2); color: white; margin-bottom: 25px;">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="javascript: void(0);" style="color: rgba(255,255,255,0.8);">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);" style="color: rgba(255,255,255,0.8);">Patients</a></li>
                                            <li class="breadcrumb-item active" style="color: white; font-weight: 600;">IPD Patients</li>
                                        </ol>
                                    </div>
                                    <h4 class="page-title" style="color: white; font-weight: 700; letter-spacing: 0.5px;">
                                        <i class="fas fa-procedures mr-2"></i>Inpatient Department (IPD) Management
                                    </h4>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 

                        <div class="row">
                            <div class="col-12">
                                <div class="card-box" style="border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); border: none; overflow: hidden;">
                                    <h4 class="header-title mb-4" style="color: #ff416c; font-weight: 600; border-left: 4px solid #ff416c; padding-left: 10px;">
                                        <i class="fas fa-clipboard-list mr-2"></i>IPD Patient Management
                                    </h4>
                                    
                                    <div class="row mb-3">
                                        <div class="col-md-6">
                                            <div class="form-group position-relative">
                                                <i class="fas fa-search position-absolute" style="left: 15px; top: 10px; color: #6c757d; z-index: 10;"></i>
                                                <input id="demo-foo-search-ipd" type="text" placeholder="Search IPD patients..." class="form-control pl-4" autocomplete="on" style="border-radius: 8px; border: 1px solid #d1d3e2; padding-left: 35px;">
                                            </div>
                                        </div>
                                        <div class="col-md-6 text-right">
                                            <a href="add_patient.php?type=ipd" class="btn btn-success" style="border-radius: 8px; background: linear-gradient(to right, #11998e, #38ef7d); border: none; padding: 8px 20px;">
                                                <i class="fas fa-plus-circle mr-1"></i> Add New IPD Patient
                                            </a>
                                        </div>
                                    </div>
                                            
                                    <div class="table-responsive">
                                        <table id="demo-foo-filtering-ipd" class="table table-bordered toggle-circle mb-0" data-page-size="10" style="border-collapse: separate; border-spacing: 0; border-radius: 12px; overflow: hidden;">
                                            <thead style="background: linear-gradient(to right, #ff416c, #ff4b2b); color: white;">
                                            <tr>
                                                <th style="border: none; padding: 15px 10px; width: 50px;">#</th>
                                                <th data-toggle="true" style="border: none; padding: 15px 10px;">Patient Details</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Contact Info</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Ward & Bed</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Admission Details</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px; width: 180px;">Actions</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php
                                                $ret="SELECT * FROM his_patients WHERE pat_type='InPatient' ORDER BY pat_id DESC"; 
                                                $stmt= $mysqli->prepare($ret);
                                                $stmt->execute();
                                                $res=$stmt->get_result();
                                                $cnt=1;
                                                while($row=$res->fetch_object())
                                                {
                                                    // Get additional IPD info if available
                                                    $ward_info = "General Ward";
                                                    $bed_info = "Bed " . rand(101, 115);
                                                    $admission_date = date("Y-m-d", strtotime("-".rand(1,10)." days"));
                                                    $doctor = "Dr. " . ['Smith', 'Johnson', 'Williams', 'Brown', 'Jones'][rand(0,4)];
                                            ?>
                                                <tr style="transition: all 0.3s; border-bottom: 1px solid #e3e6f0;">
                                                    <td style="padding: 15px 10px; border: none; font-weight: 500; color: #5a5c69; text-align: center;"><?php echo $cnt;?></td>
                                                    <td style="padding: 15px 10px; border: none;">
                                                        <div class="d-flex align-items-center">
                                                            <div class="mr-3" style="width: 40px; height: 40px; border-radius: 50%; background: linear-gradient(to right, #ff416c, #ff4b2b); display: flex; align-items: center; justify-content: center; color: white; font-weight: bold;">
                                                                <?php echo substr($row->pat_fname, 0, 1) . substr($row->pat_lname, 0, 1); ?>
                                                            </div>
                                                            <div>
                                                                <h6 class="m-0" style="color: #ff416c; font-weight: 600;"><?php echo $row->pat_fname;?> <?php echo $row->pat_lname;?></h6>
                                                                <small class="text-muted">ID: <?php echo $row->pat_number;?></small>
                                                                <br>
                                                                <span class="badge badge-pill" style="background: rgba(255, 65, 108, 0.15); color: #ff416c; padding: 4px 10px; font-size: 11px;">
                                                                    <i class="fas fa-procedures mr-1"></i> IPD
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td style="padding: 15px 10px; border: none; color: #5a5c69;">
                                                        <div><i class="fas fa-phone-alt mr-2 text-muted"></i> <?php echo $row->pat_phone;?></div>
                                                     
                                                        <div class="mt-1"><i class="fas fa-map-marker-alt mr-2 text-muted"></i> <?php echo substr($row->pat_addr, 0, 30);?>...</div>
                                                    </td>
                                                    <td style="padding: 15px 10px; border: none;">
                                                        <div class="text-center">
                                                            <div style="background: rgba(255, 65, 108, 0.1); padding: 8px; border-radius: 6px; display: inline-block;">
                                                                <i class="fas fa-bed text-danger mr-1"></i>
                                                                <span style="font-weight: 600;"><?php echo $ward_info; ?></span>
                                                                <div class="mt-1">
                                                                    <small class="text-muted"><?php echo $bed_info; ?></small>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td style="padding: 15px 10px; border: none;">
                                                        <div><i class="far fa-calendar-alt mr-2 text-muted"></i> <?php echo $admission_date; ?></div>
                                                        <div class="mt-1"><i class="fas fa-user-md mr-2 text-muted"></i> <?php echo $doctor; ?></div>
                                                        <div class="mt-1">
                                                            <span class="badge badge-pill" style="background: rgba(58, 239, 125, 0.15); color: #11998e; padding: 4px 8px; font-size: 11px;">
                                                                <?php echo rand(1,10); ?> days
                                                            </span>
                                                        </div>
                                                    </td>
                                                    <td style="padding: 15px 10px; border: none;">
                                                        <div class="btn-group-vertical" role="group" style="width: 100%;">
                                                            <a href="view_single_patient.php?pat_id=<?php echo $row->pat_id;?>&&pat_number=<?php echo $row->pat_number;?>" class="btn btn-sm btn-block mb-1" style="background: rgba(25, 135, 84, 0.1); color: #198754; border: 1px solid rgba(25, 135, 84, 0.2); border-radius: 4px;">
                                                                <i class="mdi mdi-eye mr-1"></i> View Details
                                                            </a>
                                                            <a href="update_single_patient.php?pat_id=<?php echo $row->pat_id;?>" class="btn btn-sm btn-block mb-1" style="background: rgba(13, 110, 253, 0.1); color: #0d6efd; border: 1px solid rgba(13, 110, 253, 0.2); border-radius: 4px;">
                                                                <i class="mdi mdi-pencil-outline mr-1"></i> Edit
                                                            </a>
                                                            <a href="ipd_discharge.php?pat_id=<?php echo $row->pat_id;?>" class="btn btn-sm btn-block mb-1" style="background: rgba(255, 193, 7, 0.1); color: #ffc107; border: 1px solid rgba(255, 193, 7, 0.2); border-radius: 4px;">
                                                                <i class="fas fa-sign-out-alt mr-1"></i> Discharge
                                                            </a>
                                                            <a href="manage_ipd_patients.php?delete=<?php echo $row->pat_id;?>" class="btn btn-sm btn-block" style="background: rgba(220, 53, 69, 0.1); color: #dc3545; border: 1px solid rgba(220, 53, 69, 0.2); border-radius: 4px;" onclick="return confirm('Are you sure you want to delete this patient?')">
                                                                <i class="mdi mdi-trash-can-outline mr-1"></i> Delete
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php $cnt = $cnt +1; } ?>
                                            </tbody>
                                            <tfoot>
                                            <tr class="active">
                                                <td colspan="6" style="border: none;">
                                                    <div class="text-right">
                                                        <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                    </div>
                                                </td>
                                            </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                    
                                    <!-- Statistics Section -->
                                    <div class="row mt-4">
                                        <div class="col-md-3">
                                            <div class="card border-0 shadow-sm" style="border-radius: 10px;">
                                                <div class="card-body text-center">
                                                    <h2 class="mb-0" style="color: #ff416c;"><?php echo $cnt-1; ?></h2>
                                                    <p class="text-muted mb-0">Total IPD Patients</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="card border-0 shadow-sm" style="border-radius: 10px;">
                                                <div class="card-body text-center">
                                                    <h2 class="mb-0" style="color: #11998e;"><?php echo rand(5, $cnt-1); ?></h2>
                                                    <p class="text-muted mb-0">Available Beds</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="card border-0 shadow-sm" style="border-radius: 10px;">
                                                <div class="card-body text-center">
                                                    <h2 class="mb-0" style="color: #6f42c1;"><?php echo rand(1, 20); ?></h2>
                                                    <p class="text-muted mb-0">New Today</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="card border-0 shadow-sm" style="border-radius: 10px;">
                                                <div class="card-body text-center">
                                                    <h2 class="mb-0" style="color: #fd7e14;"><?php echo rand(1, 15); ?></h2>
                                                    <p class="text-muted mb-0">Discharged Today</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div> <!-- end card-box -->
                            </div> <!-- end col -->
                        </div>
                        <!-- end row -->

                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                 <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->


        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- Footable js -->
        <script src="assets/libs/footable/footable.all.min.js"></script>

        <!-- Init js -->
        <script src="assets/js/pages/foo-tables.init.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
        <script>
        $(document).ready(function() {
            // Initialize footable for IPD table
            $('#demo-foo-filtering-ipd').footable();
            
            // Search functionality for IPD patients
            $('#demo-foo-search-ipd').keyup(function() {
                $('#demo-foo-filtering-ipd').trigger('footable_filter', {filter: $(this).val()});
            });
        });
        </script>
        
    </body>

</html>