<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid = $_SESSION['ad_id'];
  
  if(isset($_GET['delete_pay_number'])) {
    $id = intval($_GET['delete_pay_number']);
    $adn = "delete from his_payrolls where pay_number=?";
    $stmt = $mysqli->prepare($adn);
    $stmt->bind_param('i', $id);
    $stmt->execute();
    $stmt->close();     
  
    if($stmt) {
      $success = "Payroll Record Deleted";
    } else {
      $err = "Try Again Later";
    }
  }
?>

<!DOCTYPE html>
<html lang="en">
    
<?php include('assets/inc/head.php');?>

<body>
    <!-- Begin page -->
    <div id="wrapper">
        <!-- Topbar Start -->
        <?php include('assets/inc/nav.php');?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->
        <div class="content-page">
            <div class="content">
                <!-- Start Content-->
                <div class="container-fluid">                        
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Payroll</a></li>
                                        <li class="breadcrumb-item active">Manage Payroll</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Employee Payroll Details</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 

                    <!-- Alert Messages -->
                    <?php if(isset($success)) { ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                            <?php echo $success; ?>
                        </div>
                    <?php } ?>
                    
                    <?php if(isset($err)) { ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                            <?php echo $err; ?>
                        </div>
                    <?php } ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title mb-4">Payroll Records</h4>
                                    
                                    <div class="row mb-2">
                                        <div class="col-sm-12">
                                            <div class="float-sm-right">
                                                <div class="form-inline">
                                                    <div class="form-group">
                                                        <input id="demo-foo-search" type="text" placeholder="Search" class="form-control form-control-sm" autocomplete="on">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="table-responsive">
                                        <table id="demo-foo-filtering" class="table table-striped table-bordered mb-0" data-page-size="10">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>#</th>
                                                    <th data-toggle="true">Employee Name</th>
                                                    <th>Employee Number</th>
                                                    <th data-hide="phone">Payroll Number</th>
                                                    <th data-hide="phone">Employee Salary</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                    $ret = "SELECT * FROM his_payrolls ORDER BY RAND()"; 
                                                    $stmt = $mysqli->prepare($ret);
                                                    $stmt->execute();
                                                    $res = $stmt->get_result();
                                                    $cnt = 1;
                                                    
                                                    while($row = $res->fetch_object()) {
                                                ?>
                                                <tr>
                                                    <td><?php echo $cnt;?></td>
                                                    <td><?php echo $row->pay_doc_name;?></td>
                                                    <td><?php echo $row->pay_doc_number;?></td>
                                                    <td><?php echo $row->pay_number;?></td>   
                                                    <td>$<?php echo number_format($row->pay_emp_salary, 2);?></td>
                                                    <td>
                                                        <div class="btn-group">
                                                            <a href="update_single_employee_payroll.php?pay_number=<?php echo $row->pay_number;?>" class="btn btn-sm btn-primary">
                                                                <i class="fas fa-edit"></i> Update
                                                            </a>
                                                            <a href="manage_payrolls.php?delete_pay_number=<?php echo $row->pay_number;?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this record?')">
                                                                <i class="fas fa-trash"></i> Delete
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <?php $cnt++; } ?>
                                            </tbody>
                                            <tfoot>
                                                <tr class="active">
                                                    <td colspan="6">
                                                        <div class="text-right">
                                                            <ul class="pagination pagination-rounded justify-content-end footable-pagination"></ul>
                                                        </div>
                                                    </td>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div> <!-- end .table-responsive-->
                                </div> <!-- end card-body -->
                            </div> <!-- end card -->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->
                </div> <!-- container -->
            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->
        </div>
        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->
    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- Footable js -->
    <script src="assets/libs/footable/footable.all.min.js"></script>

    <!-- Init js -->
    <script src="assets/js/pages/foo-tables.init.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
    
    <!-- Confirmation for delete -->
    <script>
        function confirmDelete() {
            return confirm("Are you sure you want to delete this payroll record?");
        }
    </script>
</body>
</html>