<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid=$_SESSION['ad_id'];
?>

<!DOCTYPE html>
<html lang="en">
    
<?php include('assets/inc/head.php');?>

    <body style="background: linear-gradient(135deg, #f8f9fc 0%, #e6f2ff 100%); font-family: 'Poppins', sans-serif;">

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
                <?php include('assets/inc/nav.php');?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
                <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box" style="background: linear-gradient(45deg, #6a11cb 0%, #2575fc 100%); border-radius: 12px; padding: 20px; box-shadow: 0 8px 20px rgba(106, 17, 203, 0.2); color: white; margin-bottom: 25px;">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="javascript: void(0);" style="color: rgba(255,255,255,0.8);">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);" style="color: rgba(255,255,255,0.8);">Patients</a></li>
                                            <li class="breadcrumb-item active" style="color: white; font-weight: 600;">Transfer Patients</li>
                                        </ol>
                                    </div>
                                    <h4 class="page-title" style="color: white; font-weight: 700; letter-spacing: 0.5px;">
                                        <i class="fas fa-ambulance mr-2"></i>Patient Transfers
                                    </h4>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 

                        <!-- Patients Awaiting Transfer -->
                        <div class="row">
                            <div class="col-12">
                                <div class="card-box" style="border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); border: none; overflow: hidden;">
                                    <h4 class="header-title" style="color: #4e73df; font-weight: 600; border-left: 4px solid #4e73df; padding-left: 10px;">
                                        <i class="fas fa-user-clock mr-2"></i>Patients Awaiting Transfer
                                    </h4>
                                    <div class="mb-3">
                                        <div class="row">
                                            <div class="col-12 text-sm-center form-inline">
                                                <div class="form-group position-relative">
                                                    <i class="fas fa-search position-absolute" style="left: 15px; top: 10px; color: #6c757d;"></i>
                                                    <input id="demo-foo-search-pending" type="text" placeholder="Search patients..." class="form-control form-control-sm pl-4" autocomplete="on" style="border-radius: 8px; border: 1px solid #d1d3e2; width: 250px; padding-left: 35px;">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="table-responsive">
                                        <table id="demo-foo-filtering-pending" class="table table-bordered toggle-circle mb-0" data-page-size="7" style="border-collapse: separate; border-spacing: 0; border-radius: 12px; overflow: hidden;">
                                            <thead style="background: linear-gradient(to right, #4e73df, #224abe); color: white;">
                                            <tr>
                                                <th style="border: none; padding: 15px 10px;">#</th>
                                                <th data-toggle="true" style="border: none; padding: 15px 10px;">Patient</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Number</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Address</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Category</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Action</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php
                                                $ret="SELECT * FROM his_patients WHERE pat_type = 'InPatient'"; 
                                                $stmt= $mysqli->prepare($ret);
                                                $stmt->execute();
                                                $res=$stmt->get_result();
                                                $cnt=1;
                                                while($row=$res->fetch_object())
                                                {
                                            ?>
                                                <tr style="transition: all 0.3s; border-bottom: 1px solid #e3e6f0;">
                                                    <td style="padding: 15px 10px; border: none; font-weight: 500; color: #5a5c69;"><?php echo $cnt;?></td>
                                                    <td style="padding: 15px 10px; border: none; font-weight: 600; color: #4e73df;">
                                                        <i class="fas fa-user-circle mr-2"></i><?php echo $row->pat_fname;?> <?php echo $row->pat_lname;?>
                                                    </td>
                                                    <td style="padding: 15px 10px; border: none; color: #5a5c69;"><?php echo $row->pat_number;?></td>
                                                    <td style="padding: 15px 10px; border: none; color: #5a5c69;"><?php echo $row->pat_addr;?></td>
                                                    <td style="padding: 15px 10px; border: none;">
                                                        <span class="badge badge-pill" style="background: linear-gradient(to right, #ff416c, #ff4b2b); padding: 5px 12px; font-size: 12px;">IPD</span>
                                                    </td>
                                                    <td style="padding: 15px 10px; border: none;">
                                                        <a href="transfer_single_patient.php?pat_number=<?php echo $row->pat_number;?>" class="btn btn-sm btn-primary" style="background: linear-gradient(to right, #4e73df, #224abe); border: none; padding: 8px 15px; font-weight: 500; border-radius: 8px; box-shadow: 0 4px 8px rgba(0,0,0,0.1); transition: all 0.3s;">
                                                            <i class="mdi mdi-ambulance mr-1"></i> Transfer
                                                        </a>
                                                    </td>
                                                </tr>
                                            <?php $cnt = $cnt +1; } ?>
                                            </tbody>
                                            <tfoot>
                                            <tr class="active">
                                                <td colspan="6" style="border: none;">
                                                    <div class="text-right">
                                                        <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                    </div>
                                                </td>
                                            </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End Patients Awaiting Transfer -->

                        <!-- Transferred Patients -->
                        <div class="row">
                            <div class="col-12">
                                <div class="card-box" style="border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); border: none; overflow: hidden; margin-top: 25px;">
                                    <h4 class="header-title" style="color: #4e73df; font-weight: 600; border-left: 4px solid #4e73df; padding-left: 10px;">
                                        <i class="fas fa-history mr-2"></i>Transferred Patients
                                    </h4>
                                    <div class="mb-3">
                                        <div class="row">
                                            <div class="col-12 text-sm-center form-inline">
                                                <div class="form-group position-relative">
                                                    <i class="fas fa-search position-absolute" style="left: 15px; top: 10px; color: #6c757d;"></i>
                                                    <input id="demo-foo-search-completed" type="text" placeholder="Search transfers..." class="form-control form-control-sm pl-4" autocomplete="on" style="border-radius: 8px; border: 1px solid #d1d3e2; width: 250px; padding-left: 35px;">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="table-responsive">
                                        <table id="demo-foo-filtering-completed" class="table table-bordered toggle-circle mb-0" data-page-size="7" style="border-collapse: separate; border-spacing: 0; border-radius: 12px; overflow: hidden;">
                                            <thead style="background: linear-gradient(to right, #11998e, #38ef7d); color: white;">
                                            <tr>
                                                <th style="border: none; padding: 15px 10px;">#</th>
                                                <th data-toggle="true" style="border: none; padding: 15px 10px;">Patient Name</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Number</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Status</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Hospital</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Transfer Date</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php
                                                $ret="SELECT * FROM his_patient_transfers"; 
                                                $stmt= $mysqli->prepare($ret);
                                                $stmt->execute();
                                                $res=$stmt->get_result();
                                                $cnt=1;
                                                while($row=$res->fetch_object())
                                                {
                                            ?>
                                                <tr style="transition: all 0.3s; border-bottom: 1px solid #e3e6f0;">
                                                    <td style="padding: 15px 10px; border: none; font-weight: 500; color: #5a5c69;"><?php echo $cnt;?></td>
                                                    <td style="padding: 15px 10px; border: none; font-weight: 600; color: #11998e;">
                                                        <i class="fas fa-user-circle mr-2"></i><?php echo $row->t_pat_name;?>
                                                    </td>
                                                    <td style="padding: 15px 10px; border: none; color: #5a5c69;"><?php echo $row->t_pat_number;?></td>
                                                    <td style="padding: 15px 10px; border: none;">
                                                        <?php if($row->t_status == 'Completed'): ?>
                                                            <span class="badge badge-pill" style="background: linear-gradient(to right, #38ef7d, #11998e); padding: 5px 12px; font-size: 12px;">
                                                                <?php echo $row->t_status;?>
                                                            </span>
                                                        <?php else: ?>
                                                            <span class="badge badge-pill" style="background: linear-gradient(to right, #f7971e, #ffd200); padding: 5px 12px; font-size: 12px;">
                                                                <?php echo $row->t_status;?>
                                                            </span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td style="padding: 15px 10px; border: none; color: #5a5c69;"><?php echo $row->t_hospital;?></td>
                                                    <td style="padding: 15px 10px; border: none; color: #5a5c69;"><?php echo $row->t_date;?></td>
                                                </tr>
                                            <?php $cnt = $cnt +1; } ?>
                                            </tbody>
                                            <tfoot>
                                            <tr class="active">
                                                <td colspan="6" style="border: none;">
                                                    <div class="text-right">
                                                        <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                    </div>
                                                </td>
                                            </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End Transferred Patients -->
                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                 <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->


        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- Footable js -->
        <script src="assets/libs/footable/footable.all.min.js"></script>

        <!-- Init js -->
        <script src="assets/js/pages/foo-tables.init.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
        <script>
        $(document).ready(function() {
            // Initialize footable for all tables
            $('#demo-foo-filtering-pending').footable();
            $('#demo-foo-filtering-completed').footable();
            
            // Search functionality for pending transfers
            $('#demo-foo-search-pending').keyup(function() {
                $('#demo-foo-filtering-pending').trigger('footable_filter', {filter: $(this).val()});
            });
            
            // Search functionality for completed transfers
            $('#demo-foo-search-completed').keyup(function() {
                $('#demo-foo-filtering-completed').trigger('footable_filter', {filter: $(this).val()});
            });
        });
        </script>
        
    </body>

</html>