<?php
error_reporting(0);
session_start();
include('assets/inc/config.php');

if(isset($_POST['add_patient']))
{
    $pat_fname=$_POST['pat_fname'];
    $pat_lname=$_POST['pat_lname'];
    $pat_number=$_POST['pat_number'];
    $pat_phone=$_POST['pat_phone'];
    $pat_type=$_POST['pat_type'];
    $pat_addr=$_POST['pat_addr'];
    $pat_age = $_POST['pat_age'];
    $pat_dob = $_POST['pat_dob'];
    $pat_ailment = $_POST['pat_ailment'];
    $doc_dept= $_POST['doc_dept'];
    $doc_id= $_POST['doc_id'];
    $f= $_POST['fee'];
    $insurance = $_POST['insurance'];
    $status = $_POST['status'];
    $gender= $_POST['gender'];
    $card_no= $_POST['card_no'];
    $title= $_POST['title'];
    
    // Additional fields for OPD only
   $payment_mode = isset($_POST['payment_mode']) ? $_POST['payment_mode'] : '';
    $remarks = isset($_POST['remarks']) ? $_POST['remarks'] : '';
    
    // For IPD patients, set fee to 0 as they will be billed separately
   // For IPD patients, set fee to 0 as they will be billed separately
if($pat_type == 'InPatient') {
    $f = 0; // IPD patients don't pay consultation fee at registration
    // Also ensure ailment is handled properly for IPD
    if(empty($pat_ailment)) {
        $pat_ailment = "Admission - To be diagnosed"; // Default for IPD
    }
}
    
    //sql to insert captured values
    $query="INSERT INTO his_patients (pat_fname, pat_ailment, pat_lname, pat_age, pat_dob, pat_number, pat_phone, pat_type, pat_addr, dept, doc_id, insurance, status, gender, card_no, title, fee, payment_mode, remarks) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    $stmt = $mysqli->prepare($query);
    $rc=$stmt->bind_param('sssssssssssssssssss', $pat_fname, $pat_ailment, $pat_lname, $pat_age, $pat_dob, $pat_number, $pat_phone, $pat_type, $pat_addr, $doc_dept, $doc_id, $insurance, $status, $gender, $card_no, $title, $f, $payment_mode, $remarks);
    $stmt->execute();
    
    if($stmt)
    {
        $success = "Patient Details Added";
    }
    else {
        $err = "Please Try Again Or Try Later";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
    
    <!--Head-->
    <?php include('assets/inc/head.php');?>
    <style>
        :root {
            --primary: #2c6aa0;      /* Professional blue - trust, calmness */
            --primary-light: #e8f2fa; /* Light blue background */
            --primary-dark: #1a4d75;  /* Darker blue for hover states */
            --secondary: #4cb5ab;     /* Teal for accents - health, cleanliness */
            --accent: #d83444;        /* Coral red for important actions */
            --neutral-light: #f8f9fc; /* Light background */
            --neutral-dark: #5a5c69;  /* Dark text */
            --success: #38b673;       /* Green for success states */
            --warning: #f3b13e;       /* Yellow for warnings */
            --border: #d1e2ed;        /* Soft blue border */
            --shadow: 0 4px 12px rgba(44, 106, 160, 0.15);
            --transition: all 0.3s ease;
        }
        
        body {
            background: linear-gradient(135deg, var(--primary-light) 0%, #f0f7ff 100%);
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            min-height: 100vh;
            color: #3a3a3a;
        }
        
        .card {
            border: none;
            border-radius: 12px;
            box-shadow: var(--shadow);
            transition: var(--transition);
            overflow: hidden;
            background: white;
            border-top: 4px solid var(--primary);
        }
        
        .card:hover {
            box-shadow: 0 10px 25px rgba(44, 106, 160, 0.2);
            transform: translateY(-3px);
        }
        
        .page-title-box {
            background: linear-gradient(to right, var(--primary), var(--primary-dark));
            color: white;
            padding: 25px;
            border-radius: 12px;
            box-shadow: var(--shadow);
            margin-bottom: 25px;
            transition: var(--transition);
        }
        
        .page-title-box:hover {
            box-shadow: 0 8px 20px rgba(44, 106, 160, 0.25);
        }
        
        .page-title {
            color: white;
            font-weight: 600;
            letter-spacing: 0.5px;
            position: relative;
            padding-bottom: 15px;
            text-shadow: 1px 1px 2px rgba(0,0,0,0.1);
        }
        .btn-info {
    background: linear-gradient(to right, #17a2b8, #138496);
    border: none;
    color: white;
}

.btn-success {
    background: linear-gradient(to right, #28a745, #20c997);
    border: none;
    color: white;
}

.btn-sm {
    padding: 5px 10px;
    font-size: 12px;
    margin: 2px;
}
        .page-title:after {
            content: '';
            position: absolute;
            left: 0;
            bottom: 0;
            width: 50px;
            height: 3px;
            background: rgba(255,255,255,0.7);
            border-radius: 3px;
        }
        
        .breadcrumb-item a {
            color: rgba(255,255,255,0.8);
            font-weight: 500;
            transition: var(--transition);
        }
        
        .breadcrumb-item a:hover {
            color: white;
            text-decoration: none;
        }
        
        .breadcrumb-item.active {
            color: rgba(255,255,255,0.9);
        }
        
        .form-control {
            border-radius: 8px;
            border: 1px solid var(--border);
            padding: 12px 15px;
            transition: var(--transition);
            background-color: white;
            height: auto;
            color: var(--neutral-dark);
        }
        
        .form-control:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 0.2rem rgba(44, 106, 160, 0.2);
            background-color: white;
        }
        
        select.form-control {
            appearance: none;
            background-image: url('data:image/svg+xml;utf8,<svg fill="%232c6aa0" height="24" viewBox="0 0 24 24" width="24" xmlns="http://www.w3.org/2000/svg"><path d="M7 10l5 5 5-5z"/></svg>');
            background-repeat: no-repeat;
            background-position: right 10px center;
        }
        
        label {
            font-weight: 600;
            color: var(--primary-dark);
            margin-bottom: 8px;
            display: block;
        }
        
        .btn-primary {
            background: linear-gradient(to right, var(--primary), var(--primary-dark));
            border: none;
            padding: 12px 30px;
            font-weight: 600;
            border-radius: 8px;
            box-shadow: 0 4px 15px rgba(44, 106, 160, 0.3);
            transition: var(--transition);
            position: relative;
            overflow: hidden;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(44, 106, 160, 0.4);
            background: linear-gradient(to right, var(--primary-dark), var(--primary));
        }
        
        .btn-primary:active {
            transform: translateY(0);
        }
        
        .header-title {
            color: var(--primary);
            margin-bottom: 2rem;
            font-weight: 600;
            position: relative;
            padding-bottom: 15px;
            border-bottom: 2px solid var(--border);
        }
        
        .form-text {
            font-size: 0.8rem;
            color: #6c87a0;
        }
        
        /* Patient type specific fields */
        .opd-only, .ipd-only {
            display: none;
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        
        .opd-only.show, .ipd-only.show {
            display: block;
            opacity: 1;
        }
        
        /* Fee field styling for different patient types */
        .fee-field {
            position: relative;
            background-color: #f0f7ff;
            padding: 15px;
            border-radius: 8px;
            border-left: 4px solid var(--secondary);
        }
        
        .fee-note {
            font-size: 0.75rem;
            color: var(--success);
            font-weight: 500;
            margin-top: 5px;
        }
        
        /* Required field indicator */
        label[required]:after {
            content: " *";
            color: var(--accent);
        }
        
        /* Animations */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .animate-fade {
            animation: fadeIn 0.5s ease forwards;
        }
        
        /* Form section styling */
        .form-section {
            background: #f9fbfd;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            border: 1px solid var(--border);
        }
        
        .form-section-title {
            color: var(--primary);
            font-weight: 600;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 1px dashed var(--border);
        }
        
        /* Success and error messages */
        .alert-success {
            background: linear-gradient(to right, var(--success), #2da061);
            color: white;
            border: none;
            border-radius: 8px;
        }
        
        .alert-danger {
            background: linear-gradient(to right, var(--accent), #c12a38);
            color: white;
            border: none;
            border-radius: 8px;
        }
        
        /* Loading animation */
        .loading {
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 3px solid rgba(255,255,255,.3);
            border-radius: 50%;
            border-top-color: #fff;
            animation: spin 1s ease-in-out infinite;
        }
        
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        
        /* Responsive adjustments */
        @media (max-width: 768px) {
            .page-title-box {
                padding: 15px;
            }
            
            .card {
                margin: 0 10px;
            }
            
            .form-section {
                padding: 15px;
            }
        }
    </style>
    <body>

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
            <?php include("assets/inc/nav.php");?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
            <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row animate-fade">
                            <div class="col-12">
                              
                            </div>
                        </div>     
                        <!-- end page title --> 
                        
                        <!-- Display success/error messages -->
                        <?php if(isset($success)) { ?>
                        <div class="row animate-fade">
                            <div class="col-12">
                                <div class="alert alert-success alert-dismissible fade show" role="alert">
                                    <strong>Success!</strong> <?php echo $success; ?>
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <?php } ?>
                        
                        <?php if(isset($err)) { ?>
                        <div class="row animate-fade">
                            <div class="col-12">
                                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                    <strong>Error!</strong> <?php echo $err; ?>
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <?php } ?>
                        
                        <!-- Form row -->
                       <div class="row animate-fade" style="animation-delay: 0.1s;">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h4 class="header-title"><i class="fas fa-user-injured mr-2" style="color: var(--primary);"></i>Patient Information</h4>
                <form method="post" id="patientForm">
                    <div class="form-row">
                        <div class="form-group col-md-3">
                            <label for="pat_type" required>Patient Type</label>
                            <select id="pat_type" name="pat_type" class="form-control" required onchange="togglePatientTypeFields()">
                                <option value="" disabled selected>Select Patient Type</option>
                                <option value="OutPatient">OPD (Outpatient)</option>
                                <option value="InPatient">IPD (Inpatient)</option>
                            </select>
                            <small class="form-text text-muted">Select OPD or IPD</small>
                        </div>
                        <div class="form-group col-md-3">
                            <label for="department" required>Department</label>
                            <select id="department" name="doc_dept" class="form-control" required>
                                <option value="" disabled selected>Select Department</option>
                            </select>
                            <small class="form-text text-muted">Select department based on patient type</small>
                        </div>
                        <div class="form-group col-md-3">
                            <label for="doctor" required>Doctor</label>
                            <select name="doc_id" class="form-control" id="doctor" required>
                                <option value="" disabled selected>Select Doctor</option>
                                <?php
                                $ret = "SELECT * FROM his_docs";
                                $stmt = $mysqli->prepare($ret);
                                $stmt->execute();
                                $res = $stmt->get_result();
                                while ($row = $res->fetch_object()) {
                                    echo '<option value="' . $row->doc_id . '" data-dept="' . $row->doc_dept . '">' . $row->doc_fname . ' ' . $row->doc_lname . '</option>';
                                }
                                ?>
                            </select>
                            <small class="form-text text-muted">Select attending doctor</small>
                        </div>
                        <div class="form-group col-md-3">
                            <label for="ailment" required>Ailment</label>
                            <select id="ailment" name="pat_ailment" class="form-control" required>
                                <option value="" disabled selected>Select Ailment</option>
                            </select>
                            <small class="form-text text-muted">Select patient's ailment</small>
                        </div>
                        <div class="form-group col-md-3">
                            <label for="fee">Fee</label>
                            <input type="text" class="form-control" id="fee" name="fee" value="0" readonly required>
                            <div id="feeNote" class="fee-note"></div>
                            <small class="form-text text-muted" id="feeDescription">Consultation fee</small>
                        </div>
                        <div class="opd-only form-group col-md-3">
                            <label for="payment_mode">Payment Mode</label>
                            <select id="payment_mode" name="payment_mode" class="form-control">
                                <option value="" selected disabled>Select Payment Mode</option>
                                <option value="Cash">Cash</option>
                                <option value="Card">Card</option>
                                <option value="Upi">Upi</option>
                                <option value="Insurance">Insurance</option>
                            </select>
                            <small class="form-text text-muted">OPD payment method</small>
                        </div>
                        <div class="opd-only form-group col-md-3">
                            <label for="remarks">Remarks</label>
                            <textarea id="remarks" name="remarks" class="form-control" rows="1" placeholder="Additional notes"></textarea>
                            <small class="form-text text-muted">OPD specific remarks</small>
                        </div>
                        <div class="form-group col-md-3">
                            <label for="patientTitle" required>Patient Title</label>
                            <select required name="title" class="form-control" id="patientTitle">
                                <option value="" disabled selected>Select Title</option>
                                <option value="Mr">Mr</option>
                                <option value="Miss">Miss</option>
                                <option value="Mrs">Mrs</option>
                                <option value="Master">Master</option>
                                <option value="Baby">Baby</option>
                                <option value="Prof">Prof</option>
                                <option value="Dr">Dr</option>
                            </select>
                            <small class="form-text text-muted">Select patient title</small>
                        </div>
                        <div class="form-group col-md-3">
                            <label for="inputFirstName" required>First Name</label>
                            <input type="text" required name="pat_fname" class="form-control" id="inputFirstName" placeholder="Patient's First Name">
                            <small class="form-text text-muted">Enter patient's legal first name</small>
                        </div>
                        <div class="form-group col-md-3">
                            <label for="inputLastName" required>Last Name</label>
                            <input required type="text" name="pat_lname" class="form-control" id="inputLastName" placeholder="Patient's Last Name">
                            <small class="form-text text-muted">Enter patient's legal last name</small>
                        </div>
                        <div class="form-group col-md-3">
                            <label for="inputCardNo" required>Aadhar Card No</label>
                            <input 
  required 
  type="text" 
  name="card_no" 
  class="form-control" 
  id="inputCardNo" 
  placeholder="Aadhar card No" 
  maxlength="12" 
  pattern="\d{12}" 
  title="Please enter exactly 12 digits"
/>

                            <small class="form-text text-muted">12-digit Aadhar card number</small>
                        </div>
                        <div class="form-group col-md-3">
                            <label for="patientGender" required>Gender</label>
                            <select required name="gender" class="form-control" id="patientGender">
                                <option value="" disabled selected>Select Gender</option>
                                <option value="Male">Male</option>
                                <option value="Female">Female</option>
                                <option value="Other">Other</option>
                            </select>
                            <small class="form-text text-muted">Select gender</small>
                        </div>
                        <div class="form-group col-md-3">
                            <label for="patientStatus" required>Marital Status</label>
                            <select required name="status" class="form-control" id="patientStatus">
                                <option value="" disabled selected>Select Status</option>
                                <option value="Single">Single</option>
                                <option value="Married">Married</option>
                                <option value="Divorced">Divorced</option>
                                <option value="Other">Other</option>
                            </select>
                            <small class="form-text text-muted">Select marital status</small>
                        </div>
                        <div class="form-group col-md-3">
                            <label for="insurance">Insurance Company</label>
                            <select name="insurance" class="form-control" id="insurance">
                                <option value="" disabled selected>Select Insurance Company</option>
                                <?php
                                $query = "SELECT * FROM his_insurance ORDER BY insurance_name ASC";
                                $stmt = $mysqli->prepare($query);
                                $stmt->execute();
                                $result = $stmt->get_result();
                                while ($row = $result->fetch_assoc()) {
                                    echo '<option value="' . htmlspecialchars($row['insurance_name']) . '">' . htmlspecialchars($row['insurance_name']) . '</option>';
                                }
                                ?>
                            </select>
                            <small class="form-text text-muted">Insurance provider</small>
                        </div>
                       <div class="form-group col-md-3">
    <label for="dob_year">Date of Birth</label>
    <div class="d-flex" style="gap: 5px;">
        <!-- Year -->
        <select name="dob_year" id="dob_year" class="form-control" required>
            <option value="">Year</option>
        </select>

        <!-- Month -->
        <select name="dob_month" id="dob_month" class="form-control" required>
            <option value="">Month</option>
        </select>

        <!-- Day -->
        <select name="dob_day" id="dob_day" class="form-control" required>
            <option value="">Day</option>
        </select>
    </div>
    <small class="form-text text-muted">Patient's date of birth</small>
</div>

<script>
    // Populate Years (e.g., last 100 years)
    const yearSelect = document.getElementById('dob_year');
    const monthSelect = document.getElementById('dob_month');
    const daySelect = document.getElementById('dob_day');

    const currentYear = new Date().getFullYear();
    for(let y = currentYear; y >= currentYear - 100; y--){
        const option = document.createElement('option');
        option.value = y;
        option.text = y;
        yearSelect.add(option);
    }

    // Populate Months
    const months = [
        "January","February","March","April","May","June",
        "July","August","September","October","November","December"
    ];
    months.forEach((month, index) => {
        const option = document.createElement('option');
        option.value = index + 1; // month number 1-12
        option.text = month;
        monthSelect.add(option);
    });

    // Populate Days based on year and month
    function populateDays(){
        const year = parseInt(yearSelect.value);
        const month = parseInt(monthSelect.value);
        daySelect.innerHTML = '<option value="">Day</option>'; // clear previous

        if(!year || !month) return;

        // Get number of days in the month
        const daysInMonth = new Date(year, month, 0).getDate();

        for(let d=1; d<=daysInMonth; d++){
            const option = document.createElement('option');
            option.value = d;
            option.text = d;
            daySelect.add(option);
        }
    }

    yearSelect.addEventListener('change', populateDays);
    monthSelect.addEventListener('change', populateDays);
</script> 

                        <div class="form-group col-md-3">
                            <label for="inputAge" required>Age</label>
                            <input required type="number" name="pat_age" class="form-control" id="inputAge" placeholder="Patient's Age">
                            <small class="form-text text-muted">Patient's current age</small>
                        </div>
                        <div class="form-group col-md-3">
                            <label for="inputAddress" required>Address</label>
                            <input required type="text" class="form-control" name="pat_addr" id="inputAddress" placeholder="Patient's Address">
                            <small class="form-text text-muted">Full residential address</small>
                        </div>
                        <div class="form-group col-md-3">
                            <label for="inputPhone" required>Mobile Number</label>
                            <input required type="tel" name="pat_phone" class="form-control" id="inputPhone" placeholder="e.g. +91700000000" maxlength="15" >
                            <small class="form-text text-muted">With country code</small>
                        </div>
                    </div>
                    <div class="form-group col-md-2" style="display:none">
                        <?php 
                            $length = 5;    
                            $patient_number =  substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'),1,$length);
                        ?>
                        <label for="inputPatNumber">Patient Number</label>
                        <input type="text" name="pat_number" value="<?php echo $patient_number;?>" class="form-control" id="inputPatNumber">
                    </div>
                    <div class="form-group col-md-3">
                            <label for="registration_date">Registration Date</label>
                            <input type="datetime-local" class="form-control" id="registration_date" name="registration_date" value="<?php echo date('Y-m-d\TH:i'); ?>">
                            <small class="form-text text-muted">Date and time of registration</small>
                        </div>
                    <div class="text-right mt-4">
                        <button type="submit" name="add_patient" class="btn btn-primary"><i class="fas fa-user-plus mr-2"></i>Add Patient</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

                        <!-- end row -->
<div class="row animate-fade" style="animation-delay: 0.2s;">
  <div class="col-12">
    <div class="card shadow-sm">
      <div class="card-body">
        <!-- Header -->
        <h4 class="header-title mb-4 text-center">
          <i class="fas fa-users mr-2" style="color: var(--primary);"></i>
          <span class="text-primary">Patients List</span>
        </h4>

        <!-- Filter Buttons -->
        <div class="text-center mb-3">
          <button class="btn btn-primary btn-sm mx-1" onclick="filterPatients('All')">
            <i class="fas fa-list mr-1"></i> All
          </button>
          <button class="btn btn-secondary btn-sm mx-1" onclick="filterPatients('OutPatient')">
            <i class="fas fa-hospital-user mr-1"></i> OPD
          </button>
          <button class="btn btn-info btn-sm mx-1" onclick="filterPatients('InPatient')">
            <i class="fas fa-procedures mr-1"></i> IPD
          </button>
        </div>

        <!-- Patients Table -->
        <div class="table-responsive">
          <table class="table table-bordered table-hover align-middle">
            <thead class="bg-primary text-white text-center">
              <tr>
                <th>#</th>
                <th>Patient Details</th>
                <th>Type</th>
                <th>Department</th>
                <th>Insurance</th>
                <th>Date-Time</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody id="patientsTableBody">
              <?php
              // Default query to fetch all patients
              $query = "SELECT * FROM his_patients";
              if (isset($_GET['filter'])) {
                  $filter = $_GET['filter'];
                  if ($filter === 'OutPatient' || $filter === 'InPatient') {
                      $query .= " WHERE pat_type = '$filter'";
                  }
              }
              $query .= " ORDER BY pat_date_joined DESC";

              $stmt = $mysqli->prepare($query);
              $stmt->execute();
              $result = $stmt->get_result();
              $count = 1;

              while ($row = $result->fetch_assoc()) {
                  echo "<tr>";
                  echo "<td class='text-center fw-bold'>" . $count++ . "</td>";

                  // Patient card block
                  echo "<td>
                    <div class='patient-card'>
                      <p><strong>ID:</strong> " . htmlspecialchars($row['pat_id']) . "</p>
                      <p><strong>Number:</strong> " . htmlspecialchars($row['pat_number']) . "</p>
                      <p><strong>Name:</strong> " . htmlspecialchars($row['pat_fname'] . ' ' . $row['pat_lname']) . "</p>
                      <p><strong>Age:</strong> " . htmlspecialchars($row['pat_age']) . " | <strong>Gender:</strong> " . htmlspecialchars($row['gender']) . "</p>
                      <p><strong>Phone:</strong> " . htmlspecialchars($row['pat_phone']) . "</p>
                    </div>
                  </td>";

                  echo "<td class='text-center'>" . htmlspecialchars($row['pat_type']) . "</td>";
                  echo "<td class='text-center'>" . htmlspecialchars($row['dept']) . "</td>";
                  echo "<td class='text-center'>" . htmlspecialchars($row['insurance']) . "</td>";
                  echo "<td class='text-center'>" . htmlspecialchars($row['pat_date_joined']) . "</td>";

                  // Action buttons
                  echo "<td class='text-center'>
                    <div class='btn-group' role='group' aria-label='Patient Actions'>
                      <a href='update_single_patient.php?pat_id=" . htmlspecialchars($row['pat_id']) . "' 
                         class='btn btn-primary btn-sm' title='Edit Patient'>
                        <i class='fas fa-edit'></i>
                      </a>
                      <a href='manage_patient.php?delete=" . htmlspecialchars($row['pat_id']) . "' 
                         class='btn btn-danger btn-sm' title='Delete Patient'
                         onclick=\"return confirm('Are you sure you want to delete this patient?');\">
                        <i class='fas fa-trash'></i>
                      </a>
                     
                      <button onclick='generateInvoice(" . $row['pat_id'] . ")' 
                              class='btn btn-success btn-sm' title='Generate Invoice'>
                        <i class='fas fa-file-invoice'></i>
                      </button>
                      <a href='single_patient_medicine.php?pat_id=" . htmlspecialchars($row['pat_id']) . "' 
                         class='btn btn-warning btn-sm' title='Add Bill'>
                        <i class='fas fa-pills'></i>
                      </a>
                      <a href='patient_medical_details.php?pat_id=" . htmlspecialchars($row['pat_id']) . "' 
                         class='btn btn-secondary btn-sm' title='Payment'>
                        <i class='fas fa-notes-medical'></i>
                      </a>
                      <a href='generate_invoice1.php?pat_id=" . htmlspecialchars($row['pat_id']) . "' 
                         class='btn btn-dark btn-sm' title='Ledger'>
                        <i class='fas fa-file-invoice-dollar'></i>
                      </a>
                      <a href='transfer_patient.php?pat_id=" . htmlspecialchars($row['pat_id']) . "' 
                         class='btn btn-outline-dark btn-sm' title='Transfer'>
                        <i class='fas fa-right-left'></i>
                      </a>
                      <a href='printrec.php?pat_id=" . htmlspecialchars($row['pat_id']) . "' 
                         class='btn btn-outline-primary btn-sm' title='Report'>
                        <i class='fas fa-file-alt'></i>
                      </a>
                    </div>
                  </td>";

                  echo "</tr>";
              }
              ?>
            </tbody>
          </table>
        </div>

        <!-- Custom styles -->
        <style>
        .patient-card {
          background: #f8f9fa;
          border-left: 5px solid #007bff;
          padding: 8px 12px;
          border-radius: 5px;
        }
        .patient-card p {
          margin: 2px 0;
          font-size: 13px;
        }
        .table thead th {
          background-color: #007bff !important;
          color: white !important;
          vertical-align: middle;
        }
        .btn-group .btn {
          margin: 1px;
        }
        </style>
      </div> <!-- end card-body -->
    </div> <!-- end card-->
  </div> <!-- end col -->
</div>


<script>
function printPatientDetails(patientId) {
    window.open('print_patient_details.php?pat_id=' + patientId, '_blank');
}

function generateInvoice(patientId) {
    window.open('generate_invoice.php?pat_id=' + patientId, '_blank');
}

function filterPatients(filter) {
    window.location.href = window.location.pathname + "?filter=" + filter;
}
</script>
            </div> <!-- end card-body -->
        </div> <!-- end card-->
    </div> <!-- end col -->
</div>

<!-- JavaScript for Filtering -->
<script>
    function filterPatients(filter) {
        // Redirect to the same page with the filter parameter
        window.location.href = window.location.pathname + "?filter=" + filter;
    }
</script>

                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- App js-->
        <script src="assets/js/app.min.js"></script>

        <!-- jQuery -->
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    

   <script>
    // Put this ONCE outside
$('#ailment').on('change', function () {
    let selectedFee = $('#ailment option:selected').data('fee');
    if (selectedFee !== undefined) {
        $('#fee').val(selectedFee);
    }
});

    $(document).ready(function () {
        // Initialize by hiding type-specific fields
        togglePatientTypeFields();
        
        // Patient type change handler
        $('#pat_type').on('change', function () {
            togglePatientTypeFields();
            let patType = $(this).val();
            
            // Clear dependent fields
            $('#department').html('<option value="" disabled selected>Loading departments...</option>');
            $('#doctor').html('<option value="" disabled selected>Select Doctor</option>');
            $('#ailment').html('<option value="" disabled selected>Select Ailment</option>');
            
            // Set fee based on patient type
            if (patType === 'InPatient') {
                $('#fee').val('0');
                $('#fee').prop('readonly', true); // Make it readonly for IPD
                $('#feeNote').text('IPD patients will be billed separately for admission and treatment');
                $('#feeDescription').text('Admission fee will be calculated separately');
                // Hide the fee field for IPD patients
                $('.fee-field').hide();
                // Remove required attribute from ailment for IPD
                $('#ailment').removeAttr('required');
            } else {
                $('#fee').val('');
                $('#fee').prop('readonly', false); // Make it editable for OPD
                $('#feeNote').text('');
                $('#feeDescription').text('Consultation fee');
                // Show the fee field for OPD patients
                $('.fee-field').show();
                // Add required attribute to ailment for OPD
                $('#ailment').attr('required', 'required');
            }
            
            // Load departments based on patient type
            if (patType) {
                $.ajax({
                    url: 'get_departments.php',
                    type: 'POST',
                    data: { pat_type: patType },
                    success: function (response) {
                        $('#department').html(response);
                    },
                    error: function() {
                        $('#department').html('<option value="" disabled selected>Error loading departments</option>');
                    }
                });
            }
        });

        // Department change handler
        $('#department').on('change', function () {
            let deptName = $(this).val();
            let patType = $('#pat_type').val();
            
            // Load doctors based on selected department
            if (deptName) {
                $('#doctor').html('<option value="" disabled selected>Loading doctors...</option>');
                $.ajax({
                    url: 'get_doctors.php',
                    type: 'POST',
                    data: { department_name: deptName },
                    success: function (response) {
                        let doctors = JSON.parse(response);
                        $('#doctor').html('<option value="" disabled selected>Select Doctor</option>');
                        doctors.forEach(function (doc) {
                            $('#doctor').append('<option value="' + doc.doc_id + '">' + doc.doc_fname + ' ' + doc.doc_lname + '</option>');
                        });
                    },
                    error: function() {
                        $('#doctor').html('<option value="" disabled selected>Error loading doctors</option>');
                    }
                });
            } else {
                $('#doctor').html('<option value="" disabled selected>Select Doctor</option>');
            }
            
            // For IPD patients, don't load ailments
            if (patType === 'InPatient') {
                // Set a default value for IPD patients
                $('#ailment').val('Admission - To be diagnosed');
                return;
            }
            
            if (deptName && patType === 'OutPatient') {
                $('#ailment').html('<option value="" disabled selected>Loading ailments...</option>');
                
               $.ajax({
    url: 'get_ailments_and_fee.php',
    type: 'POST',
    dataType: 'json',
    data: { department_name: deptName },
    success: function (data) {
        $('#ailment').html('<option value="" disabled selected>Select Ailment</option>');
        if (data.ailments && data.ailments.length > 0) {
            data.ailments.forEach(function (item) {
                // Show department + ailment in text
                let text = item.ailment + ' - ' + item.fee;
                // store opd_fee in data-fee
                $('#ailment').append('<option value="' + item.ailment + '" data-fee="' + item.fee + '">' + text + '</option>');
            });
        }
        // clear fee initially unmobilemobiletil ailment selected
        $('#fee').val('');
    },
    error: function() {
        $('#ailment').html('<option value="" disabled selected>Error loading ailments</option>');
        $('#fee').val('');
    }
});

            } else {
                $('#ailment').html('<option value="" disabled selected>Select Ailment</option>');
                if (patType === 'OutPatient') {
                    $('#fee').val('');
                }
            }
        });

        // Age calculation from DOB
        $('#inputDOB').on('change', function() {
            const dob = new Date($(this).val());
            const today = new Date();
            let age = today.getFullYear() - dob.getFullYear();
            const m = today.getMonth() - dob.getMonth();
            
            if (m < 0 || (m === 0 && today.getDate() < dob.getDate())) {
                age--;
            }
            
            if (age > 0) {
                $('#inputAge').val(age);
            }
        });
        
        // Set default ailment for IPD on page load if needed
        if ($('#pat_type').val() === 'InPatient') {
            $('#ailment').val('Admission - To be diagnosed');
        }
    });

    // Function to toggle OPD/IPD specific fields
    function togglePatientTypeFields() {
        const patientType = $('#pat_type').val();
        
        // Hide all type-specific fields first
        $('.opd-only, .ipd-only').removeClass('show');
        
        // Show/hide fields based on patient type
        if (patientType === 'OutPatient') {
            $('.opd-only').addClass('show');
            $('#feeDescription').text('Consultation fee');
            $('#feeNote').text('');
            $('.fee-field').show(); // Show fee field for OPD
            $('.form-group:has(#ailment)').show(); // Show ailment field for OPD
            $('#ailment').attr('required', 'required'); // Make ailment required for OPD
        } else if (patientType === 'InPatient') {
            $('.ipd-only').addClass('show');
            $('#fee').val('0');
            $('#feeDescription').text('Admission fee will be calculated separately');
            $('#feeNote').text('IPD patients will be billed separately for admission and treatment');
            $('.fee-field').hide(); // Hide fee field for IPD
            $('.form-group:has(#ailment)').hide(); // Hide ailment field for IPD
            $('#ailment').removeAttr('required'); // Remove required attribute for IPD
            // Set a default value for IPD patients
            $('#ailment').val('Admission - To be diagnosed');
        }
    }

    // Form validation
    $('#patientForm').on('submit', function(e) {
        const patientType = $('#pat_type').val();
        
        if (!patientType) {
            e.preventDefault();
            alert('Please select patient type (OPD or IPD)');
            $('#pat_type').focus();
            return false;
        }
        
        // For IPD patients, ensure fee is 0 and remove required from ailment
        if (patientType === 'InPatient') {
            $('#fee').val('0'); // Force set fee to 0 for IPD
            $('#ailment').removeAttr('required');
            // Set a default value if empty
            if (!$('#ailment').val()) {
                $('#ailment').val('Admission - To be diagnosed');
            }
        } else {
            $('#ailment').attr('required', 'required');
        }
        
        // Additional validation can be added here
        return true;
    });
</script>
 
    </body>
</html>