<div class="form-section">
    <h5>Add New Department</h5>
    <form action="update_settings.php" method="post">
        <input type="hidden" name="setting_type" value="department_add">
        
        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="department_name">Department Name</label>
                <input type="text" class="form-control" id="department_name" name="department_name" required>
            </div>
            
            <div class="form-group col-md-6">
                <label for="department_type">Department Type</label>
                <select class="form-control" id="department_type" name="department_type" required>
                    <option value="OutPatient">OPD</option>
                    <option value="InPatient">IPD</option>
                </select>
            </div>
        </div>
        
        <div class="form-row">
            <div class="form-group col-md-4">
                <label for="opd_fee">OPD Fee (if applicable)</label>
                <input type="number" step="0.01" class="form-control" id="opd_fee" name="opd_fee" value="0.00">
            </div>
            
            <div class="form-group col-md-4">
                <label for="ipd_fee">IPD Fee (if applicable)</label>
                <input type="number" step="0.01" class="form-control" id="ipd_fee" name="ipd_fee" value="0.00">
            </div>
            
            <div class="form-group col-md-4">
                <label for="ailment_name">Common Ailment</label>
                <input type="text" class="form-control" id="ailment_name" name="ailment_name">
            </div>
        </div>
        
        <div class="form-group">
            <label for="department_description">Description</label>
            <textarea class="form-control" id="department_description" name="department_description" rows="3"></textarea>
        </div>
        
        <button type="submit" class="btn btn-primary">Add Department</button>
    </form>
</div>

<div class="form-section">
    <h5>Manage Departments</h5>
    <div class="table-responsive">
        <table id="departments-table" class="table table-bordered mb-0" style="width:100%">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Department Name</th>
                    <th>Type</th>
                    <th>OPD Fee</th>
                    <th>IPD Fee</th>
                    <th>Common Ailment</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $ret = "SELECT * FROM his_departments ORDER BY department_name";
                $stmt = $mysqli->prepare($ret);
                $stmt->execute();
                $res = $stmt->get_result();
                $cnt = 1;
                while($row = $res->fetch_object()):
                ?>
                <tr>
                    <td><?php echo $cnt; ?></td>
                    <td><?php echo htmlspecialchars($row->department_name); ?></td>
                    <td><?php echo htmlspecialchars($row->department_type); ?></td>
                    <td><?php echo number_format($row->opd_fee, 2); ?></td>
                    <td><?php echo number_format($row->ipd_fee, 2); ?></td>
                    <td><?php echo htmlspecialchars($row->ailment_name); ?></td>
                    <td>
                        <div class="d-flex" style="gap: 5px;">
                            <a href="edit_department.php?id=<?php echo $row->department_id; ?>" class="badge badge-primary">
                                <i class="fas fa-edit mr-1"></i> Edit
                            </a>
                            <a href="update_settings.php?action=delete_department&id=<?php echo $row->department_id; ?>" 
                               class="badge badge-danger" onclick="return confirm('Are you sure you want to delete this department?');">
                                <i class="fas fa-trash-alt mr-1"></i> Delete
                            </a>
                        </div>
                    </td>
                </tr>
                <?php $cnt++; endwhile; ?>
            </tbody>
        </table>
    </div>
</div>