<?php
// Fetch current settings
$ret = "SELECT * FROM his_system_settings WHERE id = 1";
$stmt = $mysqli->prepare($ret);
$stmt->execute();
$res = $stmt->get_result();
$settings = $res->fetch_object();
?>

<div class="form-section">
    <h5>Hospital Information</h5>
    <form action="update_settings.php" method="post" enctype="multipart/form-data">
        <input type="hidden" name="setting_type" value="general">
        
        <div class="form-group">
            <label for="system_name">Hospital Name</label>
            <input type="text" class="form-control" id="system_name" name="system_name" 
                   value="<?php echo htmlspecialchars($settings->system_name ?? ''); ?>" required>
        </div>
        
        <div class="form-group">
            <label for="system_email">Email Address</label>
            <input type="email" class="form-control" id="system_email" name="system_email" 
                   value="<?php echo htmlspecialchars($settings->system_email ?? ''); ?>">
        </div>
        
        <div class="form-group">
            <label for="system_phone">Phone Number</label>
            <input type="text" class="form-control" id="system_phone" name="system_phone" 
                   value="<?php echo htmlspecialchars($settings->system_phone ?? ''); ?>">
        </div>
        
        <div class="form-group">
            <label for="system_address">Address</label>
            <textarea class="form-control" id="system_address" name="system_address" 
                      rows="3"><?php echo htmlspecialchars($settings->system_address ?? ''); ?></textarea>
        </div>
        
        <div class="form-group">
            <label for="system_logo">Hospital Logo</label>
            <input type="file" class="form-control-file" id="system_logo" name="system_logo">
            <?php if($settings->system_logo): ?>
                <img src="<?php echo htmlspecialchars($settings->system_logo); ?>" id="logo-preview" class="logo-preview">
            <?php else: ?>
                <img src="" id="logo-preview" class="logo-preview" style="display:none;">
            <?php endif; ?>
        </div>
        
        <div class="form-group">
            <label for="system_mission">Mission Statement</label>
            <textarea class="form-control" id="system_mission" name="system_mission" 
                      rows="5"><?php echo htmlspecialchars($settings->system_mission ?? ''); ?></textarea>
        </div>
        
        <button type="submit" class="btn btn-primary">Save Changes</button>
    </form>
</div>