<?php
error_reporting(0);
session_start();
include('assets/inc/config.php');

// Get patient ID from URL
$patient_id = isset($_GET['pat_id']) ? $_GET['pat_id'] : null;

// Fetch patient details
$patient = null;
if ($patient_id) {
    $query = "SELECT * FROM his_patients WHERE pat_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('i', $patient_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $patient = $result->fetch_assoc();
}

// Handle form submission for adding medicine orders
if(isset($_POST['add_medicine_order'])) {
    $pat_id = $_POST['pat_id'];
    $department = $_POST['department'];
    $patient_number = $_POST['patient_number'];
    
    // Process multiple medicine orders
    if(isset($_POST['medicine_name']) && is_array($_POST['medicine_name'])) {
        foreach($_POST['medicine_name'] as $index => $name) {
            if(!empty($name)) {
                $description = $_POST['medicine_description'][$index];
                $qty = $_POST['medicine_qty'][$index];
                $price = $_POST['medicine_price'][$index];
                
                // Calculate total price
                $total_price = $qty * $price;
                
                // Insert into database
                $query = "INSERT INTO his_medicine_orders (pat_id, department, patient_number, name, description, qty, price, total_price) 
                          VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
                $stmt = $mysqli->prepare($query);
                $stmt->bind_param('issssidd', $pat_id, $department, $patient_number, $name, $description, $qty, $price, $total_price);
                $stmt->execute();
            }
        }
        
        $success = "Medicine orders added successfully";
    } else {
        $err = "Please add at least one medicine";
    }
}

// Fetch medicine orders for this patient
$medicine_orders = [];
if ($patient_id) {
    $query = "SELECT * FROM his_medicine_orders WHERE pat_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('i', $patient_id);
    $stmt->execute();
    $result = $stmt->get_result();
    while ($row = $result->fetch_assoc()) {
        $medicine_orders[] = $row;
    }
}

// Calculate totals
$total_qty = 0;
$total_price = 0;
foreach ($medicine_orders as $order) {
    $total_qty += $order['qty'];
    $total_price += $order['total_price'];
}
?>
<!DOCTYPE html>
<html lang="en">
    
    <!--Head-->
    <?php include('assets/inc/head.php');?>
    <style>
        :root {
            --primary: #2c6aa0;
            --primary-light: #e8f2fa;
            --primary-dark: #1a4d75;
            --secondary: #4cb5ab;
            --accent: #d83444;
            --neutral-light: #f8f9fc;
            --neutral-dark: #5a5c69;
            --success: #38b673;
            --warning: #f3b13e;
            --border: #d1e2ed;
            --shadow: 0 4px 12px rgba(44, 106, 160, 0.15);
            --transition: all 0.3s ease;
        }
        
        body {
            background: linear-gradient(135deg, var(--primary-light) 0%, #f0f7ff 100%);
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            min-height: 100vh;
            color: #3a3a3a;
        }
        
        .card {
            border: none;
            border-radius: 12px;
            box-shadow: var(--shadow);
            transition: var(--transition);
            overflow: hidden;
            background: white;
            border-top: 4px solid var(--primary);
        }
        
        .card:hover {
            box-shadow: 0 10px 25px rgba(44, 106, 160, 0.2);
            transform: translateY(-3px);
        }
        
        .patient-header {
            background: linear-gradient(to right, var(--primary), var(--primary-dark));
            color: white;
            padding: 25px;
            border-radius: 12px;
            box-shadow: var(--shadow);
            margin-bottom: 25px;
        }
        
        .patient-info {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            margin-bottom: 15px;
        }
        
        .patient-info-item {
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 15px;
        }
        
        .patient-id {
            background: rgba(255, 255, 255, 0.2);
            padding: 5px 12px;
            border-radius: 20px;
            font-weight: 600;
        }
        
        .medicines-table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        
        .medicines-table th {
            background-color: var(--primary);
            color: white;
            padding: 12px;
            text-align: left;
        }
        
        .medicines-table td {
            padding: 12px;
            border-bottom: 1px solid var(--border);
        }
        
        .medicines-table tr:hover {
            background-color: var(--primary-light);
        }
        
        .totals-row {
            font-weight: bold;
            background-color: #f0f7ff;
        }
        
        .btn-add-row {
            background: var(--success);
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 6px;
            cursor: pointer;
            margin-bottom: 15px;
        }
        
        .btn-remove {
            background: var(--accent);
            color: white;
            border: none;
            padding: 5px 10px;
            border-radius: 4px;
            cursor: pointer;
        }
        
        .order-form {
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: var(--shadow);
            margin-top: 20px;
        }
        
        .form-row {
            display: flex;
            gap: 15px;
            margin-bottom: 15px;
            flex-wrap: wrap;
        }
        
        .form-group {
            flex: 1;
            min-width: 200px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: 600;
            color: var(--primary-dark);
        }
        
        .form-control {
            width: 100%;
            padding: 10px;
            border: 1px solid var(--border);
            border-radius: 6px;
            font-size: 14px;
        }
        
        .btn-submit {
            background: var(--primary);
            color: white;
            border: none;
            padding: 12px 25px;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
        }
        
        .btn-submit:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
        }
        
        .medicine-row {
            display: flex;
            gap: 15px;
            margin-bottom: 15px;
            flex-wrap: wrap;
            align-items: flex-end;
            padding: 15px;
            border-radius: 8px;
            background-color: var(--primary-light);
            transition: var(--transition);
        }
        
        .medicine-row:hover {
            background-color: #e0eaf5;
        }
        
        .medicine-field {
            flex: 1;
            min-width: 150px;
        }
        
        .medicine-field label {
            display: block;
            margin-bottom: 5px;
            font-weight: 600;
            color: var(--primary-dark);
        }
        
        .medicine-field input {
            width: 100%;
            padding: 10px;
            border: 1px solid var(--border);
            border-radius: 6px;
            font-size: 14px;
        }
        
        .remove-row {
            background: var(--accent);
            color: white;
            border: none;
            padding: 10px 15px;
            border-radius: 6px;
            cursor: pointer;
            height: fit-content;
        }
        
        .remove-row:hover {
            background: #c52232;
        }
        
        @media (max-width: 768px) {
            .patient-info {
                flex-direction: column;
                gap: 10px;
            }
            
            .form-row {
                flex-direction: column;
            }
            
            .form-group {
                min-width: 100%;
            }
            
            .medicine-row {
                flex-direction: column;
                align-items: stretch;
            }
            
            .medicine-field {
                min-width: 100%;
            }
        }
    </style>
    <body>

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
            <?php include("assets/inc/nav.php");?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
            <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- Display success/error messages -->
                        <?php if(isset($success)) { ?>
                        <div class="row">
                            <div class="col-12">
                                <div class="alert alert-success alert-dismissible fade show" role="alert">
                                    <strong>Success!</strong> <?php echo $success; ?>
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <?php } ?>
                        
                        <?php if(isset($err)) { ?>
                        <div class="row">
                            <div class="col-12">
                                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                    <strong>Error!</strong> <?php echo $err; ?>
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <?php } ?>
                        
                        <?php if($patient): ?>
                        <!-- Patient Header -->
                      <div class="row">
  <div class="col-12">
    <div class="patient-header">
      <h2>Patient Medicine Management</h2>
      <div class="patient-info">
        <div class="patient-info-item">
          <span>👤</span>
          <span><strong>Name:</strong> 
            <?php echo htmlspecialchars($patient['title'] . ' ' . $patient['pat_fname'] . ' ' . $patient['pat_lname']); ?>
          </span>
        </div>
        <div class="patient-info-item">
          <span>🗓️</span>
          <span><strong>Regi. Date:</strong> 
            <?php echo date('Y-m-d', strtotime($patient['pat_date_joined'])); ?>
          </span>
        </div>
        <div class="patient-info-item">
          <span>🏷️</span>
          <span><strong>Type:</strong> 
            <?php echo htmlspecialchars($patient['pat_type']); ?>
          </span>
        </div>
        <div class="patient-info-item">
          <span>🆔</span>
          <span><strong>UHID / VISIT ID:</strong> 
            <?php echo htmlspecialchars($patient['pat_number']); ?>
          </span>
        </div>
        <div class="patient-info-item">
          <span>🏥</span>
          <span><strong>Department:</strong> 
            <?php echo htmlspecialchars($patient['dept']); ?>
          </span>
        </div>
      </div>
      <div class="btn-container">
        <a href="generate_invoice1.php?pat_id=<?php echo $patient_id; ?>" class="btn-print" target="_blank">
          📄 Print Invoice
        </a>
      </div>
    </div>
  </div>
</div>
<style>:root {
  --primary: #4e73df;           /* main color */
  --primary-dark: #3752a6;
  --background: #f8f9fc;
  --text-dark: #333;
  --text-light: #6c757d;
  --transition: all 0.3s ease;
}

.patient-header {
  background: #fff;
  border-radius: 16px;
  padding: 30px;
  margin-top: 20px;
  box-shadow: 0 6px 20px rgba(0, 0, 0, 0.05);
  transition: var(--transition);
}

.patient-header:hover {
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.08);
}

.patient-header h2 {
  color: var(--primary);
  font-size: 1.8rem;
  font-weight: 700;
  margin-bottom: 20px;
  text-align: center;
}

.patient-info {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
  gap: 15px;
  margin-bottom: 20px;
}

.patient-info-item {
  background: var(--background);
  border-radius: 12px;
  padding: 15px;
  display: flex;
  align-items: center;
  gap: 10px;
  font-size: 1rem;
  color: var(--text-dark);
  transition: var(--transition);
}

.patient-info-item:hover {
  background: #eef2ff;
  transform: translateY(-3px);
}

.patient-info-item span:first-child {
  font-size: 1.4rem;
}

.btn-container {
  text-align: center;
  margin-top: 20px;
}

.btn-print {
  background: var(--primary);
  color: #fff;
  padding: 12px 30px;
  border-radius: 8px;
  font-weight: 600;
  cursor: pointer;
  transition: var(--transition);
  text-decoration: none;
  display: inline-block;
  font-size: 1rem;
  box-shadow: 0 4px 10px rgba(78, 115, 223, 0.3);
}

.btn-print:hover {
  background: var(--primary-dark);
  transform: translateY(-3px);
  box-shadow: 0 6px 14px rgba(78, 115, 223, 0.4);
  color: #fff;
  text-decoration: none;
}
</style>
                        
                        <!-- Patient Order Details -->
                <div class="row">
  <div class="col-12">
    <div class="card">
      <div class="card-body">
        <h4 class="header-title">Patient Order Details</h4>

        <!-- Responsive Wrapper -->
        <div class="table-responsive">
          <table class="table table-striped table-bordered medicines-table">
            <thead class="thead-dark">
              <tr>
                <th>#</th>
                <th>Department</th>
                <th>Patient Number</th>
                <th>Name</th>
                <th>Description</th>
                <th>Qty</th>
                <th>Price</th>
                <th>Total Price</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody id="medicine-orders">
              <?php if(count($medicine_orders) > 0): ?>
                <?php foreach($medicine_orders as $index => $order): ?>
                  <tr>
                    <td><?= $index + 1; ?></td>
                    <td><?= htmlspecialchars($order['department']); ?></td>
                    <td><?= htmlspecialchars($order['patient_number']); ?></td>
                    <td><?= htmlspecialchars($order['name']); ?></td>
                    <td><?= htmlspecialchars($order['description']); ?></td>
                    <td><?= htmlspecialchars($order['qty']); ?></td>
                    <td><?= number_format($order['price'], 2); ?></td>
                    <td><?= number_format($order['total_price'], 2); ?></td>
                    <td>
                      <button class="btn btn-danger btn-sm" onclick="removeOrder(<?= $order['id']; ?>)">Remove</button>
                    </td>
                  </tr>
                <?php endforeach; ?>
              <?php else: ?>
                <tr>
                  <td colspan="9" class="text-center">No medicine orders found for this patient.</td>
                </tr>
              <?php endif; ?>
            </tbody>
            <tfoot>
              <tr class="table-secondary">
                <td colspan="5">Total</td>
                <td><?= $total_qty; ?></td>
                <td></td>
                <td><?= number_format($total_price, 2); ?></td>
                <td></td>
              </tr>
            </tfoot>
          </table>
        </div>
        <!-- End Responsive Wrapper -->

      </div>
    </div>
  </div>
</div>

                        
                        <!-- Add Medicine Order Form -->
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="header-title">Add New Medicine Orders</h4>
                                        
                                        <form method="post" class="order-form" id="medicine-order-form">
                                            <input type="hidden" name="pat_id" value="<?php echo $patient_id; ?>">
                                            
                                            <div class="form-row">
                                                <div class="form-group">
                                                    <label for="department">Department</label>
                                                    <input type="text" class="form-control" id="department" name="department" value="Medicine" required>
                                                </div>
                                                <div class="form-group">
                                                    <label for="patient_number">Patient Number</label>
                                                    <input type="text" class="form-control" id="patient_number" name="patient_number" value="<?php echo htmlspecialchars($patient['pat_number']); ?>" required>
                                                </div>
                                            </div>
                                            
                                            <h5>Medicines</h5>
                                            <div id="medicine-rows">
                                                <!-- Medicine rows will be added here dynamically -->
                                                <div class="medicine-row">
                                                    <div class="medicine-field">
                                                        <label>Medicine Name</label>
                                                        <input type="text" name="medicine_name[]" required>
                                                    </div>
                                                    <div class="medicine-field">
                                                        <label>Description</label>
                                                        <input type="text" name="medicine_description[]" required>
                                                    </div>
                                                    <div class="medicine-field">
                                                        <label>Quantity</label>
                                                        <input type="number" name="medicine_qty[]" min="1" required>
                                                    </div>
                                                    <div class="medicine-field">
                                                        <label>Price</label>
                                                        <input type="number" name="medicine_price[]" step="0.01" min="0" required>
                                                    </div>
                                                    <button type="button" class="remove-row" onclick="removeMedicineRow(this)">Remove</button>
                                                </div>
                                            </div>
                                            
                                            <button type="button" class="btn-add-row" onclick="addMedicineRow()">+ Add Another Medicine</button>
                                            
                                            <div style="margin-top: 20px;">
                                                <button type="submit" name="add_medicine_order" class="btn-submit">Save All Medicine Orders</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <?php else: ?>
                        <div class="row">
                            <div class="col-12">
                                <div class="alert alert-warning">
                                    Patient not found. Please select a valid patient.
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>

                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- App js-->
        <script src="assets/js/app.min.js"></script>

        <!-- jQuery -->
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

        <script>
        function removeOrder(orderId) {
            if(confirm('Are you sure you want to remove this medicine order?')) {
                // AJAX request to remove the order
                $.ajax({
                    url: 'remove_medicine_order.php',
                    type: 'POST',
                    data: { order_id: orderId },
                    success: function(response) {
                        if(response.success) {
                            location.reload();
                        } else {
                            //alert('Error removing order: ' + response.message);
                             location.reload();
                        }
                    },
                    error: function() {
                       // alert('Error removing order. Please try again.');
                         location.reload();
                    }
                });
            }
        }
        
        // Add new medicine row
        function addMedicineRow() {
            const newRow = document.createElement('div');
            newRow.className = 'medicine-row';
            newRow.innerHTML = `
                <div class="medicine-field">
                    <label>Medicine Name</label>
                    <input type="text" name="medicine_name[]" required>
                </div>
                <div class="medicine-field">
                    <label>Description</label>
                    <input type="text" name="medicine_description[]" required>
                </div>
                <div class="medicine-field">
                    <label>Quantity</label>
                    <input type="number" name="medicine_qty[]" min="1" required>
                </div>
                <div class="medicine-field">
                    <label>Price</label>
                    <input type="number" name="medicine_price[]" step="0.01" min="0" required>
                </div>
                <button type="button" class="remove-row" onclick="removeMedicineRow(this)">Remove</button>
            `;
            document.getElementById('medicine-rows').appendChild(newRow);
        }
        
        // Remove medicine row
        function removeMedicineRow(button) {
            const rows = document.querySelectorAll('.medicine-row');
            if (rows.length > 1) {
                button.closest('.medicine-row').remove();
            } else {
                alert('You need at least one medicine row.');
            }
        }
        
        // Calculate total price when qty or price changes
        $(document).on('input', 'input[name="medicine_qty[]"], input[name="medicine_price[]"]', function() {
            const row = $(this).closest('.medicine-row');
            const qty = parseFloat(row.find('input[name="medicine_qty[]"]').val()) || 0;
            const price = parseFloat(row.find('input[name="medicine_price[]"]').val()) || 0;
            const total = qty * price;
            
            // If you want to show the total in a field, you can add a total field to each row
            // row.find('.total-price').text(total.toFixed(2));
        });
        </script>

    </body>
</html>