<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid=$_SESSION['ad_id'];
?>

<!DOCTYPE html>
<html lang="en">
    
<?php include('assets/inc/head.php');?>

    <body>

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
                <?php include('assets/inc/nav.php');?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
                <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box bg-gradient-primary">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Surgery | Theatre</a></li>
                                            <li class="breadcrumb-item active text-white">Surgery Records</li>
                                        </ol>
                                    </div>
                                    <h4 class="page-title text-white">Surgery Patient Records</h4>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 

                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header bg-primary text-white">
                                        <h4 class="header-title">Surgical Procedures</h4>
                                        <div class="btn-group float-right">
                                            <button class="btn btn-success dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                <i class="fas fa-download mr-1"></i> Export
                                            </button>
                                            <div class="dropdown-menu">
                                                <a class="dropdown-item" href="#" onclick="exportToExcel()">Excel</a>
                                                <a class="dropdown-item" href="#" onclick="exportToCSV()">CSV</a>
                                                <a class="dropdown-item" href="#" onclick="exportToPDF()">PDF</a>
                                                <a class="dropdown-item" href="#" onclick="printTable()">Print</a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="mb-3">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <input id="demo-foo-search" type="text" placeholder="Search records..." class="form-control" autocomplete="on">
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <select id="surgeon-filter" class="custom-select">
                                                            <option value="">All Surgeons</option>
                                                            <?php
                                                            $surgeons = $mysqli->query("SELECT DISTINCT s_doc FROM his_surgery");
                                                            while($surgeon = $surgeons->fetch_object()):
                                                            ?>
                                                            <option value="<?php echo $surgeon->s_doc; ?>"><?php echo $surgeon->s_doc; ?></option>
                                                            <?php endwhile; ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-2">
                                                    <button class="btn btn-primary btn-block" onclick="resetFilters()">Reset</button>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="table-responsive">
                                            <table id="demo-foo-filtering" class="table table-hover table-bordered toggle-circle mb-0" data-page-size="10">
                                                <thead class="thead-light">
                                                <tr>
                                                    <th>#</th>
                                                    <th data-toggle="true">Patient Name</th>
                                                    <th data-hide="phone">Patient Number</th>
                                                    <th data-hide="phone">Patient Ailment</th>
                                                    <th data-hide="phone">Surgeon</th>
                                                    <th data-hide="phone">Surgery Date</th>
                                                    <th>Action</th>
                                                </tr>
                                                </thead>
                                                <?php
                                                $ret="SELECT * FROM his_surgery ORDER BY s_pat_date DESC"; 
                                                $stmt= $mysqli->prepare($ret);
                                                $stmt->execute();
                                                $res=$stmt->get_result();
                                                $cnt=1;
                                                while($row=$res->fetch_object()):
                                                    $mysqlDateTime = $row->s_pat_date;
                                                ?>
                                                <tbody>
                                                <tr>
                                                    <td><?php echo $cnt;?></td>
                                                    <td><?php echo $row->s_pat_name;?></td>
                                                    <td><?php echo $row->s_pat_number;?></td>
                                                    <td><?php echo $row->s_pat_ailment;?></td>
                                                    <td><span class="badge badge-info"><?php echo $row->s_doc;?></span></td>
                                                    <td><?php echo date("d/m/Y", strtotime($mysqlDateTime));?></td>
                                                    <td>
                                                        <div class="btn-group">
                                                            <a href="view_single_patient_surgery.php?s_number=<?php echo $row->s_number;?>" class="btn btn-sm btn-info"><i class="mdi mdi-eye mr-1"></i> View</a>
                                                            <a href="#" class="btn btn-sm btn-secondary"><i class="mdi mdi-printer mr-1"></i> Print</a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                </tbody>
                                                <?php $cnt++; endwhile; ?>
                                                <tfoot>
                                                <tr class="active">
                                                    <td colspan="7">
                                                        <div class="text-right">
                                                            <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                        </div>
                                                    </td>
                                                </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                 <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- Footable js -->
        <script src="assets/libs/footable/footable.all.min.js"></script>

        <!-- Init js -->
        <script src="assets/js/pages/foo-tables.init.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
        <!-- Export functionality -->
        <script src="https://cdn.jsdelivr.net/npm/xlsx@0.17.0/dist/xlsx.full.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/file-saver@2.0.5/dist/FileSaver.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.25/jspdf.plugin.autotable.min.js"></script>
        
        <style>
            .bg-gradient-primary {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
                border-radius: 0.25rem;
                box-shadow: 0 4px 20px 0 rgba(0,0,0,.14), 0 7px 10px -5px rgba(102, 126, 234, .4);
            }
            
            .card {
                border: none;
                box-shadow: 0 1px 15px rgba(0,0,0,0.1);
            }
            
            .table-hover tbody tr:hover {
                background-color: rgba(0, 123, 255, 0.05);
            }
            
            .btn-group .btn {
                margin-right: 5px;
                border-radius: 4px;
            }
            
            .btn-group .btn:last-child {
                margin-right: 0;
            }
            
            @media print {
                body * {
                    visibility: hidden;
                }
                .card, .card * {
                    visibility: visible;
                }
                .card {
                    position: absolute;
                    left: 0;
                    top: 0;
                    width: 100%;
                    border: none;
                    box-shadow: none;
                }
                .no-print, .dropdown-menu, .btn-group {
                    display: none !important;
                }
                .badge {
                    color: black !important;
                    border: 1px solid #ddd;
                    background-color: transparent !important;
                }
            }
        </style>
        
        <script>
            // Export to Excel function
            function exportToExcel() {
                const table = document.getElementById("demo-foo-filtering");
                const wb = XLSX.utils.table_to_book(table, {sheet:"Surgery Records"});
                XLSX.writeFile(wb, "Surgery_Records.xlsx");
            }
            
            // Export to CSV function
            function exportToCSV() {
                const table = document.getElementById("demo-foo-filtering");
                const ws = XLSX.utils.table_to_sheet(table);
                const csv = XLSX.utils.sheet_to_csv(ws);
                const blob = new Blob([csv], {type: "text/csv;charset=utf-8;"});
                saveAs(blob, "Surgery_Records.csv");
            }
            
            // Export to PDF function
            function exportToPDF() {
                const { jsPDF } = window.jspdf;
                const doc = new jsPDF();
                
                doc.autoTable({
                    html: '#demo-foo-filtering',
                    theme: 'grid',
                    headStyles: {
                        fillColor: [102, 126, 234],
                        textColor: 255
                    },
                    styles: {
                        cellPadding: 3,
                        fontSize: 10,
                        valign: 'middle'
                    },
                    margin: { top: 20 },
                    didDrawPage: function (data) {
                        doc.text('Surgery Patient Records', data.settings.margin.left, 10);
                    }
                });
                
                doc.save('Surgery_Records.pdf');
            }
            
            // Print function
            function printTable() {
                window.print();
            }
            
            // Enhanced filtering
            $(document).ready(function() {
                $('#surgeon-filter').change(function() {
                    const filter = $(this).val().toLowerCase();
                    $('table tbody tr').each(function() {
                        const surgeon = $(this).find('td:eq(4)').text().toLowerCase();
                        if (filter === '' || surgeon.includes(filter)) {
                            $(this).show();
                        } else {
                            $(this).hide();
                        }
                    });
                });
            });
            
            // Reset filters
            function resetFilters() {
                $('#demo-foo-search').val('');
                $('#surgeon-filter').val('');
                $('table tbody tr').show();
            }
        </script>
    </body>
</html>