<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();

if(isset($_POST['update_department'])) {
    $department_id = $_POST['department_id'];
    $department_name = $_POST['department_name'];
    $department_type = $_POST['department_type'];
    $opd_fee = $_POST['opd_fee'];
    $ipd_fee = $_POST['ipd_fee'];
    $ailment_name = $_POST['ailment_name'];
    $department_description = $_POST['department_description'];
    
    // Update query
    $query = "UPDATE his_departments SET 
        department_name=?, 
        department_type=?, 
        opd_fee=?, 
        ipd_fee=?, 
        ailment_name=?, 
        department_description=? 
        WHERE department_id=?";
    
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('ssddssi', 
        $department_name, 
        $department_type, 
        $opd_fee, 
        $ipd_fee, 
        $ailment_name, 
        $department_description,
        $department_id
    );
    $stmt->execute();
    
    if($stmt) {
        $success = "Department Updated";
    } else {
        $err = "Please Try Again Or Try Later";
    }
}

header("location:settings.php");
exit;
?>