<?php
session_start();
include('assets/inc/config.php');

// Check if request is POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    die(json_encode(['success' => false, 'message' => 'Invalid request method']));
}

// Get and sanitize input data
$department_id = intval($_POST['department_id']);
$department_type = trim($_POST['department_type']);
$department_name = trim($_POST['department_name']);
$ailment_name = trim($_POST['ailment_name']);
$department_description = trim($_POST['department_description']);

// Get fees based on department type
$opd_fee = ($department_type == 'OutPatient') ? floatval($_POST['opd_fee']) : 0;
$ipd_fee = ($department_type == 'InPatient') ? floatval($_POST['ipd_fee']) : 0;

// Validate inputs
if (empty($department_name) {
    die(json_encode(['success' => false, 'message' => 'Department name is required']));
}
if (empty($ailment_name)) {
    die(json_encode(['success' => false, 'message' => 'Ailment name is required']));
}
if ($department_type == 'OutPatient' && $opd_fee <= 0) {
    die(json_encode(['success' => false, 'message' => 'Valid OPD fee is required']));
}
if ($department_type == 'InPatient' && $ipd_fee <= 0) {
    die(json_encode(['success' => false, 'message' => 'Valid IPD fee is required']));
}

// Update department
$query = "UPDATE his_departments SET 
          department_type = ?, 
          department_name = ?, 
          opd_fee = ?, 
          ipd_fee = ?,
          department_description = ?, 
          ailment_name = ?
          WHERE department_id = ?";
$stmt = $mysqli->prepare($query);
$stmt->bind_param('ssddssi', $department_type, $department_name, $opd_fee, $ipd_fee, $department_description, $ailment_name, $department_id);

if ($stmt->execute()) {
    echo json_encode(['success' => true, 'message' => 'Department updated successfully']);
} else {
    echo json_encode(['success' => false, 'message' => 'Error updating department: ' . $stmt->error]);
}
?>