<?php
session_start();
include('assets/inc/config.php');

// Fetch insurance companies for dropdown
$insurance_query = "SELECT * FROM his_insurance ORDER BY insurance_name ASC";
$insurance_stmt = $mysqli->prepare($insurance_query);
$insurance_stmt->execute();
$insurance_result = $insurance_stmt->get_result();

if(isset($_POST['update_patient'])) {
    $pat_id = $_GET['pat_id'];
    $pat_fname = $_POST['pat_fname'];
    $pat_lname = $_POST['pat_lname'];
    $pat_number = $_POST['pat_number'];
    $pat_phone = $_POST['pat_phone'];
    $pat_type = $_POST['pat_type'];
    $pat_addr = $_POST['pat_addr'];
    $pat_age = $_POST['pat_age'];
    $pat_dob = $_POST['pat_dob'];
    $pat_ailment = $_POST['pat_ailment'];
    $doc_dept = $_POST['doc_dept'];
    $doc_id = $_POST['doc_id'];
    $f = $_POST['fee'];
    $insurance = $_POST['insurance'];
    $status = $_POST['status'];
    $gender = $_POST['gender'];
    $card_no = $_POST['card_no'];
    $title = $_POST['title'];
    
    // Handle OPD-specific fields
    $payment_mode = isset($_POST['payment_mode']) ? $_POST['payment_mode'] : '';
    $remarks = isset($_POST['remarks']) ? $_POST['remarks'] : '';
    
    // For IPD patients, set fee to 0
    if($pat_type == 'InPatient') {
        $f = 0;
        if(empty($pat_ailment)) {
            $pat_ailment = "Admission - To be diagnosed";
        }
    }

    // FIXED: Updated the query and bind_param to match the number of parameters
  $query = "UPDATE his_patients SET 
    pat_fname=?, pat_lname=?, pat_age=?, pat_dob=?, pat_phone=?, 
    pat_type=?, pat_addr=?, pat_ailment=?, dept=?, doc_id=?, 
    insurance=?, status=?, gender=?, card_no=?, title=?, 
    fee=?, payment_mode=?, remarks=? 
    WHERE pat_id = ?";

$stmt = $mysqli->prepare($query);

$rc = $stmt->bind_param(
    'sssssssssssssssissi', 
    $pat_fname,   // s
    $pat_lname,   // s
    $pat_age,     // i
    $pat_dob,     // s
    $pat_phone,   // s
    $pat_type,    // s
    $pat_addr,    // s
    $pat_ailment, // s
    $doc_dept,    // s
    $doc_id,      // s
    $insurance,   // s
    $status,      // s
    $gender,      // s
    $card_no,     // s
    $title,       // s
    $f,           // i
    $payment_mode,// s
    $remarks,     // s
    $pat_id       // i
);

    
    $stmt->execute();
    
    if($stmt) {
        $success = "Patient Details Updated Successfully";
    } else {
        $err = "Please Try Again Or Try Later: " . $mysqli->error;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        /* Add the same styles as the first form */
        :root {
            --primary: #2c6aa0;
            --primary-light: #e8f2fa;
            --primary-dark: #1a4d75;
            --secondary: #4cb5ab;
            --accent: #d83444;
            --neutral-light: #f8f9fc;
            --neutral-dark: #5a5c69;
            --success: #38b673;
            --warning: #f3b13e;
            --border: #d1e2ed;
            --shadow: 0 4px 12px rgba(44, 106, 160, 0.15);
            --transition: all 0.3s ease;
        }
        
        body {
            background: linear-gradient(135deg, var(--primary-light) 0%, #f0f7ff 100%);
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            min-height: 100vh;
            color: #3a3a3a;
        }
        
        .card {
            border: none;
            border-radius: 12px;
            box-shadow: var(--shadow);
            transition: var(--transition);
            overflow: hidden;
            background: white;
            border-top: 4px solid var(--primary);
        }
        
        .page-title-box {
            background: linear-gradient(to right, var(--primary), var(--primary-dark));
            color: white;
            padding: 25px;
            border-radius: 12px;
            box-shadow: var(--shadow);
            margin-bottom: 25px;
            transition: var(--transition);
        }
        
        .form-control {
            border-radius: 8px;
            border: 1px solid var(--border);
            padding: 12px 15px;
            transition: var(--transition);
            background-color: white;
            height: auto;
            color: var(--neutral-dark);
        }
        
        .form-control:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 0.2rem rgba(44, 106, 160, 0.2);
        }
        
        .btn-primary {
            background: linear-gradient(to right, var(--primary), var(--primary-dark));
            border: none;
            padding: 12px 30px;
            font-weight: 600;
            border-radius: 8px;
            box-shadow: 0 4px 15px rgba(44, 106, 160, 0.3);
            transition: var(--transition);
        }
        
        .opd-only, .ipd-only {
            display: none;
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        
        .opd-only.show, .ipd-only.show {
            display: block;
            opacity: 1;
        }
        
        .fee-field {
            position: relative;
            background-color: #f0f7ff;
            padding: 15px;
            border-radius: 8px;
            border-left: 4px solid var(--secondary);
        }
        
        /* Loading animation for AJAX requests */
        .loading {
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 3px solid rgba(255,255,255,.3);
            border-radius: 50%;
            border-top-color: #fff;
            animation: spin 1s ease-in-out infinite;
            margin-right: 10px;
        }
        
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <div id="wrapper">
        <?php include("assets/inc/nav.php");?>
        <?php include("assets/inc/sidebar.php");?>

        <div class="content-page">
            <div class="content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript:void(0);">Patients</a></li>
                                        <li class="breadcrumb-item active">Update Patient</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">
                                    <i class="fas fa-user-edit mr-2"></i>Update Patient Details
                                </h4>
                            </div>
                        </div>
                    </div>
                    
                    <?php
                        $pat_id = $_GET['pat_id'];
                        $ret = "SELECT * FROM his_patients WHERE pat_id=?";
                        $stmt = $mysqli->prepare($ret);
                        $stmt->bind_param('i', $pat_id);
                        $stmt->execute();
                        $res = $stmt->get_result();
                        while($row = $res->fetch_object()) {
                    ?>
                    
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">
                                        <i class="fas fa-user-injured mr-2"></i>Patient Information
                                    </h4>
                                    
                                    <?php if(isset($success)) { ?>
                                        <div class="alert alert-success"><?php echo $success; ?></div>
                                    <?php } ?>
                                    <?php if(isset($err)) { ?>
                                        <div class="alert alert-danger"><?php echo $err; ?></div>
                                    <?php } ?>
                                    
                                    <form method="post" id="patientForm">
                                        <div class="form-section">
                                            <h5 class="form-section-title">Patient Type & Department</h5>
                                            <div class="form-row">
                                                <div class="form-group col-md-4">
                                                    <label for="pat_type" required>Patient Type</label>
                                                    <select id="pat_type" name="pat_type" class="form-control" required onchange="togglePatientTypeFields()">
                                                        <option value="OutPatient" <?php echo ($row->pat_type == 'OutPatient') ? 'selected' : ''; ?>>OPD (Outpatient)</option>
                                                        <option value="InPatient" <?php echo ($row->pat_type == 'InPatient') ? 'selected' : ''; ?>>IPD (Inpatient)</option>
                                                    </select>
                                                </div>

                                                <div class="form-group col-md-4">
                                                    <label for="department" required>Department</label>
                                                    <select id="department" name="doc_dept" class="form-control" required>
                                                        <option value="<?php echo $row->dept; ?>" selected><?php echo $row->dept; ?></option>
                                                        <!-- Departments will be loaded via AJAX -->
                                                    </select>
                                                    <div id="deptLoading" style="display:none;">
                                                        <span class="loading"></span> Loading departments...
                                                    </div>
                                                </div>

                                                <div class="form-group col-md-4">
                                                    <label for="ailment" required>Ailment</label>
                                                    <select id="ailment" name="pat_ailment" class="form-control" required>
                                                        <option value="<?php echo $row->pat_ailment; ?>" selected><?php echo $row->pat_ailment; ?></option>
                                                        <!-- Ailments will be loaded via AJAX -->
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-4">
    <label for="doctor" required>Doctor</label>
    <select name="doc_id" class="form-control" id="doctor" required>
        <option value="" disabled selected>Select Doctor</option>
        <!-- Doctors will be loaded via AJAX based on department -->
    </select>
    <small class="form-text text-muted">Select attending doctor</small>
</div>
                                            </div>
                                        </div>
                                        
                                        <div class="form-section">
                                            <h5 class="form-section-title">Billing Information</h5>
                                            <div class="form-row">
                                                <div class="form-group col-md-4 fee-field">
                                                    <label for="fee">Fee</label>
                                                    <input type="text" class="form-control" id="fee" name="fee" value="<?php echo $row->fee; ?>" readonly required>
                                                    <div id="feeNote" class="fee-note"></div>
                                                </div>

                                                <div class="opd-only form-group col-md-4">
                                                    <label for="payment_mode">Payment Mode</label>
                                                    <select id="payment_mode" name="payment_mode" class="form-control">
                                                        <option value="" <?php echo empty($row->payment_mode) ? 'selected disabled' : ''; ?>>Select Payment Mode</option>
                                                        <option value="Cash" <?php echo ($row->payment_mode == 'Cash') ? 'selected' : ''; ?>>Cash</option>
                                                        <option value="Card" <?php echo ($row->payment_mode == 'Card') ? 'selected' : ''; ?>>Card</option>
                                                        <option value="Mobile Money" <?php echo ($row->payment_mode == 'Mobile Money') ? 'selected' : ''; ?>>UPIy</option>
                                                        <option value="Insurance" <?php echo ($row->payment_mode == 'Insurance') ? 'selected' : ''; ?>>Insurance</option>
                                                    </select>
                                                </div>

                                                <div class="opd-only form-group col-md-4">
                                                    <label for="remarks">Remarks</label>
                                                    <textarea id="remarks" name="remarks" class="form-control" rows="1"><?php echo $row->remarks; ?></textarea>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="form-section">
                                            <h5 class="form-section-title">Personal Information</h5>
                                            <div class="form-row">
                                                <div class="form-group col-md-4">
                                                    <label for="patientTitle" required>Patient Title</label>
                                                    <select required name="title" class="form-control" id="patientTitle">
                                                        <option value="Mr" <?php echo ($row->title == 'Mr') ? 'selected' : ''; ?>>Mr</option>
                                                        <option value="Miss" <?php echo ($row->title == 'Miss') ? 'selected' : ''; ?>>Miss</option>
                                                        <option value="Mrs" <?php echo ($row->title == 'Mrs') ? 'selected' : ''; ?>>Mrs</option>
                                                        <option value="Master" <?php echo ($row->title == 'Master') ? 'selected' : ''; ?>>Master</option>
                                                        <option value="Baby" <?php echo ($row->title == 'Baby') ? 'selected' : ''; ?>>Baby</option>
                                                        <option value="Prof" <?php echo ($row->title == 'Prof') ? 'selected' : ''; ?>>Prof</option>
                                                        <option value="Dr" <?php echo ($row->title == 'Dr') ? 'selected' : ''; ?>>Dr</option>
                                                    </select>
                                                </div>
                                                
                                                <div class="form-group col-md-4">
                                                    <label for="pat_fname" required>First Name</label>
                                                    <input type="text" required name="pat_fname" class="form-control" value="<?php echo $row->pat_fname; ?>">
                                                </div>
                                                
                                                <div class="form-group col-md-4">
                                                    <label for="pat_lname" required>Last Name</label>
                                                    <input type="text" required name="pat_lname" class="form-control" value="<?php echo $row->pat_lname; ?>">
                                                </div>
                                                
                                                <div class="form-group col-md-4">
                                                    <label for="card_no" required>Aadhar Card No</label>
                                                    <input type="text" required name="card_no" class="form-control" value="<?php echo $row->card_no; ?>">
                                                </div>
                                                
                                                <div class="form-group col-md-4">
                                                    <label for="gender" required>Gender</label>
                                                    <select required name="gender" class="form-control">
                                                        <option value="Male" <?php echo ($row->gender == 'Male') ? 'selected' : ''; ?>>Male</option>
                                                        <option value="Female" <?php echo ($row->gender == 'Female') ? 'selected' : ''; ?>>Female</option>
                                                        <option value="Other" <?php echo ($row->gender == 'Other') ? 'selected' : ''; ?>>Other</option>
                                                    </select>
                                                </div>
                                                
                                                <div class="form-group col-md-4">
                                                    <label for="status" required>Marital Status</label>
                                                    <select required name="status" class="form-control">
                                                        <option value="Single" <?php echo ($row->status == 'Single') ? 'selected' : ''; ?>>Single</option>
                                                        <option value="Married" <?php echo ($row->status == 'Married') ? 'selected' : ''; ?>>Married</option>
                                                        <option value="Divorced" <?php echo ($row->status == 'Divorced') ? 'selected' : ''; ?>>Divorced</option>
                                                        <option value="Other" <?php echo ($row->status == 'Other') ? 'selected' : ''; ?>>Other</option>
                                                    </select>
                                                </div>
                                                
                                                <div class="form-group col-md-4">
                                                    <label for="insurance">Insurance Company</label>
                                                    <select name="insurance" class="form-control">
                                                        <option value="" disabled>Select Insurance</option>
                                                        <?php 
                                                        $insurance_result->data_seek(0); // Reset pointer
                                                        while($insurance = $insurance_result->fetch_assoc()) { ?>
                                                            <option value="<?php echo $insurance['insurance_name']; ?>" <?php echo ($row->insurance == $insurance['insurance_name']) ? 'selected' : ''; ?>>
                                                                <?php echo $insurance['insurance_name']; ?>
                                                            </option>
                                                        <?php } ?>
                                                    </select>
                                                </div>

                                              <?php
// Split existing date into year, month, day if available
$dobYear = $dobMonth = $dobDay = '';
if(!empty($row->pat_dob) && $row->pat_dob != '0000-00-00'){
    list($dobYear, $dobMonth, $dobDay) = explode('-', $row->pat_dob);
}
?>

<div class="form-group col-md-4">
    <label for="dob_year">Date Of Birth</label>
    <div class="d-flex" style="gap: 5px;">
        <!-- Year -->
        <select name="dob_year" id="dob_year" class="form-control" required>
            <option value="">Year</option>
        </select>

        <!-- Month -->
        <select name="dob_month" id="dob_month" class="form-control" required>
            <option value="">Month</option>
        </select>

        <!-- Day -->
        <select name="dob_day" id="dob_day" class="form-control" required>
            <option value="">Day</option>
        </select>
    </div>
</div>

<script>
const yearSelect = document.getElementById('dob_year');
const monthSelect = document.getElementById('dob_month');
const daySelect = document.getElementById('dob_day');

const currentYear = new Date().getFullYear();
const dobYear = "<?php echo $dobYear; ?>";
const dobMonth = "<?php echo $dobMonth; ?>";
const dobDay = "<?php echo $dobDay; ?>";

// Populate Years
for(let y = currentYear; y >= currentYear - 100; y--){
    const option = document.createElement('option');
    option.value = y;
    option.text = y;
    if(y == dobYear) option.selected = true;
    yearSelect.add(option);
}

// Populate Months
const months = [
    "January","February","March","April","May","June",
    "July","August","September","October","November","December"
];
months.forEach((month, index) => {
    const option = document.createElement('option');
    option.value = index + 1;
    option.text = month;
    if((index+1) == dobMonth) option.selected = true;
    monthSelect.add(option);
});

// Populate Days based on year and month
function populateDays(){
    const year = parseInt(yearSelect.value);
    const month = parseInt(monthSelect.value);
    daySelect.innerHTML = '<option value="">Day</option>';

    if(!year || !month) return;

    const daysInMonth = new Date(year, month, 0).getDate();
    for(let d=1; d<=daysInMonth; d++){
        const option = document.createElement('option');
        option.value = d;
        option.text = d;
        if(d == dobDay) option.selected = true;
        daySelect.add(option);
    }
}

// Initial population
populateDays();

yearSelect.addEventListener('change', populateDays);
monthSelect.addEventListener('change', populateDays);
</script>

                                                
                                                <div class="form-group col-md-4">
                                                    <label for="pat_age" required>Age</label>
                                                    <input type="number" required name="pat_age" class="form-control" value="<?php echo $row->pat_age; ?>">
                                                </div>
                                                
                                                <div class="form-group col-md-4">
                                                    <label for="pat_addr" required>Address</label>
                                                    <input type="text" required name="pat_addr" class="form-control" value="<?php echo $row->pat_addr; ?>">
                                                </div>

                                                <div class="form-group col-md-4">
                                                    <label for="pat_phone" required>Mobile Number</label>
                                                    <input type="tel" required name="pat_phone" class="form-control" value="<?php echo $row->pat_phone; ?>">
                                                </div>

                                            </div>
                                        </div>

                                        <input type="hidden" name="pat_number" value="<?php echo $row->pat_number; ?>">
                                        
                                        <div class="text-right mt-4">
                                            <button type="submit" name="update_patient" class="btn btn-primary">
                                                <i class="fas fa-save mr-2"></i>Update Patient
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
                </div>
            </div>

            <?php include('assets/inc/footer.php');?>
        </div>
 
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script>
        $(document).ready(function () {
            // Initialize by setting up the form based on current patient type
            togglePatientTypeFields();
            
            // Load departments based on current patient type
            loadDepartments($('#pat_type').val());
            
            // Patient type change handler
            $('#pat_type').on('change', function () {
                togglePatientTypeFields();
                let patType = $(this).val();
                
                // Load departments based on patient type
                loadDepartments(patType); 
                
                // Set fee based on patient type
                if (patType === 'InPatient') {
                    $('#fee').val('0');
                    $('#fee').prop('readonly', true);
                    $('#feeNote').text('IPD patients will be billed separately for admission and treatment');
                    $('.fee-field').hide();
                    $('#ailment').removeAttr('required');
                } else {
                    $('#fee').prop('readonly', false);
                    $('#feeNote').text('');
                    $('.fee-field').show();
                    $('#ailment').attr('required', 'required');
                }
            });
            
            // Department change handler
            $('#department').on('change', function () {
                let deptName = $(this).val();
                let patType = $('#pat_type').val();
                

                    if (deptName) {
                $('#doctor').html('<option value="" disabled selected>Loading doctors...</option>');
                $.ajax({
                    url: 'get_doctors.php',
                    type: 'POST',
                    data: { department_name: deptName },
                    success: function (response) {
                        let doctors = JSON.parse(response);
                        $('#doctor').html('<option value="" disabled selected>Select Doctor</option>');
                        doctors.forEach(function (doc) {
                            $('#doctor').append('<option value="' + doc.doc_id + '">' + doc.doc_fname + ' ' + doc.doc_lname + '</option>');
                        });
                    },
                    error: function() {
                        $('#doctor').html('<option value="" disabled selected>Error loading doctors</option>');
                    }
                });
            } else {
                $('#doctor').html('<option value="" disabled selected>Select Doctor</option>');
            }
                // For IPD patients, don't load ailments
                if (patType === 'InPatient') {
                    $('#ailment').val('Admission - To be diagnosed');
                    return;
                }
                
                if (deptName && patType === 'OutPatient') {
                    
               $.ajax({
    url: 'get_ailments_and_fee.php',
    type: 'POST',
    dataType: 'json',
    data: { department_name: deptName },
    success: function (data) {
        $('#ailment').html('<option value="" disabled selected>Select Ailment</option>');
        if (data.ailments && data.ailments.length > 0) {
            data.ailments.forEach(function (item) {
                // Show department + ailment in text
                let text = item.ailment + ' - ' + item.fee;
                // store opd_fee in data-fee
                $('#ailment').append('<option value="' + item.ailment + '" data-fee="' + item.fee + '">' + text + '</option>');
            });
        }
        // clear fee initially unmobilemobiletil ailment selected
        $('#fee').val('');
    },
    error: function() {
        $('#ailment').html('<option value="" disabled selected>Error loading ailments</option>');
        $('#fee').val('');
    }
});
                }
            });
            
            function loadDepartments(patType) {
                if (patType) {
                    $('#deptLoading').show();
                    $.ajax({
                        url: 'get_departments.php',
                        type: 'POST',
                        data: { pat_type: patType },
                        success: function (response) {
                            $('#department').html(response);
                            $('#deptLoading').hide();
                        },
                        error: function() {
                            $('#department').html('<option value="" disabled selected>Error loading departments</option>');
                            $('#deptLoading').hide();
                        }
                    });
                }
            }
        });

        // Function to toggle OPD/IPD specific fields
        function togglePatientTypeFields() {
            const patientType = $('#pat_type').val();
            
            // Hide all type-specific fields first
            $('.opd-only, .ipd-only').removeClass('show');
            
            // Show/hide fields based on patient type
            if (patientType === 'OutPatient') {
                $('.opd-only').addClass('show');
                $('#feeNote').text('');
                $('.fee-field').show();
            } else if (patientType === 'InPatient') {
                $('.ipd-only').addClass('show');
                $('#fee').val('0');
                $('#feeNote').text('IPD patients will be billed separately for admission and treatment');
                $('.fee-field').hide();
            }
        }

        // Form validation
        $('#patientForm').on('submit', function(e) {
            const patientType = $('#pat_type').val();
            
            // For IPD patients, ensure fee is 0
            if (patientType === 'InPatient') {
                $('#fee').val('0');
            }
            
            return true;
        });
        </script>
    </body>
</html>