<?php
    session_start();
    include('assets/inc/config.php');
    if(isset($_POST['update_vendor']))
    {
        $v_name=$_POST['v_name'];
        $v_adr=$_POST['v_adr'];
        $v_number=$_GET['v_number'];
        $v_email=$_POST['v_email'];
        $v_phone = $_POST['v_phone'];
        $v_desc = $_POST['v_desc'];
        
        //sql to insert captured values
        $query="UPDATE his_vendor SET v_name=?, v_adr=?, v_email=?, v_phone=?, v_desc=? WHERE v_number=?";
        $stmt = $mysqli->prepare($query);
        $rc=$stmt->bind_param('ssssss', $v_name, $v_adr, $v_email, $v_phone, $v_desc, $v_number);
        $stmt->execute();
        
        if($stmt)
        {
            $success = "Vendor Details Updated";
        }
        else {
            $err = "Please Try Again Or Try Later";
        }
    }
?>
<!DOCTYPE html>
<html lang="en">
    
    <!--Head-->
    <?php include('assets/inc/head.php');?>
    <style>
        :root {
            --primary-color: #4e73df;
            --secondary-color: #1cc88a;
            --accent-color: #f6c23e;
            --dark-color: #5a5c69;
            --light-color: #f8f9fc;
        }
        
        body {
            background-color: #f5f7fb;
            font-family: 'Nunito', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
        }
        
        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            transition: all 0.3s ease;
            background: white;
        }
        
        .card:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12);
        }
        
        .page-title-box {
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        
        .form-control {
            border-radius: 8px;
            padding: 12px 15px;
            border: 1px solid #e0e0e0;
            transition: all 0.3s ease;
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
        }
        
        .form-group label {
            font-weight: 600;
            color: var(--dark-color);
            margin-bottom: 8px;
        }
        
        .btn-success {
            background-color: var(--secondary-color);
            border-color: var(--secondary-color);
            border-radius: 8px;
            padding: 10px 24px;
            font-weight: 600;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
            box-shadow: 0 2px 5px rgba(28, 200, 138, 0.3);
        }
        
        .btn-success:hover {
            background-color: #17a673;
            border-color: #17a673;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(28, 200, 138, 0.4);
        }
        
        .btn-success:active {
            transform: translateY(0);
        }
        
        /* CKEditor 5 container styling */
        .ck-editor__editable {
            min-height: 200px;
            border-radius: 0 0 8px 8px !important;
        }
        
        .ck.ck-editor {
            border-radius: 8px !important;
            overflow: hidden;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        
        .ck.ck-toolbar {
            border-radius: 8px 8px 0 0 !important;
            background: #f8f9fa !important;
            border-bottom: 1px solid #e0e0e0 !important;
        }
        
        /* Animation for form elements */
        .form-group {
            transition: all 0.3s ease;
        }
        
        .form-group:hover {
            transform: translateX(3px);
        }
        
        /* Responsive adjustments */
        @media (max-width: 768px) {
            .form-row > div {
                margin-bottom: 15px;
            }
        }
    </style>
    <body>

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
            <?php include("assets/inc/nav.php");?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
            <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Vendor</a></li>
                                            <li class="breadcrumb-item active">Update Vendor</li>
                                        </ol>
                                    </div>
                                    <h4 class="page-title">Update Vendor Details</h4>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 
                        <!-- Form row -->
                        <?php
                            $v_number=$_GET['v_number'];
                            $ret="SELECT * FROM his_vendor WHERE v_number = ?";
                            $stmt= $mysqli->prepare($ret);
                            $stmt->bind_param('i',$v_number);
                            $stmt->execute();
                            $res=$stmt->get_result();
                            while($row=$res->fetch_object())
                            {
                        ?>
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="header-title" style="color: var(--primary-color);">Vendor Information</h4>
                                        <p class="text-muted mb-4">Update vendor details below</p>
                                        
                                        <form method="post">
                                            <div class="form-row">
                                                <div class="form-group col-md-4">
                                                    <label for="v_name">Vendor Name</label>
                                                    <input type="text" required value="<?php echo $row->v_name;?>" name="v_name" class="form-control" id="v_name">
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label for="v_phone">Vendor Phone Number</label>
                                                    <input required type="text" value="<?php echo $row->v_phone;?>" name="v_phone" class="form-control" id="v_phone">
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label for="v_adr">Vendor Address</label>
                                                    <input required value="<?php echo $row->v_adr;?>" type="text" name="v_adr" class="form-control" id="v_adr">
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <label for="v_email">Vendor Email</label>
                                                <input required value="<?php echo $row->v_email;?>" type="email" class="form-control" name="v_email" id="v_email">
                                            </div>

                                            <div class="form-group">
                                                <label for="editor">Vendor Details</label>
                                                <textarea class="form-control" name="v_desc" id="editor"><?php echo $row->v_desc;?></textarea>
                                            </div>

                                            <div class="text-center mt-4">
                                                <button type="submit" name="update_vendor" class="ladda-button btn btn-success" data-style="expand-right">
                                                    <span class="ladda-label">Update Vendor</span>
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php }?>
                        <!-- end row -->
                    </div>
                </div>

                <!-- Footer Start -->
                <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->
            </div>
        </div>

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>
        
        <!-- CKEditor 5 Script -->
        <script src="https://cdn.ckeditor.com/ckeditor5/41.1.0/classic/ckeditor.js"></script>
        <script>
            ClassicEditor
                .create(document.querySelector('#editor'), {
                    toolbar: {
                        items: [
                            'heading', '|',
                            'bold', 'italic', 'link', 'bulletedList', 'numberedList', '|',
                            'outdent', 'indent', '|',
                            'blockQuote', 'insertTable', 'undo', 'redo'
                        ]
                    },
                    language: 'en',
                    table: {
                        contentToolbar: [
                            'tableColumn',
                            'tableRow',
                            'mergeTableCells'
                        ]
                    }
                })
                .catch(error => {
                    console.error(error);
                });
        </script>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- App js-->
        <script src="assets/js/app.min.js"></script>

        <!-- Loading buttons js -->
        <script src="assets/libs/ladda/spin.js"></script>
        <script src="assets/libs/ladda/ladda.js"></script>

        <!-- Buttons init js-->
        <script src="assets/js/pages/loading-btn.init.js"></script>
        
        <!-- Form animations -->
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const formGroups = document.querySelectorAll('.form-group');
                
                formGroups.forEach((group, index) => {
                    group.style.opacity = 0;
                    group.style.transform = 'translateY(20px)';
                    group.style.transition = `all 0.5s ease ${index * 0.1}s`;
                    
                    setTimeout(() => {
                        group.style.opacity = 1;
                        group.style.transform = 'translateY(0)';
                    }, 100);
                });
            });
        </script>
    </body>
</html>