<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];

// Get patient details if patient ID is provided
$pat_id = $_GET['pat_id'] ?? '';
$patient = null;
if ($pat_id) {
    $ret = "SELECT * FROM his_patients WHERE pat_id = ?";
    $stmt = $mysqli->prepare($ret);
    $stmt->bind_param('i', $pat_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $patient = $res->fetch_object();
}

// Get financial data for the patient
$bills = [];
$payments = [];
$balance = 0;

if ($pat_id) {
    // Get all bills
    $ret = "SELECT * FROM his_bills WHERE pat_id = ? ORDER BY bill_date DESC";
    $stmt = $mysqli->prepare($ret);
    $stmt->bind_param('i', $pat_id);
    $stmt->execute();
    $res = $stmt->get_result();
    while ($bill = $res->fetch_object()) {
        $bills[] = $bill;
        if ($bill->status != 'Paid') {
            $balance += $bill->amount;
        }
    }
    
    // Get all payments
    $ret = "SELECT p.*, b.bill_number 
            FROM his_payments p 
            LEFT JOIN his_bills b ON p.bill_id = b.bill_id 
            WHERE p.pat_id = ? 
            ORDER BY p.payment_date DESC";
    $stmt = $mysqli->prepare($ret);
    $stmt->bind_param('i', $pat_id);
    $stmt->execute();
    $res = $stmt->get_result();
    while ($payment = $res->fetch_object()) {
        $payments[] = $payment;
        $balance -= $payment->amount;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<?php include('assets/inc/head.php');?>

<body>
    <div id="wrapper">
        <?php include('assets/inc/nav.php');?>
        <?php include("assets/inc/sidebar.php");?>

        <div class="content-page">
            <div class="content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Billing</a></li>
                                        <li class="breadcrumb-item active">View Ledger</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Patient Financial Ledger</h4>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">Patient Financial Summary</h4>
                                    
                                    <form method="get" class="mb-4">
                                        <div class="form-group">
                                            <label for="pat_id">Select Patient</label>
                                            <select class="form-control" id="pat_id" name="pat_id" required onchange="this.form.submit()">
                                                <option value="">Select Patient</option>
                                                <?php
                                                $ret = "SELECT * FROM his_patients ORDER BY pat_fname";
                                                $stmt = $mysqli->prepare($ret);
                                                $stmt->execute();
                                                $res = $stmt->get_result();
                                                while ($pat = $res->fetch_object()) {
                                                    $selected = ($pat->pat_id == $pat_id) ? 'selected' : '';
                                                    echo "<option value='$pat->pat_id' $selected>$pat->pat_fname $pat->pat_lname ($pat->pat_number)</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </form>

                                    <?php if ($patient) { ?>
                                    <div class="row mb-4">
                                        <div class="col-md-4">
                                            <div class="card bg-light">
                                                <div class="card-body text-center">
                                                    <h5>Total Bills</h5>
                                                    <h3>$<?php echo array_sum(array_column($bills, 'amount')); ?></h3>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="card bg-light">
                                                <div class="card-body text-center">
                                                    <h5>Total Payments</h5>
                                                    <h3>$<?php echo array_sum(array_column($payments, 'amount')); ?></h3>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="card <?php echo ($balance > 0) ? 'bg-danger text-white' : 'bg-success text-white'; ?>">
                                                <div class="card-body text-center">
                                                    <h5>Current Balance</h5>
                                                    <h3>$<?php echo number_format($balance, 2); ?></h3>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <h4 class="header-title mt-4">Billing History</h4>
                                    <div class="table-responsive">
                                        <table class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th>Bill #</th>
                                                    <th>Date</th>
                                                    <th>Description</th>
                                                    <th>Amount</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($bills as $bill) { ?>
                                                <tr>
                                                    <td><?php echo $bill->bill_number; ?></td>
                                                    <td><?php echo date('M d, Y', strtotime($bill->bill_date)); ?></td>
                                                    <td><?php echo $bill->description; ?></td>
                                                    <td>$<?php echo number_format($bill->amount, 2); ?></td>
                                                    <td>
                                                        <span class="badge badge-<?php 
                                                            if ($bill->status == 'Paid') echo 'success';
                                                            elseif ($bill->status == 'Partial') echo 'warning';
                                                            else echo 'danger';
                                                        ?>">
                                                            <?php echo $bill->status; ?>
                                                        </span>
                                                    </td>
                                                </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>

                                    <h4 class="header-title mt-4">Payment History</h4>
                                    <div class="table-responsive">
                                        <table class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th>Reference #</th>
                                                    <th>Date</th>
                                                    <th>Bill #</th>
                                                    <th>Amount</th>
                                                    <th>Method</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($payments as $payment) { ?>
                                                <tr>
                                                    <td><?php echo $payment->payment_ref; ?></td>
                                                    <td><?php echo date('M d, Y', strtotime($payment->payment_date)); ?></td>
                                                    <td><?php echo $payment->bill_number; ?></td>
                                                    <td>$<?php echo number_format($payment->amount, 2); ?></td>
                                                    <td><?php echo $payment->payment_method; ?></td>
                                                </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    <?php } elseif ($_GET) { ?>
                                        <div class="alert alert-info">Please select a patient to view their financial ledger.</div>
                                    <?php } ?>
                                    
                                    <a href="view_patients.php" class="btn btn-secondary mt-3">Back to Patients</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include('assets/inc/footer.php');?>
        </div>
    </div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>
    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
</body>
</html>