<?php
session_start();
include('assets/inc/config.php');
if(isset($_POST['add_equipments'])) {
    $eqp_code = $_POST['eqp_code'];
    $eqp_name = $_POST['eqp_name'];
    $eqp_vendor = $_POST['eqp_vendor'];
    $eqp_desc = $_POST['eqp_desc'];
    $eqp_dept = $_POST['eqp_dept'];
    $eqp_status = $_POST['eqp_status'];
    $eqp_qty = $_POST['eqp_qty'];
        
    //sql to insert captured values
    $query = "INSERT INTO his_equipments (eqp_code, eqp_name, eqp_vendor, eqp_desc, eqp_dept, eqp_status, eqp_qty) VALUES (?,?,?,?,?,?,?)";
    $stmt = $mysqli->prepare($query);
    $rc = $stmt->bind_param('sssssss', $eqp_code, $eqp_name, $eqp_vendor, $eqp_desc, $eqp_dept, $eqp_status, $eqp_qty);
    $stmt->execute();
    
    if($stmt) {
        $success = "Equipment Added Successfully";
    } else {
        $err = "Please Try Again Or Try Later";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        :root {
            --primary-color: #5b73e8;
            --secondary-color: #6c757d;
            --success-color: #28a745;
            --danger-color: #dc3545;
            --warning-color: #ffc107;
            --info-color: #17a2b8;
        }
        
        body {
            background-color: #f8f9fa;
        }
        
        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.05);
        }
        
        .page-title-box {
            padding: 20px 0;
        }
        
        .form-control, .form-select {
            border-radius: 8px;
            padding: 12px 15px;
            border: 1px solid #e0e0e0;
            transition: all 0.3s;
        }
        
        .form-control:focus, .form-select:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(91, 115, 232, 0.25);
        }
        
        .btn-success {
            background-color: var(--success-color);
            border-color: var(--success-color);
            padding: 10px 25px;
            border-radius: 8px;
            font-weight: 500;
            letter-spacing: 0.5px;
        }
        
        .btn-success:hover {
            background-color: #218838;
            border-color: #1e7e34;
        }
        
        .ck.ck-editor {
            border-radius: 8px;
            overflow: hidden;
        }
        
        .ck.ck-editor__main>.ck-editor__editable {
            min-height: 150px;
            border-radius: 0 0 8px 8px;
        }
        
        .ck.ck-toolbar {
            border-radius: 8px 8px 0 0;
        }
        
        .alert {
            border-radius: 8px;
        }
    </style>
</head>
<body>
    <!-- Begin page -->
    <div id="wrapper">
        <!-- Topbar Start -->
        <?php include("assets/inc/nav.php");?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->
        <div class="content-page">
            <div class="content">
                <!-- Start Content-->
                <div class="container-fluid">
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Surgical/ Theatre</a></li>
                                        <li class="breadcrumb-item active">Add Equipment</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Add Surgical Equipment</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 
                    
                    <!-- Alert Messages -->
                    <?php if(isset($success)) { ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="fas fa-check-circle me-2"></i>
                            <?php echo $success; ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php } ?>
                    
                    <?php if(isset($err)) { ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <i class="fas fa-exclamation-triangle me-2"></i>
                            <?php echo $err; ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php } ?>

                    <!-- Form row -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title mb-4">Equipment Details</h4>
                                    <form method="post">
                                        <div class="row g-3">
                                            <div class="col-md-4">
                                                <label for="eqp_name" class="form-label">Equipment Name *</label>
                                                <input type="text" class="form-control" id="eqp_name" name="eqp_name" required>
                                            </div>
                                            
                                            <div class="col-md-4">
                                                <label for="eqp_vendor" class="form-label">Equipment Vendor *</label>
                                                <input type="text" class="form-control" id="eqp_vendor" name="eqp_vendor" required>
                                            </div>
                                            
                                            <div class="col-md-4">
                                                <label for="eqp_qty" class="form-label">Equipment Quantity *</label>
                                                <input type="number" class="form-control" id="eqp_qty" name="eqp_qty" required min="1">
                                            </div>
                                            
                                            <div class="col-md-6" style="display:none">
                                                <label for="eqp_dept" class="form-label">Equipment Department</label>
                                                <input type="text" class="form-control" id="eqp_dept" name="eqp_dept" value="Surgical | Theatre">
                                            </div>
                                            
                                            <div class="col-md-6" style="display:none">
                                                <label for="eqp_status" class="form-label">Equipment Status</label>
                                                <input type="text" class="form-control" id="eqp_status" name="eqp_status" value="Functioning">
                                            </div>
                                            
                                            <div class="col-12">
                                                <label for="eqp_code" class="form-label">Equipment Barcode (EAN-8)</label>
                                                <?php 
                                                    $length = 10;    
                                                    $bcode = substr(str_shuffle('0123456789'),1,$length);
                                                ?>
                                                <input type="text" class="form-control" id="eqp_code" name="eqp_code" value="<?php echo $bcode;?>" readonly>
                                            </div>
                                            
                                            <div class="col-12">
                                                <label for="editor" class="form-label">Equipment Description *</label>
                                                <textarea class="form-control" id="editor" name="eqp_desc" required></textarea>
                                            </div>
                                            
                                            <div class="col-12 mt-3">
                                                <button type="submit" name="add_equipments" class="btn btn-success px-4 py-2 ladda-button" data-style="expand-right">
                                                    <i class="fas fa-plus-circle me-2"></i> Add Equipment
                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                </div> <!-- end card-body -->
                            </div> <!-- end card-->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->
                </div> <!-- container -->
            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->
        </div>
        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->
    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App js-->
    <script src="assets/js/app.min.js"></script>

    <!-- CKEditor 5 -->
    <script src="https://cdn.ckeditor.com/ckeditor5/41.3.1/classic/ckeditor.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            ClassicEditor
                .create(document.querySelector('#editor'), {
                    toolbar: [
                        'heading', '|',
                        'bold', 'italic', 'underline', 'strikethrough', '|',
                        'bulletedList', 'numberedList', '|',
                        'blockQuote', 'link', '|',
                        'undo', 'redo'
                    ],
                    heading: {
                        options: [
                            { model: 'paragraph', title: 'Paragraph', class: 'ck-heading_paragraph' },
                            { model: 'heading2', view: 'h2', title: 'Heading 2', class: 'ck-heading_heading2' },
                            { model: 'heading3', view: 'h3', title: 'Heading 3', class: 'ck-heading_heading3' }
                        ]
                    },
                    placeholder: 'Enter equipment description here...',
                    height: '150px'
                })
                .catch(error => {
                    console.error('There was a problem initializing the editor.', error);
                });

            // Initialize Ladda buttons
            Ladda.bind('.ladda-button', {
                timeout: 2000
            });
        });
    </script>

    <!-- Loading buttons js -->
    <script src="assets/libs/ladda/spin.js"></script>
    <script src="assets/libs/ladda/ladda.js"></script>

    <!-- Buttons init js-->
    <script src="assets/js/pages/loading-btn.init.js"></script>
</body>
</html>