<?php
    session_start();
    include('assets/inc/config.php');
    if(isset($_POST['add_pharmaceutical_category'])) {
        $pharm_cat_name = $_POST['pharm_cat_name'];
        $pharm_cat_vendor = $_POST['pharm_cat_vendor'];
        $pharm_cat_desc = $_POST['pharm_cat_desc'];
        
        $query = "INSERT INTO his_pharmaceuticals_categories (pharm_cat_name, pharm_cat_vendor, pharm_cat_desc) VALUES (?,?,?)";
        $stmt = $mysqli->prepare($query);
        $rc = $stmt->bind_param('sss', $pharm_cat_name, $pharm_cat_vendor, $pharm_cat_desc);
        $stmt->execute();
        
        if($stmt) {
            $success = "Pharmaceutical Category Added";
        } else {
            $err = "Please Try Again Or Try Later";
        }
    }
?>
<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3a0ca3;
            --success-color: #00b46e;
            --light-bg: #f8f9fc;
            --card-shadow: 0 4px 24px rgba(0, 0, 0, 0.05);
            --form-border: #e0e3ff;
            --dark-text: #2b2d42;
            --medium-text: #495057;
        }
        
        body {
            background-color: var(--light-bg);
            font-family: 'Inter', sans-serif;
        }
        
        .pharma-header {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            padding: 25px 0;
            border-radius: 12px 12px 0 0;
            margin-bottom: 20px;
            text-align: center;
        }
        
        .pharma-card {
            background: white;
            border-radius: 12px;
            box-shadow: var(--card-shadow);
            overflow: hidden;
            transition: all 0.3s ease;
            max-width: 100%;
        }
        
        .pharma-card:hover {
            box-shadow: 0 10px 30px rgba(67, 97, 238, 0.15);
        }
        
        .form-section {
            padding: 30px;
        }
        
        .section-title {
            color: var(--primary-color);
            font-weight: 600;
            margin-bottom: 25px;
            position: relative;
            padding-bottom: 10px;
        }
        
        .section-title:after {
            content: '';
            position: absolute;
            left: 0;
            bottom: 0;
            width: 50px;
            height: 3px;
            background: var(--primary-color);
            border-radius: 3px;
        }
        
        .form-control {
            border: 1px solid var(--form-border);
            border-radius: 8px;
            padding: 12px 15px;
            transition: all 0.3s ease;
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 2px rgba(67, 97, 238, 0.1);
        }
        
        select.form-control {
            appearance: none;
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='%234361ee' viewBox='0 0 16 16'%3E%3Cpath d='M7.247 11.14 2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z'/%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: right 15px center;
            background-size: 12px;
        }
        
        .btn-add {
            background: var(--success-color);
            border: none;
            padding: 12px 30px;
            font-weight: 500;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
            border-radius: 8px;
            width: 100%;
            max-width: 250px;
            margin: 20px auto 0;
            display: block;
        }
        
        .btn-add:hover {
            background: #00a05e;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 180, 110, 0.3);
        }
        
        /* CKEditor 4.25.1 Customization */
        .cke_chrome {
            border-radius: 8px !important;
            border: 1px solid var(--form-border) !important;
            overflow: hidden;
            transition: all 0.3s ease;
        }
        
        .cke_top {
            background: var(--primary-light) !important;
            border-bottom: 1px solid var(--form-border) !important;
            padding: 6px 8px !important;
        }
        
        .cke_bottom {
            background: var(--primary-light) !important;
            border-top: 1px solid var(--form-border) !important;
            padding: 6px 8px !important;
        }
        
        .cke_contents {
            min-height: 200px !important;
        }
        
        .cke_button_icon {
            filter: brightness(0.5);
        }
        
        .cke_button:hover .cke_button_icon {
            filter: brightness(0.8);
        }
        
        .cke_button_on .cke_button_icon {
            filter: brightness(1);
        }
        
        @media (max-width: 768px) {
            .form-section {
                padding: 20px;
            }
            
            .btn-add {
                width: 100%;
                max-width: none;
            }
            
            .cke_toolbar {
                float: none !important;
                display: inline-block !important;
            }
        }
    </style>
    <!-- Load CKEditor 4.25.1 from CDN -->
    <script src="https://cdn.ckeditor.com/4.25.1/standard/ckeditor.js"></script>
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include("assets/inc/nav.php");?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Pharmaceuticals</a></li>
                                        <li class="breadcrumb-item active">Add Category</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Create Pharmaceutical Category</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 
                    
                    <div class="row justify-content-center">
                        <div class="col-lg-12">
                            <div class="pharma-card">
                                <div class="pharma-header">
                                    <h3>New Pharmaceutical Category</h3>
                                </div>
                                
                                <div class="form-section">
                                    <h4 class="section-title">Category Details</h4>
                                    <form method="post">
                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label>Category Name</label>
                                                <input type="text" required name="pharm_cat_name" class="form-control" placeholder="Enter category name">
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Vendor</label>
                                                <select required name="pharm_cat_vendor" class="form-control">
                                                    <option value="">Select Vendor</option>
                                                    <?php
                                                        $ret = "SELECT * FROM his_vendor ORDER BY v_name";
                                                        $stmt = $mysqli->prepare($ret);
                                                        $stmt->execute();
                                                        $res = $stmt->get_result();
                                                        while($row = $res->fetch_object()) {
                                                    ?>
                                                    <option value="<?php echo htmlspecialchars($row->v_name, ENT_QUOTES); ?>">
                                                        <?php echo htmlspecialchars($row->v_name, ENT_QUOTES); ?>
                                                    </option>
                                                    <?php } ?>   
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label>Description</label>
                                            <textarea required name="pharm_cat_desc" id="editor" class="form-control" rows="6" placeholder="Enter detailed description"></textarea>
                                        </div>

                                        <button type="submit" name="add_pharmaceutical_category" class="btn btn-add">
                                            <i class="mdi mdi-plus-circle-outline mr-1"></i> Add Category
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                </div> <!-- container -->

            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Initialize CKEditor 4.25.1 with security enhancements -->
    <script>
        CKEDITOR.replace('editor', {
            // Basic toolbar configuration
            toolbar: [
                { name: 'document', items: ['Source', '-', 'NewPage', 'Preview', '-', 'Templates' ] },
                { name: 'clipboard', items: ['Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo' ] },
                { name: 'editing', items: ['Find', 'Replace', '-', 'SelectAll', '-', 'Scayt' ] },
                { name: 'basicstyles', items: ['Bold', 'Italic', 'Underline', 'Strike', 'Subscript', 'Superscript', '-', 'CopyFormatting', 'RemoveFormat' ] },
                { name: 'paragraph', items: ['NumberedList', 'BulletedList', '-', 'Outdent', 'Indent', '-', 'Blockquote', 'CreateDiv', '-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock', '-', 'BidiLtr', 'BidiRtl' ] },
                { name: 'links', items: ['Link', 'Unlink', 'Anchor' ] },
                { name: 'insert', items: ['Image', 'Table', 'HorizontalRule', 'SpecialChar', 'PageBreak', 'Iframe' ] },
                { name: 'styles', items: ['Styles', 'Format', 'Font', 'FontSize' ] },
                { name: 'colors', items: ['TextColor', 'BGColor' ] },
                { name: 'tools', items: ['Maximize', 'ShowBlocks' ] }
            ],
            
            // Security configurations
            allowedContent: true, // Set to false if you want to restrict content
            removeButtons: '', // Buttons to remove
            extraPlugins: '', // Additional plugins to load
            removePlugins: 'exportpdf', // Remove potentially insecure plugins
            
            // UI customizations
            height: 250,
            width: '100%',
            resize_enabled: true,
            
            // Content filtering
            basicEntities: false,
            entities: false,
            entities_latin: false,
            entities_greek: false,
            
            // File upload security
            filebrowserUploadMethod: 'form',
            filebrowserUploadUrl: '', // Set your secure upload endpoint
            
            // Prevent XSS
            htmlEncodeOutput: true,
            bodyClass: 'cke_editable cke_contents_ltr',
            
            // Auto-paragraph
            autoParagraph: true,
            
            // Disable source editing by default
            startupMode: 'wysiwyg',
            
            // Language
            language: 'en',
            
            // Accessibility
            title: 'Rich Text Editor',
            skin: 'moono-lisa'
        });
        
        // Additional security - sanitize output before form submission
        document.querySelector('form').addEventListener('submit', function(e) {
            var editorData = CKEDITOR.instances.editor.getData();
            document.getElementById('editor').value = editorData;
        });
    </script>

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App js-->
    <script src="assets/js/app.min.js"></script>

    <!-- Loading buttons js -->
    <script src="assets/libs/ladda/spin.js"></script>
    <script src="assets/libs/ladda/ladda.js"></script>

    <!-- Buttons init js-->
    <script src="assets/js/pages/loading-btn.init.js"></script>
    
</body>
</html>