<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid=$_SESSION['ad_id'];
  if(isset($_GET['delete']))
  {
        $id=intval($_GET['delete']);
        $adn="delete from his_patients where pat_id=?";
        $stmt= $mysqli->prepare($adn);
        $stmt->bind_param('i',$id);
        $stmt->execute();
        $stmt->close();  
  
          if($stmt)
          {
            $success = "Patients Records Deleted";
          }
            else
            {
                $err = "Try Again Later";
            }
    }
?>

<!DOCTYPE html>
<html lang="en">
    
<?php include('assets/inc/head.php');?>

    <body>

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
                <?php include('assets/inc/nav.php');?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
                <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box bg-gradient-primary">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Surgery | Theatre</a></li>
                                            <li class="breadcrumb-item active text-white">Add Patient</li>
                                        </ol>
                                    </div>
                                    <h4 class="page-title text-white">Patient Management</h4>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 

                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header bg-primary text-white">
                                        <h4 class="header-title">Patient Records</h4>
                                        <div class="btn-group float-right">
                                            <button class="btn btn-success dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                <i class="fas fa-download mr-1"></i> Export
                                            </button>
                                            <div class="dropdown-menu">
                                                <a class="dropdown-item" href="#" onclick="exportToExcel()">Excel</a>
                                                <a class="dropdown-item" href="#" onclick="exportToCSV()">CSV</a>
                                                <a class="dropdown-item" href="#" onclick="printTable()">Print</a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="mb-3">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <input id="demo-foo-search" type="text" placeholder="Search patients..." class="form-control" autocomplete="on">
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <select id="category-filter" class="custom-select">
                                                            <option value="">All Categories</option>
                                                            <option value="InPatients">InPatients</option>
                                                            <option value="OutPatients">OutPatients</option>
                                                            <option value="Emergency">Emergency</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-2">
                                                    <button class="btn btn-primary btn-block" onclick="resetFilters()">Reset</button>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="table-responsive">
                                            <table id="demo-foo-filtering" class="table table-hover table-bordered toggle-circle mb-0" data-page-size="10">
                                                <thead class="thead-light">
                                                <tr>
                                                    <th>#</th>
                                                    <th data-toggle="true">Patient Name</th>
                                                    <th data-hide="phone">Patient Number</th>
                                                    <th data-hide="phone">Patient Address</th>
                                                    <th data-hide="phone">Patient Category</th>
                                                    <th>Action</th>
                                                </tr>
                                                </thead>
                                                <?php
                                                /*
                                                    *get details of allpatients
                                                    *
                                                */
                                                    $ret="SELECT * FROM  his_patients ORDER BY RAND() "; 
                                                    //sql code to get to ten docs  randomly
                                                    $stmt= $mysqli->prepare($ret) ;
                                                    $stmt->execute() ;//ok
                                                    $res=$stmt->get_result();
                                                    $cnt=1;
                                                    while($row=$res->fetch_object())
                                                    {
                                                ?>

                                                    <tbody>
                                                    <tr>
                                                        <td><?php echo $cnt;?></td>
                                                        <td><?php echo $row->pat_fname;?> <?php echo $row->pat_lname;?></td>
                                                        <td><?php echo $row->pat_number;?></td>
                                                        <td><?php echo $row->pat_addr;?></td>
                                                        <td>
                                                            <span class="badge 
                                                            <?php 
                                                                if($row->pat_type == 'InPatients') echo 'badge-primary';
                                                                elseif($row->pat_type == 'OutPatients') echo 'badge-success';
                                                                else echo 'badge-danger';
                                                            ?>">
                                                            <?php echo $row->pat_type;?>
                                                            </span>
                                                        </td>
                                                        
                                                        <td>
                                                            <div class="btn-group">
                                                               
                                                                <a href="theatre_single_patient.php?pat_id=<?php echo $row->pat_id;?>" class="btn btn-sm btn-primary"><i class="mdi mdi-plus-circle mr-1"></i> Add</a>
                                                                <a href="manage_patient.php?delete=<?php echo $row->pat_id;?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this patient record?');"><i class="mdi mdi-delete mr-1"></i> Delete</a>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    </tbody>
                                                <?php  $cnt = $cnt +1 ; }?>
                                                <tfoot>
                                                <tr class="active">
                                                    <td colspan="6">
                                                        <div class="text-right">
                                                            <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                        </div>
                                                    </td>
                                                </tr>
                                                </tfoot>
                                            </table>
                                        </div> <!-- end .table-responsive-->
                                    </div> <!-- end card-body -->
                                </div> <!-- end card -->
                            </div> <!-- end col -->
                        </div>
                        <!-- end row -->

                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                 <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- Footable js -->
        <script src="assets/libs/footable/footable.all.min.js"></script>

        <!-- Init js -->
        <script src="assets/js/pages/foo-tables.init.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
        <!-- Export functionality -->
        <script src="https://cdn.jsdelivr.net/npm/xlsx@0.17.0/dist/xlsx.full.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/file-saver@2.0.5/dist/FileSaver.min.js"></script>
        
        <style>
            .bg-gradient-primary {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
                border-radius: 0.25rem;
                box-shadow: 0 4px 20px 0 rgba(0,0,0,.14), 0 7px 10px -5px rgba(102, 126, 234, .4);
            }
            
            .card {
                border: none;
                box-shadow: 0 1px 15px rgba(0,0,0,0.1);
            }
            
            .table-hover tbody tr:hover {
                background-color: rgba(0, 123, 255, 0.05);
            }
            
            .btn-group .btn {
                margin-right: 5px;
                border-radius: 4px;
            }
            
            .btn-group .btn:last-child {
                margin-right: 0;
            }
            
            @media print {
                body * {
                    visibility: hidden;
                }
                .card, .card * {
                    visibility: visible;
                }
                .card {
                    position: absolute;
                    left: 0;
                    top: 0;
                    width: 100%;
                    border: none;
                    box-shadow: none;
                }
                .no-print, .dropdown-menu, .btn-group {
                    display: none !important;
                }
                .badge {
                    color: black !important;
                    border: 1px solid #ddd;
                    background-color: transparent !important;
                }
            }
        </style>
        
        <script>
            // Export to Excel function
            function exportToExcel() {
                const table = document.getElementById("demo-foo-filtering");
                const wb = XLSX.utils.table_to_book(table, {sheet:"Patient Data"});
                XLSX.writeFile(wb, "Patient_Records.xlsx");
            }
            
            // Export to CSV function
            function exportToCSV() {
                const table = document.getElementById("demo-foo-filtering");
                const ws = XLSX.utils.table_to_sheet(table);
                const csv = XLSX.utils.sheet_to_csv(ws);
                const blob = new Blob([csv], {type: "text/csv;charset=utf-8;"});
                saveAs(blob, "Patient_Records.csv");
            }
            
            // Print function
            function printTable() {
                window.print();
            }
            
            // Enhanced filtering
            $(document).ready(function() {
                $('#category-filter').change(function() {
                    const filter = $(this).val().toLowerCase();
                    $('table tbody tr').each(function() {
                        const category = $(this).find('td:eq(4)').text().toLowerCase();
                        if (filter === '' || category === filter.toLowerCase()) {
                            $(this).show();
                        } else {
                            $(this).hide();
                        }
                    });
                });
            });
            
            // Reset filters
            function resetFilters() {
                $('#demo-foo-search').val('');
                $('#category-filter').val('');
                $('table tbody tr').show();
            }
        </script>
    </body>
</html>