<?php
    $doc_id = $_SESSION['doc_id'];
    $doc_number = $_SESSION['doc_number'];
    $ret="SELECT * FROM  his_docs WHERE doc_id = ? AND doc_number = ?";
    $stmt= $mysqli->prepare($ret) ;
    $stmt->bind_param('is',$doc_id, $doc_number);
    $stmt->execute() ;//ok
    $res=$stmt->get_result();
    while($row=$res->fetch_object())
    {
?>
<style>
:root {
    --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    --primary-light: rgba(102, 126, 234, 0.1);
    --dropdown-bg: #4b3b70;
    --text-light: rgba(255,255,255,0.9);
    --text-lighter: rgba(255,255,255,0.7);
    --transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
    --shadow-sm: 0 4px 6px rgba(0,0,0,0.1);
    --shadow-md: 0 8px 15px rgba(0,0,0,0.1);
    --card-radius: 12px;
}

/* Modern Navbar */
.navbar-custom {
    background: var(--primary-gradient);
    padding: 0.75rem 1.5rem;
    box-shadow: var(--shadow-md);
    color: white;
    transition: var(--transition);
    position: fixed;
    z-index: 1000;
}

.navbar-custom::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: linear-gradient(135deg, rgba(255,255,255,0.1) 0%, transparent 100%);
    opacity: 0;
    transition: var(--transition);
}

.navbar-custom:hover::before {
    opacity: 1;
}

/* Logo */
.logo-box img {
    filter: brightness(1.2);
    transition: transform 0.3s ease, filter 0.3s ease;
}

.logo-box:hover img {
    transform: scale(1.05);
    filter: brightness(1.3);
}

/* Navigation Items */
.navbar-custom .topnav-menu li a,
.navbar-custom .pro-user-name,
.navbar-custom .dropdown-menu a {
    color: var(--text-light) !important;
    transition: var(--transition);
}

.navbar-custom .topnav-menu li a:hover {
    color: white !important;
    transform: translateY(-2px);
}

/* User Profile */
.nav-user {
    display: flex;
    align-items: center;
    padding: 0.5rem 1rem;
    border-radius: 50px;
    transition: var(--transition);
    background: rgba(255,255,255,0.1);
}

.nav-user:hover {
    background: rgba(255,255,255,0.2);
    transform: translateY(-2px);
}

.nav-user img {
    width: 36px;
    height: 36px;
    object-fit: cover;
    border: 2px solid rgba(255,255,255,0.3);
    transition: var(--transition);
}

.nav-user:hover img {
    border-color: white;
    transform: scale(1.1);
}

/* Dropdown Menu */
.dropdown-menu {
    background-color: var(--dropdown-bg);
    border: none;
    border-radius: var(--card-radius);
    box-shadow: var(--shadow-md);
    padding: 0.5rem 0;
    transform-origin: top right;
    animation: fadeIn 0.2s ease-out forwards;
    opacity: 0;
    transform: translateY(10px);
}

@keyframes fadeIn {
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.dropdown-item {
    padding: 0.75rem 1.5rem;
    transition: var(--transition);
    position: relative;
    overflow: hidden;
}

.dropdown-item::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.1), transparent);
    transition: var(--transition);
}

.dropdown-item:hover::before {
    left: 100%;
}

.dropdown-item:hover {
    background-color: rgba(255, 255, 255, 0.1);
    padding-left: 1.75rem;
}

.dropdown-item i {
    margin-right: 0.75rem;
    width: 20px;
    text-align: center;
    transition: var(--transition);
}

.dropdown-item:hover i {
    transform: scale(1.2);
    color: white;
}

/* Search Bar */
.app-search .form-control {
    background: rgba(255,255,255,0.15);
    border: none;
    color: white;
    border-radius: 50px;
    padding: 0.75rem 1.5rem;
    transition: var(--transition);
    backdrop-filter: blur(5px);
}

.app-search .form-control:focus {
    background: rgba(255,255,255,0.25);
    box-shadow: 0 0 0 3px rgba(255,255,255,0.2);
}

.app-search .form-control::placeholder {
    color: var(--text-lighter);
}

.app-search button {
    background-color: rgba(255,255,255,0.2);
    border: none;
    color: white;
    border-radius: 0 50px 50px 0;
    transition: var(--transition);
}

.app-search button:hover {
    background-color: rgba(255,255,255,0.3);
}

/* Quick Links */
.dropdown-toggle::after {
    transition: transform 0.3s ease;
}

.show .dropdown-toggle::after {
    transform: rotate(180deg);
}

/* Menu Button */
.button-menu-mobile {
    background: transparent;
    border: none;
    color: white;
    font-size: 1.5rem;
    padding: 0.5rem;
    border-radius: 50%;
    transition: var(--transition);
    display: flex;
    align-items: center;
    justify-content: center;
}

.button-menu-mobile:hover {
    background: rgba(255,255,255,0.2);
    transform: rotate(90deg);
}

/* Responsive Adjustments */
@media (max-width: 768px) {
    .navbar-custom {
        padding: 0.75rem 1rem;
    }
    
    .app-search {
        display: none;
    }
    
    .nav-user .pro-user-name {
        display: none;
    }
}
</style>

<div class="navbar-custom">
    <ul class="list-unstyled topnav-menu float-right mb-0">

        <li class="d-none d-sm-block">
            <form class="app-search">
                <div class="app-search-box">
                    <div class="input-group">
                        <input type="text" class="form-control" placeholder="Search...">
                        <div class="input-group-append">
                            <button class="btn" type="submit">
                                <i class="fe-search"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </li>

        <li class="dropdown notification-list">
            <a class="nav-link dropdown-toggle nav-user mr-0 waves-effect waves-light" data-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                <img src="assets/images/users/<?php echo $row->doc_dpic;?>" alt="dpic" class="rounded-circle">
                <span class="pro-user-name ml-1">
                    <?php echo $row->doc_fname;?> <?php echo $row->doc_lname;?> <i class="mdi mdi-chevron-down"></i> 
                </span>
            </a>
            <div class="dropdown-menu dropdown-menu-right profile-dropdown">
                <!-- item-->
                <div class="dropdown-header noti-title">
                    <h6 class="text-overflow m-0">My profile</h6>
                </div>

                <a href="update-account.php" class="dropdown-item notify-item">
                    <i class="fas fa-user-tag"></i>
                    <span>Update Profile</span>
                </a>

                <div class="dropdown-divider"></div>

                <!-- item-->
                <a href="logout_partial.php" class="dropdown-item notify-item">
                    <i class="fe-log-out"></i>
                    <span>Logout</span>
                </a>
            </div>
        </li>
    </ul>

    <!-- LOGO -->
    <div class="logo-box">
        <a href="dashboard.php" class="logo text-center">
            <span class="logo-lg">
                <img src="assets/images/logo.png" alt="" height="50">
            </span>
            <span class="logo-sm">
                <img src="assets/images/favicon.png" alt="" height="18">
            </span>
        </a>
    </div>

    <ul class="list-unstyled topnav-menu topnav-menu-left m-0">
        <li>
            <button class="button-menu-mobile waves-effect waves-light">
                <i class="fe-menu"></i>
            </button>
        </li>

        <li class="dropdown d-none d-lg-block">
            <a class="nav-link dropdown-toggle waves-effect waves-light" data-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                Quick Links
                <i class="mdi mdi-chevron-down"></i> 
            </a>
            <div class="dropdown-menu">
                <a href="register_patient.php" class="dropdown-item">
                    <i class="fe-activity mr-1"></i>
                    <span>Patient</span>
                </a>

                <a href="lab_report.php" class="dropdown-item">
                    <i class="fe-hard-drive mr-1"></i>
                    <span>Laboratory Report</span>
                </a>
                
                <div class="dropdown-divider"></div>
            </div>
        </li>
    </ul>
</div>
<?php }?>