<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid=$_SESSION['ad_id'];
?>

<!DOCTYPE html>
<html lang="en">
    
<?php include('assets/inc/head.php');?>

    <body style="background: linear-gradient(135deg, #f8f9fc 0%, #e6f2ff 100%); font-family: 'Poppins', sans-serif;">

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
                <?php include('assets/inc/nav.php');?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
                <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box" style="background: linear-gradient(45deg, #6a11cb 0%, #2575fc 100%); border-radius: 12px; padding: 20px; box-shadow: 0 8px 20px rgba(106, 17, 203, 0.2); color: white; margin-bottom: 25px;">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="javascript: void(0);" style="color: rgba(255,255,255,0.8);">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);" style="color: rgba(255,255,255,0.8);">Patients</a></li>
                                            <li class="breadcrumb-item active" style="color: white; font-weight: 600;">Discharge Patients</li>
                                        </ol>
                                    </div>
                                    <h4 class="page-title" style="color: white; font-weight: 700; letter-spacing: 0.5px;">
                                        <i class="fas fa-user-check mr-2"></i>Discharge Patients
                                    </h4>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 

                        <div class="row">
                            <div class="col-12">
                                <div class="card-box" style="border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); border: none; overflow: hidden;">
                                    <h4 class="header-title mb-4" style="color: #4e73df; font-weight: 600; border-left: 4px solid #4e73df; padding-left: 10px;">
                                        <i class="fas fa-procedures mr-2"></i>Current In-Patients (IPD)
                                    </h4>
                                    
                                    <div class="mb-3">
                                        <div class="row">
                                            <div class="col-12 text-sm-center form-inline">
                                                <div class="form-group position-relative">
                                                    <i class="fas fa-search position-absolute" style="left: 15px; top: 10px; color: #6c757d;"></i>
                                                    <input id="demo-foo-search" type="text" placeholder="Search patients..." class="form-control form-control-sm pl-4" autocomplete="on" style="border-radius: 8px; border: 1px solid #d1d3e2; width: 250px; padding-left: 35px;">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="table-responsive">
                                        <table id="demo-foo-filtering" class="table table-bordered toggle-circle mb-0" data-page-size="7" style="border-collapse: separate; border-spacing: 0; border-radius: 12px; overflow: hidden;">
                                            <thead style="background: linear-gradient(to right, #4e73df, #224abe); color: white;">
                                            <tr>
                                                <th style="border: none; padding: 15px 10px;">#</th>
                                                <th data-toggle="true" style="border: none; padding: 15px 10px;">Patient Name</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Patient Number</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Address</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Category</th>
                                                <th data-hide="phone" style="border: none; padding: 15px 10px;">Action</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php
                                                $ret="SELECT * FROM his_patients WHERE pat_discharge_status !='Discharged' AND pat_type = 'InPatient'"; 
                                                $stmt= $mysqli->prepare($ret);
                                                $stmt->execute();
                                                $res=$stmt->get_result();
                                                $cnt=1;
                                                while($row=$res->fetch_object())
                                                {
                                            ?>
                                                <tr style="transition: all 0.3s; border-bottom: 1px solid #e3e6f0;">
                                                    <td style="padding: 15px 10px; border: none; font-weight: 500; color: #5a5c69;"><?php echo $cnt;?></td>
                                                    <td style="padding: 15px 10px; border: none; font-weight: 600; color: #4e73df;">
                                                        <i class="fas fa-user-circle mr-2"></i><?php echo $row->pat_fname;?> <?php echo $row->pat_lname;?>
                                                    </td>
                                                    <td style="padding: 15px 10px; border: none; color: #5a5c69;"><?php echo $row->pat_number;?></td>
                                                    <td style="padding: 15px 10px; border: none; color: #5a5c69;"><?php echo $row->pat_addr;?></td>
                                                    <td style="padding: 15px 10px; border: none;">
                                                        <span class="badge badge-pill" style="background: linear-gradient(to right, #ff416c, #ff4b2b); padding: 5px 12px; font-size: 12px;">IPD</span>
                                                    </td>
                                                    <td style="padding: 15px 10px; border: none;">
                                                        <a href="discharge_single_patient.php?pat_id=<?php echo $row->pat_id;?>" class="btn btn-sm btn-primary" style="background: linear-gradient(to right, #4e73df, #224abe); border: none; padding: 8px 15px; font-weight: 500; border-radius: 8px; box-shadow: 0 4px 8px rgba(0,0,0,0.1); transition: all 0.3s;">
                                                            <i class="mdi mdi-check-box-outline mr-1"></i> Discharge
                                                        </a>
                                                    </td>
                                                </tr>
                                            <?php $cnt = $cnt +1; } ?>
                                            </tbody>
                                            <tfoot>
                                            <tr class="active">
                                                <td colspan="6" style="border: none;">
                                                    <div class="text-right">
                                                        <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                    </div>
                                                </td>
                                            </tr>
                                            </tfoot>
                                        </table>
                                    </div> <!-- end .table-responsive-->
                                </div> <!-- end card-box -->
                            </div> <!-- end col -->
                        </div>
                        <!-- end row -->

                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                 <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->


        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- Footable js -->
        <script src="assets/libs/footable/footable.all.min.js"></script>

        <!-- Init js -->
        <script src="assets/js/pages/foo-tables.init.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
    </body>

</html>