<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];
?>

<!DOCTYPE html>
<html lang="en">
    
<?php include('assets/inc/head.php');?>

<body>
    <!-- Begin page -->
    <div id="wrapper">
        <!-- Topbar Start -->
        <?php include('assets/inc/nav.php');?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">
                <!-- Start Content-->
                <div class="container-fluid">
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Payroll</a></li>
                                        <li class="breadcrumb-item active">Generate Payroll</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Employee Payroll Management</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row mb-3">
                                        <div class="col-md-6">
                                            <h4 class="header-title">Employee Payroll Records</h4>
                                            <p class="text-muted">View and generate payroll for employees</p>
                                        </div>
                                        <div class="col-md-6 text-md-right">
                                            <div class="form-inline float-md-right">
                                                <div class="search-box">
                                                    <div class="position-relative">
                                                        <input type="text" id="demo-foo-search" class="form-control" placeholder="Search...">
                                                        <i class="fas fa-search search-icon"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="table-responsive">
                                        <table id="demo-foo-filtering" class="table table-hover table-centered mb-0" data-page-size="10">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th data-toggle="true">#</th>
                                                    <th>Employee Name</th>
                                                    <th>Employee Number</th>
                                                    <th data-hide="phone">Payroll Number</th>
                                                    <th data-hide="phone">Date Posted</th>
                                                    <th data-hide="phone">Salary</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $ret = "SELECT * FROM his_payrolls ORDER BY pay_date_generated DESC"; 
                                                $stmt = $mysqli->prepare($ret);
                                                $stmt->execute();
                                                $res = $stmt->get_result();
                                                $cnt = 1;
                                                
                                                while($row = $res->fetch_object()) {
                                                    $mysqlDateTime = $row->pay_date_generated;
                                                ?>
                                                <tr>
                                                    <td><?php echo $cnt;?></td>
                                                    <td><?php echo htmlspecialchars($row->pay_doc_name);?></td>
                                                    <td><?php echo htmlspecialchars($row->pay_doc_number);?></td>
                                                    <td><?php echo htmlspecialchars($row->pay_number);?></td> 
                                                    <td><?php echo date("M d, Y H:i", strtotime($mysqlDateTime));?></td>
                                                    <td>$<?php echo number_format($row->pay_emp_salary, 2);?></td>
                                                    <td>
                                                        <a href="generate_single_employee_payroll.php?pay_number=<?php echo $row->pay_number;?>&pay_doc_number=<?php echo $row->pay_doc_number;?>" 
                                                           class="btn btn-sm btn-outline-primary rounded-pill">
                                                           <i class="fas fa-file-invoice-dollar mr-1"></i> Generate
                                                        </a>
                                                    </td>
                                                </tr>
                                                <?php $cnt++; } ?>
                                            </tbody>
                                            <tfoot>
                                                <tr class="active">
                                                    <td colspan="7">
                                                        <div class="text-right">
                                                            <ul class="pagination pagination-rounded justify-content-end footable-pagination"></ul>
                                                        </div>
                                                    </td>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div> <!-- end .table-responsive-->
                                </div> <!-- end card-body -->
                            </div> <!-- end card -->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->
                </div> <!-- container -->
            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->
        </div>
        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->
    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- Footable js -->
    <script src="assets/libs/footable/footable.all.min.js"></script>

    <!-- Init js -->
    <script src="assets/js/pages/foo-tables.init.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
    
    <style>
        .card {
            border: none;
            box-shadow: 0 0.75rem 1.5rem rgba(18, 38, 63, 0.03);
        }
        
        .table thead th {
            border-bottom: 1px solid #f1f3f9;
            border-top: 0;
            font-weight: 600;
            text-transform: uppercase;
            font-size: 0.75rem;
            letter-spacing: 0.5px;
        }
        
        .table td, .table th {
            vertical-align: middle;
            padding: 1rem 0.75rem;
        }
        
        .table-hover tbody tr:hover {
            background-color: rgba(91, 115, 232, 0.05);
        }
        
        .search-box .search-icon {
            position: absolute;
            right: 15px;
            top: 12px;
            color: #98a6ad;
        }
        
        .btn-outline-primary {
            border-color: #5b73e8;
            color: #5b73e8;
        }
        
        .btn-outline-primary:hover {
            background-color: #5b73e8;
            color: white;
        }
        
        .page-title-box {
            padding: 20px 0;
        }
        
        .badge {
            font-weight: 500;
            padding: 0.35em 0.5em;
        }
    </style>
</body>
</html>