<?php
include('assets/inc/config.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['department_id'])) {
    $dept_id = $_POST['department_id'];

    // Fetch all matching records
    $query = "SELECT * FROM his_departments WHERE department_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param("i", $dept_id);
    $stmt->execute();
    $result = $stmt->get_result();

    $ailments = [];
    $fee = 0;

    while ($row = $result->fetch_assoc()) {
        $ailments[] = $row['ailment_name'];

        // Set the fee based on the department_type
        $fee = ($row['department_type'] == 'OutPatient') ? $row['opd_fee'] : $row['ipd_fee'];
    }

    echo json_encode([
        'ailments' => $ailments,
        'fee' => $fee
    ]);
}
