<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid=$_SESSION['ad_id'];
?>

<!DOCTYPE html>
<html lang="en">
    
<?php include('assets/inc/head.php');?>

    <body>

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
                <?php include('assets/inc/nav.php');?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
                <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box bg-gradient-primary">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Laboratory</a></li>
                                            <li class="breadcrumb-item active text-white">Add Laboratory Result</li>
                                        </ol>
                                    </div>
                                    <h4 class="page-title text-white">Patient Laboratory Records</h4>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 

                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                                        <h4 class="header-title">Patient Test Records</h4>
                                        <button class="btn btn-light btn-sm" onclick="window.print()">
                                            <i class="mdi mdi-printer mr-1"></i> Print
                                        </button>
                                    </div>
                                    <div class="card-body">
                                        <div class="mb-3">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <input id="demo-foo-search" type="text" placeholder="Search patients..." class="form-control" autocomplete="on">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="table-responsive">
                                            <table id="demo-foo-filtering" class="table table-hover table-bordered toggle-circle mb-0" data-page-size="10">
                                                <thead class="thead-light">
                                                <tr>
                                                    <th>#</th>
                                                    <th data-toggle="true">Patient Name</th>
                                                    <th data-hide="phone">Patient Number</th>
                                                    <th data-hide="phone">Patient Ailment</th>
                                                    <th data-hide="phone">Test Date</th>
                                                    <th>Action</th>
                                                </tr>
                                                </thead>
                                                <?php
                                                $ret="SELECT * FROM his_laboratory ORDER BY lab_date_rec DESC"; 
                                                $stmt= $mysqli->prepare($ret);
                                                $stmt->execute();
                                                $res=$stmt->get_result();
                                                $cnt=1;
                                                while($row=$res->fetch_object()):
                                                    $mysqlDateTime = $row->lab_date_rec;
                                                ?>
                                                <tbody>
                                                <tr>
                                                    <td><?php echo $cnt;?></td>
                                                    <td><?php echo $row->lab_pat_name;?></td>
                                                    <td><?php echo $row->lab_pat_number;?></td>
                                                    <td><?php echo $row->lab_pat_ailment;?></td>
                                                    <td><?php echo date("d/m/Y", strtotime($mysqlDateTime));?></td>
                                                    <td>
                                                        <a href="add_single_lab_result.php?lab_number=<?php echo $row->lab_number;?>" class="btn btn-sm btn-success">
                                                            <i class="mdi mdi-flask mr-1"></i> Add Result
                                                        </a>
                                                    </td>
                                                </tr>
                                                </tbody>
                                                <?php $cnt++; endwhile; ?>
                                                <tfoot>
                                                <tr class="active">
                                                    <td colspan="6">
                                                        <div class="text-right">
                                                            <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                        </div>
                                                    </td>
                                                </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                 <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- Footable js -->
        <script src="assets/libs/footable/footable.all.min.js"></script>

        <!-- Init js -->
        <script src="assets/js/pages/foo-tables.init.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
        <style>
            /* Color Scheme */
            .bg-gradient-primary {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
                border-radius: 0.25rem;
                box-shadow: 0 4px 20px 0 rgba(0,0,0,.14), 0 7px 10px -5px rgba(102, 126, 234, .4);
            }
            
            /* Card Styling */
            .card {
                border: none;
                box-shadow: 0 1px 15px rgba(0,0,0,0.1);
            }
            
            /* Table Styling */
            .table-hover tbody tr {
                transition: all 0.3s ease;
            }
            .table-hover tbody tr:hover {
                background-color: rgba(0, 123, 255, 0.05);
            }
            
            /* Button Styling */
            .btn-sm {
                padding: 0.25rem 0.5rem;
                font-size: 0.875rem;
            }
            
            /* Print Styles */
            @media print {
                body * {
                    visibility: hidden;
                }
                .card, .card * {
                    visibility: visible;
                }
                .card {
                    position: absolute;
                    left: 0;
                    top: 0;
                    width: 100%;
                    border: none;
                    box-shadow: none;
                }
                .no-print, .card-header button, .pagination {
                    display: none !important;
                }
                table {
                    width: 100% !important;
                }
                .table-bordered {
                    border: 1px solid #dee2e6 !important;
                }
                .table-bordered th,
                .table-bordered td {
                    border: 1px solid #dee2e6 !important;
                }
            }
        </style>
    </body>
</html>