<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid=$_SESSION['ad_id'];
?>

<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        :root {
            --primary: #4361ee;
            --primary-light: #eef2ff;
            --secondary: #3a0ca3;
            --success: #00b46e;
            --danger: #dc3545;
            --warning: #ff9e00;
            --info: #17a2b8;
            --light: #f8f9fc;
            --dark: #2b2d42;
            --gray: #6c757d;
            --border: #e0e3ff;
        }

        body {
            background: linear-gradient(135deg, #f8f9fc 0%, #e9ecef 100%);
            font-family: 'Inter', sans-serif;
            color: var(--dark);
        }

        #wrapper {
            background-color: rgba(255, 255, 255, 0.95);
            box-shadow: 0 0 30px rgba(0, 0, 0, 0.05);
        }

        .content-page {
            background: transparent;
        }

        .card-box {
            border-radius: 12px;
            box-shadow: 0 4px 24px rgba(0, 0, 0, 0.05);
            border: none;
            background-color: white;
            overflow: hidden;
            padding: 25px;
        }

        .page-title-box {
            padding: 20px 0;
            background: transparent;
        }

        .page-title {
            color: var(--dark);
            font-weight: 700;
        }

        .header-title {
            color: var(--primary);
            font-weight: 700;
            margin-bottom: 1.5rem;
            font-size: 1.5rem;
            border-bottom: 2px solid var(--primary-light);
            padding-bottom: 0.75rem;
        }

        .table-responsive {
            border-radius: 12px;
            overflow: hidden;
        }

        .table {
            margin-bottom: 0;
        }

        .table thead th {
            background-color: var(--primary);
            color: white;
            border-color: var(--primary);
            font-weight: 600;
            text-transform: uppercase;
            font-size: 0.8rem;
            letter-spacing: 0.5px;
        }

        .table tbody tr {
            transition: all 0.2s ease;
        }

        .table tbody tr:hover {
            background-color: var(--primary-light);
            transform: translateY(-1px);
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
        }

        .table tbody td {
            vertical-align: middle;
            border-color: var(--border);
        }

        .badge {
            padding: 0.5em 0.8em;
            font-weight: 600;
            letter-spacing: 0.5px;
            border-radius: 6px;
            transition: all 0.2s ease;
        }

        .badge-success {
            background-color: var(--success);
        }

        .badge:hover {
            transform: translateY(-2px);
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            opacity: 0.9;
        }

        .form-control {
            border-radius: 8px;
            border: 1px solid var(--border);
            transition: all 0.3s ease;
        }

        .form-control:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 0.2rem rgba(67, 97, 238, 0.25);
        }

        .pagination .page-item.active .page-link {
            background-color: var(--primary);
            border-color: var(--primary);
        }

        .pagination .page-link {
            color: var(--primary);
        }

        /* Quantity indicator styling */
        .quantity-low {
            color: var(--danger);
            font-weight: bold;
        }
        .quantity-medium {
            color: var(--warning);
        }
        .quantity-high {
            color: var(--success);
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .card-box {
                padding: 15px;
            }
            .table thead {
                display: none;
            }
            .table, .table tbody, .table tr, .table td {
                display: block;
                width: 100%;
            }
            .table tr {
                margin-bottom: 15px;
                border-radius: 8px;
                box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            }
            .table td {
                text-align: right;
                padding-left: 50%;
                position: relative;
                border-bottom: 1px solid var(--border);
            }
            .table td::before {
                content: attr(data-label);
                position: absolute;
                left: 15px;
                width: 45%;
                padding-right: 15px;
                font-weight: 600;
                color: var(--primary);
                text-align: left;
            }
        }
    </style>
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include('assets/inc/nav.php');?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Inventory</a></li>
                                        <li class="breadcrumb-item active">Pharmaceuticals Inventory</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Pharmaceutical Inventory Management</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 

                    <div class="row">
                        <div class="col-12">
                            <div class="card-box">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <h4 class="header-title">Pharmaceutical Inventory</h4>
                                    <a href="add_pharmaceutical.php" class="btn btn-primary">
                                        <i class="fas fa-plus-circle mr-1"></i> Add New
                                    </a>
                                </div>
                                
                                <div class="mb-3">
                                    <div class="row">
                                        <div class="col-12 text-sm-center form-inline">
                                            <div class="form-group">
                                                <input id="demo-foo-search" type="text" placeholder="Search pharmaceuticals..." class="form-control form-control-sm" autocomplete="on">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="table-responsive">
                                    <table id="demo-foo-filtering" class="table table-bordered toggle-circle mb-0" data-page-size="7">
                                        <thead>
                                        <tr>
                                            <th>#</th>
                                            <th data-toggle="true">Name</th>
                                            <th data-hide="phone">Barcode</th>
                                            <th data-hide="phone">Vendor</th>
                                            <th data-hide="phone">Category</th>
                                            <th data-hide="phone">Quantity</th>
                                            <th data-hide="phone">Actions</th>
                                        </tr>
                                        </thead>
                                        <?php
                                            $ret = "SELECT * FROM his_pharmaceuticals ORDER BY RAND()"; 
                                            $stmt = $mysqli->prepare($ret);
                                            $stmt->execute();
                                            $res = $stmt->get_result();
                                            $cnt = 1;
                                            while($row = $res->fetch_object()):
                                                // Determine quantity class
                                                $quantityClass = 'quantity-high';
                                                if ($row->phar_qty < 10) {
                                                    $quantityClass = 'quantity-low';
                                                } elseif ($row->phar_qty < 20) {
                                                    $quantityClass = 'quantity-medium';
                                                }
                                        ?>
                                            <tbody>
                                            <tr>
                                                <td><?php echo $cnt;?></td>
                                                <td><?php echo htmlspecialchars($row->phar_name);?></td>
                                                <td><?php echo htmlspecialchars($row->phar_bcode);?></td>
                                                <td><?php echo htmlspecialchars($row->phar_vendor);?></td>
                                                <td><?php echo htmlspecialchars($row->phar_cat);?></td>
                                                <td class="<?php echo $quantityClass; ?>"><?php echo htmlspecialchars($row->phar_qty);?> Cartons</td>
                                                <td>
                                                    <a href="view_single_pharm.php?phar_bcode=<?php echo $row->phar_bcode;?>" class="badge badge-success">
                                                        <i class="far fa-eye mr-1"></i> View
                                                    </a>
                                                  
                                                </td>
                                            </tr>
                                            </tbody>
                                        <?php $cnt++; endwhile; ?>
                                        <tfoot>
                                        <tr class="active">
                                            <td colspan="8">
                                                <div class="text-right">
                                                    <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                </div>
                                            </td>
                                        </tr>
                                        </tfoot>
                                    </table>
                                </div> <!-- end .table-responsive-->
                            </div> <!-- end card-box -->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- container -->

            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- Footable js -->
    <script src="assets/libs/footable/footable.all.min.js"></script>

    <!-- Init js -->
    <script src="assets/js/pages/foo-tables.init.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
    
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    
</body>
</html>