<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();

if(isset($_GET['pat_id'])) {
    $pat_id = intval($_GET['pat_id']);
    
    $ret = "SELECT * FROM his_patients WHERE pat_id=?";
    $stmt = $mysqli->prepare($ret);
    $stmt->bind_param('i', $pat_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $patient = $res->fetch_object();
    
    if(!$patient) {
        header("Location: manage_invoices.php");
        exit;
    }
} else {
    header("Location: manage_invoices.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice - <?php echo $patient->pat_fname . ' ' . $patient->pat_lname; ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #fff;
            padding: 20px;
        }
        .invoice-container {
            max-width: 800px;
            margin: 0 auto;
            border: 1px solid #ddd;
            padding: 30px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        .header {
            display: flex;
            justify-content: space-between;
            margin-bottom: 30px;
            border-bottom: 2px solid #4e73df;
            padding-bottom: 20px;
        }
        .hospital-info h2 {
            color: #4e73df;
            margin: 0;
        }
        .invoice-info {
            text-align: right;
        }
        .invoice-title {
            text-align: center;
            margin: 20px 0;
            color: #4e73df;
            font-size: 24px;
        }
        .patient-info, .service-info {
            margin-bottom: 20px;
        }
        .details-table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        .details-table th, .details-table td {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: left;
        }
        .details-table th {
            background-color: #f8f9fc;
        }
        .total {
            text-align: right;
            font-size: 18px;
            font-weight: bold;
            margin-top: 20px;
        }
        .footer {
            margin-top: 50px;
            text-align: center;
            font-size: 12px;
            color: #777;
        }
        .status-badge {
            padding: 5px 10px;
            border-radius: 20px;
            font-weight: bold;
            display: inline-block;
        }
        .status-paid {
            background-color: #d4edda;
            color: #155724;
        }
        .status-pending {
            background-color: #fff3cd;
            color: #856404;
        }
        .status-cancelled {
            background-color: #f8d7da;
            color: #721c24;
        }
        .status-rejected {
            background-color: #d6d8db;
            color: #1b1e21;
        }
        @media print {
            body {
                padding: 0;
            }
            .no-print {
                display: none;
            }
            .invoice-container {
                border: none;
                box-shadow: none;
                padding: 0;
            }
        }
    </style>
</head>
<body>
    <div class="invoice-container">
        <div class="header">
            <div class="hospital-info">
                <?php
include('assets/inc/config.php');

// Fetch system settings
$query = "SELECT * FROM his_system_settings LIMIT 1";
$result = $mysqli->query($query);
$settings = $result->fetch_assoc();
?>
 <?php if(!empty($settings['system_logo'])): ?>
                            <img src="<?php echo htmlspecialchars($settings['system_logo']); ?>" alt="<?php echo htmlspecialchars($settings['system_name']); ?> logo" height="50" />
                        <?php else: ?>
                            <img src="img/Medical.png" alt="Medical logo" height="50" />
                        <?php endif; ?>
                <h2><?php echo htmlspecialchars($settings['system_name'] ?? 'AFLUX Hospital'); ?></h2>
                <p><?php echo htmlspecialchars($settings['system_address'] ?? 'AFLUX Hospital'); ?></p>
                
                <p>Phone: <?php echo htmlspecialchars($settings['system_phone'] ?? 'AFLUX Hospital'); ?></p>
            </div>
            <div class="invoice-info">
                <h3>INVOICE</h3>
                <p>Invoice #: <?php echo $patient->pat_number; ?></p>
                <p>Date: <?php echo date('F j, Y', strtotime($patient->pat_date_joined)); ?></p>
                <p>Status: 
                    <span class="status-badge status-<?php echo $patient->psataus; ?>">
                        <?php echo ucfirst($patient->psataus); ?>
                    </span>
                </p>
            </div>
        </div>
        
        <div class="patient-info">
            <h4>Patient Information</h4>
            <p><strong>Name:</strong> <?php echo $patient->pat_fname . ' ' . $patient->pat_lname; ?></p>
            <p><strong>Patient ID:</strong> <?php echo $patient->pat_number; ?></p>
            <p><strong>Date of Birth:</strong> <?php echo $patient->pat_dob; ?></p>
            <p><strong>Phone:</strong> <?php echo $patient->pat_phone; ?></p>
            <p><strong>Insurance:</strong> <?php echo $patient->insurance; ?></p>
        </div>
        
        <div class="service-info">
            <h4>Service Details</h4>
            <table class="details-table">
                <thead>
                    <tr>
                        <th>Description</th>
                        <th>Type</th>
                        <th>Department</th>
                        <th>Amount</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?php echo $patient->pat_ailment; ?></td>
                        <td><?php echo $patient->pat_type; ?></td>
                       <td>
    <?php 
    // First, fetch the department name
    $dept_query = "SELECT department_name FROM his_departments WHERE department_id = ?";
    $dept_stmt = $mysqli->prepare($dept_query);
    $dept_stmt->bind_param('i', $patient->dept);
    $dept_stmt->execute();
    $dept_result = $dept_stmt->get_result();
    
    if ($dept_result && $dept_result->num_rows > 0) {
        $dept_row = $dept_result->fetch_object();
        echo htmlspecialchars($dept_row->department_name);
    } else {
        // Fallback to show ID if name not found
        echo "Department #" . htmlspecialchars($patient->dept);
    }
    $dept_stmt->close();
    ?>
</td>
                        <td>$<?php echo $patient->fee; ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
        
        <div class="total">
            <p>Total Amount Due: <strong>$<?php echo $patient->fee; ?></strong></p>
        </div>
        
        <div class="footer">
            <p>Thank you for choosing our hospital. Please make payment within 30 days.</p>
            <p>For any questions regarding this invoice, please contact our billing department.</p>
        </div>
        
        <div class="no-print" style="text-align: center; margin-top: 20px;">
            <button onclick="window.print()" class="btn btn-primary">Print Invoice</button>
            <button onclick="window.close()" class="btn btn-secondary">Close</button>
        </div>
    </div>
    
    <script>
        // Automatically trigger print dialog when page loads
        window.onload = function() {
            setTimeout(function() {
                window.print();
            }, 1000);
        };
    </script>
</body>
</html>