<?php
session_start();
include('assets/inc/config.php');

$response = ['success' => false, 'message' => ''];

if(isset($_POST['department_id'])) {
    $department_id = intval($_POST['department_id']);
    $department_type = trim($_POST['department_type']);
    $department_name = trim($_POST['department_name']);
    $opd_fee = ($department_type == 'OPD') ? trim($_POST['opd_fee']) : 0;
    $ipd_fee = ($department_type == 'IPD') ? trim($_POST['ipd_fee']) : 0;
    $department_description = trim($_POST['department_description']);
    $ailment_name = trim($_POST['ailment_name']);

    $query = "UPDATE his_departments SET 
             department_type = ?, 
             department_name = ?, 
             opd_fee = ?, 
             ipd_fee = ?,
             department_description = ?, 
             ailment_name = ?
             WHERE department_id = ?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('ssddssi', 
        $department_type, 
        $department_name, 
        $opd_fee,
        $ipd_fee,
        $department_description, 
        $ailment_name,
        $department_id
    );
    
    if($stmt->execute()) {
        $response['success'] = true;
        $response['message'] = "Department updated successfully";
    } else {
        $response['message'] = "Error updating department: " . $stmt->error;
    }
} else {
    $response['message'] = "Invalid request";
}

header('Content-Type: application/json');
echo json_encode($response);
?>