<?php
session_start();
include('assets/inc/config.php');
if(isset($_POST['update_acc']))
{
    $acc_name = $_POST['acc_name'];
    $acc_desc = $_POST['acc_desc'];
    $acc_type = $_POST['acc_type'];
    $acc_number = $_GET['acc_number'];
    $acc_amount = $_POST['acc_amount'];

    $query = "UPDATE his_accounts SET acc_name=?, acc_desc=?, acc_type=?, acc_amount=? WHERE acc_number = ?";
    $stmt = $mysqli->prepare($query);
    $rc = $stmt->bind_param('sssss', $acc_name, $acc_desc, $acc_type, $acc_amount, $acc_number);
    $stmt->execute();
    
    if($stmt)
    {
        $success = "Account Receivable Details Updated";
    }
    else {
        $err = "Please Try Again Or Try Later";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        :root {
            --primary: #4361ee;
            --primary-light: #eef2ff;
            --secondary: #3a0ca3;
            --success: #00b46e;
            --danger: #dc3545;
            --warning: #ff9e00;
            --info: #17a2b8;
            --light: #f8f9fc;
            --dark: #2b2d42;
            --gray: #6c757d;
            --border: #e0e3ff;
        }

        body {
            background: linear-gradient(135deg, #f8f9fc 0%, #e9ecef 100%);
            font-family: 'Inter', sans-serif;
            color: var(--dark);
        }

        #wrapper {
            background-color: rgba(255, 255, 255, 0.95);
            box-shadow: 0 0 30px rgba(0, 0, 0, 0.05);
        }

        .content-page {
            background: transparent;
        }

        .card {
            border-radius: 12px;
            box-shadow: 0 4px 24px rgba(0, 0, 0, 0.05);
            border: none;
            background-color: white;
            overflow: hidden;
        }

        .card-body {
            padding: 2rem;
        }

        .page-title-box {
            padding: 20px 0;
            background: transparent;
        }

        .page-title {
            color: var(--dark);
            font-weight: 700;
        }

        .header-title {
            color: var(--primary);
            font-weight: 700;
            margin-bottom: 1.5rem;
            font-size: 1.5rem;
            border-bottom: 2px solid var(--primary-light);
            padding-bottom: 0.75rem;
        }

        .form-control {
            border: 1px solid var(--border);
            border-radius: 8px;
            padding: 0.75rem 1rem;
            font-size: 0.95rem;
            transition: all 0.3s;
        }

        .form-control:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 0.2rem rgba(67, 97, 238, 0.25);
        }

        label {
            font-weight: 600;
            color: var(--dark);
            margin-bottom: 0.5rem;
        }

        .btn-warning {
            background-color: var(--warning);
            border-color: var(--warning);
            color: white;
            padding: 0.75rem 1.5rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            transition: all 0.3s;
        }

        .btn-warning:hover {
            background-color: #e69100;
            border-color: #e69100;
            color: white;
            transform: translateY(-1px);
        }

        /* CKEditor 5 custom styling */
        .ck.ck-editor {
            max-width: 100%;
            margin-bottom: 1rem;
        }
        .ck.ck-editor__main>.ck-editor__editable {
            min-height: 200px;
            border: 1px solid var(--border) !important;
            border-radius: 0.35rem !important;
        }
        .ck.ck-editor__main>.ck-editor__editable:focus {
            border-color: var(--primary) !important;
            box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25) !important;
        }

        /* Alert styling */
        .alert {
            border-radius: 8px;
            border: none;
            padding: 1rem 1.5rem;
        }

        .alert-success {
            background-color: rgba(0, 180, 110, 0.1);
            color: var(--success);
            border-left: 4px solid var(--success);
        }

        .alert-danger {
            background-color: rgba(220, 53, 69, 0.1);
            color: var(--danger);
            border-left: 4px solid var(--danger);
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .card-body {
                padding: 1.5rem;
            }
            .form-row {
                flex-direction: column;
            }
            .form-group {
                margin-bottom: 1rem;
            }
        }
    </style>
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include("assets/inc/nav.php");?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->
        <?php
            $acc_number = $_GET['acc_number'];
            $ret = "SELECT * FROM his_accounts WHERE acc_number=?";
            $stmt = $mysqli->prepare($ret);
            $stmt->bind_param('i',$acc_number);
            $stmt->execute();
            $res = $stmt->get_result();
            
            while($row = $res->fetch_object()):
        ?>
        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Accounting</a></li>
                                        <li class="breadcrumb-item active">Manage Receivable Account</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Receivable Account Details</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 
                    
                    <?php if(isset($success)) { ?>
                        <div class="alert alert-success alert-dismissible fade show mb-3" role="alert">
                            <strong>Success!</strong> <?php echo $success; ?>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php } ?>
                    
                    <?php if(isset($err)) { ?>
                        <div class="alert alert-danger alert-dismissible fade show mb-3" role="alert">
                            <strong>Error!</strong> <?php echo $err; ?>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php } ?>

                    <!-- Form row -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">Update Account Details</h4>
                                    
                                    <form method="post">
                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label for="acc_name" class="col-form-label">Account Name</label>
                                                <input type="text" required name="acc_name" class="form-control" id="acc_name" value="<?php echo htmlspecialchars($row->acc_name); ?>">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label for="acc_amount" class="col-form-label">Account Amount ($)</label>
                                                <input type="text" required name="acc_amount" class="form-control" id="acc_amount" value="<?php echo htmlspecialchars($row->acc_amount); ?>">
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="editor" class="col-form-label">Account Description</label>
                                            <textarea required name="acc_desc" class="form-control" id="editor"><?php echo htmlspecialchars($row->acc_desc); ?></textarea>
                                        </div>

                                        <div class="form-group" style="display:none">
                                            <label for="acc_type" class="col-form-label">Account Type</label>
                                            <input required value="Receivable Account" type="text" class="form-control" name="acc_type" id="acc_type">
                                        </div>

                                        <button type="submit" name="update_acc" class="ladda-button btn btn-warning" data-style="expand-right">
                                            <span class="ladda-label">Update Account</span>
                                        </button>

                                    </form>
                                </div> <!-- end card-body -->
                            </div> <!-- end card-->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- container -->

            </div> <!-- content -->
        <?php endwhile; ?>

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- CKEditor 5 -->
    <script src="https://cdn.ckeditor.com/ckeditor5/41.3.1/classic/ckeditor.js"></script>
    <script>
        ClassicEditor
            .create(document.querySelector('#editor'), {
                toolbar: {
                    items: [
                        'heading', '|',
                        'bold', 'italic', 'link', 'bulletedList', 'numberedList', '|',
                        'undo', 'redo'
                    ]
                },
                heading: {
                    options: [
                        { model: 'paragraph', title: 'Paragraph', class: 'ck-heading_paragraph' },
                        { model: 'heading1', view: 'h1', title: 'Heading 1', class: 'ck-heading_heading1' },
                        { model: 'heading2', view: 'h2', title: 'Heading 2', class: 'ck-heading_heading2' }
                    ]
                }
            })
            .catch(error => {
                console.error(error);
            });
    </script>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App js-->
    <script src="assets/js/app.min.js"></script>

    <!-- Loading buttons js -->
    <script src="assets/libs/ladda/spin.js"></script>
    <script src="assets/libs/ladda/ladda.js"></script>

    <!-- Buttons init js-->
    <script src="assets/js/pages/loading-btn.init.js"></script>
    
</body>
</html>