<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $doc_id = $_SESSION['doc_id'];

  /*Doctor Cant delete their payrolls 
  oh but if you need yours to be able to delete their payrolls
  then uncomment this bunch of code
  
  if(isset($_GET['delete_pay_number']))
  {
        $id=intval($_GET['delete_pay_number']);
        $adn="delete from his_payrolls where pay_number=?";
        $stmt= $mysqli->prepare($adn);
        $stmt->bind_param('i',$id);
        $stmt->execute();
        $stmt->close();  
  
          if($stmt)
          {
            $success = "Payroll Record Deleted";
          }
            else
            {
                $err = "Try Again Later";
            }
    }
    */
?>

<!DOCTYPE html>
<html lang="en">
    
<?php include('assets/inc/head.php');?>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include('assets/inc/nav.php');?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Payroll</a></li>
                                        <li class="breadcrumb-item active">My Payrolls</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">
                                    <i class="mdi mdi-cash-multiple mr-1"></i>
                                    My Payroll Records
                                </h4>
                                <p class="text-muted mb-0">View and manage your payroll information</p>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header bg-primary text-white">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <h4 class="header-title mb-0 text-white">
                                            <i class="mdi mdi-file-document-box-outline mr-1"></i>
                                            Payroll History
                                        </h4>
                                        <div class="search-box">
                                            <div class="position-relative">
                                                <input id="demo-foo-search" type="text" class="form-control rounded-pill" placeholder="Search payrolls..." autocomplete="on">
                                                <i class="fas fa-search search-icon"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="demo-foo-filtering" class="table table-hover table-centered mb-0" data-page-size="10">
                                            <thead class="thead-light">
                                            <tr>
                                                <th>#</th>
                                                <th data-toggle="true">Payroll Details</th>
                                                <th>Salary</th>
                                                <th>Status</th>
                                                <th>Action</th>
                                            </tr>
                                            </thead>
                                            <?php
                                                $pay_doc_number = $_SESSION['doc_number'];
                                                $ret="SELECT * FROM his_payrolls WHERE pay_doc_number = ?";
                                                $stmt= $mysqli->prepare($ret);
                                                $stmt->bind_param('s',$pay_doc_number);
                                                $stmt->execute();
                                                $res=$stmt->get_result();
                                                $cnt=1;
                                                while($row=$res->fetch_object()):
                                            ?>
                                            <tbody>
                                            <tr>
                                                <td><?php echo $cnt;?></td>
                                                <td>
                                                    <div class="d-flex flex-column">
                                                        <h5 class="m-0 font-14"><?php echo $row->pay_doc_name;?></h5>
                                                        <div class="d-flex">
                                                            <small class="text-muted mr-2">
                                                                <i class="mdi mdi-identifier mr-1"></i> <?php echo $row->pay_doc_number;?>
                                                            </small>
                                                            <small class="text-muted">
                                                                <i class="mdi mdi-numeric mr-1"></i> <?php echo $row->pay_number;?>
                                                            </small>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <span class="font-weight-bold text-success">$<?php echo number_format($row->pay_emp_salary, 2);?></span>
                                                </td>
                                                <td>
                                                   Processed</span>
                                                </td>
                                                <td>
                                                    <a href="view_single_payroll.php?pay_number=<?php echo $row->pay_number;?>" 
                                                       class="btn btn-sm btn-primary rounded-pill">
                                                       <i class="mdi mdi-eye-outline mr-1"></i> View
                                                    </a>
                                                </td>
                                            </tr>
                                            </tbody>
                                            <?php $cnt = $cnt +1; endwhile; ?>
                                            <tfoot>
                                            <tr>
                                                <td colspan="5">
                                                    <div class="text-right">
                                                        <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                    </div>
                                                </td>
                                            </tr>
                                            </tfoot>
                                        </table>
                                    </div> <!-- end .table-responsive-->
                                </div> <!-- end card-body -->
                            </div> <!-- end card -->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- container -->

            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- Footable js -->
    <script src="assets/libs/footable/footable.all.min.js"></script>

    <!-- Init js -->
    <script src="assets/js/pages/foo-tables.init.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
    
</body>
</html>