<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid=$_SESSION['ad_id'];
?>

<!DOCTYPE html>
<html lang="en">

<?php include('assets/inc/head.php');?>

<body style="background-color: #f8f9fc">

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include("assets/inc/nav.php");?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================= -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <!--Get Details Of A Single User And Display Them Here-->
        <?php
            $doc_id=$_GET['doc_id'];
            $ret="SELECT  * FROM his_docs WHERE doc_id=?";
            $stmt= $mysqli->prepare($ret) ;
            $stmt->bind_param('i',$doc_id);
            $stmt->execute() ;//ok
            $res=$stmt->get_result();
            $doc_number=$_GET['doc_number'];
            while($row=$res->fetch_object())
        {
        ?>
        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">

                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);" style="color: #6c757d">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);" style="color: #6c757d">Employees</a></li>
                                        <li class="breadcrumb-item active" style="color: #4361ee">View Employees</li>
                                    </ol>
                                </div>
                                <h4 class="page-title" style="color: #2b2d42">
                                    <?php echo $row->doc_fname;?> <?php echo $row->doc_lname;?>'s Profile
                                    <span class="badge bg-soft-primary text-primary" style="font-size: 0.7rem; vertical-align: middle">ID: <?php echo $row->doc_number;?></span>
                                </h4>
                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <style>
    /* Profile Card Styling */
    .profile-card {
        background: white;
        border-radius: 12px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.05);
        border: none;
        transition: all 0.3s ease;
        overflow: hidden;
    }
    
    .profile-card:hover {
        box-shadow: 0 10px 30px rgba(67, 97, 238, 0.1);
        transform: translateY(-3px);
    }
    
    .profile-img-container {
        background: linear-gradient(135deg, #4361ee 0%, #3a0ca3 100%);
        padding: 20px;
        text-align: center;
    }
    
    .profile-img {
        width: 150px;
        height: 150px;
        object-fit: cover;
        border: 5px solid white;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        transition: all 0.3s ease;
    }
    
    .profile-img:hover {
        transform: scale(1.05);
    }
    
    .profile-details {
        padding: 25px;
    }
    
    .detail-item {
        display: flex;
        align-items: center;
        margin-bottom: 18px;
        padding-bottom: 18px;
        border-bottom: 1px solid #f1f3f9;
    }
    
    .detail-item:last-child {
        border-bottom: none;
        margin-bottom: 0;
        padding-bottom: 0;
    }
    
    .detail-icon {
        width: 40px;
        height: 40px;
        background: #f0f4ff;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 15px;
        color: #4361ee;
        font-size: 18px;
    }
    
    .detail-label {
        font-weight: 600;
        color: #2b2d42;
        display: block;
        margin-bottom: 2px;
    }
    
    .detail-value {
        color: #6c757d;
    }
    
    /* Vitals Table Styling */
    .vitals-card {
        background: white;
        border-radius: 12px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.05);
        border: none;
        transition: all 0.3s ease;
    }
    
    .vitals-card:hover {
        box-shadow: 0 10px 30px rgba(67, 97, 238, 0.1);
    }
    
    .vitals-table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0;
    }
    
    .vitals-table th {
        background-color: #f8f9fc;
        color: #4361ee;
        font-weight: 600;
        padding: 12px 15px;
        border-bottom: 2px solid #e0e3ff;
    }
    
    .vitals-table td {
        padding: 12px 15px;
        border-bottom: 1px solid #f1f3f9;
        vertical-align: middle;
    }
    
    .vitals-table tr:last-child td {
        border-bottom: none;
    }
    
    .vitals-table tr:hover {
        background-color: #f8f9ff;
    }
    
    /* Responsive adjustments */
    @media (max-width: 768px) {
        .profile-img {
            width: 120px;
            height: 120px;
        }
        
        .vitals-table th, 
        .vitals-table td {
            padding: 8px 10px;
            font-size: 14px;
        }
    }
</style>

<div class="row">
    <div class="col-lg-6 col-xl-6 mb-4">
        <div class="card-box profile-card">
            <div class="profile-img-container">
                <img src="../doc/assets/images/users/<?php echo $row->doc_dpic;?>" class="rounded-circle profile-img img-thumbnail" alt="profile-image">
            </div>
            
            <div class="profile-details">
                <div class="detail-item">
                    <div class="detail-icon">
                        <i class="mdi mdi-account"></i>
                    </div>
                    <div>
                        <span class="detail-label">Full Name</span>
                        <span class="detail-value"><?php echo $row->doc_fname;?> <?php echo $row->doc_lname;?></span>
                    </div>
                </div>
                
                <div class="detail-item">
                    <div class="detail-icon">
                        <i class="mdi mdi-hospital-building"></i>
                    </div>
                    <div>
                        <span class="detail-label">Department</span>
                        <span class="detail-value"><?php echo $row->doc_dept;?></span>
                    </div>
                </div>
                
                <div class="detail-item">
                    <div class="detail-icon">
                        <i class="mdi mdi-identifier"></i>
                    </div>
                    <div>
                        <span class="detail-label">Employee Number</span>
                        <span class="detail-value"><?php echo $row->doc_number;?></span>
                    </div>
                </div>
                
                <div class="detail-item">
                    <div class="detail-icon">
                        <i class="mdi mdi-email"></i>
                    </div>
                    <div>
                        <span class="detail-label">Email</span>
                        <span class="detail-value"><?php echo $row->doc_email;?></span>
                    </div>
                </div>
            </div>
        </div> <!-- end card-box -->
    </div> <!-- end col-->
    
    <!--Vitals-->
    <div class="col-lg-6 col-xl-6 mb-4">
        <div class="card-box vitals-card p-4">
            <h4 class="header-title mb-3" style="color: #2b2d42">Vital Signs History</h4>
            <div class="table-responsive">
                <table class="table vitals-table table-hover mb-0">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Temp (°C)</th>
                            <th>Pulse (BPM)</th>
                            <th>Resp. Rate</th>
                            <th>BP (mmHg)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            $vit_pat_number = $_GET['doc_number'];
                            $ret = "SELECT * FROM his_vitals WHERE vit_pat_number = ? ORDER BY vit_daterec DESC";
                            $stmt = $mysqli->prepare($ret);
                            $stmt->bind_param('s', $vit_pat_number);
                            $stmt->execute();
                            $res = $stmt->get_result();
                            
                            while($row_vit = $res->fetch_object()) {
                                $mysqlDateTime = $row_vit->vit_daterec;
                        ?>
                        <tr>
                            <td><?php echo date("Y-m-d", strtotime($mysqlDateTime));?></td>
                            <td><?php echo $row_vit->vit_bodytemp;?></td>
                            <td><?php echo $row_vit->vit_heartpulse;?></td>
                            <td><?php echo $row_vit->vit_resprate;?></td>
                            <td><?php echo $row_vit->vit_bloodpress;?></td>
                        </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div> <!-- end col-->
</div>
                    <!-- end row-->

                </div> <!-- container -->

            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->

        </div>
        <?php }?>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>

</body>
</html>