<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];
?>
<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <!-- Quill Editor CSS -->
    <link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
    <style>
        :root {
            --primary: #4361ee;
            --primary-light: #eef2ff;
            --secondary: #3a0ca3;
            --success: #00b46e;
            --danger: #dc3545;
            --warning: #ff9e00;
            --light: #f8f9fc;
            --dark: #2b2d42;
            --gray: #495057;
            --border: #e0e3ff;
        }

        body {
            background: linear-gradient(135deg, #f8f9fc 0%, #e9ecef 100%);
            font-family: 'Inter', sans-serif;
            color: var(--dark);
        }

        #wrapper {
            background-color: rgba(255, 255, 255, 0.95);
            box-shadow: 0 0 30px rgba(0, 0, 0, 0.05);
        }

        .content-page {
            background: transparent;
        }

        .card-box {
            border-radius: 12px;
            box-shadow: 0 4px 24px rgba(0, 0, 0, 0.05);
            border: none;
            background-color: white;
            overflow: hidden;
        }

        .page-title-box {
            padding: 20px 0;
            background: transparent;
        }

        .page-title {
            color: var(--dark);
            font-weight: 700;
        }

        img.img-fluid {
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            border: 3px solid white;
            transition: transform 0.3s ease;
        }

        img.img-fluid:hover {
            transform: scale(1.02);
        }

        h2, h4 {
            color: var(--dark);
            margin-bottom: 1rem;
        }

        h2 {
            font-weight: 700;
            color: var(--primary);
        }

        .text-danger {
            color: var(--danger) !important;
        }

        hr {
            border-top: 1px solid var(--border);
            margin: 1.5rem 0;
        }

        .text-muted {
            color: var(--gray) !important;
        }

        /* Quill Editor styling for display */
        .ql-container {
            border: none !important;
            font-family: inherit;
            font-size: 1rem;
            padding: 0;
        }

        .ql-editor {
            padding: 0;
            line-height: 1.6;
        }

        .ql-editor p {
            margin-bottom: 1rem;
        }

        .ql-editor ul, 
        .ql-editor ol {
            padding-left: 1.5rem;
            margin-bottom: 1rem;
        }

        /* Account details card */
        .account-detail-card {
            background: linear-gradient(135deg, var(--primary-light) 0%, white 100%);
            border-radius: 12px;
            padding: 2rem;
            height: 100%;
        }

        .detail-label {
            font-weight: 600;
            color: var(--secondary);
            font-size: 0.9rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 0.5rem;
        }

        .detail-value {
            color: var(--dark);
            font-weight: 500;
            font-size: 1.1rem;
            margin-bottom: 1.5rem;
        }

        /* Print-specific styles */
        @media print {
            body * {
                visibility: hidden;
            }
            #printable-area, #printable-area * {
                visibility: visible;
            }
            #printable-area {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                background: white;
                padding: 20px;
            }
            .no-print {
                display: none !important;
            }
            .account-detail-card {
                background: white !important;
                box-shadow: none !important;
                padding: 0 !important;
            }
            .page-title-box {
                padding: 0 0 20px 0 !important;
            }
            .detail-label {
                color: black !important;
            }
        }

        /* Action buttons */
        .action-buttons {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
        }
        .btn-print {
            background-color: var(--warning);
            border-color: var(--warning);
            color: white;
        }
        .btn-print:hover {
            background-color: #e69100;
            border-color: #e69100;
            color: white;
        }

        @media (max-width: 768px) {
            .pl-xl-3 {
                padding-left: 0 !important;
                margin-top: 1.5rem;
            }
            .action-buttons {
                flex-direction: column;
            }
        }
    </style>
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include('assets/inc/nav.php');?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->
        <?php
            $acc_number = $_GET['acc_number'];
            $ret = "SELECT * FROM his_accounts WHERE acc_number = ?";
            $stmt = $mysqli->prepare($ret);
            $stmt->bind_param('i', $acc_number);
            $stmt->execute();
            $res = $stmt->get_result();
            
            while($row = $res->fetch_object()):
        ?>

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Accounts</a></li>
                                            <li class="breadcrumb-item active">View Payable Account</li>
                                        </ol>
                                    </div>
                                    <h4 class="page-title">Account Details</h4>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 

                        <div class="row">
                            <div class="col-12">
                                <div class="action-buttons no-print">
                                    <button onclick="window.print()" class="btn btn-print">
                                        <i class="fas fa-print mr-1"></i> Print Account
                                    </button>
                                    <a href="javascript:history.back()" class="btn btn-secondary">
                                        <i class="fas fa-arrow-left mr-1"></i> Back
                                    </a>
                                </div>
                                
                                <div class="card-box" id="printable-area">
                                    <div class="row">
                                        <div class="col-xl-12">
                                            <div class="account-detail-card">
                                                <h2 class="mb-4">Account #<?php echo htmlspecialchars($row->acc_number); ?></h2>
                                                
                                                <div class="detail-item">
                                                    <div class="detail-label">Account Name</div>
                                                    <div class="detail-value"><?php echo htmlspecialchars($row->acc_name); ?></div>
                                                </div>
                                                
                                                <div class="detail-item">
                                                    <div class="detail-label">Account Type</div>
                                                    <div class="detail-value"><?php echo htmlspecialchars($row->acc_type); ?></div>
                                                </div>
                                                
                                                <div class="detail-item">
                                                    <div class="detail-label">Account Amount</div>
                                                    <div class="detail-value text-danger">$<?php echo number_format($row->acc_amount, 2); ?></div>
                                                </div>
                                                
                                                <div class="detail-item">
                                                    <div class="detail-label">Account Description</div>
                                                    <div id="account-description-editor" class="ql-container ql-snow">
                                                        <div class="ql-editor">
                                                            <?php echo $row->acc_desc; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div> <!-- end col -->
                                    </div>
                                    <!-- end row -->
                                </div> <!-- end card-->
                            </div> <!-- end col-->
                        </div>
                        <!-- end row-->
                        
                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>
        <?php endwhile; ?>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- Quill Editor JS -->
    <script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>
    
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    
    <script>
        // Initialize Quill editor for display only
        document.addEventListener('DOMContentLoaded', function() {
            // This is just for display, no actual editor functionality
            const editor = new Quill('#account-description-editor', {
                readOnly: true,
                modules: {
                    toolbar: false
                },
                theme: 'snow'
            });
            
            // Add a print button event listener for better control
            document.querySelector('.btn-print').addEventListener('click', function() {
                window.print();
            });
        });
    </script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
    
</body>
</html>