<?php
session_start();
include('assets/inc/config.php');
if(isset($_POST['add_equipments'])) {
    $eqp_code = $_POST['eqp_code'];
    $eqp_name = $_POST['eqp_name'];
    $eqp_vendor = $_POST['eqp_vendor'];
    $eqp_desc = $_POST['eqp_desc'];
    $eqp_dept = $_POST['eqp_dept'];
    $eqp_status = $_POST['eqp_status'];
    $eqp_qty = $_POST['eqp_qty'];
        
    $query = "INSERT INTO his_equipments (eqp_code, eqp_name, eqp_vendor, eqp_desc, eqp_dept, eqp_status, eqp_qty) VALUES (?,?,?,?,?,?,?)";
    $stmt = $mysqli->prepare($query);
    $rc = $stmt->bind_param('sssssss', $eqp_code, $eqp_name, $eqp_vendor, $eqp_desc, $eqp_dept, $eqp_status, $eqp_qty);
    $stmt->execute();
    
    if($stmt) {
        $success = "Laboratory Equipment Added Successfully";
    } else {
        $err = "Please Try Again Or Try Later";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <!-- CKEditor 5 CDN -->
    <script src="https://cdn.ckeditor.com/ckeditor5/41.1.0/classic/ckeditor.js"></script>
    <style>
        /* Modern Healthcare Color Palette */
        :root {
            --primary: #3a7bd5;
            --secondary: #00d2ff;
            --accent: #ff6b6b;
            --light: #f8f9fa;
            --dark: #343a40;
        }
        
        /* Animated Gradient Background */
        body {
            background: linear-gradient(-45deg, #f5f7fa, #e4f0fb, #f0f5ff, #e6f7ff);
            background-size: 400% 400%;
            animation: gradientBG 15s ease infinite;
            min-height: 100vh;
        }
        
        @keyframes gradientBG {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }
        
        /* Content Wrapper */
        .content-page {
            background: rgba(255, 255, 255, 0.95);
            margin-left: 260px;
            min-height: 100vh;
            box-shadow: 0 0 40px rgba(0, 0, 0, 0.08);
            animation: fadeIn 0.5s ease-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        /* Card Styling */
        .card {
            border: none;
            border-radius: 12px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            overflow: hidden;
            transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
            animation: cardEnter 0.6s ease-out;
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.12);
        }
        
        @keyframes cardEnter {
            from { opacity: 0; transform: scale(0.95); }
            to { opacity: 1; transform: scale(1); }
        }
        
        /* Form Elements */
        .form-control {
            border-radius: 8px;
            padding: 12px 15px;
            border: 1px solid #e0e6f5;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 0.2rem rgba(58, 123, 213, 0.25);
        }
        
        .form-control[readonly] {
            background-color: #f8fafc;
        }
        
        /* Button Styling */
        .btn-success {
            background: linear-gradient(to right, var(--primary), var(--secondary));
            border: none;
            padding: 12px 30px;
            font-weight: 600;
            border-radius: 30px;
            transition: all 0.3s;
            position: relative;
            overflow: hidden;
            z-index: 1;
        }
        
        .btn-success:before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 0;
            height: 100%;
            background: linear-gradient(to right, var(--secondary), var(--primary));
            transition: all 0.3s;
            z-index: -1;
        }
        
        .btn-success:hover:before {
            width: 100%;
        }
        
        .btn-success:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 20px rgba(58, 123, 213, 0.3);
        }
        
        /* Header Styling */
        .page-title {
            color: var(--dark);
            font-weight: 700;
            position: relative;
            display: inline-block;
            animation: titleEnter 0.8s ease-out;
        }
        
        @keyframes titleEnter {
            from { opacity: 0; transform: translateX(-20px); }
            to { opacity: 1; transform: translateX(0); }
        }
        
        .page-title:after {
            content: '';
            position: absolute;
            bottom: -8px;
            left: 0;
            width: 60px;
            height: 4px;
            background: linear-gradient(to right, var(--primary), var(--secondary));
            border-radius: 3px;
        }
        
        .header-title {
            color: var(--dark);
            margin-bottom: 1.5rem;
            font-weight: 600;
            position: relative;
            padding-bottom: 10px;
        }
        
        .header-title:after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 50px;
            height: 3px;
            background: linear-gradient(to right, var(--primary), var(--secondary));
            border-radius: 3px;
        }
        
        /* CKEditor 5 Styling */
        .ck.ck-editor {
            margin-top: 10px;
            animation: fadeIn 0.5s ease-out;
        }
        
        .ck.ck-editor__editable:not(.ck-editor__nested-editable) {
            min-height: 200px;
            border-radius: 8px;
            box-shadow: 0 0 5px rgba(0,0,0,0.05);
            transition: all 0.3s;
        }
        
        .ck.ck-editor__editable:not(.ck-editor__nested-editable):focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 0.2rem rgba(58, 123, 213, 0.15);
        }
        
        /* Input Group Animations */
        .form-group {
            transition: all 0.3s;
        }
        
        .form-group:hover {
            transform: translateY(-2px);
        }
        
        /* Responsive Adjustments */
        @media (max-width: 768px) {
            .content-page {
                margin-left: 0;
            }
            
            .form-group:hover {
                transform: none;
            }
        }
        
        /* Barcode Styling */
        .barcode-display {
            font-family: 'Libre Barcode 128', cursive;
            font-size: 2.5rem;
            letter-spacing: 2px;
            text-align: center;
            margin: 15px 0;
            background: white;
            padding: 10px;
            border-radius: 8px;
            border: 1px dashed #ccc;
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.02); }
            100% { transform: scale(1); }
        }
    </style>
    <!-- FontAwesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <!-- Barcode font -->
    <link href="https://fonts.googleapis.com/css2?family=Libre+Barcode+128&display=swap" rel="stylesheet">
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include("assets/inc/nav.php");?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box animate__animated animate__fadeIn">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Laboratory</a></li>
                                        <li class="breadcrumb-item active">Add Equipment</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Add Laboratory Equipment</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 
                    
                    <!-- Success/Error Messages -->
                    <?php if(isset($success)): ?>
                        <div class="alert alert-success alert-dismissible fade show animate__animated animate__bounceIn">
                            <i class="fas fa-check-circle mr-2"></i>
                            <?php echo $success; ?>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php endif; ?>
                    <?php if(isset($err)): ?>
                        <div class="alert alert-danger alert-dismissible fade show animate__animated animate__shakeX">
                            <i class="fas fa-exclamation-circle mr-2"></i>
                            <?php echo $err; ?>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Form row -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card animate__animated animate__zoomIn">
                                <div class="card-body">
                                    <h4 class="header-title">Equipment Information</h4>
                                    
                                    <!--Add Equipment Form-->
                                    <form method="post">
                                        <div class="form-row">
                                            <div class="form-group col-md-4">
                                                <label>Equipment Name</label>
                                                <input type="text" required name="eqp_name" class="form-control">
                                            </div>
                                            <div class="form-group col-md-4">
                                                <label>Equipment Vendor</label>
                                                <input type="text" required name="eqp_vendor" class="form-control">
                                            </div>
                                            <div class="form-group col-md-4">
                                                <label>Equipment Quantity</label>
                                                <input type="number" required name="eqp_qty" class="form-control" min="1">
                                            </div>
                                            
                                            <!-- Hidden fields -->
                                            <div class="form-group col-md-4" style="display:none">
                                                <input type="text" value="Laboratory" name="eqp_dept" class="form-control">
                                            </div>
                                            <div class="form-group col-md-6" style="display:none">
                                                <input type="text" value="Functioning" name="eqp_status" class="form-control">
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label>Equipment Barcode (EAN-8)</label>
                                            <?php 
                                                $length = 10;    
                                                $bcode = substr(str_shuffle('0123456789'),1,$length);
                                            ?>
                                            <input required readonly type="text" value="<?php echo $bcode; ?>" name="eqp_code" class="form-control">
                                            <div class="barcode-display">*<?php echo $bcode; ?>*</div>
                                        </div>

                                        <div class="form-group">
                                            <label>Equipment Description</label>
                                            <textarea required type="text" class="form-control" name="eqp_desc" id="editor"></textarea>
                                        </div>

                                        <div class="text-center mt-4">
                                            <button type="submit" name="add_equipments" class="ladda-button btn btn-success" data-style="expand-right">
                                                <span class="ladda-label">
                                                    <i class="fas fa-plus-circle mr-2"></i> Add Equipment
                                                </span>
                                            </button>
                                        </div>
                                    </form>
                                    <!--End Equipment Form-->
                                </div> <!-- end card-body -->
                            </div> <!-- end card-->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->
                </div> <!-- container -->
            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->
        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->
    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App js-->
    <script src="assets/js/app.min.js"></script>

    <!-- Loading buttons js -->
    <script src="assets/libs/ladda/spin.js"></script>
    <script src="assets/libs/ladda/ladda.js"></script>

    <!-- Buttons init js-->
    <script src="assets/js/pages/loading-btn.init.js"></script>
    
    <!-- Initialize CKEditor 5 -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            ClassicEditor
                .create(document.querySelector('#editor'), {
                    toolbar: [
                        'heading', '|',
                        'bold', 'italic', 'link', 'bulletedList', 'numberedList', '|',
                        'blockQuote', 'insertTable', 'undo', 'redo'
                    ]
                })
                .catch(error => {
                    console.error(error);
                });
            
            // Input validation for quantity
            document.querySelector('input[name="eqp_qty"]').addEventListener('input', function(e) {
                this.value = this.value.replace(/[^0-9]/g, '');
            });
        });
    </script>
</body>
</html>