<?php
  session_start();
  include('assets/inc/config.php');
  include('assets/inc/checklogin.php');
  check_login();
  $aid=$_SESSION['ad_id'];
?>

<!DOCTYPE html>
<html lang="en">
    
<?php include('assets/inc/head.php');?>

    <body>

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
                <?php include('assets/inc/nav.php');?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
                <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Medical Records</a></li>
                                            <li class="breadcrumb-item active">Add Medical Records</li>
                                        </ol>
                                    </div>
                                    <div class="d-flex justify-content-between align-items-center">
                                        <h4 class="page-title">Patient Details</h4>
                                        <div class="search-box">
                                            <div class="form-group mb-0">
                                                <input id="patient-search" type="text" placeholder="Search patients..." class="form-control form-control-sm" autocomplete="on">
                                                <i class="fas fa-search search-icon"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 

                        <div class="row">
                            <div class="col-12">
                                <div class="card-box">
                                    <!-- Patient Category Tabs -->
                                    <ul class="nav nav-tabs nav-bordered mb-3">
                                        <li class="nav-item">
                                            <a href="#inpatients" data-toggle="tab" aria-expanded="false" class="nav-link active">
                                                <i class="fas fa-procedures mr-1"></i> Inpatients
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a href="#outpatients" data-toggle="tab" aria-expanded="true" class="nav-link">
                                                <i class="fas fa-user-injured mr-1"></i> Outpatients
                                            </a>
                                        </li>
                                    </ul>
                                    
                                    <div class="tab-content">
                                        <!-- Inpatients Tab -->
                                        <div class="tab-pane show active" id="inpatients">
                                            <div class="table-responsive">
                                                <table id="inpatients-table" class="table table-hover table-striped table-bordered mb-0" data-page-size="7">
                                                    <thead class="thead-dark">
                                                    <tr>
                                                        <th width="5%">#</th>
                                                        <th>Patient Name</th>
                                                        <th data-hide="phone">Patient ID</th>
                                                        <th data-hide="phone">Address</th>
                                                        <th data-hide="phone">Phone</th>
                                                        <th data-hide="phone">Age</th>
                                                        <th width="15%">Action</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php
                                                        $ret = "SELECT * FROM his_patients WHERE pat_type = 'InPatient' ORDER BY RAND()"; 
                                                        $stmt = $mysqli->prepare($ret);
                                                        $stmt->execute();
                                                        $res = $stmt->get_result();
                                                        $cnt = 1;
                                                        while($row = $res->fetch_object()):
                                                    ?>
                                                        <tr>
                                                            <td><?php echo $cnt;?></td>
                                                            <td>
                                                                <div class="d-flex align-items-center">
                                                                    <div class="avatar-sm mr-2">
                                                                        <span class="avatar-title bg-soft-danger rounded">
                                                                            <?php echo strtoupper(substr($row->pat_fname, 0, 1)); ?>
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        <h6 class="mb-0"><?php echo $row->pat_fname;?> <?php echo $row->pat_lname;?></h6>
                                                                        <small class="text-muted">ID: <?php echo $row->pat_number;?></small>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td><?php echo $row->pat_number;?></td>
                                                            <td>
                                                                <span class="d-inline-block text-truncate" style="max-width: 150px;" 
                                                                      title="<?php echo $row->pat_addr; ?>">
                                                                    <?php echo $row->pat_addr; ?>
                                                                </span>
                                                            </td>
                                                            <td><?php echo $row->pat_phone;?></td>
                                                            <td>
                                                                <span class="badge badge-soft-info p-2">
                                                                    <?php echo $row->pat_age;?> Years
                                                                </span>
                                                            </td>
                                                            <td class="text-center">
                                                                <a href="add_single_patient_medical_record.php?pat_number=<?php echo $row->pat_number;?>" 
                                                                   class="btn btn-sm btn-primary">
                                                                    <i class="fas fa-file-signature mr-1"></i> Add Record
                                                                </a>
                                                            </td>
                                                        </tr>
                                                    <?php 
                                                        $cnt++;
                                                        endwhile;
                                                    ?>
                                                    </tbody>
                                                    <tfoot>
                                                    <tr class="active">
                                                        <td colspan="7">
                                                            <div class="d-flex justify-content-between align-items-center">
                                                                <div class="dataTables_info">
                                                                    Showing <?php echo max(1, $cnt-1); ?> inpatients
                                                                </div>
                                                                <div>
                                                                    <ul class="pagination pagination-rounded justify-content-end mb-0"></ul>
                                                                </div>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    </tfoot>
                                                </table>
                                            </div>
                                        </div> <!-- end inpatients tab -->
                                        
                                        <!-- Outpatients Tab -->
                                        <div class="tab-pane" id="outpatients">
                                            <div class="table-responsive">
                                                <table id="outpatients-table" class="table table-hover table-striped table-bordered mb-0" data-page-size="7">
                                                    <thead class="thead-dark">
                                                    <tr>
                                                        <th width="5%">#</th>
                                                        <th>Patient Name</th>
                                                        <th data-hide="phone">Patient ID</th>
                                                        <th data-hide="phone">Address</th>
                                                        <th data-hide="phone">Phone</th>
                                                        <th data-hide="phone">Age</th>
                                                        <th width="15%">Action</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php
                                                        $ret = "SELECT * FROM his_patients WHERE pat_type = 'OutPatient' ORDER BY RAND()"; 
                                                        $stmt = $mysqli->prepare($ret);
                                                        $stmt->execute();
                                                        $res = $stmt->get_result();
                                                        $cnt = 1;
                                                        while($row = $res->fetch_object()):
                                                    ?>
                                                        <tr>
                                                            <td><?php echo $cnt;?></td>
                                                            <td>
                                                                <div class="d-flex align-items-center">
                                                                    <div class="avatar-sm mr-2">
                                                                        <span class="avatar-title bg-soft-success rounded">
                                                                            <?php echo strtoupper(substr($row->pat_fname, 0, 1)); ?>
                                                                        </span>
                                                                    </div>
                                                                    <div>
                                                                        <h6 class="mb-0"><?php echo $row->pat_fname;?> <?php echo $row->pat_lname;?></h6>
                                                                        <small class="text-muted">ID: <?php echo $row->pat_number;?></small>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td><?php echo $row->pat_number;?></td>
                                                            <td>
                                                                <span class="d-inline-block text-truncate" style="max-width: 150px;" 
                                                                      title="<?php echo $row->pat_addr; ?>">
                                                                    <?php echo $row->pat_addr; ?>
                                                                </span>
                                                            </td>
                                                            <td><?php echo $row->pat_phone;?></td>
                                                            <td>
                                                                <span class="badge badge-soft-info p-2">
                                                                    <?php echo $row->pat_age;?> Years
                                                                </span>
                                                            </td>
                                                            <td class="text-center">
                                                                <a href="add_single_patient_medical_record.php?pat_number=<?php echo $row->pat_number;?>" 
                                                                   class="btn btn-sm btn-primary">
                                                                    <i class="fas fa-file-signature mr-1"></i> Add Record
                                                                </a>
                                                            </td>
                                                        </tr>
                                                    <?php 
                                                        $cnt++;
                                                        endwhile;
                                                    ?>
                                                    </tbody>
                                                    <tfoot>
                                                    <tr class="active">
                                                        <td colspan="7">
                                                            <div class="d-flex justify-content-between align-items-center">
                                                                <div class="dataTables_info">
                                                                    Showing <?php echo max(1, $cnt-1); ?> outpatients
                                                                </div>
                                                                <div>
                                                                    <ul class="pagination pagination-rounded justify-content-end mb-0"></ul>
                                                                </div>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    </tfoot>
                                                </table>
                                            </div>
                                        </div> <!-- end outpatients tab -->
                                    </div> <!-- end tab-content -->
                                </div> <!-- end card-box -->
                            </div> <!-- end col -->
                        </div>
                        <!-- end row -->

                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                 <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- Footable js -->
        <script src="assets/libs/footable/footable.all.min.js"></script>

        <!-- Init js -->
        <script src="assets/js/pages/foo-tables.init.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
        <style>
            /* Custom styling */
            .avatar-sm {
                width: 32px;
                height: 32px;
                display: inline-flex;
                align-items: center;
                justify-content: center;
            }
            
            .avatar-title {
                display: flex;
                align-items: center;
                justify-content: center;
                width: 100%;
                height: 100%;
                font-weight: bold;
                color: #fff;
            }
            
            .search-box {
                position: relative;
                width: 250px;
            }
            
            .search-box .search-icon {
                position: absolute;
                right: 10px;
                top: 8px;
                color: #98a6ad;
            }
            
            #inpatients-table thead th,
            #outpatients-table thead th {
                position: sticky;
                top: 0;
                background-color: #343a40;
                color: white;
                font-weight: 500;
            }
            
            #inpatients-table tbody tr:hover,
            #outpatients-table tbody tr:hover {
                background-color: rgba(0, 123, 255, 0.05);
            }
            
            .badge-soft-info {
                color: #3bafda;
                background-color: rgba(59, 175, 218, 0.1);
            }
            
            .bg-soft-danger {
                background-color: rgba(241, 85, 108, 0.2) !important;
            }
            
            .bg-soft-success {
                background-color: rgba(26, 188, 156, 0.2) !important;
            }
            
            .text-truncate {
                white-space: nowrap;
                overflow: hidden;
                text-overflow: ellipsis;
            }
            
            .dataTables_info {
                font-size: 0.9rem;
                color: #6c757d;
            }
            
            .nav-tabs .nav-link {
                font-weight: 500;
            }
            
            .nav-tabs .nav-link.active {
                border-bottom: 2px solid #3bafda;
            }
        </style>
        
        <script>
        $(document).ready(function() {
            // Initialize footable for both tables
            $('#inpatients-table').footable();
            $('#outpatients-table').footable();
            
            // Search functionality
            $('#patient-search').keyup(function() {
                var searchText = $(this).val().toLowerCase();
                
                // Search in active tab
                var activeTable = $('.tab-pane.active table');
                activeTable.find('tbody tr').each(function() {
                    var rowText = $(this).text().toLowerCase();
                    $(this).toggle(rowText.indexOf(searchText) > -1);
                });
            });
        });
        </script>
    </body>
</html>