<?php
session_start();
include('assets/inc/config.php');
if(isset($_POST['add_pharmaceutical'])) {
    $phar_name = $_POST['phar_name'];
    $phar_desc = $_POST['phar_desc'];
    $phar_qty = $_POST['phar_qty'];
    $phar_cat = $_POST['phar_cat'];
    $phar_bcode = $_POST['phar_bcode'];
    $phar_vendor = $_POST['phar_vendor'];
        
    //sql to insert captured values
    $query = "INSERT INTO his_pharmaceuticals (phar_name, phar_bcode, phar_desc, phar_qty, phar_cat, phar_vendor) VALUES (?,?,?,?,?,?)";
    $stmt = $mysqli->prepare($query);
    $rc = $stmt->bind_param('ssssss', $phar_name, $phar_bcode, $phar_desc, $phar_qty, $phar_cat, $phar_vendor);
    $stmt->execute();
    
    if($stmt) {
        $success = "Pharmaceutical Added Successfully";
    } else {
        $err = "Please Try Again Or Try Later";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        :root {
            --primary-color: #4361ee;
            --primary-light: #eef2ff;
            --secondary-color: #3a0ca3;
            --success-color: #00b46e;
            --danger-color: #dc3545;
            --warning-color: #ff9e00;
            --light-bg: #f8f9fc;
            --card-shadow: 0 4px 24px rgba(0, 0, 0, 0.05);
            --form-border: #e0e3ff;
            --dark-text: #2b2d42;
            --medium-text: #495057;
        }
        
        body {
            background-color: var(--light-bg);
            font-family: 'Inter', sans-serif;
        }
        
        .card {
            border: none;
            border-radius: 12px;
            box-shadow: var(--card-shadow);
        }
        
        .page-title-box {
            padding: 20px 0;
        }
        
        .page-title {
            color: var(--dark-text);
            font-weight: 700;
        }
        
        .form-control, .form-select {
            border: 1px solid var(--form-border);
            border-radius: 8px;
            padding: 12px 15px;
            height: auto;
        }
        
        .form-control:focus, .form-select:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(67, 97, 238, 0.25);
        }
        
        label {
            font-weight: 600;
            color: var(--dark-text);
            margin-bottom: 8px;
        }
        
        .btn-success {
            background-color: var(--success-color);
            border-color: var(--success-color);
            padding: 12px 30px;
            border-radius: 8px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
        }
        
        .btn-success:hover {
            background-color: #00a05e;
            border-color: #009959;
            transform: translateY(-2px);
        }
        
        .ck-editor__editable {
            min-height: 200px;
            border-radius: 8px !important;
            border: 1px solid var(--form-border) !important;
        }
        
        .header-title {
            color: var(--primary-color);
            font-weight: 700;
            margin-bottom: 20px;
            position: relative;
            padding-bottom: 10px;
        }
        
        .header-title:after {
            content: '';
            position: absolute;
            left: 0;
            bottom: 0;
            width: 60px;
            height: 3px;
            background: var(--primary-color);
            border-radius: 3px;
        }
        
        .barcode-input {
            background-color: var(--primary-light);
            font-family: 'Libre Barcode 39', cursive;
            font-size: 24px;
            letter-spacing: 2px;
        }
        
        @media (max-width: 768px) {
            .form-group {
                margin-bottom: 20px;
            }
            
            .btn-success {
                width: 100%;
            }
        }
    </style>
    <link href="https://fonts.googleapis.com/css2?family=Libre+Barcode+39&display=swap" rel="stylesheet">
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include("assets/inc/nav.php");?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Pharmaceuticals</a></li>
                                        <li class="breadcrumb-item active">Add Pharmaceutical</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Create A Pharmaceutical</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 
                    <!-- Form row -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">Pharmaceutical Details</h4>
                                    <!--Add Pharmaceutical Form-->
                                    <form method="post">
                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label for="phar_name" class="col-form-label">Pharmaceutical Name</label>
                                                <input type="text" required="required" name="phar_name" class="form-control" id="phar_name" placeholder="Enter pharmaceutical name">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label for="phar_qty" class="col-form-label">Quantity (Cartons)</label>
                                                <input required="required" type="number" name="phar_qty" class="form-control" id="phar_qty" placeholder="Enter quantity">
                                            </div>
                                        </div>
                                        
                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label for="phar_cat" class="col-form-label">Category</label>
                                                <select id="phar_cat" required="required" name="phar_cat" class="form-select">
                                                    <option value="" disabled selected>Select category</option>
                                                    <?php
                                                    $ret = "SELECT * FROM his_pharmaceuticals_categories ORDER BY pharm_cat_name"; 
                                                    $stmt = $mysqli->prepare($ret);
                                                    $stmt->execute();
                                                    $res = $stmt->get_result();
                                                    while($row = $res->fetch_object()) {
                                                    ?>
                                                        <option value="<?php echo htmlspecialchars($row->pharm_cat_name);?>"><?php echo htmlspecialchars($row->pharm_cat_name);?></option>
                                                    <?php }?>    
                                                </select>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label for="phar_vendor" class="col-form-label">Vendor</label>
                                                <select id="phar_vendor" required="required" name="phar_vendor" class="form-select">
                                                    <option value="" disabled selected>Select vendor</option>
                                                    <?php
                                                    $ret = "SELECT * FROM his_vendor ORDER BY v_name"; 
                                                    $stmt = $mysqli->prepare($ret);
                                                    $stmt->execute();
                                                    $res = $stmt->get_result();
                                                    while($row = $res->fetch_object()) {
                                                    ?>
                                                        <option value="<?php echo htmlspecialchars($row->v_name);?>"><?php echo htmlspecialchars($row->v_name);?></option>
                                                    <?php }?>   
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="phar_bcode" class="col-form-label">Barcode (EAN-8)</label>
                                            <?php 
                                                $length = 8;    
                                                $phar_bcode = substr(str_shuffle('0123456789'), 1, $length);
                                            ?>
                                            <input required="required" type="text" value="<?php echo htmlspecialchars($phar_bcode);?>" name="phar_bcode" class="form-control barcode-input" id="phar_bcode" readonly>
                                        </div>

                                        <div class="form-group">
                                            <label for="editor" class="col-form-label">Description</label>
                                            <textarea required="required" class="form-control" name="phar_desc" id="editor" placeholder="Enter pharmaceutical description"></textarea>
                                        </div>

                                        <button type="submit" name="add_pharmaceutical" class="ladda-button btn btn-success" data-style="expand-right">
                                            <span class="ladda-label">Add Pharmaceutical</span>
                                        </button>

                                    </form>
                                 
                                </div> <!-- end card-body -->
                            </div> <!-- end card-->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- container -->

            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->
    
    <!--Load CKEditor 5-->
    <script src="https://cdn.ckeditor.com/ckeditor5/41.1.0/classic/ckeditor.js"></script>
    <script>
        ClassicEditor
            .create(document.querySelector('#editor'), {
                toolbar: {
                    items: [
                        'heading', '|',
                        'bold', 'italic', 'link', 'bulletedList', 'numberedList', '|',
                        'undo', 'redo'
                    ]
                },
                heading: {
                    options: [
                        { model: 'paragraph', title: 'Paragraph', class: 'ck-heading_paragraph' },
                        { model: 'heading1', view: 'h1', title: 'Heading 1', class: 'ck-heading_heading1' },
                        { model: 'heading2', view: 'h2', title: 'Heading 2', class: 'ck-heading_heading2' }
                    ]
                }
            })
            .catch(error => {
                console.error(error);
            });
    </script>
   
    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App js-->
    <script src="assets/js/app.min.js"></script>

    <!-- Loading buttons js -->
    <script src="assets/libs/ladda/spin.js"></script>
    <script src="assets/libs/ladda/ladda.js"></script>

    <!-- Buttons init js-->
    <script src="assets/js/pages/loading-btn.init.js"></script>
    
</body>

</html>