<?php
    session_start();
    include('assets/inc/config.php');
    if(isset($_POST['add_patient_lab_test']))
    {
        $lab_pat_name = $_POST['lab_pat_name'];
        $lab_pat_ailment = $_POST['lab_pat_ailment'];
        $lab_pat_number  = $_POST['lab_pat_number'];
        $lab_pat_tests = $_POST['lab_pat_tests'];
        $lab_number  = $_POST['lab_number'];
        
        $query="INSERT INTO his_laboratory (lab_pat_name, lab_pat_ailment, lab_pat_number, lab_pat_tests, lab_number) VALUES(?,?,?,?,?)";
        $stmt = $mysqli->prepare($query);
        $rc=$stmt->bind_param('sssss', $lab_pat_name, $lab_pat_ailment, $lab_pat_number, $lab_pat_tests, $lab_number);
        $stmt->execute();
        
        if($stmt)
        {
            $success = "Patient Laboratory Tests Added";
        }
        else {
            $err = "Please Try Again Or Try Later";
        }
    }
?>
<!DOCTYPE html>
<html lang="en">
    
    <!--Head-->
    <?php include('assets/inc/head.php');?>
    <body>

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
            <?php include("assets/inc/nav.php");?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
            <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->
            <?php
                $pat_number = $_GET['pat_number'];
                $ret="SELECT * FROM his_patients WHERE pat_number=?";
                $stmt= $mysqli->prepare($ret);
                $stmt->bind_param('s',$pat_number);
                $stmt->execute();
                $res=$stmt->get_result();
                while($row=$res->fetch_object()):
            ?>
                <div class="content-page">
                    <div class="content">

                        <!-- Start Content-->
                        <div class="container-fluid">
                            
                            <!-- start page title -->
                            <div class="row">
                                <div class="col-12">
                                    <div class="page-title-box bg-gradient-primary">
                                        <div class="page-title-right">
                                            <ol class="breadcrumb m-0">
                                                <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                                <li class="breadcrumb-item"><a href="javascript: void(0);">Laboratory</a></li>
                                                <li class="breadcrumb-item active text-white">Add Lab Test</li>
                                            </ol>
                                        </div>
                                        <h4 class="page-title text-white">Laboratory Test Management</h4>
                                    </div>
                                </div>
                            </div>     
                            <!-- end page title --> 
                            
                            <!-- Form row -->
                            <div class="row">
                                <div class="col-12">
                                    <div class="card">
                                        <div class="card-header bg-primary text-white">
                                            <h4 class="header-title">Patient Laboratory Test Form</h4>
                                        </div>
                                        <div class="card-body">
                                            <form method="post" class="needs-validation" novalidate>
                                                <div class="form-row">
                                                    <div class="form-group col-md-6">
                                                        <label for="lab_pat_name" class="col-form-label">Patient Name</label>
                                                        <input type="text" required readonly name="lab_pat_name" 
                                                               value="<?php echo $row->pat_fname.' '.$row->pat_lname;?>" 
                                                               class="form-control border-primary" id="lab_pat_name">
                                                    </div>

                                                    <div class="form-group col-md-6">
                                                        <label for="lab_pat_ailment" class="col-form-label">Patient Ailment</label>
                                                        <input type="text" required readonly name="lab_pat_ailment" 
                                                               value="<?php echo $row->pat_ailment;?>" 
                                                               class="form-control border-primary" id="lab_pat_ailment">
                                                    </div>
                                                </div>

                                                <div class="form-row">
                                                    <div class="form-group col-md-6">
                                                        <label for="lab_pat_number" class="col-form-label">Patient Number</label>
                                                        <input type="text" required readonly name="lab_pat_number" 
                                                               value="<?php echo $row->pat_number;?>" 
                                                               class="form-control border-primary" id="lab_pat_number">
                                                    </div>
                                                    
                                                    <div class="form-group col-md-6" style="display:none">
                                                        <?php 
                                                            $length = 5;    
                                                            $pres_no = substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'),1,$length);
                                                        ?>
                                                        <label for="lab_number" class="col-form-label">Lab Test Number</label>
                                                        <input type="text" name="lab_number" value="<?php echo $pres_no;?>" 
                                                               class="form-control border-primary" id="lab_number">
                                                    </div>
                                                </div>

                                                <div class="form-group">
                                                    <label for="editor" class="col-form-label">Laboratory Tests</label>
                                                    <div class="border-primary rounded">
                                                        <textarea required type="text" class="form-control" name="lab_pat_tests" id="editor"></textarea>
                                                    </div>
                                                </div>

                                                <div class="form-group text-right mt-4">
                                                    <button type="submit" name="add_patient_lab_test" 
                                                            class="ladda-button btn btn-success btn-rounded" 
                                                            data-style="expand-right">
                                                        <i class="fas fa-flask mr-1"></i> Add Laboratory Test
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div> <!-- container -->

                    </div> <!-- content -->

                    <!-- Footer Start -->
                    <?php include('assets/inc/footer.php');?>
                    <!-- end Footer -->

                </div>
            <?php endwhile; ?>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Load CKEditor 5 -->
        <script src="https://cdn.ckeditor.com/ckeditor5/41.1.0/classic/ckeditor.js"></script>
        <script>
            ClassicEditor
                .create(document.querySelector('#editor'), {
                    toolbar: [
                        'heading', '|',
                        'bold', 'italic', 'link', 'bulletedList', 'numberedList', '|',
                        'undo', 'redo'
                    ],
                    heading: {
                        options: [
                            { model: 'paragraph', title: 'Paragraph', class: 'ck-heading_paragraph' },
                            { model: 'heading2', view: 'h2', title: 'Heading', class: 'ck-heading_heading2' }
                        ]
                    }
                })
                .catch(error => {
                    console.error(error);
                });
        </script>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- App js-->
        <script src="assets/js/app.min.js"></script>

        <!-- Loading buttons js -->
        <script src="assets/libs/ladda/spin.js"></script>
        <script src="assets/libs/ladda/ladda.js"></script>

        <!-- Buttons init js-->
        <script src="assets/js/pages/loading-btn.init.js"></script>
        
        <style>
            .bg-gradient-primary {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
                border-radius: 0.25rem;
                box-shadow: 0 4px 20px 0 rgba(0,0,0,.14), 0 7px 10px -5px rgba(102, 126, 234, .4);
            }
            
            .border-primary {
                border-color: #667eea !important;
            }
            
            .card {
                box-shadow: 0 1px 15px rgba(0,0,0,0.1);
                border: none;
            }
            
            .card-header {
                border-bottom: 1px solid rgba(0,0,0,0.1);
            }
            
            .btn-rounded {
                border-radius: 50px !important;
            }
            
            .form-control:focus {
                border-color: #764ba2;
                box-shadow: 0 0 0 0.2rem rgba(118, 75, 162, 0.25);
            }
            
            .ck.ck-editor__editable_inline {
                min-height: 200px;
                border: 1px solid #667eea !important;
                border-radius: 0.25rem;
            }
            
            .ck.ck-toolbar {
                border: 1px solid #667eea !important;
                border-bottom: none !important;
                border-radius: 0.25rem 0.25rem 0 0;
            }
            
            .needs-validation .form-control:invalid {
                border-color: #dc3545;
            }
            
            .needs-validation .invalid-feedback {
                display: block;
            }
        </style>
    </body>
</html>