<?php
    session_start();
    include('assets/inc/config.php');
    if(isset($_POST['add_vendor']))
    {
        $v_name=$_POST['v_name'];
        $v_adr=$_POST['v_adr'];
        $v_number=$_POST['v_number'];
        $v_email=$_POST['v_email'];
        $v_phone = $_POST['v_phone'];
        $v_desc = $_POST['v_desc'];
        
        $query="INSERT INTO his_vendor (v_name, v_adr, v_number, v_email, v_phone, v_desc) values(?,?,?,?,?,?)";
        $stmt = $mysqli->prepare($query);
        $rc=$stmt->bind_param('ssssss', $v_name, $v_adr, $v_number, $v_email, $v_phone, $v_desc);
        $stmt->execute();
        
        if($stmt)
        {
            $success = "Vendor Details Added";
        }
        else {
            $err = "Please Try Again Or Try Later";
        }
    }
?>
<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        /* Custom Styles */
        .vendor-form-container {
            max-width: 900px;
            margin: 0 auto;
            padding: 30px;
            background: #fff;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }
        
        .form-header {
            border-bottom: 1px solid #eee;
            padding-bottom: 15px;
            margin-bottom: 30px;
        }
        
        .form-header h4 {
            color: #2c3e50;
            font-weight: 600;
        }
        
        .form-label {
            font-weight: 500;
            color: #4a5568;
            margin-bottom: 8px;
        }
        
        .form-control {
            border-radius: 6px;
            padding: 10px 15px;
            border: 1px solid #e2e8f0;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        
        .btn-submit {
            background-color: #4CAF50;
            border: none;
            padding: 12px 30px;
            font-weight: 500;
            letter-spacing: 0.5px;
            transition: all 0.3s;
        }
        
        .btn-submit:hover {
            background-color: #3e8e41;
            transform: translateY(-2px);
        }
        
        .ckeditor-container {
            border-radius: 6px;
            overflow: hidden;
        }
        
        /* Responsive adjustments */
        @media (max-width: 768px) {
            .vendor-form-container {
                padding: 20px;
            }
            
            .form-row {
                flex-direction: column;
            }
            
            .form-group {
                margin-bottom: 1.5rem;
            }
        }
    </style>
</head>

<body>
    <div id="wrapper">
        <?php include("assets/inc/nav.php");?>
        <?php include("assets/inc/sidebar.php");?>

        <div class="content-page">
            <div class="content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Vendor</a></li>
                                        <li class="breadcrumb-item active">Add Vendor</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Add Vendor Details</h4>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Success/Error Messages -->
                    <?php if(isset($success)): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <strong>Success!</strong> <?php echo $success; ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <?php endif; ?>
                    
                    <?php if(isset($err)): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Error!</strong> <?php echo $err; ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <?php endif; ?>
                    
                    <div class="row justify-content-center">
                        <div class="col-12">
                            <div class="vendor-form-container">
                                <div class="form-header">
                                    <h4>Vendor Information</h4>
                                    <p class="text-muted">Please fill all required fields</p>
                                </div>
                                
                                <form method="post">
                                    <div class="form-row">
                                        <div class="form-group col-md-6">
                                            <label for="v_name" class="form-label">Vendor Name</label>
                                            <input type="text" required name="v_name" class="form-control" id="v_name" placeholder="Enter vendor name">
                                        </div>
                                        <div class="form-group col-md-6">
                                            <label for="v_phone" class="form-label">Phone Number</label>
                                            <input required type="tel" name="v_phone" class="form-control" id="v_phone" placeholder="Enter phone number">
                                        </div>
                                    </div>
                                    
                                    <div class="form-row">
                                        <div class="form-group col-md-6">
                                            <label for="v_email" class="form-label">Email Address</label>
                                            <input required type="email" class="form-control" name="v_email" id="v_email" placeholder="Enter email address">
                                        </div>
                                        <div class="form-group col-md-6">
                                            <label for="v_adr" class="form-label">Physical Address</label>
                                            <input required type="text" name="v_adr" class="form-control" id="v_adr" placeholder="Enter physical address">
                                        </div>
                                    </div>
                                    
                                    <div class="form-group" style="display:none">
                                        <?php 
                                            $length = 5;    
                                            $vendor_number = substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'),1,$length);
                                        ?>
                                        <input type="text" name="v_number" value="<?php echo $vendor_number;?>" class="form-control">
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="editor" class="form-label">Vendor Details</label>
                                        <div class="ckeditor-container">
                                            <textarea type="text" class="form-control" name="v_desc" id="editor" placeholder="Enter vendor description"></textarea>
                                        </div>
                                    </div>
                                    
                                    <div class="form-group text-center mt-4">
                                        <button type="submit" name="add_vendor" class="btn btn-submit btn-lg">
                                            <i class="mdi mdi-check-circle-outline mr-1"></i> Add Vendor
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <?php include('assets/inc/footer.php');?>
        </div>
    </div>

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>
    
    <!-- CKEditor -->
     <script src="https://cdn.ckeditor.com/ckeditor5/41.3.1/classic/ckeditor.js"></script>
    <script type="text/javascript">
        CKEDITOR.replace('editor', {
            toolbar: [
                { name: 'basicstyles', items: [ 'Bold', 'Italic', 'Underline', 'Strike' ] },
                { name: 'paragraph', items: [ 'NumberedList', 'BulletedList' ] },
                { name: 'links', items: [ 'Link', 'Unlink' ] },
                { name: 'tools', items: [ 'Maximize' ] }
            ],
            height: 150
        });
    </script>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App js-->
    <script src="assets/js/app.min.js"></script>

    <!-- Loading buttons js -->
    <script src="assets/libs/ladda/spin.js"></script>
    <script src="assets/libs/ladda/ladda.js"></script>

    <!-- Buttons init js-->
    <script src="assets/js/pages/loading-btn.init.js"></script>
</body>
</html>