<?php
    session_start();
    include('assets/inc/config.php');
    
    // Fetch system settings
    $query = "SELECT * FROM his_system_settings LIMIT 1";
    $result = $mysqli->query($query);
    $settings = $result->fetch_assoc();

    if(isset($_POST['doc_login']))
    {
        $doc_number = $_POST['doc_number'];
        $doc_pwd = sha1(md5($_POST['doc_pwd']));
        $stmt=$mysqli->prepare("SELECT doc_number, doc_pwd, doc_id FROM his_lab WHERE doc_number=? AND doc_pwd=? ");
        $stmt->bind_param('ss', $doc_number, $doc_pwd);
        $stmt->execute();
        $stmt -> bind_result($doc_number, $doc_pwd ,$doc_id);
        $rs=$stmt->fetch();
        $_SESSION['lab_id'] = $doc_id;
        $_SESSION['doc_number'] = $doc_number;
        
        if($rs) {
            header("location:dashboard.php");
        }
        else {
            $err = "Access Denied Please Check Your Credentials";
        }
    }
?>
<!DOCTYPE html>
<html lang="en">
    
<head>
    <meta charset="utf-8" />
    <title><?php echo htmlspecialchars($settings['system_name'] ?? 'Hospital Management System'); ?> - Doctor Login</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="<?php echo htmlspecialchars($settings['system_name'] ?? 'Hospital Management System'); ?>" name="description" />
    <meta content="" name="MartDevelopers" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="../../image/favicon.png">

    <!-- App css -->
    <link href="assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/app.min.css" rel="stylesheet" type="text/css" />
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&family=Montserrat:wght@400;500;600&display=swap" rel="stylesheet">
    
    <!--Load Sweet Alert Javascript-->
    <script src="assets/js/swal.js"></script>
    
    <style>
        :root {
            --primary-color: #2c7be5;
            --secondary-color: #00d97e;
            --dark-color: #12263f;
            --light-color: #f9fbfd;
            --accent-color: #6e00e5;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.7)), 
                        url('../../image/pro4.jpg') no-repeat center center fixed;
            background-size: cover;
            color: #fff;
            height: 100vh;
            display: flex;
            align-items: center;
        }
        
        .login-container {
            max-width: 500px;
            width: 100%;
            margin: 0 auto;
            animation: fadeIn 0.8s ease-in-out;
        }
        
        .login-card {
            border: none;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            transition: transform 0.3s ease;
        }
        
        .login-card:hover {
            transform: translateY(-5px);
        }
        
        .login-header {
            background: linear-gradient(135deg, var(--primary-color), var(--accent-color));
            color: white;
            padding: 25px;
            text-align: center;
            position: relative;
        }
        
        .login-header:after {
            content: '';
            position: absolute;
            bottom: -15px;
            left: 50%;
            transform: translateX(-50%);
            width: 0;
            height: 0;
            border-left: 15px solid transparent;
            border-right: 15px solid transparent;
            border-top: 15px solid var(--primary-color);
        }
        
        .login-logo {
            width: 80px;
            margin-bottom: 15px;
        }
        
        .form-control {
            border-radius: 8px;
            padding: 12px 15px;
            border: 2px solid #e0e6ed;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(44, 123, 229, 0.2);
        }
        
        .btn-login {
            background: linear-gradient(135deg, var(--primary-color), var(--accent-color));
            border: none;
            padding: 12px;
            font-weight: 500;
            letter-spacing: 0.5px;
            border-radius: 8px;
            transition: all 0.3s;
        }
        
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(44, 123, 229, 0.3);
        }
        
        .forgot-link {
            color: var(--primary-color);
            transition: color 0.3s;
        }
        
        .forgot-link:hover {
            color: var(--accent-color);
            text-decoration: none;
        }
        
        .medical-icon {
            font-size: 24px;
            margin-right: 10px;
            color: var(--primary-color);
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .input-group-text {
            background-color: #f8f9fa;
            border: 2px solid #e0e6ed;
            border-right: none;
        }
    </style>
    
    <!--Inject SWAL-->
    <?php if(isset($success)) {?>
        <script>
            setTimeout(function () { 
                swal("Success","<?php echo $success;?>","success");
            }, 100);
        </script>
    <?php } ?>

    <?php if(isset($err)) {?>
        <script>
            setTimeout(function () { 
                swal("Failed","<?php echo $err;?>","error");
            }, 100);
        </script>
    <?php } ?>
</head>

<body>
    <div class="container">
        <div class="login-container">
            <div class="login-card">
                <div class="login-header">
                    <?php if(!empty($settings['system_logo'])): ?>
                        <img src="<?php echo htmlspecialchars($settings['system_logo']); ?>" alt="<?php echo htmlspecialchars($settings['system_name'] ?? 'Hospital Logo'); ?>" class="login-logo">
                    <?php else: ?>
                        <img src="../../image/logo.png" alt="Hospital Logo" class="login-logo">
                    <?php endif; ?>
                    <h4><?php echo htmlspecialchars($settings['system_name'] ?? 'Hospital System'); ?> - Lab technitian  Portal</h4>
                    <p class="mb-0">Secure access to patient records and hospital systems</p>
                </div>
                
                <div class="card-body p-4">
                    <form method="post">
                        <div class="form-group mb-4">
                            <label for="doc_number" class="font-weight-bold text-dark">
                                <i class="mdi mdi-account-circle medical-icon"></i>Lab-Tech ID
                            </label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><i class="mdi mdi-identifier"></i></span>
                                </div>
                                <input class="form-control" name="doc_number" type="text" id="doc_number" required placeholder="Enter your doctor ID">
                            </div>
                        </div>

                        <div class="form-group mb-4">
                            <label for="password" class="font-weight-bold text-dark">
                                <i class="mdi mdi-lock medical-icon"></i>Password
                            </label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><i class="mdi mdi-key"></i></span>
                                </div>
                                <input class="form-control" name="doc_pwd" type="password" required id="password" placeholder="Enter your password">
                            </div>
                        </div>

                        <div class="form-group mb-3 text-center">
                            <button class="btn btn-login btn-block" name="doc_login" type="submit">
                                <i class="mdi mdi-login mr-1"></i> Login
                            </button>
                        </div>

                        <div class="text-center mt-4">
                            <a href="reset_pwd.php" class="forgot-link">
                                <i class="mdi mdi-lock-reset"></i> Forgot Password?
                            </a>
                        </div>
                    </form>
                </div>
            </div>
            
            <div class="text-center mt-4">
                <p class="text-white">© <?php echo date("Y"); ?> <?php echo htmlspecialchars($settings['system_name'] ?? 'Hospital Management System'); ?>. All rights reserved.</p>
            </div>
        </div>
    </div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
</body>
</html>