<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];
?>

<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        /* Modern Healthcare Color Palette */
        :root {
            --primary: #3a7bd5;
            --secondary: #00d2ff;
            --accent: #ff6b6b;
            --light: #f8f9fa;
            --dark: #343a40;
            --success: #28a745;
        }
        
        /* Animated Gradient Background */
        body {
            background: linear-gradient(-45deg, #f5f7fa, #e4f0fb, #f0f5ff, #e6f7ff);
            background-size: 400% 400%;
            animation: gradientBG 15s ease infinite;
            min-height: 100vh;
        }
        
        @keyframes gradientBG {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }
        
        /* Content Wrapper */
        .content-page {
            background: rgba(255, 255, 255, 0.95);
            margin-left: 260px;
            min-height: 100vh;
            box-shadow: 0 0 40px rgba(0, 0, 0, 0.08);
            animation: fadeIn 0.5s ease-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        /* Card Styling */
        .card-box {
            border-radius: 12px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            padding: 25px;
            background: white;
            border: none;
            transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
            animation: cardEnter 0.6s ease-out;
            overflow: hidden;
        }
        
        @keyframes cardEnter {
            from { opacity: 0; transform: scale(0.95); }
            to { opacity: 1; transform: scale(1); }
        }
        
        /* Table Styling */
        .table {
            border-collapse: separate;
            border-spacing: 0;
            width: 100%;
            background: white;
        }
        
        .table th {
            background: linear-gradient(to right, var(--primary), var(--secondary));
            color: white;
            font-weight: 600;
            border: none;
            padding: 15px;
            position: sticky;
            top: 0;
            z-index: 10;
        }
        
        .table td {
            padding: 12px 15px;
            vertical-align: middle;
            border-bottom: 1px solid #f1f5fd;
            background: white;
            transition: all 0.2s;
        }
        
        .table tbody tr:hover td {
            background-color: #f8faff;
            transform: scale(1.01);
        }
        
        /* Badge Styling */
        .badge-success {
            background: var(--primary);
            padding: 8px 15px;
            border-radius: 20px;
            font-weight: 500;
            transition: all 0.3s;
            display: inline-flex;
            align-items: center;
            color: white;
            border: none;
            box-shadow: 0 2px 5px rgba(58, 123, 213, 0.2);
        }
        
        .badge-success:hover {
            background: var(--secondary);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 210, 255, 0.3);
            text-decoration: none;
        }
        
        .badge-success i {
            margin-right: 8px;
            font-size: 14px;
            transition: all 0.3s;
        }
        
        .badge-success:hover i {
            transform: scale(1.2);
        }
        
        /* Page Title Styling */
        .page-title {
            color: var(--dark);
            font-weight: 700;
            position: relative;
            display: inline-block;
            animation: titleEnter 0.8s ease-out;
        }
        
        @keyframes titleEnter {
            from { opacity: 0; transform: translateX(-20px); }
            to { opacity: 1; transform: translateX(0); }
        }
        
        .page-title:after {
            content: '';
            position: absolute;
            bottom: -8px;
            left: 0;
            width: 60px;
            height: 4px;
            background: linear-gradient(to right, var(--primary), var(--secondary));
            border-radius: 3px;
        }
        
        /* Search Box */
        .search-box {
            position: relative;
            margin-bottom: 20px;
        }
        
        .search-box .form-control {
            padding-left: 45px;
            border-radius: 25px;
            border: 1px solid #e0e6f5;
            height: 40px;
            box-shadow: none;
            transition: all 0.3s;
        }
        
        .search-box .form-control:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 0.2rem rgba(58, 123, 213, 0.25);
        }
        
        .search-box i {
            position: absolute;
            left: 15px;
            top: 11px;
            color: #7e98c7;
            z-index: 4;
        }
        
        /* Pagination */
        .pagination-rounded .page-item.active .page-link {
            background: linear-gradient(to right, var(--primary), var(--secondary));
            border-color: transparent;
        }
        
        .pagination-rounded .page-link {
            color: var(--primary);
            border-radius: 50% !important;
            margin: 0 5px;
            width: 36px;
            height: 36px;
            text-align: center;
            line-height: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
            border: 1px solid #e0e6f5;
            transition: all 0.3s;
        }
        
        .pagination-rounded .page-link:hover {
            background-color: #f1f5fd;
        }
        
        /* Responsive Adjustments */
        @media (max-width: 768px) {
            .content-page {
                margin-left: 0;
            }
            
            .table-responsive {
                border: 0;
            }
            
            .table thead {
                display: none;
            }
            
            .table tr {
                display: block;
                margin-bottom: 20px;
                border: 1px solid #e0e6f5;
                border-radius: 8px;
                box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
                animation: mobileRowEnter 0.5s ease-out;
            }
            
            @keyframes mobileRowEnter {
                from { opacity: 0; transform: translateX(-20px); }
                to { opacity: 1; transform: translateX(0); }
            }
            
            .table td {
                display: flex;
                justify-content: space-between;
                align-items: center;
                border-bottom: 1px solid #f1f5fd;
            }
            
            .table td:before {
                content: attr(data-label);
                font-weight: 600;
                margin-right: 15px;
                color: var(--primary);
            }
        }
    </style>
    <!-- Animate.css for additional animations -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
    <!-- FontAwesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <!-- Material Design Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/MaterialDesign-Webfont/5.3.45/css/materialdesignicons.min.css">
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include('assets/inc/nav.php');?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box animate__animated animate__fadeIn">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Laboratory</a></li>
                                        <li class="breadcrumb-item active">Laboratory Records</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Patient Laboratory Records</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 

                    <div class="row">
                        <div class="col-12">
                            <div class="card-box animate__animated animate__zoomIn">
                                <h4 class="header-title mb-4">Patient Test Results</h4>
                                
                                <!-- Search Box -->
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <div class="search-box">
                                            <i class="fas fa-search"></i>
                                            <input id="demo-foo-search" type="text" placeholder="Search patients..." 
                                                   class="form-control form-control-sm" autocomplete="on">
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="table-responsive">
                                    <table id="demo-foo-filtering" class="table table-hover table-centered mb-0" data-page-size="7">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th data-toggle="true">Patient Name</th>
                                                <th data-hide="phone">Patient Number</th>
                                                <th data-hide="phone">Patient Ailment</th>
                                                <th data-hide="phone">Test Date</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $ret = "SELECT * FROM his_laboratory ORDER BY RAND()";
                                            $stmt = $mysqli->prepare($ret);
                                            $stmt->execute();
                                            $res = $stmt->get_result();
                                            $cnt = 1;
                                            while($row = $res->fetch_object()):
                                                $mysqlDateTime = $row->lab_date_rec;
                                            ?>
                                            <tr class="animate__animated animate__fadeInUp" style="animation-delay: <?php echo $cnt * 0.05; ?>s">
                                                <td><?php echo $cnt; ?></td>
                                                <td><?php echo htmlspecialchars($row->lab_pat_name); ?></td>
                                                <td><?php echo htmlspecialchars($row->lab_pat_number); ?></td>
                                                <td><?php echo htmlspecialchars($row->lab_pat_ailment); ?></td>
                                                <td><?php echo date("d/m/Y", strtotime($mysqlDateTime)); ?></td>
                                                <td>
                                                    <a href="view_single_lab_record.php?lab_id=<?php echo $row->lab_id; ?>&&lab_number=<?php echo $row->lab_number; ?>" 
                                                       class="badge badge-success">
                                                       <i class="mdi mdi-eye"></i> View Lab Report
                                                    </a>
                                                </td>
                                            </tr>
                                            <?php 
                                            $cnt++;
                                            endwhile; 
                                            ?>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td colspan="6">
                                                    <div class="text-right">
                                                        <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div> <!-- end .table-responsive-->
                            </div> <!-- end card-box -->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- container -->

            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- Footable js -->
    <script src="assets/libs/footable/footable.all.min.js"></script>

    <!-- Init js -->
    <script src="assets/js/pages/foo-tables.init.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
    
    <!-- Additional animation effects -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Add hover effect to table rows
            const rows = document.querySelectorAll('.table tbody tr');
            rows.forEach(row => {
                row.addEventListener('mouseenter', () => {
                    row.style.transform = 'scale(1.01)';
                    row.style.boxShadow = '0 5px 15px rgba(0, 0, 0, 0.1)';
                });
                row.addEventListener('mouseleave', () => {
                    row.style.transform = 'scale(1)';
                    row.style.boxShadow = 'none';
                });
            });
            
            // Add animation to search box on focus
            const searchBox = document.getElementById('demo-foo-search');
            searchBox.addEventListener('focus', () => {
                searchBox.parentElement.style.transform = 'scale(1.02)';
            });
            searchBox.addEventListener('blur', () => {
                searchBox.parentElement.style.transform = 'scale(1)';
            });
        });
    </script>
</body>
</html>