<?php
session_start();
include('assets/inc/config.php');

// Server side code to handle Patient Transfer
if(isset($_POST['transfer_patient'])) {
    $t_pat_number = $_POST['t_pat_number'];
    $t_pat_name = $_POST['t_pat_name'];
    $t_date = $_POST['t_date'];
    $t_hospital = $_POST['t_hospital'];
    $t_status = $_POST['t_status'];
    
    // Validate inputs
    if(empty($t_pat_number) || empty($t_pat_name) || empty($t_date) || empty($t_hospital)) {
        $err = "All fields are required";
    } else {
        // sql to insert captured values
        $query = "INSERT INTO his_patient_transfers (t_pat_number, t_pat_name, t_date, t_hospital, t_status) VALUES(?,?,?,?,?)";
        $stmt = $mysqli->prepare($query);
        $rc = $stmt->bind_param('sssss', $t_pat_number, $t_pat_name, $t_date, $t_hospital, $t_status);
        $stmt->execute();
        
        if($stmt) {
            $success = "Patient Transferred Successfully";
            // Optionally redirect after success
            // header("Location: patients.php");
            // exit();
        } else {
            $err = "Please Try Again Or Try Later";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
    
    <!--Head-->
    <?php include('assets/inc/head.php');?>
    <body>

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
            <?php include("assets/inc/nav.php");?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
            <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        
                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Patients</a></li>
                                            <li class="breadcrumb-item active">Transfer Patient</li>
                                        </ol>
                                    </div>
                                    <h4 class="page-title">Transfer Patient To A Referral Facility</h4>
                                </div>
                            </div>
                        </div>     
                        <!-- end page title --> 
                        
                        <!-- Display Alerts -->
                        <?php if(isset($success)) { ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                                <?php echo $success; ?>
                            </div>
                        <?php } ?>
                        
                        <?php if(isset($err)) { ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                                <?php echo $err; ?>
                            </div>
                        <?php } ?>
                        
                        <!-- Form row -->
                        <?php
                        // Secure patient number retrieval
                        $pat_number = isset($_GET['pat_number']) ? trim($_GET['pat_number']) : '';
                        
                        if(empty($pat_number)) {
                            echo '<div class="alert alert-danger">Patient number is required</div>';
                        } else {
                            // Get single patient details
                            $ret = "SELECT pat_number, pat_fname, pat_lname FROM his_patients WHERE pat_number = ?";
                            $stmt = $mysqli->prepare($ret);
                            $stmt->bind_param('s', $pat_number);
                            $stmt->execute();
                            $res = $stmt->get_result();
                            
                            if($res->num_rows == 0) {
                                echo '<div class="alert alert-danger">Patient not found</div>';
                            } else {
                                $row = $res->fetch_object();
                        ?>
                        
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="header-title">Patient Transfer Details</h4>
                                        
                                        <!-- Transfer Patient Form -->
                                        <form method="post">
                                            <div class="form-row">
                                                <div class="form-group col-md-12">
                                                    <label for="patientName" class="col-form-label">Patient Name</label>
                                                    <input type="text" readonly value="<?php echo htmlspecialchars($row->pat_fname . ' ' . $row->pat_lname); ?>" name="t_pat_name" class="form-control" id="patientName">
                                                </div>
                                            </div>

                                            <div class="form-row">
                                                <div class="form-group col-md-6">
                                                    <label for="referralHospital" class="col-form-label">Referral Hospital</label>
                                                    <input type="text" required name="t_hospital" class="form-control" id="referralHospital" placeholder="Hospital Name">
                                                </div>
                                                <div class="form-group col-md-6">
                                                    <label for="transferDate" class="col-form-label">Transfer Date</label>
                                                    <input required type="date" name="t_date" class="form-control" id="transferDate" min="<?php echo date('Y-m-d'); ?>">
                                                </div>
                                                <input type="hidden" name="t_pat_number" value="<?php echo htmlspecialchars($row->pat_number); ?>">
                                                <input type="hidden" name="t_status" value="Pending">
                                            </div>

                                            <button type="submit" name="transfer_patient" class="ladda-button btn btn-success" data-style="expand-right">
                                                <i class="fas fa-paper-plane mr-2"></i>Transfer Patient
                                            </button>
                                            
                                            <a href="javascript:history.back()" class="btn btn-secondary ml-2">
                                                <i class="fas fa-times mr-2"></i>Cancel
                                            </a>
                                        </form>
                                        <!--End Patient Form-->
                                    </div> <!-- end card-body -->
                                </div> <!-- end card-->
                            </div> <!-- end col -->
                        </div>
                        
                        <?php 
                            } // end if patient found
                        } // end if pat_number not empty
                        ?>
                        <!-- end row -->

                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                <?php include('assets/inc/footer.php');?>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>
<style>/* Main Background */
body {
    background-color: #f8f9fc;
    font-family: 'Nunito', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
}

/* Page Header Styling */
.page-title-box {
    background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
    border-radius: 12px;
    padding: 20px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.1);
    color: white;
    margin-bottom: 25px;
}

.page-title-box .breadcrumb {
    background-color: transparent;
    padding: 0;
}

.page-title-box .breadcrumb-item a {
    color: rgba(255,255,255,0.8);
}

.page-title-box .breadcrumb-item.active {
    color: white;
    font-weight: 600;
}

.page-title-box .page-title {
    color: white;
    font-weight: 700;
    letter-spacing: 0.5px;
}

/* Alert Styling */
.alert {
    border-radius: 10px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    border: none;
    padding: 15px 20px;
}

.alert-success {
    box-shadow: 0 4px 15px rgba(25, 135, 84, 0.2);
}

.alert-danger {
    box-shadow: 0 4px 15px rgba(220, 53, 69, 0.2);
}

.alert i {
    margin-right: 8px;
}

/* Card Styling */
.card {
    border-radius: 15px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.05);
    border: none;
    overflow: hidden;
}

.card-body {
    padding: 2rem;
}

.card .header-title {
    color: #4e73df;
    border-bottom: 2px solid #f8f9fc;
    padding-bottom: 10px;
    margin-bottom: 20px;
    font-weight: 600;
}

/* Form Styling */
.form-control {
    border-radius: 8px;
    border: 1px solid #e3e6f0;
    padding: 12px 15px;
    height: auto;
}

.form-control:focus {
    border-color: #bac8f3;
    box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
}

.form-control[readonly] {
    background-color: #f8f9fc;
}

.form-label {
    font-weight: 600;
    color: #5a5c69;
    margin-bottom: 8px;
}

/* Button Styling */
.btn-primary {
    background: linear-gradient(to right, #4e73df, #224abe);
    border: none;
    border-radius: 8px;
    padding: 12px 30px;
    font-weight: 600;
    box-shadow: 0 4px 15px rgba(78, 115, 223, 0.3);
    transition: all 0.3s;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(78, 115, 223, 0.4);
}

.btn-secondary {
    border-radius: 8px;
    padding: 12px 25px;
    font-weight: 600;
    border: none;
    transition: all 0.3s;
}

.btn-secondary:hover {
    background-color: #6c757d;
}

/* Form Group Spacing */
.form-group {
    margin-bottom: 1.5rem;
}

/* Responsive Adjustments */
@media (max-width: 768px) {
    .card-body {
        padding: 1.5rem;
    }
    
    .btn {
        width: 100%;
        margin-bottom: 10px;
    }
    
    .text-right {
        text-align: center !important;
    }
}</style>
        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- App js-->
        <script src="assets/js/app.min.js"></script>

        <!-- Loading buttons js -->
        <script src="assets/libs/ladda/spin.js"></script>
        <script src="assets/libs/ladda/ladda.js"></script>

        <!-- Buttons init js-->
        <script src="assets/js/pages/loading-btn.init.js"></script>
        
    </body>
</html>