<?php
session_start();
include('assets/inc/config.php');
if(isset($_POST['update_patient_presc'])) {
    $pres_pat_name = $_POST['pres_pat_name'];
    $pres_pat_type = $_POST['pres_pat_type'];
    $pres_pat_addr = $_POST['pres_pat_addr'];
    $pres_pat_age = $_POST['pres_pat_age'];
    $pres_number = $_GET['pres_number'];
    $pres_ins = $_POST['pres_ins'];
    $pres_pat_ailment = $_POST['pres_pat_ailment'];
    
    $query = "UPDATE his_prescriptions SET pres_pat_name=?, pres_pat_type=?, pres_pat_addr=?, pres_pat_age=?, pres_pat_ailment=?, pres_ins=? WHERE pres_number=?";
    $stmt = $mysqli->prepare($query);
    $stmt->bind_param('sssssss', $pres_pat_name, $pres_pat_type, $pres_pat_addr, $pres_pat_age, $pres_pat_ailment, $pres_ins, $pres_number);
    $stmt->execute();
    
    if($stmt) {
        $success = "Patient prescription updated successfully!";
    } else {
        $err = "Error updating prescription. Please try again.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        :root {
            --primary: #4361ee;
            --primary-light: #eef2ff;
            --secondary: #3a0ca3;
            --success: #00b46e;
            --danger: #dc3545;
            --warning: #ff9e00;
            --light: #f8f9fc;
            --dark: #2b2d42;
            --gray: #495057;
            --border: #e0e3ff;
        }
        
        body {
            background-color: var(--light);
            font-family: 'Inter', sans-serif;
        }
        
        .card {
            border: none;
            border-radius: 12px;
            box-shadow: 0 4px 24px rgba(0, 0, 0, 0.05);
        }
        
        .page-title-box {
            padding: 20px 0;
        }
        
        .page-title {
            color: var(--dark);
            font-weight: 700;
        }
        
        .form-control {
            border: 1px solid var(--border);
            border-radius: 8px;
            padding: 12px 15px;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 0.2rem rgba(67, 97, 238, 0.15);
        }
        
        .form-control[readonly] {
            background-color: var(--light);
        }
        
        label {
            font-weight: 600;
            color: var(--dark);
            margin-bottom: 8px;
        }
        
        .btn-primary {
            background-color: var(--primary);
            border-color: var(--primary);
            padding: 12px 30px;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .btn-primary:hover {
            background-color: var(--secondary);
            border-color: var(--secondary);
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(58, 12, 163, 0.2);
        }
        
        .header-title {
            color: var(--primary);
            font-weight: 700;
            margin-bottom: 20px;
            position: relative;
            padding-bottom: 10px;
        }
        
        .header-title:after {
            content: '';
            position: absolute;
            left: 0;
            bottom: 0;
            width: 60px;
            height: 3px;
            background: var(--primary);
            border-radius: 3px;
        }
        
        /* CKEditor 5 Styling */
        .ck.ck-editor {
            border-radius: 8px;
            overflow: hidden;
            margin-top: 10px;
        }
        
        .ck.ck-toolbar {
            border-radius: 8px 8px 0 0 !important;
            background-color: var(--light) !important;
            border: 1px solid var(--border) !important;
            border-bottom: none !important;
        }
        
        .ck.ck-content {
            min-height: 200px;
            border-radius: 0 0 8px 8px !important;
            border: 1px solid var(--border) !important;
            border-top: none !important;
        }
        
        hr {
            border-top: 1px solid var(--border);
            margin: 20px 0;
        }
        
        @media (max-width: 768px) {
            .form-group {
                margin-bottom: 20px;
            }
            
            .btn-primary {
                width: 100%;
            }
        }
    </style>
</head>

<body>

    <div id="wrapper">
        <?php include("assets/inc/nav.php");?>
        <?php include("assets/inc/sidebar.php");?>

        <div class="content-page">
            <div class="content">
                <div class="container-fluid">
                    
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript:void(0);">Pharmacy</a></li>
                                        <li class="breadcrumb-item active">Update Prescription</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Update Patient Prescription</h4>
                            </div>
                        </div>
                    </div>
                    
                    <?php
                    $pres_number = $_GET['pres_number'];
                    $ret = "SELECT * FROM his_prescriptions WHERE pres_number=?";
                    $stmt = $mysqli->prepare($ret);
                    $stmt->bind_param('s', $pres_number);
                    $stmt->execute();
                    $res = $stmt->get_result();
                    $row = $res->fetch_object();
                    ?>
                    
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">Prescription Details</h4>
                                    
                                    <form method="post">
                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label>Patient Name</label>
                                                <input type="text" class="form-control" name="pres_pat_name" 
                                                    value="<?php echo htmlspecialchars($row->pres_pat_name); ?>" readonly>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>Patient Age</label>
                                                <input type="text" class="form-control" name="pres_pat_age" 
                                                    value="<?php echo htmlspecialchars($row->pres_pat_age); ?>" readonly>
                                            </div>
                                        </div>
                                        
                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label>Patient Address</label>
                                                <input type="text" class="form-control" name="pres_pat_addr" 
                                                    value="<?php echo htmlspecialchars($row->pres_pat_addr); ?>" readonly>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>Patient Type</label>
                                                <input type="text" class="form-control" name="pres_pat_type" 
                                                    value="<?php echo htmlspecialchars($row->pres_pat_type); ?>" readonly>
                                            </div>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label>Patient Ailment</label>
                                            <input type="text" class="form-control" name="pres_pat_ailment" 
                                                value="<?php echo htmlspecialchars($row->pres_pat_ailment); ?>" required>
                                        </div>
                                        
                                        <hr>
                                        
                                        <div class="form-group">
                                            <label>Prescription</label>
                                            <textarea class="form-control" name="pres_ins" id="editor"><?php echo htmlspecialchars($row->pres_ins); ?></textarea>
                                        </div>
                                        
                                        <button type="submit" name="update_patient_presc" class="btn btn-primary ladda-button" data-style="expand-right">
                                            <i class="fas fa-save mr-2"></i> Update Prescription
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <?php include('assets/inc/footer.php');?>
        </div>
    </div>

    <!-- CKEditor 5 -->
    <script src="https://cdn.ckeditor.com/ckeditor5/41.3.0/classic/ckeditor.js"></script>
    <script>
        ClassicEditor
            .create(document.querySelector('#editor'), {
                toolbar: {
                    items: [
                        'heading', '|',
                        'bold', 'italic', 'link', 'bulletedList', 'numberedList', '|',
                        'blockQuote', 'insertTable', '|',
                        'undo', 'redo'
                    ]
                },
                heading: {
                    options: [
                        { model: 'paragraph', title: 'Paragraph', class: 'ck-heading_paragraph' },
                        { model: 'heading1', view: 'h1', title: 'Heading 1', class: 'ck-heading_heading1' },
                        { model: 'heading2', view: 'h2', title: 'Heading 2', class: 'ck-heading_heading2' }
                    ]
                },
                table: {
                    contentToolbar: [ 'tableColumn', 'tableRow', 'mergeTableCells' ]
                }
            })
            .catch(error => {
                console.error(error);
            });
    </script>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>
    <script src="assets/libs/ladda/spin.js"></script>
    <script src="assets/libs/ladda/ladda.js"></script>
    <script src="assets/js/pages/loading-btn.init.js"></script>
    <script src="assets/js/app.min.js"></script>
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
</body>
</html>