<?php
    session_start();
    include('assets/inc/config.php');
        if(isset($_POST['update_equipments']))
        {
            $eqp_code = $_GET['eqp_code'];
            $eqp_name = $_POST['eqp_name'];
            $eqp_vendor = $_POST['eqp_vendor'];
            $eqp_desc = $_POST['eqp_desc'];
            $eqp_dept = $_POST['eqp_dept'];
            $eqp_status = $_POST['eqp_status'];
            $eqp_qty = $_POST['eqp_qty'];
                
            //sql to insert captured values
            $query="UPDATE  his_equipments SET  eqp_name = ?, eqp_vendor = ?, eqp_desc = ?, eqp_dept = ?, eqp_status = ?, eqp_qty = ? WHERE eqp_code = ?";
            $stmt = $mysqli->prepare($query);
            $rc=$stmt->bind_param('sssssss',  $eqp_name, $eqp_vendor, $eqp_desc, $eqp_dept, $eqp_status, $eqp_qty, $eqp_code);
            $stmt->execute();
            
            //declare a varible which will be passed to alert function
            if($stmt)
            {
                $success = "Laboratory Equipment Updated";
            }
            else {
                $err = "Please Try Again Or Try Later";
            }
        }
?>
<!DOCTYPE html>
<html lang="en">
    
    <!--Head-->
    <?php include('assets/inc/head.php');?>
    <body>

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
            <?php include("assets/inc/nav.php");?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
            <?php include("assets/inc/sidebar.php");?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->
            <?php
                $eqp_code=$_GET['eqp_code'];
                $ret="SELECT  * FROM his_equipments WHERE eqp_code=?";
                $stmt= $mysqli->prepare($ret) ;
                $stmt->bind_param('i',$eqp_code);
                $stmt->execute() ;//ok
                $res=$stmt->get_result();
                while($row=$res->fetch_object())
                {
            ?>
                <div class="content-page">
                    <div class="content">

                        <!-- Start Content-->
                        <div class="container-fluid">
                            
                            <!-- start page title -->
                            <div class="row">
                                <div class="col-12">
                                    <div class="page-title-box bg-gradient-primary">
                                        <div class="page-title-right">
                                            <ol class="breadcrumb m-0">
                                                <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                                <li class="breadcrumb-item"><a href="javascript: void(0);">Manage Equipment</a></li>
                                                <li class="breadcrumb-item active text-white">Update Equipment</li>
                                            </ol>
                                        </div>
                                        <h4 class="page-title text-white">Update Equipment Details</h4>
                                    </div>
                                </div>
                            </div>     
                            <!-- end page title --> 
                            <!-- Form row -->
                            <div class="row">
                                <div class="col-12">
                                    <div class="card border-primary">
                                        <div class="card-header bg-primary text-white">
                                            <h4 class="header-title">Equipment Information</h4>
                                        </div>
                                        <div class="card-body">
                                            <!--Add Patient Form-->
                                            <form method="post">
                                                <div class="form-row">
                                                    <div class="form-group col-md-4">
                                                        <label for="eqp_name" class="col-form-label">Equipment Name</label>
                                                        <input type="text" required="required" value="<?php echo $row->eqp_name;?>" name="eqp_name" class="form-control border-primary" id="eqp_name">
                                                    </div>
                                                    <div class="form-group col-md-4">
                                                        <label for="eqp_vendor" class="col-form-label">Equipment Vendor</label>
                                                        <input required="required" type="text" value="<?php echo $row->eqp_vendor;?>" name="eqp_vendor" class="form-control border-primary" id="eqp_vendor">
                                                    </div>
                                                    <div class="form-group col-md-4">
                                                        <label for="eqp_qty" class="col-form-label">Equipment Quantity</label>
                                                        <input required="required" type="number" value="<?php echo $row->eqp_qty;?>" name="eqp_qty" class="form-control border-primary" id="eqp_qty">
                                                    </div>
                                                </div>

                                                <div class="form-row">
                                                    <div class="form-group col-md-6">
                                                        <label for="eqp_status" class="col-form-label">Equipment Status</label>
                                                        <select required="required" name="eqp_status" class="form-control border-primary" id="eqp_status">
                                                            <option value="Functioning" <?php echo ($row->eqp_status == 'Functioning') ? 'selected' : ''; ?>>Functioning</option>
                                                            <option value="Maintenance" <?php echo ($row->eqp_status == 'Maintenance') ? 'selected' : ''; ?>>Maintenance</option>
                                                            <option value="Out of Service" <?php echo ($row->eqp_status == 'Out of Service') ? 'selected' : ''; ?>>Out of Service</option>
                                                        </select>
                                                    </div>
                                                    <div class="form-group col-md-6" style="display:none">
                                                        <label for="eqp_dept" class="col-form-label">Equipment Department</label>
                                                        <input required="required" type="text" value="Laboratory" name="eqp_dept" class="form-control border-primary" id="eqp_dept">
                                                    </div>
                                                </div>

                                                <div class="form-group">
                                                    <label for="editor" class="col-form-label">Equipment Description</label>
                                                    <textarea required="required" type="text" class="form-control" name="eqp_desc" id="editor"><?php echo $row->eqp_desc;?></textarea>
                                                </div>

                                                <button type="submit" name="update_equipments" class="ladda-button btn btn-success btn-rounded waves-effect waves-light" data-style="expand-right">
                                                    <i class="fas fa-save mr-1"></i> Update Equipment
                                                </button>

                                            </form>
                                        
                                        </div> <!-- end card-body -->
                                    </div> <!-- end card-->
                                </div> <!-- end col -->
                            </div>
                            <!-- end row -->

                        </div> <!-- container -->

                    </div> <!-- content -->

                    <!-- Footer Start -->
                    <?php include('assets/inc/footer.php');?>
                    <!-- end Footer -->

                </div>
            <?php }?>
            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <!--Load CKEditor 5-->
        <script src="https://cdn.ckeditor.com/ckeditor5/41.1.0/classic/ckeditor.js"></script>
        <script>
            ClassicEditor
                .create( document.querySelector( '#editor' ), {
                    toolbar: [ 'heading', '|', 'bold', 'italic', 'link', 'bulletedList', 'numberedList', 'blockQuote' ],
                    heading: {
                        options: [
                            { model: 'paragraph', title: 'Paragraph', class: 'ck-heading_paragraph' },
                            { model: 'heading1', view: 'h1', title: 'Heading 1', class: 'ck-heading_heading1' },
                            { model: 'heading2', view: 'h2', title: 'Heading 2', class: 'ck-heading_heading2' }
                        ]
                    }
                } )
                .catch( error => {
                    console.error( error );
                } );
        </script>
       
        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- App js-->
        <script src="assets/js/app.min.js"></script>

        <!-- Loading buttons js -->
        <script src="assets/libs/ladda/spin.js"></script>
        <script src="assets/libs/ladda/ladda.js"></script>

        <!-- Buttons init js-->
        <script src="assets/js/pages/loading-btn.init.js"></script>
        
        <style>
            /* Custom Color Scheme */
            .bg-gradient-primary {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
                border-radius: 0.25rem;
                box-shadow: 0 4px 20px 0 rgba(0,0,0,.14), 0 7px 10px -5px rgba(102, 126, 234, .4);
            }
            
            .border-primary {
                border-color: #667eea !important;
            }
            
            .card {
                box-shadow: 0 1px 15px rgba(0,0,0,0.1);
                border: none;
            }
            
            .card-header {
                border-bottom: 1px solid rgba(0,0,0,0.1);
            }
            
            .btn-rounded {
                border-radius: 50px !important;
            }
            
            .form-control:focus {
                border-color: #764ba2;
                box-shadow: 0 0 0 0.2rem rgba(118, 75, 162, 0.25);
            }
            
            .ck.ck-editor__editable_inline {
                min-height: 200px;
                border: 1px solid #667eea !important;
                border-radius: 0.25rem;
            }
            
            .ck.ck-toolbar {
                border: 1px solid #667eea !important;
                border-bottom: none !important;
                border-radius: 0.25rem 0.25rem 0 0;
            }
        </style>
    </body>
</html>