<?php
session_start();
include('assets/inc/config.php');
include('assets/inc/checklogin.php');
check_login();
$aid = $_SESSION['ad_id'];
?>

<!DOCTYPE html>
<html lang="en">
    
<head>
    <?php include('assets/inc/head.php');?>
    <style>
        :root {
            --primary-color: #4361ee;
            --primary-light: #eef2ff;
            --secondary-color: #3a0ca3;
            --success-color: #00b46e;
            --danger-color: #dc3545;
            --warning-color: #ff9e00;
            --light-bg: #f8f9fc;
            --card-shadow: 0 4px 24px rgba(0, 0, 0, 0.05);
            --form-border: #e0e3ff;
            --dark-text: #2b2d42;
            --medium-text: #495057;
        }
        
        body {
            background-color: var(--light-bg);
            font-family: 'Inter', sans-serif;
        }
        
        .card-box {
            border-radius: 12px;
            box-shadow: var(--card-shadow);
            border: none;
        }
        
        .page-title {
            color: var(--dark-text);
            font-weight: 700;
        }
        
        .table {
            border-collapse: separate;
            border-spacing: 0;
            width: 100%;
        }
        
        .table th {
            background-color: var(--primary-color);
            color: white;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            font-size: 0.85rem;
            position: sticky;
            top: 0;
        }
        
        .table td, .table th {
            padding: 12px 15px;
            vertical-align: middle;
            border-top: 1px solid #e9ecef;
        }
        
        .table tbody tr:hover {
            background-color: rgba(67, 97, 238, 0.05);
        }
        
        .badge-success {
            background-color: var(--success-color);
            padding: 6px 10px;
            font-weight: 500;
            letter-spacing: 0.3px;
            font-size: 0.75rem;
            transition: all 0.2s;
        }
        
        .badge-success:hover {
            transform: translateY(-1px);
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }
        
        #demo-foo-search {
            border-radius: 20px;
            padding-left: 15px;
            border: 1px solid var(--form-border);
            box-shadow: none;
        }
        
        #demo-foo-search:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(67, 97, 238, 0.25);
        }
        
        .pagination .page-link {
            color: var(--primary-color);
        }
        
        .pagination .page-item.active .page-link {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
        }
        
        @media (max-width: 768px) {
            .table-responsive {
                border: 0;
            }
            
            .table thead {
                display: none;
            }
            
            .table tr {
                margin-bottom: 15px;
                display: block;
                border: 1px solid #e9ecef;
                border-radius: 8px;
            }
            
            .table td {
                display: flex;
                justify-content: space-between;
                align-items: center;
                border-bottom: 1px solid #e9ecef;
            }
            
            .table td:before {
                content: attr(data-label);
                font-weight: 600;
                color: var(--dark-text);
                margin-right: 15px;
            }
            
            .badge {
                margin-top: 5px;
            }
        }
    </style>
</head>

<body>

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <?php include('assets/inc/nav.php');?>
        <!-- end Topbar -->

        <!-- ========== Left Sidebar Start ========== -->
        <?php include("assets/inc/sidebar.php");?>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Pharmaceuticals</a></li>
                                        <li class="breadcrumb-item active">View Pharmaceuticals</li>
                                    </ol>
                                </div>
                                <h4 class="page-title">Pharmaceutical Inventory</h4>
                            </div>
                        </div>
                    </div>     
                    <!-- end page title --> 

                    <div class="row">
                        <div class="col-12">
                            <div class="card-box">
                                <div class="mb-2">
                                    <div class="row">
                                        <div class="col-12 text-sm-center form-inline">
                                            <div class="form-group">
                                                <input id="demo-foo-search" type="text" placeholder="Search pharmaceuticals..." class="form-control form-control-sm" autocomplete="on">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="table-responsive">
                                    <table id="demo-foo-filtering" class="table table-bordered toggle-circle mb-0" data-page-size="10">
                                        <thead>
                                        <tr>
                                            <th>#</th>
                                            <th data-toggle="true">Name</th>
                                            <th data-hide="phone">Barcode</th>
                                            <th data-hide="phone">Vendor</th>
                                            <th data-hide="phone">Category</th>
                                            <th data-hide="phone">Quantity</th>
                                            <th data-hide="phone">Actions</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                            $ret = "SELECT * FROM his_pharmaceuticals ORDER BY phar_name"; 
                                            $stmt = $mysqli->prepare($ret);
                                            $stmt->execute();
                                            $res = $stmt->get_result();
                                            $cnt = 1;
                                            while($row = $res->fetch_object()) {
                                        ?>
                                            <tr>
                                                <td><?php echo $cnt;?></td>
                                                <td><?php echo htmlspecialchars($row->phar_name);?></td>
                                                <td><?php echo htmlspecialchars($row->phar_bcode);?></td>
                                                <td><?php echo htmlspecialchars($row->phar_vendor);?></td>
                                                <td><?php echo htmlspecialchars($row->phar_cat);?></td>
                                                <td>
                                                    <span class="badge <?php echo ($row->phar_qty < 10) ? 'badge-danger' : 'badge-primary'; ?>">
                                                        <?php echo htmlspecialchars($row->phar_qty);?> Cartons
                                                    </span>
                                                </td>
                                                <td>
                                                    <a href="view_single_pharm.php?phar_bcode=<?php echo $row->phar_bcode;?>" class="badge badge-success">
                                                        <i class="far fa-eye"></i> View Details
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php $cnt = $cnt + 1; } ?>
                                        </tbody>
                                        <tfoot>
                                        <tr class="active">
                                            <td colspan="7">
                                                <div class="text-right">
                                                    <ul class="pagination pagination-rounded justify-content-end footable-pagination m-t-10 mb-0"></ul>
                                                </div>
                                            </td>
                                        </tr>
                                        </tfoot>
                                    </table>
                                </div> <!-- end .table-responsive-->
                            </div> <!-- end card-box -->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- container -->

            </div> <!-- content -->

            <!-- Footer Start -->
            <?php include('assets/inc/footer.php');?>
            <!-- end Footer -->

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- Footable js -->
    <script src="assets/libs/footable/footable.all.min.js"></script>

    <!-- Init js -->
    <script src="assets/js/pages/foo-tables.init.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>
    
</body>

</html>