<?php include('./constant/layout/head.php'); ?>
<?php include('./constant/layout/header.php'); ?>
<?php include('./constant/layout/sidebar.php'); ?>
<?php include('./constant/connect.php'); ?>
<div class="page-wrapper">
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-primary">Retailer Invoice Management</h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                <li class="breadcrumb-item active">Retailer Invoice Management</li>
            </ol>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-title"></div>
                    <div id="add-brand-messages"></div>
                    <div id="success-message" class="alert alert-success" style="display: none;">
                        <button type="button" class="close" data-dismiss="alert">&times;</button>
                        <strong><i class="glyphicon glyphicon-ok-sign"></i></strong> Invoice added successfully!
                    </div>
                    <div class="card-body">
                        <div class="input-states">
                            <form class="form-horizontal" method="POST" id="createOrderForm" action="php_action/order.php">
                                <div class="form-group">
                                    <br>
                                
<div class="col-sm-4">
    <div class="btn-group btn-group-toggle w-100" data-toggle="buttons">
        <label class="btn btn-primary active w-50 py-3 fs-5" style="background-color: #007bff; border-color: #007bff;">
            <input type="radio" name="orderType" id="orderTypeRetail" value="retail" autocomplete="off" checked> Retail
        </label>
        <label class="btn btn-primary w-50 py-3 fs-5" style="background-color: #6f42c1; border-color: #6f42c1;">
            <input type="radio" name="orderType" id="orderTypeWholesale" value="wholesale" autocomplete="off"> Wholesale
        </label>
    </div>
    <input type="hidden" class="form-control" id="type" name="type" value="retail" />
</div>

                                    <br>
                                    
                                    <div class="row">
                                        <label class="col-sm-2 control-label">Invoice No</label>
                                        <div class="col-sm-4">
                                            <?php
                                            $user = "SELECT * FROM orders WHERE id=(SELECT MAX(id) FROM orders)";
                                            $result = $connect->query($user);
                                            $res = $result->fetch_assoc();
                                            $n = "INV-000";
                                            $l = $res['id'] + 1;
                                            $stall_no = $n . $l;
                                            ?>
                                            <input type="text" class="form-control" placeholder="Invoice Number" value="<?php echo $stall_no; ?>" autocomplete="off" name="uno" required />
                                        </div>
                                        <label class="col-sm-2 control-label">GSTIN (Optional)</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="gstn" name="gstn" placeholder="GSTIN Number" autocomplete="off" />
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row">
                                        <label class="col-sm-2 control-label">Invoice Date</label>
                                        <div class="col-sm-4">
                                            <input type="date" class="form-control" value="<?php echo date('Y-m-d'); ?>" id="orderDate" name="orderDate" autocomplete="off" required />
                                        </div>
                                        <label class="col-sm-2 control-label">Invoice Time</label>
                                        <div class="col-sm-4">
                                            <?php
                                            date_default_timezone_set('Asia/Kolkata');
                                            $ist_time = date('H:i');
                                            ?>
                                            <input type="time" class="form-control" value="<?php echo $ist_time; ?>" id="orderTime" name="orderTime" autocomplete="off" required />
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row">
                                        <label class="col-sm-2 control-label">Client Name</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="clientName" name="clientName" placeholder="Client Name" autocomplete="off" required />
                                        </div>
                                       
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row">
                                        <label class="col-sm-2 control-label">Client Contact No.</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="clientContact" name="clientContact" placeholder="Contact Number" autocomplete="off" pattern="^[0][1-9]\d{9}$|^[1-9]\d{9}$" required />
                                        </div>
                                    </div>
                                </div>

                                <div class="table-responsive">
                                    <table class="table" id="productTable">
                                        <thead>
                                            <tr>
                                                <th style="width:20%;">Product</th>
                                                <th style="width:8%;">Chamber</th>
                                                <th style="width:8%;">Rate</th>
                                                <th style="width:8%;">M.R.P</th>
                                                <th style="width:10%;">Pack</th>
                                                <th style="width:10%;">Expiry</th>
                                                <th style="width:6%;">Stock</th>
                                                <th style="width:6%;">Quantity</th>
                                                <th style="width:8%;">Discount %</th>
                                                <th style="width:10%;">Total</th>
                                                <th style="width:10%;">Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $arrayNumber = 0;
                                            for ($x = 1; $x < 2; $x++) { ?>
                                                <tr id="row<?php echo $x; ?>" class="<?php echo $arrayNumber; ?>">
                                                    <td>
                                                        <style>
                                                            .select2-container--default .select2-selection--single {
                                                                height: 60px !important;
                                                                line-height: 60px !important;
                                                                font-size: 12px !important;
                                                                padding-top: 10px !important;
                                                                padding-bottom: 10px !important;
                                                            }
                                                            .select2-container--default .select2-selection--single .select2-selection__rendered {
                                                                line-height: 60px !important;
                                                                font-size: 12px !important;
                                                            }
                                                            .select2-container--default .select2-selection--single .select2-selection__arrow {
                                                                height: 60px !important;
                                                            }
                                                        </style>
                                                        <div class="form-group">
                                                            <select class="form-control select2-product" name="productName[]" id="productName<?php echo $x; ?>" onchange="fetchProductData(<?php echo $x; ?>)">
                                                                <option value="">~~SELECT~~</option>
                                                            </select>
                                                            <input type="hidden" name="productId[]" id="productId<?php echo $x; ?>" />
                                                            <input type="hidden" name="realMedicineName[]" id="realMedicineName<?php echo $x; ?>" />
                                                        </div>
                                                    </td>
                                                    <td><input type="text" name="chamber[]" id="chamber<?php echo $x; ?>" autocomplete="off" class="form-control" readonly /></td>
                                                    <td>
                                                        <input type="text" name="rate[]" id="rate<?php echo $x; ?>" autocomplete="off" disabled="true" class="form-control" />
                                                        <input type="hidden" name="rateValue[]" id="rateValue<?php echo $x; ?>" autocomplete="off" class="form-control" />
                                                    </td>
                                                    <td>
                                                        <input type="text" name="mrp[]" id="mrp<?php echo $x; ?>" autocomplete="off" disabled="true" class="form-control" />
                                                        <input type="hidden" name="mrpValue[]" id="mrpValue<?php echo $x; ?>" autocomplete="off" class="form-control" />
                                                    </td>
                                                    <td><input type="text" name="pack[]" id="pack<?php echo $x; ?>" autocomplete="off" class="form-control" readonly /></td>
                                                    <td><input type="text" name="expiry_date[]" id="expiry_date<?php echo $x; ?>" autocomplete="off" class="form-control" readonly /></td>
                                                    <td><div class="form-group"><p id="available_quantity<?php echo $x; ?>">-</p></div></td>
                                                    <td><div class="form-group"><input type="number" name="quantity[]" id="quantity<?php echo $x; ?>" onkeyup="getTotal(<?php echo $x ?>)" autocomplete="off" class="form-control" min="1" /></div></td>
                                                    <td><input type="number" name="discount_percentage_item[]" id="discount_percentage_item<?php echo $x; ?>" onkeyup="getTotal(<?php echo $x ?>)" autocomplete="off" class="form-control" value="0" step="0.01" /></td>
                                                    <td>
                                                        <input type="text" name="total[]" id="total<?php echo $x; ?>" autocomplete="off" class="form-control" disabled="true" />
                                                        <input type="hidden" name="totalValue[]" id="totalValue<?php echo $x; ?>" autocomplete="off" class="form-control" />
                                                    </td>
                                                    <td>
                                                        <button type="button" class="btn btn-primary btn-flat" onclick="addRow()"><i class="fa fa-plus"></i></button>
                                                        <button type="button" class="btn btn-danger removeProductRowBtn" onclick="removeProductRow(<?php echo $x; ?>)"><i class="fa fa-trash"></i></button>
                                                    </td>
                                                </tr>
                                            <?php
                                            $arrayNumber++;
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>

                                <div class="form-group">
                                    <div class="row">
                                        <label class="col-sm-2 control-label">Sub Amount</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="subTotal" name="subTotal" disabled="true" />
                                            <input type="hidden" class="form-control" id="subTotalValue" name="subTotalValue" />
                                        </div>
                                        <label for="totalAmount" class="col-sm-2 control-label">Total Amount</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="totalAmount" name="totalAmount" disabled="true" />
                                            <input type="hidden" class="form-control" id="totalAmountValue" name="totalAmountValue" />
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row">
                                        <label class="col-sm-2 control-label">Discount</label>
                                        <div class="col-sm-4">
                                            <input type="number" class="form-control" id="discount" name="discount" autocomplete="off" onkeyup="calculateGrandTotal()" value="0" step="0.01" />
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row">
                                        <label for="grandTotal" class="col-sm-2 control-label">Grand Total</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="grandTotal" name="grandTotal" disabled="true" />
                                            <input type="hidden" class="form-control" id="grandTotalValue" name="grandTotalValue" />
                                        </div>
                                        <label for="paid" class="col-sm-2 control-label">Paid Amount</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="paid" name="paid" autocomplete="off" onkeyup="paidAmount()" />
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row">
                                        <label for="due" class="col-sm-2 control-label">Due Amount</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control" id="due" name="due" disabled="true" />
                                            <input type="hidden" class="form-control" id="dueValue" name="dueValue" />
                                        </div>
                                        <label for="paymentStatus" class="col-sm-2 control-label">Payment Status</label>
                                        <div class="col-sm-4">
                                            <select class="form-control" name="paymentStatus" id="paymentStatus" required>
                                                <option value="">~~SELECT~~</option>
                                                <option value="1">Paid</option>
                                                <option value="2">Pending</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row">
                                        <label for="paymentType" class="col-sm-2 control-label">Payment Type</label>
                                        <div class="col-sm-4">
                                            <select class="form-control" name="paymentType" id="paymentType" required style="height:50px">
                                                <option value="">~~SELECT~~</option>
                                                <option value="2">Cash</option>
                                                <option value="4">UPI</option>
                                                <option value="5">Debit Card</option>
                                                <option value="6">Credit Card</option>
                                                <option value="1">Netbanking</option>
                                                <option value="3">Insurance</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group submitButtonFooter">
                                    <div class="col-sm-offset-2 col-sm-10">
                                        <button type="submit" id="createOrderBtn" data-loading-text="Loading..." class="btn btn-success btn-flat m-b-30 m-t-30"><i class="glyphicon glyphicon-ok-sign"></i> Submit</button>
                                        <button type="reset" class="btn btn-danger btn-flat m-b-30 m-t-30" onclick="resetOrderForm()"><i class="glyphicon glyphicon-erase"></i> Reset</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.soft-input {
    border-radius: 12px;
    border: 1px solid #d1d9e6;
    padding: 10px 12px;
    box-shadow: inset 3px 3px 6px #d1d9e6, inset -3px -3px 6px #ffffff;
    transition: all 0.3s ease;
}
.soft-input:focus {
    border-color: #4a6cf7;
    box-shadow: inset 2px 2px 5px #c1c7d0, inset -2px -2px 5px #ffffff;
    outline: none;
}
.soft-btn {
    padding: 8px 16px;
    border-radius: 12px;
    box-shadow: 4px 4px 12px #d1d9e6, -4px -4px 12px #ffffff;
    transition: all 0.3s ease;
    font-weight: 500;
}
.soft-btn:hover {
    transform: translateY(-2px);
    box-shadow: 2px 2px 8px #c1c7d0, -2px -2px 8px #ffffff;
}
.card { background: #f7f9fc; }
body, .page-wrapper { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; color: #4a4a4a; }
.select2-container--default .select2-selection--single {
    border-radius: 12px;
    border: 1px solid #d1d9e6;
    padding: 6px 12px;
    height: auto;
    box-shadow: inset 3px 3px 6px #d1d9e6, inset -3px -3px 6px #ffffff;
}
.select2-container--default .select2-selection--single .select2-selection__arrow { height: 100%; }

/* Order Type Button Styles */
.btn-group-toggle .btn {
    border-radius: 8px;
    margin-right: 5px;
    padding: 8px 16px;
}
.btn-group-toggle .btn.active {
    background-color: #4a6cf7;
    color: white;
    border-color: #4a6cf7;
}
</style>

<?php include('./constant/layout/footer.php'); ?>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
// Cache product data globally to avoid repeated AJAX calls
var productDataCache = [];

$(document).ready(function() {
    $('.select2-product').select2({
        placeholder: "Search for a product",
        allowClear: true,
        width: '100%'
    });

    $(document).on('select2:open', () => {
        document.querySelector('.select2-container--open .select2-search__field').focus();
    });

    if (sessionStorage.getItem('showSuccessMessage') === 'true') {
        $('#success-message').show();
        sessionStorage.removeItem('showSuccessMessage');
    }

    // Load products for the first row
    fetchProductData(1, true);
    
    // Update order type when buttons are clicked
    $('input[name="orderType"]').change(function() {
        $('#type').val($(this).val());
    });
});

/* ================= CALCULATION FUNCTIONS =================== */
function getTotal(row = null) {
    if (!row) {
        alert('No row specified! Please refresh the page.');
        return;
    }

    var mrp = Number($("#mrp" + row).val()) || 0;
    var quantity = Number($("#quantity" + row).val()) || 0;
    var discountPercentage = Number($("#discount_percentage_item" + row).val()) || 0;

    if (mrp <= 0 || quantity <= 0) {
        $("#total" + row).val("0.00");
        $("#totalValue" + row).val("0");
        subAmount();
        return;
    }

    var baseAmount = mrp * quantity;
    var discountAmount = (baseAmount * discountPercentage) / 100;
    var total = baseAmount - discountAmount;
    total = total.toFixed(2);

    $("#total" + row).val(total);
    $("#totalValue" + row).val(total);

    subAmount();
}

function subAmount() {
    var tableProductLength = $("#productTable tbody tr").length;
    var totalSubAmount = 0;

    for (var x = 0; x < tableProductLength; x++) {
        var tr = $("#productTable tbody tr")[x];
        var count = $(tr).attr('id').substring(3);
        totalSubAmount += Number($("#totalValue" + count).val()) || 0;
    }

    totalSubAmount = totalSubAmount.toFixed(2);
    $("#subTotal").val(totalSubAmount);
    $("#subTotalValue").val(totalSubAmount);
    $("#totalAmount").val(totalSubAmount);
    $("#totalAmountValue").val(totalSubAmount);

    calculateGrandTotal();
}

function calculateGrandTotal() {
    var subTotal = Number($("#subTotalValue").val()) || 0;
    var discount = Number($("#discount").val()) || 0;
    var grandTotal = subTotal - (subTotal * (discount / 100));
    grandTotal = Math.round(grandTotal).toFixed(2);

    $("#grandTotal").val(grandTotal);
    $("#grandTotalValue").val(grandTotal);

    paidAmount();
}

function paidAmount() {
    var grandTotal = Number($("#grandTotal").val()) || 0;
    var paid = Number($("#paid").val()) || 0;
    var dueAmount = grandTotal - paid;
    dueAmount = dueAmount.toFixed(2);
    $("#due").val(dueAmount);
    $("#dueValue").val(dueAmount);
}

/* ================= DYNAMIC ROWS =================== */
function addRow() {
    console.log('Adding new row...');

    var tableLength = $("#productTable tbody tr").length;
    var count = tableLength > 0 ? parseInt($("#productTable tbody tr:last").attr('id').replace('row', '')) + 1 : 1;

    var tr = '<tr id="row' + count + '" class="' + count + '">' +
        '<td>' +
        '<div class="form-group">' +
        '<select class="form-control select2-product" name="productName[]" id="productName' + count + '" onchange="fetchProductData(' + count + ')">' +
        '<option value="">~~SELECT~~</option>' +
        '</select>' +
        '<input type="hidden" name="productId[]" id="productId' + count + '" />' +
        '<input type="hidden" name="realMedicineName[]" id="realMedicineName' + count + '" />' +
        '</div>' +
        '</td>' +
        '<td><input type="text" name="chamber[]" id="chamber' + count + '" autocomplete="off" class="form-control" readonly /></td>' +
        '<td>' +
        '<input type="text" name="rate[]" id="rate' + count + '" autocomplete="off" disabled="true" class="form-control" />' +
        '<input type="hidden" name="rateValue[]" id="rateValue' + count + '" autocomplete="off" class="form-control" />' +
        '</td>' +
        '<td>' +
        '<input type="text" name="mrp[]" id="mrp' + count + '" autocomplete="off" disabled="true" class="form-control" />' +
        '<input type="hidden" name="mrpValue[]" id="mrpValue' + count + '" autocomplete="off" class="form-control" />' +
        '</td>' +
        '<td><input type="text" name="pack[]" id="pack' + count + '" autocomplete="off" class="form-control" readonly /></td>' +
        '<td><input type="text" name="expiry_date[]" id="expiry_date' + count + '" autocomplete="off" class="form-control" readonly /></td>' +
        '<td><div class="form-group"><p id="available_quantity' + count + '">-</p></div></td>' +
        '<td><div class="form-group"><input type="number" name="quantity[]" id="quantity' + count + '" onkeyup="getTotal(' + count + ')" autocomplete="off" class="form-control" min="1" value="1" /></div></td>' +
        '<td><input type="number" name="discount_percentage_item[]" id="discount_percentage_item' + count + '" onkeyup="getTotal(' + count + ')" autocomplete="off" class="form-control" value="0" step="0.01" /></td>' +
        '<td>' +
        '<input type="text" name="total[]" id="total' + count + '" disabled="true" class="form-control" value="0.00"/>' +
        '<input type="hidden" name="totalValue[]" id="totalValue' + count + '" value="0"/>' +
        '</td>' +
        '<td>' +
        '<button type="button" class="btn btn-primary btn-flat" onclick="addRow()"><i class="fa fa-plus"></i></button> ' +
        '<button type="button" class="btn btn-danger removeProductRowBtn" onclick="removeProductRow(' + count + ')"><i class="fa fa-trash"></i></button>' +
        '</td>' +
        '</tr>';

    if (tableLength > 0) {
        $("#productTable tbody tr:last").after(tr);
    } else {
        $("#productTable tbody").append(tr);
    }

    // Populate dropdown using cached data
    populateProductDropdown(count);
    $("#productName" + count).select2({
        placeholder: "Search for a product",
        allowClear: true,
        width: '100%'
    });
}

function populateProductDropdown(rowId) {
    var selectElement = $('#productName' + rowId);
    selectElement.empty();
    selectElement.append('<option value="">~~SELECT~~</option>');

    if (productDataCache.length > 0) {
        $.each(productDataCache, function(index, product) {
            selectElement.append('<option value="' + product.product_id + '" ' +
                'data-chamber="' + (product.chamber || '') + '" ' +
                'data-pack="' + (product.unit_description || '') + '" ' +
                'data-rate="' + (product.rate || '0') + '" ' +
                'data-mrp="' + (product.mrp || '0') + '" ' +
                'data-quantity="' + (product.quantity || '0') + '" ' +
                'data-expiry="' + (product.expiry_date || '') + '" ' +
                'data-real-medicine-name="' + (product.real_medicine_name || product.product_name) + '">' +
                product.product_name + (product.categories_name ? ' - ' + product.categories_name : '') +
                '</option>');
        });
    } else {
        selectElement.append('<option value="">Loading...</option>');
    }
}

function removeProductRow(row = null) {
    if (!row) {
        console.error('No row specified for removal');
        alert('Error! Please refresh the page');
        return;
    }

    var tableLength = $("#productTable tbody tr").length;
    if (tableLength <= 1) {
        alert('You must have at least one product row');
        return;
    }

    $("#row" + row).fadeOut(300, function() {
        $(this).remove();
        subAmount();
        console.log('Row removed successfully');
    });
}

/* ================= MERGED PRODUCT DATA FETCHING =================== */
function fetchProductData(row = null, isInitialLoad = false) {
    if (!row && !isInitialLoad) {
        console.error('No row specified for product data');
        alert('Error! Please refresh the page');
        return;
    }

    var productId = isInitialLoad ? null : $("#productName" + row).val();
    console.log(isInitialLoad ? 'Fetching all products for row ' + row : 'Getting product data for row ' + row + ', product ID: ' + productId);

    if (!isInitialLoad && productId === "") {
        resetProductRow(row);
        return;
    }

    // If cache exists and we're populating dropdown, use it
    if (isInitialLoad && productDataCache.length > 0) {
        populateProductDropdown(row);
        $("#productName" + row).select2({
            placeholder: "Search for a product",
            allowClear: true,
            width: '100%'
        });
        return;
    }

    $.ajax({
        url: 'php_action/fetchProductData.php',
        type: 'GET',
        data: isInitialLoad ? {} : { productId: productId },
        dataType: 'json',
        success: function(response) {
            console.log('Products loaded successfully for row ' + row, response);

            if (isInitialLoad) {
                // Cache all products
                productDataCache = response;
                populateProductDropdown(row);
                $("#productName" + row).select2({
                    placeholder: "Search for a product",
                    allowClear: true,
                    width: '100%'
                });
            } else {
                // Find selected product in cache
                var product = productDataCache.find(p => p.product_id == productId);
                if (product) {
                    $("#productId" + row).val(product.product_id);
                    $("#chamber" + row).val(product.chamber || '');
                    $("#pack" + row).val(product.unit_description || '');
                    $("#rate" + row).val(Number(product.rate || 0).toFixed(2));
                    $("#rateValue" + row).val(Number(product.rate || 0).toFixed(2));
                    $("#mrp" + row).val(Number(product.mrp || 0).toFixed(2));
                    $("#mrpValue" + row).val(Number(product.mrp || 0).toFixed(2));
                    $("#expiry_date" + row).val(product.expiry ? new Date(product.expiry).toISOString().split('T')[0] : '');
                    $("#realMedicineName" + row).val(product.real_medicine_name || product.product_name);
                    $("#available_quantity" + row).text(product.quantity || '-');
                    $("#quantity" + row).val(1);
                    $("#discount_percentage_item" + row).val("0");

                    // Validate expiry date
                    var expiryDate = new Date(product.expiry);
                    var today = new Date();
                    today.setHours(0, 0, 0, 0); // Normalize to midnight
                    if (expiryDate < today) {
                        alert('Warning: The selected product (' + product.product_name + ') is expired as of ' + today.toLocaleDateString() + '.');
                        $("#expiry_date" + row).css('background-color', '#ffcccc'); // Highlight expired
                    } else {
                        $("#expiry_date" + row).css('background-color', ''); // Reset color
                        var daysLeft = Math.ceil((expiryDate - today) / (1000 * 60 * 60 * 24));
                        if (daysLeft <= 30) {
                            alert('Warning: The selected product (' + product.product_name + ') expires in ' + daysLeft + ' days.');
                            $("#expiry_date" + row).css('background-color', '#fff3cd'); // Near expiry warning
                        }
                    }

                    getTotal(row);
                } else {
                    alert('Product not found in cache. Please refresh the page.');
                    resetProductRow(row);
                }
            }
        },
        error: function(xhr, status, error) {
            console.error('Error loading products for row ' + row + ':', error);
            var selectElement = $('#productName' + row);
            selectElement.empty();
            selectElement.append('<option value="">Error loading products</option>');
            selectElement.select2({
                placeholder: "Error - try refreshing",
                width: '100%'
            });
            alert('Error loading products. Please try again.');
            if (!isInitialLoad) resetProductRow(row);
        }
    });
}

function resetProductRow(row) {
    $("#productId" + row).val("");
    $("#chamber" + row).val("");
    $("#rate" + row).val("");
    $("#rateValue" + row).val("");
    $("#mrp" + row).val("");
    $("#mrpValue" + row).val("");
    $("#pack" + row).val("");
    $("#expiry_date" + row).val("");
    $("#realMedicineName" + row).val("");
    $("#available_quantity" + row).text("-");
    $("#quantity" + row).val("");
    $("#discount_percentage_item" + row).val("0");
    $("#total" + row).val("0.00");
    $("#totalValue" + row).val("0");
    subAmount();
}

/* ================= FORM SUBMISSION =================== */
$("#createOrderForm").unbind('submit').bind('submit', function() {
    var form = $(this);
    $('.form-group').removeClass('has-error').removeClass('has-success');
    $('.text-danger').remove();

    var requiredFields = ['orderDate', 'orderTime', 'clientName', 'clientContact', 'paymentType', 'paymentStatus'];
    var isValid = true;

    $.each(requiredFields, function(index, field) {
        var value = $("#" + field).val();
        if (value === "") {
            $("#" + field).after('<p class="text-danger"> This field is required </p>');
            $("#" + field).closest('.form-group').addClass('has-error');
            isValid = false;
        } else {
            $("#" + field).closest('.form-group').addClass('has-success');
        }
    });

    // Validate order type
    var orderType = $('input[name="orderType"]:checked').val();
    if (!orderType) {
        $('.btn-group-toggle').after('<p class="text-danger"> Order type is required </p>');
        isValid = false;
    }

    var productRows = $("#productTable tbody tr");
    if (productRows.length === 0) {
        $("#productTable").after('<p class="text-danger"> At least one product is required </p>');
        isValid = false;
    }

    // Validate total quantity per product
    var productQuantities = {};
    productRows.each(function() {
        var row = $(this);
        var productId = row.find('input[name="productId[]"]').val();
        var productName = row.find('select[name="productName[]"]').val();
        var quantity = Number(row.find('input[name="quantity[]"]').val()) || 0;
        var availableQuantity = Number(row.find('p[id^="available_quantity"]').text()) || 0;

        if (!productName || !productId) {
            row.find('select[name="productName[]"]').after('<p class="text-danger"> Product is required </p>');
            isValid = false;
        }
        if (!quantity || quantity < 1) {
            row.find('input[name="quantity[]"]').after('<p class="text-danger"> Valid quantity is required </p>');
            isValid = false;
        } else {
            if (!productQuantities[productId]) productQuantities[productId] = 0;
            productQuantities[productId] += quantity;
            var product = productDataCache.find(p => p.product_id == productId);
            if (product && productQuantities[productId] > product.quantity) {
                row.find('input[name="quantity[]"]').after('<p class="text-danger"> Total quantity for this product exceeds available stock </p>');
                isValid = false;
            }
        }
    });

    if (!isValid) return false;

    $("#createOrderBtn").button('loading');

    $.ajax({
        url: form.attr('action'),
        type: form.attr('method'),
        data: form.serialize(),
        dataType: 'json',
        success: function(response) {
            $("#createOrderBtn").button('reset');
            $(".text-danger").remove();
            $('.form-group').removeClass('has-error').removeClass('has-success');

            if (response.success === true) {
                $('#success-message').show();
                sessionStorage.setItem('showSuccessMessage', 'true');
                form[0].reset();
                $("#productTable tbody tr:not(:first)").remove();
                $("#subTotal, #subTotalValue").val("0");
                $("#totalAmount, #totalAmountValue").val("0");
                $("#grandTotal, #grandTotalValue").val("0");
                $("#due, #dueValue").val("0");
                $("html, body").animate({ scrollTop: 0 }, "slow");

                // Re-initialize first row
                $("#productName1").select2({
                    placeholder: "Search for a product",
                    allowClear: true,
                    width: '100%'
                });
                resetProductRow(1);
            } else {
                alert(response.messages);
            }
        },
        error: function(xhr) {
            $("#createOrderBtn").button('reset');
            console.error('Create order failed', xhr.status, xhr.responseText);
            alert('Error submitting form. Server says:\n' + xhr.responseText);
        }
    });

    return false;
});

function resetOrderForm() {
    document.getElementById("createOrderForm").reset();
    $("#productTable tbody tr:not(:first)").remove();
    $("#subTotal, #subTotalValue").val("0");
    $("#totalAmount, #totalAmountValue").val("0");
    $("#grandTotal, #grandTotalValue").val("0");
    $("#due, #dueValue").val("0");
    $("#success-message").hide();
    sessionStorage.removeItem('showSuccessMessage');
    $("#productName1").select2({
        placeholder: "Search for a product",
        allowClear: true,
        width: '100%'
    });
    resetProductRow(1);
}
</script>