<?php
include('./constant/connect.php');

$response = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $product_id = intval($_POST['product_id']);
    $quantity_to_add = intval($_POST['quantity']);
    
    if ($quantity_to_add <= 0) {
        $response['message'] = 'Invalid quantity';
    } else {
        $sql = "UPDATE product SET quantity = quantity + ? WHERE product_id = ?";
        $stmt = $connect->prepare($sql);
        $stmt->bind_param('ii', $quantity_to_add, $product_id);
        
        if ($stmt->execute()) {
            $response['success'] = true;
        } else {
            $response['message'] = $stmt->error;
        }
        $stmt->close();
    }
}

echo json_encode($response);
?>
